/*
 * Decompiled with CFR 0.152.
 */
package io.qt.qtjambi.deployer;

import io.qt.QtLongEnumerator;
import io.qt.QtUtilities;
import io.qt.core.QByteArray;
import io.qt.core.QCommandLineOption;
import io.qt.core.QCommandLineParser;
import io.qt.core.QCoreApplication;
import io.qt.core.QList;
import io.qt.core.QScopeGuard;
import io.qt.qtjambi.deployer.AppGenerator;
import io.qt.qtjambi.deployer.PluginGenerator;
import io.qt.qtjambi.deployer.QMLGenerator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    private static void printout(QByteArray data) {
        int i = 0;
        while (i < data.size()) {
            for (int j = 0; j < 32 && i < data.size(); ++j) {
                System.out.print(Byte.toUnsignedInt(data.at(i++)));
                System.out.print(',');
            }
            System.out.println();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws InterruptedException, IOException {
        if (args.length > 0) {
            try {
                boolean doInit;
                boolean bl = doInit = QCoreApplication.instance() == null;
                if (doInit) {
                    QCoreApplication.setApplicationName((String)("deployer " + args[0]));
                    QCoreApplication.setApplicationVersion((String)QtUtilities.qtjambiVersion().toString());
                    QCoreApplication.initialize((String[])args);
                    QCoreApplication.setApplicationName((String)"deployer");
                }
                try (QScopeGuard guard = new QScopeGuard(QCoreApplication::shutdown);){
                    if (!doInit) {
                        guard.dismiss();
                    }
                    QCommandLineParser parser = new QCommandLineParser();
                    parser.setSingleDashWordOptionMode(QCommandLineParser.SingleDashWordOptionMode.ParseAsLongOptions);
                    parser.setApplicationDescription(String.format("QtJambi Deployer version %1$s", QtUtilities.qtjambiVersion().toString()));
                    parser.addHelpOption();
                    parser.addVersionOption();
                    QCommandLineOption dirOption = new QCommandLineOption((Collection)QList.of((String)"d", (String[])new String[]{"dir", "target-directory"}), "Target directory", "dir");
                    QCommandLineOption classPathOption = new QCommandLineOption((Collection)QList.of((String)"cp", (String[])new String[]{"class-path"}), "Class path for plugin/app execution", "path");
                    QCommandLineOption configurationOption = new QCommandLineOption((Collection)QList.of((String)"c", (String[])new String[]{"configuration"}), "Library configuration", "debug|release", "release");
                    switch (args[0]) {
                        case "plugin": {
                            PluginGenerator.generate(parser, args, dirOption, classPathOption, configurationOption);
                            return;
                        }
                        case "qml": {
                            QMLGenerator.generate(parser, args, dirOption, classPathOption, configurationOption);
                            return;
                        }
                        case "app": 
                        case "application": {
                            AppGenerator.generate(parser, args, dirOption, classPathOption, configurationOption);
                            return;
                        }
                        default: {
                            throw new Error("QtJambi Deployer, illegal argument: " + args[0] + ", expected: one of plugin|qml|application");
                        }
                    }
                }
            }
            catch (Error e) {
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            return;
        }
        String version = QtUtilities.qtjambiVersion().toString();
        System.out.println("Usage: deployer [plugin|qml|application]");
        System.out.println(String.format("QtJambi Deployer version %1$s", version));
    }

    static Enumeration<URL> findSpecs() throws MalformedURLException {
        int index;
        String classURL;
        Enumeration<Object> specsFound = Collections.emptyEnumeration();
        try {
            specsFound = Main.class.getClassLoader().getResources("qtjambi-utilities.xml");
        }
        catch (IOException e) {
            Logger.getLogger("io.qt").log(Level.WARNING, "", e);
        }
        if (!specsFound.hasMoreElements() && (classURL = "" + Main.class.getResource("Main.class")).startsWith("jar:file:") && (index = classURL.indexOf("!/")) > 0) {
            String jarFileURL = classURL.substring(4, index);
            File jarFile = null;
            try {
                jarFile = new File(new URL(jarFileURL).toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (jarFile != null && jarFile.exists()) {
                File directory = jarFile.getParentFile();
                Object fileName = jarFile.getName();
                String suffix = String.format("-%1$s.jar", QtUtilities.qtjambiVersion().toString());
                index = ((String)fileName).indexOf(suffix);
                fileName = ((String)fileName).substring(0, index) + "-native-";
                ArrayList<URL> foundURLs = new ArrayList<URL>();
                for (String jar : directory.list()) {
                    if (!jar.startsWith((String)fileName) || !jar.endsWith(suffix)) continue;
                    File nativeFile = new File(directory, jar);
                    URL nativeFileURL = new URL("jar:" + nativeFile.toURI() + "!/qtjambi-utilities.xml");
                    foundURLs.add(nativeFileURL);
                }
                if (!foundURLs.isEmpty()) {
                    specsFound = Collections.enumeration(foundURLs);
                }
            }
        }
        return specsFound;
    }

    static enum Parameters implements QtLongEnumerator
    {
        JVMDetectionMode,
        JVMPath,
        MinimumJVM,
        MainClass,
        ClassPath,
        ModulePath,
        LibraryPath,
        JVMArguments,
        JNIMinimumVersion;

    }

    static enum JVMDetectionModes implements QtLongEnumerator
    {
        AutoDetect,
        UseRelativePath;

    }
}

