/*
 * Decompiled with CFR 0.152.
 */
package io.qt.qtjambi.deployer;

import io.qt.core.QByteArray;
import io.qt.core.QCborArray;
import io.qt.core.QCborMap;
import io.qt.core.QCborValue;
import io.qt.core.QCommandLineOption;
import io.qt.core.QCommandLineParser;
import io.qt.core.QDir;
import io.qt.core.QFile;
import io.qt.core.QFileDevice;
import io.qt.core.QIODevice;
import io.qt.core.QList;
import io.qt.core.QStringList;
import io.qt.qtjambi.deployer.Main;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;

class AppGenerator {
    AppGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    static void generate(QCommandLineParser parser, String[] args, QCommandLineOption dirOption, QCommandLineOption classPathOption, QCommandLineOption configurationOption) throws InterruptedException, IOException {
        block122: {
            block120: {
                block121: {
                    applicationJNIMinVersionOption = new QCommandLineOption((Collection)QList.of((String)"jni-minimum-version", (String[])new String[0]), "Minimum version for the required JNI", "version");
                    applicationNameOption = new QCommandLineOption((Collection)QList.of((String)"application", (String[])new String[]{"application-name"}), "Application name", "name");
                    applicationIcoOption = new QCommandLineOption((Collection)QList.of((String)"ico", (String[])new String[]{"application-icon"}), "Application icon", "file");
                    applicationMPOption = new QCommandLineOption((Collection)QList.of((String)"mp", (String[])new String[]{"module-path"}), "Module path for application execution", "path");
                    applicationLPOption = new QCommandLineOption((Collection)QList.of((String)"lp", (String[])new String[]{"library-path"}), "Library path for application execution", "path");
                    applicationMainClassOption = new QCommandLineOption((Collection)QList.of((String)"main-class", (String[])new String[0]), "Main class", "class");
                    applicationAutodetectJvmOption = new QCommandLineOption((Collection)QList.of((String)"autodetect-jvm", (String[])new String[0]), "Autodetect Java Virtual Machine at runtime");
                    applicationJVMMinVersionOption = new QCommandLineOption((Collection)QList.of((String)"minversion-jvm", (String[])new String[]{"jvm-minimum-version"}), "Minimum version for the autodetected Java Virtual Machine", "version");
                    applicationJVMPathOption = new QCommandLineOption((Collection)QList.of((String)"jvm-path", (String[])new String[0]), "Path to Java Virtual Machine (absolute or relative to app binary)", "version");
                    applicationExeOption = new QCommandLineOption((Collection)QList.of((String)"executable", (String[])new String[0]), "Path to executable file.\nExamples:\n--executable=path" + File.separator + "QtJambiLauncher.exe\n--executable=macos" + File.pathSeparator + "path" + File.separator + "QtJambiLauncher.app", "file");
                    applicationExeLocationOption = new QCommandLineOption((Collection)QList.of((String)"executable-location", (String[])new String[0]), "Directory containing QtJambiLauncher executable", "path");
                    applicationJVMArgOption = new QCommandLineOption((Collection)QList.of((String)"jvmarg", (String[])new String[0]), "JVM argument", "arg");
                    parser.addOptions((Collection)QList.of((Object)configurationOption, (Object[])new QCommandLineOption[]{applicationJNIMinVersionOption, applicationNameOption, applicationIcoOption, applicationMPOption, applicationLPOption, applicationMainClassOption, applicationAutodetectJvmOption, applicationJVMMinVersionOption, applicationJVMPathOption, applicationExeOption, applicationExeLocationOption, applicationJVMArgOption, dirOption, classPathOption}));
                    parser.addPositionalArgument("jvmargs", "Argument for Java Virtual Machine");
                    if (args.length == 1) {
                        parser.showHelp();
                    }
                    parser.process((Collection)new QStringList(args));
                    additionalArguments = new QStringList((Collection)parser.positionalArguments());
                    appName = null;
                    if (parser.isSet(applicationNameOption)) {
                        appName = parser.value(applicationNameOption);
                    }
                    mainClass = null;
                    if (parser.isSet(applicationMainClassOption)) {
                        mainClass = parser.value(applicationMainClassOption);
                    }
                    jvmPath = null;
                    if (parser.isSet(applicationJVMPathOption)) {
                        jvmPath = parser.value(applicationJVMPathOption);
                    }
                    dir = null;
                    if (parser.isSet(dirOption)) {
                        dir = new QDir(QDir.fromNativeSeparators((String)parser.value(dirOption)));
                    }
                    ico = null;
                    if (parser.isSet(applicationIcoOption)) {
                        ico = new QFile(QDir.fromNativeSeparators((String)parser.value(applicationIcoOption)));
                    }
                    jniMinimumVersion = null;
                    if (parser.isSet(applicationJNIMinVersionOption)) {
                        jniMinimumVersion = Integer.parseInt(parser.value(applicationJNIMinVersionOption), 16);
                    }
                    classPaths = new ArrayList<String>();
                    if (parser.isSet(classPathOption)) {
                        classPaths.addAll(Arrays.asList(parser.value(classPathOption).split(File.pathSeparator)));
                    }
                    modulePaths = new ArrayList<String>();
                    if (parser.isSet(applicationMPOption)) {
                        modulePaths.addAll(Arrays.asList(parser.value(applicationMPOption).split(File.pathSeparator)));
                    }
                    libraryPaths = new ArrayList<String>();
                    if (parser.isSet(applicationLPOption)) {
                        libraryPaths.addAll(Arrays.asList(parser.value(applicationLPOption).split(File.pathSeparator)));
                    }
                    executables = new ArrayList<AbstractMap.SimpleEntry<Object, URL>>();
                    if (!parser.isSet(applicationExeOption)) break block120;
                    exeinfo = parser.value(applicationExeOption).split(File.pathSeparator);
                    if (exeinfo.length != 2) break block121;
                    exeFile = new File(exeinfo[1]);
                    if (!exeFile.isFile()) {
                        throw new Error("Specified launcher executable does not exist: " + exeinfo[1]);
                    }
                    executables.add(new AbstractMap.SimpleEntry<String, URL>(exeinfo[0], exeFile.toURI().toURL()));
                    break block122;
                }
                os = null;
                exeFile = new File(exeinfo[0]);
                if (exeinfo[0].endsWith(".exe")) {
                    os = "windows";
                    if (!exeFile.isFile()) {
                        throw new Error("Specified launcher executable does not exist: " + exeinfo[0]);
                    }
                } else if (exeinfo[0].endsWith(".app")) {
                    if (!exeFile.isDirectory()) {
                        throw new Error("Specified launcher executable does not exist: " + exeinfo[0]);
                    }
                    os = "macos";
                } else {
                    if (!exeFile.isFile()) {
                        throw new Error("Specified launcher executable does not exist: " + exeinfo[0]);
                    }
                    os = "linux";
                }
                if (os == null) break block122;
                executables.add(new AbstractMap.SimpleEntry<Object, URL>(os, exeFile.toURI().toURL()));
                break block122;
            }
            if (parser.isSet(applicationExeLocationOption)) {
                location = new QDir(parser.value(applicationExeLocationOption));
                for (String entry : location.entryList(new QDir.Filter[]{QDir.Filter.Files})) {
                    os = null;
                    if (entry.equals("QtJambiLauncher.exe")) {
                        os = "windows";
                    } else if (entry.equals("QtJambiLauncher.app")) {
                        os = "macos";
                    } else if (entry.equals("QtJambiLauncher")) {
                        os = "linux";
                    }
                    if (os == null || !entry.contains("QtJambiLauncher")) continue;
                    libFile = new File(location.absoluteFilePath(entry));
                    executables.add(new AbstractMap.SimpleEntry<String, URL>(os, libFile.toURI().toURL()));
                }
            }
        }
        autoDetect = parser.isSet(applicationAutodetectJvmOption);
        minimumJVMVersion = 11;
        if (parser.isSet(applicationJVMMinVersionOption)) {
            minimumJVMVersion = Integer.parseInt(parser.value(applicationJVMMinVersionOption));
        }
        arguments = new ArrayList<E>(additionalArguments);
        if (parser.isSet(applicationJVMArgOption)) {
            arguments.addAll(parser.values(applicationJVMArgOption));
        }
        if (appName == null || appName.isEmpty()) {
            throw new Error("Missing application name. Please use --application=...");
        }
        if (!autoDetect && (jvmPath == null || jvmPath.isEmpty())) {
            throw new Error("Missing JVM path. Please use --jvm-path=...");
        }
        if (dir == null) {
            throw new Error("Missing target directory. Please use --dir=...");
        }
        if (mainClass == null || mainClass.isEmpty()) {
            throw new Error("Missing main class. Please use --main-class=...");
        }
        if (executables.isEmpty()) {
            specsFound = Main.findSpecs();
            specsUrls = new HashSet<URL>();
            while (specsFound.hasMoreElements()) {
                url = specsFound.nextElement();
                if (specsUrls.contains(url)) continue;
                specsUrls.add(url);
                protocol = url.getProtocol();
                if (!protocol.equals("jar") || (end = (eform = url.toExternalForm()).indexOf("!/", start = 4)) == -1) continue;
                try {
                    inStream = url.openStream();
                    try {
                        factory = DocumentBuilderFactory.newInstance();
                        factory.setValidating(false);
                        builder = factory.newDocumentBuilder();
                        doc = builder.parse(inStream);
                    }
                    finally {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    system = doc.getDocumentElement().getAttribute("system");
                    for (i = 0; i < doc.getDocumentElement().getChildNodes().getLength(); ++i) {
                        child = doc.getDocumentElement().getChildNodes().item(i);
                        if (!(child instanceof Element) || !child.getNodeName().equals("library") || !(library = (element = (Element)child).getAttribute("name")).endsWith("QtJambiLauncher") && !library.endsWith("QtJambiLauncher_debug") && !library.endsWith(".exe")) continue;
                        libraryURL = new URL(eform.substring(0, end + 2) + library);
                        executables.add(new AbstractMap.SimpleEntry<String, URL>(system, (URL)libraryURL));
                    }
                }
                catch (Exception e) {
                    Logger.getLogger("io.qt").log(Level.WARNING, "", e);
                }
            }
        }
        if (executables.isEmpty()) {
            throw new Error("Missing paths to QtJambiLauncher executables. Please use --executable=<path to executable>, --executable=<platform>" + File.pathSeparatorChar + "<path to executable> or --executable-location=<path>");
        }
        cborValue = new QCborMap();
        cborValue.setValue(Main.Parameters.JVMDetectionMode.value(), new QCborValue(autoDetect != false ? Main.JVMDetectionModes.AutoDetect.value() : Main.JVMDetectionModes.UseRelativePath.value()));
        if (autoDetect) {
            cborValue.setValue(Main.Parameters.MinimumJVM.value(), new QCborValue(minimumJVMVersion));
        } else {
            cborValue.setValue(Main.Parameters.JVMPath.value(), new QCborValue(jvmPath));
        }
        arrayFactory = (IntFunction<QCborValue[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$generate$0(int ), (I)[Lio/qt/core/QCborValue;)();
        cborValue.setValue(Main.Parameters.MainClass.value(), new QCborValue(mainClass));
        argumentArray = new QCborArray((QCborValue[])arguments.stream().map((Function<String, QByteArray>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Lio/qt/core/QByteArray;)()).map((Function<QByteArray, QCborValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(io.qt.core.QByteArray ), (Lio/qt/core/QByteArray;)Lio/qt/core/QCborValue;)()).toArray(arrayFactory));
        cborValue.setValue(Main.Parameters.JVMArguments.value(), new QCborValue(argumentArray));
        classPathArray = new QCborArray((QCborValue[])classPaths.stream().map((Function<String, QCborValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Lio/qt/core/QCborValue;)()).toArray(arrayFactory));
        cborValue.setValue(Main.Parameters.ClassPath.value(), new QCborValue(classPathArray));
        modulePathArray = new QCborArray((QCborValue[])modulePaths.stream().map((Function<String, QCborValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Lio/qt/core/QCborValue;)()).toArray(arrayFactory));
        cborValue.setValue(Main.Parameters.ModulePath.value(), new QCborValue(modulePathArray));
        libraryPathArray = new QCborArray((QCborValue[])libraryPaths.stream().map((Function<String, QCborValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Lio/qt/core/QCborValue;)()).toArray(arrayFactory));
        cborValue.setValue(Main.Parameters.LibraryPath.value(), new QCborValue(libraryPathArray));
        if (jniMinimumVersion != null) {
            cborValue.setValue(Main.Parameters.JNIMinimumVersion.value(), new QCborValue(jniMinimumVersion.intValue()));
        }
        if ((cborData = cborValue.toCborValue().toCbor()).size() > 16384) {
            throw new Error("Launcher metadata exceeds maximum size of 16384 byte.");
        }
        System.gc();
        QTJAMBI_LAUNCHER = new QByteArray("QTJAMBI_LAUNCHER!");
        block64: for (Map.Entry entry : executables) {
            os = (String)entry.getKey();
            if (os == null) continue;
            file = (URL)entry.getValue();
            libraryURL = os.toLowerCase();
            var45_55 = -1;
            switch (libraryURL.hashCode()) {
                case 102977780: {
                    if (!libraryURL.equals("linux")) break;
                    var45_55 = 0;
                    break;
                }
                case 177400403: {
                    if (!libraryURL.equals("linux32")) break;
                    var45_55 = 1;
                    break;
                }
                case 177400498: {
                    if (!libraryURL.equals("linux64")) break;
                    var45_55 = 2;
                    break;
                }
                case 1345206273: {
                    if (!libraryURL.equals("linux-arm64")) break;
                    var45_55 = 3;
                    break;
                }
                case -522613412: {
                    if (!libraryURL.equals("linux-aarch64")) break;
                    var45_55 = 4;
                    break;
                }
                case -1317014243: {
                    if (!libraryURL.equals("linux-x86")) break;
                    var45_55 = 5;
                    break;
                }
                case -1317014307: {
                    if (!libraryURL.equals("linux-x64")) break;
                    var45_55 = 6;
                    break;
                }
                case 113134395: {
                    if (!libraryURL.equals("win32")) break;
                    var45_55 = 7;
                    break;
                }
                case 113134490: {
                    if (!libraryURL.equals("win64")) break;
                    var45_55 = 8;
                    break;
                }
                case 1349493379: {
                    if (!libraryURL.equals("windows")) break;
                    var45_55 = 9;
                    break;
                }
                case -1736515605: {
                    if (!libraryURL.equals("windows-aarch64")) break;
                    var45_55 = 10;
                    break;
                }
                case 383050320: {
                    if (!libraryURL.equals("windows-arm64")) break;
                    var45_55 = 11;
                    break;
                }
                case 1931142956: {
                    if (!libraryURL.equals("windows-x86")) break;
                    var45_55 = 12;
                    break;
                }
                case 1931142892: {
                    if (!libraryURL.equals("windows-x64")) break;
                    var45_55 = 13;
                    break;
                }
                case 103652211: {
                    if (!libraryURL.equals("macos")) break;
                    var45_55 = 14;
                    break;
                }
                case 110356: {
                    if (!libraryURL.equals("osx")) break;
                    var45_55 = 15;
                }
            }
            switch (var45_55) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    newFile = new QFile(dir.absoluteFilePath(appName));
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    newFile = new QFile(dir.absoluteFilePath(appName + ".exe"));
                    System.gc();
                    break;
                }
                case 14: 
                case 15: {
                    fileBase = file.toExternalForm();
                    if (fileBase.endsWith("/")) {
                        fileBase = fileBase.substring(0, fileBase.length() - 1);
                    }
                    if ((idx = (baseName = fileBase).lastIndexOf(47)) > 0) {
                        baseName = baseName.substring(idx + 1);
                    }
                    if (baseName.endsWith(".app")) {
                        baseName = baseName.substring(0, baseName.length() - 4);
                    }
                    dir.mkpath(appName + ".app/Contents/MacOS");
                    dir.mkpath(appName + ".app/Contents/Resources");
                    try {
                        infoPListUrl = new URL(fileBase + "/Contents/Info.plist");
                        device = QIODevice.fromInputStream((InputStream)infoPListUrl.openStream());
                        data = device.readAll();
                        device.close();
                        idx = data.indexOf("<key>CFBundleIdentifier</key>");
                        if (idx > 0 && (idx = data.indexOf("<string>", idx)) > 0 && (idxEnd = data.indexOf("</string>", idx += 8)) > idx) {
                            data = data.remove(idx, idxEnd - idx);
                            data.insert(idx, mainClass);
                        }
                        data = data.replace(baseName, appName);
                        data = data.replace("QtJambiLauncher", appName);
                        infoPList = new QFile(dir.absoluteFilePath(appName + ".app/Contents/Info.plist"));
                        infoPList.remove();
                        if (infoPList.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly})) {
                            infoPList.write(data);
                            infoPList.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        pkgInfoUrl = new URL(fileBase + "/Contents/PkgInfo");
                        device = QIODevice.fromInputStream((InputStream)pkgInfoUrl.openStream());
                        data = device.readAll();
                        device.close();
                        dir.mkpath(appName + ".app/Contents");
                        pkgInfo = new QFile(dir.absoluteFilePath(appName + ".app/Contents/PkgInfo"));
                        pkgInfo.remove();
                        if (pkgInfo.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly})) {
                            pkgInfo.write(data);
                            pkgInfo.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        emptylprojUrl = new URL(fileBase + "/Contents/Resources/empty.lproj");
                        device = QIODevice.fromInputStream((InputStream)emptylprojUrl.openStream());
                        data = device.readAll();
                        device.close();
                        dir.mkpath(appName + ".app/Contents/Resources");
                        emptylproj = new QFile(dir.absoluteFilePath(appName + ".app/Contents/Resources/empty.lproj"));
                        emptylproj.remove();
                        if (emptylproj.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly})) {
                            emptylproj.write(data);
                            emptylproj.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        executableUrl = new URL(fileBase + "/Contents/MacOS/" + baseName);
                        device = QIODevice.fromInputStream((InputStream)executableUrl.openStream());
                        data = device.readAll();
                        device.close();
                        dir.mkpath(appName + ".app/Contents/MacOS");
                        executable = new QFile(dir.absoluteFilePath(appName + ".app/Contents/MacOS/" + appName));
                        executable.remove();
                        if (executable.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly})) {
                            executable.write(data);
                            executable.close();
                            executable.setPermissions(executable.permissions().combined(QFileDevice.Permission.ExeGroup).combined(QFileDevice.Permission.ExeOther).combined(QFileDevice.Permission.ExeOwner).combined(QFileDevice.Permission.ExeUser));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    dir.mkpath(appName + ".app/Contents/Resources");
                    params = new QFile(dir.absoluteFilePath(appName + ".app/Contents/Resources/params.cbor"));
                    params.remove();
                    if (!params.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly})) continue block64;
                    params.write(cborData);
                    params.close();
                    continue block64;
                }
                default: {
                    continue block64;
                }
            }
            try {
                device = QIODevice.fromInputStream((InputStream)file.openStream());
                exeData = device.readAll();
                device.close();
                idx = exeData.indexOf(QTJAMBI_LAUNCHER);
                if (idx > 0) {
                    newFile.remove();
                    if (newFile.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly})) {
                        try {
                            newFile.write(exeData);
                            while (idx > 0) {
                                newFile.seek((long)idx);
                                newFile.write(cborData);
                                idx = exeData.indexOf(QTJAMBI_LAUNCHER, idx + cborData.length());
                            }
                            var47_59 = os.toLowerCase();
                            var48_66 = -1;
                            switch (var47_59.hashCode()) {
                                case 113134395: {
                                    if (!var47_59.equals("win32")) break;
                                    var48_66 = 0;
                                    break;
                                }
                                case 113134490: {
                                    if (!var47_59.equals("win64")) break;
                                    var48_66 = 1;
                                    break;
                                }
                                case 1349493379: {
                                    if (!var47_59.equals("windows")) break;
                                    var48_66 = 2;
                                }
                            }
                            switch (var48_66) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    idx = exeData.indexOf(new QByteArray("QTJAMBI_ICO!"));
                                    if (idx <= 254) ** break;
                                    if (ico != null) {
                                        if (!ico.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly})) ** break;
                                        icoData = ico.readAll();
                                        if (icoData.size() >= 92482) {
                                            throw new Error("Icon size too big.");
                                        }
                                        newFile.seek((long)(idx - 254));
                                        newFile.write(icoData);
                                        ** break;
lbl398:
                                        // 1 sources

                                        break;
                                    }
                                    stream = Main.class.getResourceAsStream("icon.ico");
                                    try {
                                        buffer = new ByteArrayOutputStream();
                                        try {
                                            data = new byte[10240];
                                            length = stream.read(data);
                                            while (length > 0) {
                                                buffer.write(data, 0, length);
                                                length = stream.read(data);
                                            }
                                            data = buffer.toByteArray();
                                            if (data.length < 92482) {
                                                newFile.seek((long)(idx - 254));
                                                newFile.write(data);
                                            }
                                            break;
                                        }
                                        finally {
                                            buffer.close();
                                        }
                                    }
                                    finally {
                                        if (stream != null) {
                                            stream.close();
                                        }
                                    }
                                }
                                ** default:
lbl424:
                                // 1 sources

                                break;
                            }
                        }
                        finally {
                            newFile.close();
                        }
                        newFile.setPermissions(newFile.permissions().combined(QFileDevice.Permission.ExeGroup).combined(QFileDevice.Permission.ExeOther).combined(QFileDevice.Permission.ExeOwner).combined(QFileDevice.Permission.ExeUser));
                        continue;
                    }
                    throw new Error("Unable to write file " + newFile.fileName());
                }
                throw new Error("Unable to find \"" + QTJAMBI_LAUNCHER + "\" in file " + file.toExternalForm());
            }
            catch (IOException e) {
                throw new Error("Unable to read file " + file.toExternalForm(), e);
            }
        }
    }

    private static /* synthetic */ QCborValue[] lambda$generate$0(int length) {
        return new QCborValue[length];
    }
}

