/*
 * Decompiled with CFR 0.152.
 */
package io.qt.qtjambi.deployer;

import io.qt.QtUtilities;
import io.qt.core.QByteArray;
import io.qt.core.QCborMap;
import io.qt.core.QCborValue;
import io.qt.core.QCommandLineOption;
import io.qt.core.QCommandLineParser;
import io.qt.core.QDir;
import io.qt.core.QFile;
import io.qt.core.QIODevice;
import io.qt.core.QJsonArray;
import io.qt.core.QJsonObject;
import io.qt.core.QJsonValue;
import io.qt.core.QList;
import io.qt.core.QPair;
import io.qt.core.QStringList;
import io.qt.core.QTextStream;
import io.qt.internal.DeployerUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

final class ContainerAccessGenerator {
    private static final long[] alignments = new long[]{1L, 2L, 4L, 8L};
    private static final boolean isQt5 = QtUtilities.qtjambiVersion().majorVersion() == 5;

    ContainerAccessGenerator() {
    }

    private static <A> void appendUnique(List<A> specs, A spec) {
        if (!specs.contains(spec)) {
            specs.add(spec);
        }
    }

    static void generate(QCommandLineParser parser, String[] args, QCommandLineOption dirOption) throws InterruptedException, IOException {
        QCommandLineOption specificationsOption = new QCommandLineOption((Collection)QList.of((String)"specifications", (String[])new String[0]), "Target specifications (e.g. QList/1/1)", "specifications");
        parser.addOptions(Arrays.asList(dirOption, specificationsOption));
        if (args.length == 1) {
            parser.showHelp();
        }
        parser.process((Collection)new QStringList(args));
        QStringList unusedArguments = new QStringList((Collection)parser.positionalArguments());
        if (unusedArguments.size() == 1) {
            throw new Error("Qt plugin generation, illegal argument: " + unusedArguments.join(", "));
        }
        if (unusedArguments.size() > 1) {
            throw new Error("Qt plugin generation, illegal argument: " + unusedArguments.join(", "));
        }
        if (!parser.isSet(dirOption)) {
            throw new Error("Missing target directory. Please use --dir=...");
        }
        File dir = new File(parser.value(dirOption));
        ArrayList<String> specifications = new ArrayList<String>();
        if (!parser.isSet(specificationsOption)) {
            throw new Error("Missing specifications. Please use --specifications=...");
        }
        specifications.addAll(Arrays.asList(parser.value(specificationsOption).split("\\,")));
        ArrayList containerSpecs = new ArrayList();
        ArrayList<MapSpec> mapSpecs = new ArrayList<MapSpec>();
        if (specifications.remove("analyze") && !isQt5) {
            QDir io_qt_dir = new QDir(":/io/qt");
            for (String subdir : io_qt_dir.entryList(new QDir.Filter[]{QDir.Filter.Dirs, QDir.Filter.NoDotAndDotDot})) {
                try {
                    QtUtilities.initializePackage((String)("io.qt." + subdir));
                }
                catch (Throwable throwable) {}
            }
            Map map = new TreeMap();
            try {
                map = DeployerUtility.getRegisteredTypeSizesAndAlignments();
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
            QPair stringPair = null;
            for (String key : new ArrayList(map.keySet())) {
                if (key.equals("QStringMatcher") || key.equals("QByteArrayMatcher") || key.startsWith("QStyleOption") || key.startsWith("QXmlStream") || key.startsWith("QDBusReply<")) {
                    map.remove(key);
                }
                if (!key.equals("QString")) continue;
                stringPair = (QPair)map.get(key);
            }
            HashSet sizesAndAlignments = new HashSet(map.values());
            HashSet<QPair> keySizesAndAlignments = new HashSet<QPair>();
            if (stringPair != null) {
                keySizesAndAlignments.add(stringPair);
            }
            keySizesAndAlignments.add(new QPair((Object)1L, (Object)1L));
            keySizesAndAlignments.add(new QPair((Object)2L, (Object)2L));
            keySizesAndAlignments.add(new QPair((Object)4L, (Object)4L));
            keySizesAndAlignments.add(new QPair((Object)8L, (Object)8L));
            for (MapType t : new MapType[]{MapType.QMap, MapType.QMultiMap}) {
                for (QPair pair2 : sizesAndAlignments) {
                    for (QPair pair : keySizesAndAlignments) {
                        mapSpecs.add(new MapSpec(t, (Long)pair.first, (Long)pair.second, (Long)pair2.first, (Long)pair2.second));
                    }
                }
            }
            ContainerAccessGenerator.appendUnique(mapSpecs, new MapSpec(MapType.QMultiMap, 16L, 4L, 2L, 2L));
            ContainerAccessGenerator.appendUnique(mapSpecs, new MapSpec(MapType.QMultiMap, 8L, 8L, 8L, 1L));
            ContainerAccessGenerator.appendUnique(mapSpecs, new MapSpec(MapType.QMap, 8L, 8L, 8L, 1L));
        }
        for (String specification : specifications) {
            String[] parts = specification.split("/");
            ContainerType containerType = null;
            Object mapType = null;
            switch (parts[0]) {
                case "QList": {
                    containerType = ContainerType.QList;
                    break;
                }
                case "QLinkedList": {
                    containerType = ContainerType.QLinkedList;
                    break;
                }
                case "QVector": {
                    containerType = ContainerType.QVector;
                    break;
                }
                case "QSet": {
                    containerType = ContainerType.QSet;
                    break;
                }
                default: {
                    mapType = MapType.valueOf(parts[0]);
                }
            }
            if (containerType != null) {
                if (parts.length < 2) continue;
                long size = Long.parseLong(parts[1]);
                if (parts.length == 2) {
                    ContainerAccessGenerator.appendUnique(containerSpecs, new ContainerSpec(containerType, size, -1L));
                    continue;
                }
                long alignment = Long.parseLong(parts[2]);
                if (alignment > size) continue;
                ContainerAccessGenerator.appendUnique(containerSpecs, new ContainerSpec(containerType, size, alignment));
                continue;
            }
            if (mapType == null || parts.length < 3) continue;
            long size1 = Long.parseLong(parts[1]);
            if (parts.length == 3) {
                long size2 = Long.parseLong(parts[2]);
                ContainerAccessGenerator.appendUnique(mapSpecs, new MapSpec((MapType)((Object)mapType), size1, -1L, size2, -1L));
                continue;
            }
            if (parts.length < 5) continue;
            long alignment1 = Long.parseLong(parts[2]);
            long size2 = Long.parseLong(parts[3]);
            long alignment2 = Long.parseLong(parts[4]);
            if (alignment1 > size1 || alignment2 > size2) continue;
            ContainerAccessGenerator.appendUnique(mapSpecs, new MapSpec((MapType)((Object)mapType), size1, alignment1, size2, alignment2));
        }
        if (!containerSpecs.isEmpty() || !mapSpecs.isEmpty()) {
            QStringList plugin_cpp = new QStringList();
            QFile f = new QFile(":/io/qt/qtjambi/deployer/containeraccess.cpp");
            if (f.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly})) {
                QTextStream s = new QTextStream((QIODevice)f);
                while (!s.atEnd()) {
                    plugin_cpp.add((Object)s.readLine());
                }
                f.close();
            }
            QStringList plugin_pro = new QStringList();
            QFile f2 = new QFile(":/io/qt/qtjambi/deployer/containeraccess.pro");
            if (f2.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly})) {
                QTextStream s = new QTextStream((QIODevice)f2);
                while (!s.atEnd()) {
                    plugin_pro.add((Object)s.readLine());
                }
                f2.close();
            }
            QCborMap cborValue = new QCborMap();
            cborValue.setValue(2L, new QCborValue("io.qt.qtjambi.ContainerAccess"));
            cborValue.setValue(3L, new QCborValue(""));
            dir = new File(dir, "containeraccess");
            dir.mkdirs();
            ArrayList<String> subdirs = new ArrayList<String>();
            for (ContainerSpec containerSpec : containerSpecs) {
                subdirs.add(ContainerAccessGenerator.generateSource(dir, containerSpec, (Iterable<String>)plugin_cpp, (Iterable<String>)plugin_pro, cborValue.clone()));
            }
            for (MapSpec mapSpec : mapSpecs) {
                subdirs.add(ContainerAccessGenerator.generateSource(dir, mapSpec, (Iterable<String>)plugin_cpp, (Iterable<String>)plugin_pro, cborValue.clone()));
            }
            QFile c_pro = new QFile(new QDir(dir.getAbsolutePath()).absoluteFilePath("containeraccess.pro"));
            if (c_pro.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly, QIODevice.OpenModeFlag.Text})) {
                QTextStream s = new QTextStream((QIODevice)c_pro);
                s.append("TEMPLATE = subdirs").endl().append("CONFIG += ordered").endl();
                for (String subdir : subdirs) {
                    if (subdir == null || subdir.isEmpty()) continue;
                    s.append("SUBDIRS += ").append(subdir).endl();
                }
                c_pro.close();
            }
        }
    }

    private static String generateSource(File dir, ContainerSpec containerSpec, Iterable<String> plugin_cpp, Iterable<String> plugin_pro, QCborMap cborValue) {
        String target = containerSpec.alignment == -1L ? String.format("%1$sAccess_S%2$s", containerSpec.containerType.name(), containerSpec.size) : String.format("%1$sAccess_S%2$s_A%3$s", containerSpec.containerType.name(), containerSpec.size, containerSpec.alignment);
        dir = new File(dir, target);
        dir.mkdirs();
        String flatTypeName = containerSpec.containerType.name().toLowerCase().substring(1);
        StringBuilder implData = new StringBuilder();
        QTextStream stream2 = new QTextStream((Object)implData);
        ArrayList<String> targets = new ArrayList<String>();
        if (containerSpec.alignment == -1L) {
            for (long algn : alignments) {
                if (algn > containerSpec.size) continue;
                targets.add(String.format("%1$sAccess_S%2$s_A%3$s", containerSpec.containerType.name(), containerSpec.size, algn));
                stream2.append("    ContainerAccessFactoryHelper<").append(containerSpec.containerType.name()).append(", ").append(algn).append(", ").append(containerSpec.size).append(", false>::registerContainerAccessFactory();").endl();
                if (containerSpec.containerType != ContainerType.QList || !isQt5) continue;
                stream2.append("    ContainerAccessFactoryHelper<").append(containerSpec.containerType.name()).append(", ").append(algn).append(", ").append(containerSpec.size).append(", true>::registerContainerAccessFactory();").endl();
            }
        } else {
            long algn = containerSpec.alignment;
            if (algn <= containerSpec.size) {
                targets.add(target);
                stream2.append("    ContainerAccessFactoryHelper<").append(containerSpec.containerType.name()).append(", ").append(algn).append(", ").append(containerSpec.size).append(", false>::registerContainerAccessFactory();").endl();
                if (containerSpec.containerType == ContainerType.QList && isQt5) {
                    stream2.append("    ContainerAccessFactoryHelper<").append(containerSpec.containerType.name()).append(", ").append(algn).append(", ").append(containerSpec.size).append(", true>::registerContainerAccessFactory();").endl();
                }
            }
        }
        stream2.dispose();
        ContainerAccessGenerator.generateFiles(dir, flatTypeName, implData, plugin_cpp, plugin_pro, cborValue, target, targets);
        return target;
    }

    private static String generateSource(File dir, MapSpec mapSpec, Iterable<String> plugin_cpp, Iterable<String> plugin_pro, QCborMap cborValue) {
        String target = mapSpec.alignment1 == -1L ? (mapSpec.alignment2 == -1L ? String.format("%1$sAccess_S%2$s_S%3$s", mapSpec.mapType.name(), mapSpec.size1, mapSpec.size2) : String.format("%1$sAccess_S%2$s_A%3$s_S%4$s", mapSpec.mapType.name(), mapSpec.size1, mapSpec.alignment1, mapSpec.size2)) : (mapSpec.alignment2 == -1L ? String.format("%1$sAccess_S%2$s_A%3$s_S%4$s", mapSpec.mapType.name(), mapSpec.size1, mapSpec.alignment1, mapSpec.size2) : String.format("%1$sAccess_S%2$s_A%3$s_S%4$s_A%5$s", mapSpec.mapType.name(), mapSpec.size1, mapSpec.alignment1, mapSpec.size2, mapSpec.alignment2));
        dir = new File(dir, target);
        dir.mkdirs();
        String flatTypeName = mapSpec.mapType.name().toLowerCase().substring(1);
        StringBuilder implData = new StringBuilder();
        QTextStream stream2 = new QTextStream((Object)implData);
        ArrayList<String> targets = new ArrayList<String>();
        if (mapSpec.alignment1 == -1L) {
            for (long algn1 : alignments) {
                if (algn1 > mapSpec.size1) continue;
                if (mapSpec.alignment2 == -1L) {
                    for (long algn2 : alignments) {
                        if (algn2 > mapSpec.size2) continue;
                        targets.add(String.format("%1$sAccess_S%2$s_A%3$s_S%4$s_A%5$s", mapSpec.mapType.name(), mapSpec.size1, algn1, mapSpec.size2, algn2));
                        stream2.append("    BiContainerAccessFactoryHelper<").append(mapSpec.mapType.name()).append(", ").append(algn1).append(", ").append(mapSpec.size1).append(", ").append(algn2).append(", ").append(mapSpec.size2).append(">::registerContainerAccessFactory();").endl();
                    }
                    continue;
                }
                long algn2 = mapSpec.alignment2;
                targets.add(String.format("%1$sAccess_S%2$s_A%3$s_S%4$s_A%5$s", mapSpec.mapType.name(), mapSpec.size1, algn1, mapSpec.size2, algn2));
                stream2.append("    BiContainerAccessFactoryHelper<").append(mapSpec.mapType.name()).append(", ").append(algn1).append(", ").append(mapSpec.size1).append(", ").append(algn2).append(", ").append(mapSpec.size2).append(">::registerContainerAccessFactory();").endl();
            }
        } else {
            long algn1 = mapSpec.alignment1;
            if (algn1 <= mapSpec.size1) {
                if (mapSpec.alignment2 == -1L) {
                    for (long algn2 : alignments) {
                        if (algn2 > mapSpec.size2) continue;
                        targets.add(String.format("%1$sAccess_S%2$s_A%3$s_S%4$s_A%5$s", mapSpec.mapType.name(), mapSpec.size1, algn1, mapSpec.size2, algn2));
                        stream2.append("    BiContainerAccessFactoryHelper<").append(mapSpec.mapType.name()).append(", ").append(algn1).append(", ").append(mapSpec.size1).append(", ").append(algn2).append(", ").append(mapSpec.size2).append(">::registerContainerAccessFactory();").endl();
                    }
                } else {
                    long algn2 = mapSpec.alignment2;
                    targets.add(target);
                    stream2.append("    BiContainerAccessFactoryHelper<").append(mapSpec.mapType.name()).append(", ").append(algn1).append(", ").append(mapSpec.size1).append(", ").append(algn2).append(", ").append(mapSpec.size2).append(">::registerContainerAccessFactory();").endl();
                }
            }
        }
        stream2.dispose();
        ContainerAccessGenerator.generateFiles(dir, flatTypeName, implData, plugin_cpp, plugin_pro, cborValue, target, targets);
        return target;
    }

    private static void generateFiles(File dir, String flatTypeName, StringBuilder implData, Iterable<String> plugin_cpp, Iterable<String> plugin_pro, QCborMap cborValue, String libName, List<String> targets) {
        QByteArray c_cpp_data = new QByteArray();
        QTextStream s = new QTextStream(c_cpp_data);
        for (String line : plugin_cpp) {
            if ("#define CBOR_DATA".equals(line)) {
                s.append("#include <qtjambi/qtjambi_containeraccess_").append(flatTypeName).append(".h>").endl().endl().append("#define CBOR_DATA \\").endl().append("    ");
                QJsonObject metaData = new QJsonObject();
                QJsonArray targetArray = new QJsonArray();
                for (String target : targets) {
                    targetArray.append(new QJsonValue(target));
                }
                metaData.setValue("Keys", new QJsonValue(targetArray));
                cborValue.setValue(4L, new QCborValue(QCborMap.fromJsonObject((QJsonObject)metaData)));
                QByteArray cborData = cborValue.toCborValue().toCbor();
                byte[] data = cborData.toByteArray();
                int i = 0;
                int j = 0;
                while (i < data.length) {
                    byte b = data[i];
                    if (Character.isAlphabetic(b)) {
                        s.append('\'').append((char)b).append("', ");
                    } else {
                        String hex = Integer.toHexString(Byte.toUnsignedInt(b));
                        while (hex.length() > 2 && hex.charAt(0) == '0') {
                            hex = hex.substring(1);
                        }
                        s.append("0x").append(hex).append(", ");
                    }
                    if (j == 7) {
                        s.append("\\").endl().append("    ");
                        j = 0;
                    }
                    ++i;
                    ++j;
                }
                s.endl().endl();
                continue;
            }
            if ("//qt_plugin_instance_impl".equals(line)) {
                s.append(implData.toString()).endl();
                continue;
            }
            s.append(line).endl();
        }
        s.dispose();
        QFile c_cpp = new QFile(new QDir(dir.getAbsolutePath()).absoluteFilePath("containeraccess.cpp"));
        if (c_cpp.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly})) {
            QByteArray all = c_cpp.readAll();
            c_cpp.close();
            if (!all.equals((Object)c_cpp_data) && c_cpp.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly})) {
                c_cpp.write(c_cpp_data);
                c_cpp.close();
            }
        } else if (c_cpp.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly})) {
            c_cpp.write(c_cpp_data);
            c_cpp.close();
        }
        QByteArray c_pro_data = new QByteArray();
        QTextStream s2 = new QTextStream(c_pro_data);
        s2.append("TARGET = ").append(libName).endl();
        for (String line : plugin_pro) {
            s2.append(line).endl();
        }
        s2.dispose();
        QFile c_pro = new QFile(new QDir(dir.getAbsolutePath()).absoluteFilePath(libName + ".pro"));
        if (c_pro.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly})) {
            QByteArray all = c_pro.readAll();
            c_pro.close();
            if (!all.equals((Object)c_pro_data) && c_pro.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly})) {
                c_pro.write(c_pro_data);
                c_pro.close();
            }
        } else if (c_pro.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.WriteOnly})) {
            c_pro.write(c_pro_data);
            c_pro.close();
        }
    }

    private static enum MapType {
        QHash,
        QMap,
        QMultiHash,
        QMultiMap,
        QPair;

    }

    private static class MapSpec {
        final MapType mapType;
        final long size1;
        final long alignment1;
        final long size2;
        final long alignment2;

        public int hashCode() {
            return Objects.hash(new Object[]{this.alignment1, this.alignment2, this.mapType, this.size1, this.size2});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapSpec other = (MapSpec)obj;
            return this.alignment1 == other.alignment1 && this.alignment2 == other.alignment2 && this.mapType == other.mapType && this.size1 == other.size1 && this.size2 == other.size2;
        }

        MapSpec(MapType mapType, long size1, long alignment1, long size2, long alignment2) {
            this.mapType = mapType;
            this.size1 = size1;
            this.alignment1 = alignment1;
            this.size2 = size2;
            this.alignment2 = alignment2;
        }
    }

    private static enum ContainerType {
        QList,
        QVector,
        QLinkedList,
        QSet;

    }

    private static class ContainerSpec {
        final ContainerType containerType;
        final long size;
        final long alignment;

        public int hashCode() {
            return Objects.hash(new Object[]{this.alignment, this.containerType, this.size});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContainerSpec other = (ContainerSpec)obj;
            return this.alignment == other.alignment && this.containerType == other.containerType && this.size == other.size;
        }

        ContainerSpec(ContainerType containerType, long size, long alignment) {
            this.containerType = containerType;
            this.size = size;
            this.alignment = alignment;
        }
    }
}

