#ifndef QSURFACE_IMPL_SHELL_H
#define QSURFACE_IMPL_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/qsurface.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qsize.h>
#include <QtGui/qsurfaceformat.h>
#include <QtJambi/RegistryAPI>


class QSurface_shell : public QSurface, public QtJambiShellInterface
{
public:
    ~QSurface_shell() override;

    QSurfaceFormat format() const override;
    QSize size() const override;
    QSurface::SurfaceType surfaceType() const override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QSurface_access : public QSurface
{
    jobject __qt_format(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_size(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_surfaceType(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QSURFACE_IMPL_SHELL_H
