#include <QtCore/QtGlobal>
#include <QtGui/qquaternion.h>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtGui/qvectornd.h>
#include "utils_p.h"

#include <QtJambi/QtJambiAPI>
#include <QtJambiGui/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QQuaternion(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QQuaternion")
    QQuaternion *_ptr = reinterpret_cast<QQuaternion *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QQuaternion()
void __qt_construct_QQuaternion_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QQuaternion()")
    Q_UNUSED(__java_arguments)
    QQuaternion *__qt_this = new(__qtjambi_ptr) QQuaternion();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QQuaternion(QVector4D)
void __qt_construct_QQuaternion_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QQuaternion(QVector4D)")
    jobject vector0 = __java_arguments[0].l;
    const QVector4D& __qt_vector0 = qtjambi_cast<const QVector4D& >(__jni_env, vector0);
    QQuaternion *__qt_this = new(__qtjambi_ptr) QQuaternion(__qt_vector0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QQuaternion(float,QVector3D)
void __qt_construct_QQuaternion_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QQuaternion(float,QVector3D)")
    jfloat scalar0 = __java_arguments[0].f;
    Q_UNUSED(scalar0)
    jobject vector1 = __java_arguments[1].l;
    const QVector3D& __qt_vector1 = qtjambi_cast<const QVector3D& >(__jni_env, vector1);
    QQuaternion *__qt_this = new(__qtjambi_ptr) QQuaternion(static_cast<float>(scalar0), __qt_vector1);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QQuaternion(float,float,float,float)
void __qt_construct_QQuaternion_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QQuaternion(float,float,float,float)")
    jfloat scalar0 = __java_arguments[0].f;
    Q_UNUSED(scalar0)
    jfloat xpos1 = __java_arguments[1].f;
    Q_UNUSED(xpos1)
    jfloat ypos2 = __java_arguments[2].f;
    Q_UNUSED(ypos2)
    jfloat zpos3 = __java_arguments[3].f;
    Q_UNUSED(zpos3)
    QQuaternion *__qt_this = new(__qtjambi_ptr) QQuaternion(static_cast<float>(scalar0), static_cast<float>(xpos1), static_cast<float>(ypos2), static_cast<float>(zpos3));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QQuaternion
void __qt_destruct_QQuaternion(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QQuaternion")
    reinterpret_cast<QQuaternion*>(ptr)->~QQuaternion();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QQuaternion::QQuaternion()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_initialize_1native__Lio_qt_gui_QQuaternion_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::QQuaternion()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QQuaternion_0, sizeof(QQuaternion), typeid(QQuaternion), false, &deleter_QQuaternion, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::QQuaternion(QVector4D)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_initialize_1native__Lio_qt_gui_QQuaternion_2Lio_qt_gui_QVector4D_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject vector0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::QQuaternion(QVector4D)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = vector0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QQuaternion_1, sizeof(QQuaternion), typeid(QQuaternion), false, &deleter_QQuaternion, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::QQuaternion(float,QVector3D)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_initialize_1native__Lio_qt_gui_QQuaternion_2FLio_qt_gui_QVector3D_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jfloat scalar0,
 jobject vector1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::QQuaternion(float,QVector3D)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].f = scalar0;
        arguments[1].l = vector1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QQuaternion_2, sizeof(QQuaternion), typeid(QQuaternion), false, &deleter_QQuaternion, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::QQuaternion(float,float,float,float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_initialize_1native__Lio_qt_gui_QQuaternion_2FFFF)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jfloat scalar0,
 jfloat xpos1,
 jfloat ypos2,
 jfloat zpos3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::QQuaternion(float,float,float,float)")
    QTJAMBI_TRY {
        jvalue arguments[4];
        arguments[0].f = scalar0;
        arguments[1].f = xpos1;
        arguments[2].f = ypos2;
        arguments[3].f = zpos3;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QQuaternion_3, sizeof(QQuaternion), typeid(QQuaternion), false, &deleter_QQuaternion, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::conjugated()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_conjugated_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::conjugated()const", __qt_this)
        QQuaternion __qt_return_value = __qt_this->conjugated();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::getAxes(QVector3D*,QVector3D*,QVector3D*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_getAxes_1native_1QVector3D_1ptr_1QVector3D_1ptr_1QVector3D_1ptr_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::getAxes(QVector3D*,QVector3D*,QVector3D*)const", __qt_this)
        QVector3D xAxis;
        QVector3D* __qt_xAxis0 = &xAxis;
        QVector3D yAxis;
        QVector3D* __qt_yAxis1 = &yAxis;
        QVector3D zAxis;
        QVector3D* __qt_zAxis2 = &zAxis;
        __qt_this->getAxes(__qt_xAxis0, __qt_yAxis1, __qt_zAxis2);
        __java_return_value = Java::QtGui::QQuaternion$Axes::newInstance(__jni_env, qtjambi_cast<jobject>(__jni_env, xAxis), qtjambi_cast<jobject>(__jni_env, yAxis), qtjambi_cast<jobject>(__jni_env, zAxis));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::getAxisAndAngle(QVector3D*,float*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_getAxisAndAngle_1native_1QVector3D_1ptr_1float_1ptr_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::getAxisAndAngle(QVector3D*,float*)const", __qt_this)
        QVector3D axis;
        QVector3D* __qt_axis0 = &axis;
        float fValue = 0;
        float* __qt_angle1 = &fValue;
        __qt_this->getAxisAndAngle(__qt_axis0, __qt_angle1);
        __java_return_value = Java::QtGui::QQuaternion$AxisAndAngle::newInstance(__jni_env, qtjambi_cast<jobject>(__jni_env, axis), fValue);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::getEulerAngles(float*,float*,float*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_getEulerAngles_1native_1float_1ptr_1float_1ptr_1float_1ptr_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::getEulerAngles(float*,float*,float*)const", __qt_this)
        float aValue = 0;
        float* __qt_pitch0 = &aValue;
        float bValue = 0;
        float* __qt_yaw1 = &bValue;
        float cValue = 0;
        float* __qt_roll2 = &cValue;
        __qt_this->getEulerAngles(__qt_pitch0, __qt_yaw1, __qt_roll2);
        __java_return_value = Java::QtGui::QQuaternion$EulerAngles::newInstance(__jni_env, aValue, bValue, cValue);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::inverted()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_inverted_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::inverted()const", __qt_this)
        QQuaternion __qt_return_value = __qt_this->inverted();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::isIdentity()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_isIdentity_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::isIdentity()const", __qt_this)
        __java_return_value = __qt_this->isIdentity();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::length()const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_length_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::length()const", __qt_this)
        __java_return_value = __qt_this->length();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::lengthSquared()const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_lengthSquared_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::lengthSquared()const", __qt_this)
        __java_return_value = __qt_this->lengthSquared();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::normalize()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_normalize_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::normalize()", __qt_this)
        __qt_this->normalize();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::normalized()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_normalized_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::normalized()const", __qt_this)
        QQuaternion __qt_return_value = __qt_this->normalized();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator*(QQuaternion,QQuaternion)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_times_1native_1cref_1QQuaternion__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID q21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator*(QQuaternion,QQuaternion)", __qt_this)
        const QQuaternion& __qt_q21 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(q21);
        const QQuaternion __qt_return_value = (*__qt_this) * __qt_q21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator*(QQuaternion,QVector3D)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_times_1native_1cref_1QVector3D__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID vec1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator*(QQuaternion,QVector3D)", __qt_this)
        const QVector3D& __qt_vec1 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(vec1);
        QVector3D __qt_return_value = (*__qt_this) * __qt_vec1;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator*(QQuaternion,float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_times_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat factor1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator*(QQuaternion,float)", __qt_this)
        const QQuaternion __qt_return_value = (*__qt_this) * static_cast<float>(factor1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator*=(QQuaternion)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_multiply_1native_1cref_1QQuaternion__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID quaternion0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator*=(QQuaternion)", __qt_this)
        const QQuaternion& __qt_quaternion0 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(quaternion0);
        (*__qt_this) *= __qt_quaternion0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator*=(float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_multiply_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat factor0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator*=(float)", __qt_this)
        (*__qt_this) *= static_cast<float>(factor0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator+(QQuaternion,QQuaternion)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_plus_1native_1cref_1QQuaternion__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID q21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator+(QQuaternion,QQuaternion)", __qt_this)
        const QQuaternion& __qt_q21 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(q21);
        const QQuaternion __qt_return_value = (*__qt_this) + __qt_q21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator+=(QQuaternion)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_add_1native_1cref_1QQuaternion__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID quaternion0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator+=(QQuaternion)", __qt_this)
        const QQuaternion& __qt_quaternion0 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(quaternion0);
        (*__qt_this) += __qt_quaternion0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator-(QQuaternion)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_unaryMinus_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator-(QQuaternion)", __qt_this)
        const QQuaternion __qt_return_value = -(*__qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator-(QQuaternion,QQuaternion)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_minus_1native_1cref_1QQuaternion__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID q21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator-(QQuaternion,QQuaternion)", __qt_this)
        const QQuaternion& __qt_q21 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(q21);
        const QQuaternion __qt_return_value = (*__qt_this) - __qt_q21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator-=(QQuaternion)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_subtract_1native_1cref_1QQuaternion__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID quaternion0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator-=(QQuaternion)", __qt_this)
        const QQuaternion& __qt_quaternion0 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(quaternion0);
        (*__qt_this) -= __qt_quaternion0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator/(QQuaternion,float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_div_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat divisor1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator/(QQuaternion,float)", __qt_this)
        const QQuaternion __qt_return_value = (*__qt_this) / static_cast<float>(divisor1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator/=(float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_divide_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat divisor0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator/=(float)", __qt_this)
        (*__qt_this) /= static_cast<float>(divisor0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator<<(QDataStream&,QQuaternion)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator<<(QDataStream&,QQuaternion)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::operator==(QQuaternion,QQuaternion)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_equals_1native_1cref_1QQuaternion__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID q21)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator==(QQuaternion,QQuaternion)", __qt_this)
        const QQuaternion& __qt_q21 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(q21);
        __java_return_value = (*__qt_this) == __qt_q21;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::operator>>(QDataStream&,QQuaternion&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::operator>>(QDataStream&,QQuaternion&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::rotatedVector(QVector3D)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_rotatedVector_1native_1cref_1QVector3D_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID vector0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::rotatedVector(QVector3D)const", __qt_this)
        const QVector3D& __qt_vector0 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(vector0);
        QVector3D __qt_return_value = __qt_this->rotatedVector(__qt_vector0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::scalar()const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_scalar_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::scalar()const", __qt_this)
        __java_return_value = __qt_this->scalar();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::setScalar(float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_setScalar_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat scalar0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::setScalar(float)", __qt_this)
        __qt_this->setScalar(static_cast<float>(scalar0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::setVector(QVector3D)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_setVector_1native_1cref_1QVector3D__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID vector0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::setVector(QVector3D)", __qt_this)
        const QVector3D& __qt_vector0 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(vector0);
        __qt_this->setVector(__qt_vector0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::setVector(float,float,float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_setVector_1native_1float_1float_1float__JFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat x0,
 jfloat y1,
 jfloat z2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::setVector(float,float,float)", __qt_this)
        __qt_this->setVector(static_cast<float>(x0), static_cast<float>(y1), static_cast<float>(z2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::setX(float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_setX_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat x0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::setX(float)", __qt_this)
        __qt_this->setX(static_cast<float>(x0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::setY(float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_setY_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat y0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::setY(float)", __qt_this)
        __qt_this->setY(static_cast<float>(y0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::setZ(float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_setZ_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat z0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::setZ(float)", __qt_this)
        __qt_this->setZ(static_cast<float>(z0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuaternion::toEulerAngles()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_toEulerAngles_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::toEulerAngles()const", __qt_this)
        QVector3D __qt_return_value = __qt_this->toEulerAngles();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::toRotationMatrix()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_toRotationMatrix_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::toRotationMatrix()const", __qt_this)
        QMatrix3x3 __qt_return_value = __qt_this->toRotationMatrix();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::toVector4D()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_toVector4D_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::toVector4D()const", __qt_this)
        QVector4D __qt_return_value = __qt_this->toVector4D();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::vector()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_vector_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::vector()const", __qt_this)
        QVector3D __qt_return_value = __qt_this->vector();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::x()const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_x_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::x()const", __qt_this)
        __java_return_value = __qt_this->x();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::y()const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_y_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::y()const", __qt_this)
        __java_return_value = __qt_this->y();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::z()const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_z_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuaternion::z()const", __qt_this)
        __java_return_value = __qt_this->z();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::dotProduct(QQuaternion,QQuaternion)
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_dotProduct_1native_1cref_1QQuaternion_1cref_1QQuaternion__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID q10,
 QtJambiNativeID q21)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::dotProduct(QQuaternion,QQuaternion)")
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion& __qt_q10 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(q10);
        const QQuaternion& __qt_q21 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(q21);
        __java_return_value = QQuaternion::dotProduct(__qt_q10, __qt_q21);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::fromAxes(QVector3D,QVector3D,QVector3D)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_fromAxes_1native_1cref_1QVector3D_1cref_1QVector3D_1cref_1QVector3D__JJJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID xAxis0,
 QtJambiNativeID yAxis1,
 QtJambiNativeID zAxis2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::fromAxes(QVector3D,QVector3D,QVector3D)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVector3D& __qt_xAxis0 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(xAxis0);
        const QVector3D& __qt_yAxis1 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(yAxis1);
        const QVector3D& __qt_zAxis2 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(zAxis2);
        QQuaternion __qt_return_value = QQuaternion::fromAxes(__qt_xAxis0, __qt_yAxis1, __qt_zAxis2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::fromAxisAndAngle(QVector3D,float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_fromAxisAndAngle_1native_1cref_1QVector3D_1float__JF)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID axis0,
 jfloat angle1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::fromAxisAndAngle(QVector3D,float)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVector3D& __qt_axis0 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(axis0);
        QQuaternion __qt_return_value = QQuaternion::fromAxisAndAngle(__qt_axis0, static_cast<float>(angle1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::fromAxisAndAngle(float,float,float,float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_fromAxisAndAngle__FFFF)
(JNIEnv *__jni_env,
 jclass,
 jfloat x0,
 jfloat y1,
 jfloat z2,
 jfloat angle3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::fromAxisAndAngle(float,float,float,float)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion __qt_return_value = QQuaternion::fromAxisAndAngle(static_cast<float>(x0), static_cast<float>(y1), static_cast<float>(z2), static_cast<float>(angle3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::fromDirection(QVector3D,QVector3D)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_fromDirection_1native_1cref_1QVector3D_1cref_1QVector3D__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID direction0,
 QtJambiNativeID up1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::fromDirection(QVector3D,QVector3D)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVector3D& __qt_direction0 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(direction0);
        const QVector3D& __qt_up1 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(up1);
        QQuaternion __qt_return_value = QQuaternion::fromDirection(__qt_direction0, __qt_up1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::fromEulerAngles(QVector3D)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_fromEulerAngles_1native_1cref_1QVector3D__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID eulerAngles0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::fromEulerAngles(QVector3D)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVector3D& __qt_eulerAngles0 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(eulerAngles0);
        QQuaternion __qt_return_value = QQuaternion::fromEulerAngles(__qt_eulerAngles0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::fromEulerAngles(float,float,float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_fromEulerAngles__FFF)
(JNIEnv *__jni_env,
 jclass,
 jfloat pitch0,
 jfloat yaw1,
 jfloat roll2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::fromEulerAngles(float,float,float)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QQuaternion __qt_return_value = QQuaternion::fromEulerAngles(static_cast<float>(pitch0), static_cast<float>(yaw1), static_cast<float>(roll2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::fromRotationMatrix(QMatrix3x3)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_fromRotationMatrix_1native_1cref_1QMatrix3x3__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID rot3x30)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::fromRotationMatrix(QMatrix3x3)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix3x3& __qt_rot3x30 = QtJambiAPI::valueReferenceFromNativeId<QMatrix3x3>(rot3x30);
        QQuaternion __qt_return_value = QQuaternion::fromRotationMatrix(__qt_rot3x30);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::nlerp(QQuaternion,QQuaternion,float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_nlerp_1native_1cref_1QQuaternion_1cref_1QQuaternion_1float__JJF)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID q10,
 QtJambiNativeID q21,
 jfloat t2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::nlerp(QQuaternion,QQuaternion,float)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion& __qt_q10 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(q10);
        const QQuaternion& __qt_q21 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(q21);
        QQuaternion __qt_return_value = QQuaternion::nlerp(__qt_q10, __qt_q21, static_cast<float>(t2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::qFuzzyCompare(QQuaternion,QQuaternion)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_qFuzzyCompare_1native_1cref_1QQuaternion_1cref_1QQuaternion__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID q10,
 QtJambiNativeID q21)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::qFuzzyCompare(QQuaternion,QQuaternion)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion& __qt_q10 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(q10);
        const QQuaternion& __qt_q21 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(q21);
        __java_return_value = qFuzzyCompare(__qt_q10, __qt_q21);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::rotationTo(QVector3D,QVector3D)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_rotationTo_1native_1cref_1QVector3D_1cref_1QVector3D__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID from0,
 QtJambiNativeID to1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::rotationTo(QVector3D,QVector3D)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QVector3D& __qt_from0 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(from0);
        const QVector3D& __qt_to1 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(to1);
        QQuaternion __qt_return_value = QQuaternion::rotationTo(__qt_from0, __qt_to1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuaternion::slerp(QQuaternion,QQuaternion,float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_slerp_1native_1cref_1QQuaternion_1cref_1QQuaternion_1float__JJF)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID q10,
 QtJambiNativeID q21,
 jfloat t2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuaternion::slerp(QQuaternion,QQuaternion,float)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuaternion& __qt_q10 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(q10);
        const QQuaternion& __qt_q21 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(q21);
        QQuaternion __qt_return_value = QQuaternion::slerp(__qt_q10, __qt_q21, static_cast<float>(t2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QQuaternion_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QQuaternion *__qt_this = QtJambiAPI::objectFromNativeId<QQuaternion>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QQuaternion(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QQuaternion>("QQuaternion", "io/qt/gui/QQuaternion");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QQuaternion, {
        ConstructorInfo(&__qt_construct_QQuaternion_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QQuaternion_1, "Lio/qt/gui/QVector4D;")
       ,ConstructorInfo(&__qt_construct_QQuaternion_2, "FLio/qt/gui/QVector3D;")
       ,ConstructorInfo(&__qt_construct_QQuaternion_3, "FFFF")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QQuaternion);
    registerMetaType<QQuaternion>("QQuaternion");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
