#ifndef QPAINTENGINE_SHELL_H
#define QPAINTENGINE_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/qpaintengine.h>
#include <QtJambi/QtJambiAPI>
#include <QVarLengthArray>
#include <QtCore/QVariant>
#include <QtCore/qline.h>
#include <QtCore/qpoint.h>
#include <QtCore/qrect.h>
#include <QtCore/qsize.h>
#include <QtGui/qimage.h>
#include <QtGui/qpaintdevice.h>
#include <QtGui/qpainter.h>
#include <QtGui/qpainterpath.h>
#include <QtGui/qpixmap.h>
#include <QtGui/qregion.h>
#include <QtJambi/RegistryAPI>


class QPaintEngine_shell : public QPaintEngine, public QtJambiShellInterface
{
public:
    QPaintEngine_shell(QPaintEngine::PaintEngineFeatures features0 = QPaintEngine::PaintEngineFeatures());
    ~QPaintEngine_shell() override;

    bool begin(QPaintDevice* pdev0) override;
    QPoint coordinateOffset() const override;
    QPixmap createPixmap(QSize size0) override;
    QPixmap createPixmapFromImage(QImage image0, Qt::ImageConversionFlags flags1) override;
    void drawEllipse(const QRect& r0) override;
    void drawEllipse(const QRectF& r0) override;
    void drawImage(const QRectF& r0, const QImage& pm1, const QRectF& sr2, Qt::ImageConversionFlags flags3) override;
    void drawLines(const QLine* lines0, int lineCount1) override;
    void drawLines(const QLineF* lines0, int lineCount1) override;
    void drawPath(const QPainterPath& path0) override;
    void drawPixmap(const QRectF& r0, const QPixmap& pm1, const QRectF& sr2) override;
    void drawPoints(const QPoint* points0, int pointCount1) override;
    void drawPoints(const QPointF* points0, int pointCount1) override;
    void drawPolygon(const QPoint* points0, int pointCount1, QPaintEngine::PolygonDrawMode mode2) override;
    void drawPolygon(const QPointF* points0, int pointCount1, QPaintEngine::PolygonDrawMode mode2) override;
    void drawRects(const QRect* rects0, int rectCount1) override;
    void drawRects(const QRectF* rects0, int rectCount1) override;
    void drawTextItem(const QPointF& p0, const QTextItem& textItem1) override;
    void drawTiledPixmap(const QRectF& r0, const QPixmap& pixmap1, const QPointF& s2) override;
    bool end() override;
    QPaintEngine::Type type() const override;
    void updateState(const QPaintEngineState& state0) override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QPaintEngine_access : public QPaintEngine
{
    jboolean __qt_begin_QPaintDevice_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID pdev0);
    jobject __qt_coordinateOffset(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_createPixmap_QSize(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID size0);
    jobject __qt_createPixmapFromImage_QImage_Qt_ImageConversionFlags(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID image0, jint flags1);
    void __qt_drawEllipse_cref_QRect(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID r0);
    void __qt_drawEllipse_cref_QRectF(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID r0);
    void __qt_drawImage_cref_QRectF_cref_QImage_cref_QRectF_Qt_ImageConversionFlags(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID r0, QtJambiNativeID pm1, QtJambiNativeID sr2, jint flags3);
    void __qt_drawLines_const_QLine_ptr_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray lines0);
    void __qt_drawLines_const_QLineF_ptr_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray lines0);
    void __qt_drawPath_cref_QPainterPath(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID path0);
    void __qt_drawPixmap_cref_QRectF_cref_QPixmap_cref_QRectF(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID r0, QtJambiNativeID pm1, QtJambiNativeID sr2);
    void __qt_drawPoints_const_QPoint_ptr_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray points0);
    void __qt_drawPoints_const_QPointF_ptr_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray points0);
    void __qt_drawPolygon_const_QPoint_ptr_int_QPaintEngine_PolygonDrawMode(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray points0, jint mode2);
    void __qt_drawPolygon_const_QPointF_ptr_int_QPaintEngine_PolygonDrawMode(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray points0, jint mode2);
    void __qt_drawRects_const_QRect_ptr_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray rects0);
    void __qt_drawRects_const_QRectF_ptr_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray rects0);
    void __qt_drawTextItem_cref_QPointF_cref_QTextItem(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID p0, QtJambiNativeID textItem1);
    void __qt_drawTiledPixmap_cref_QRectF_cref_QPixmap_cref_QPointF(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID r0, QtJambiNativeID pixmap1, QtJambiNativeID s2);
    jboolean __qt_end(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_type(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_updateState_cref_QPaintEngineState(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID state0);
    void setExtended_uint(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jboolean extended0);
    void setFeatures_cref_QPaintEngine_PaintEngineFeatures(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint features0);
    jint features(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
};

#endif // QPAINTENGINE_SHELL_H
