#ifndef QPAGEDPAINTDEVICE_IMPL_SHELL_H
#define QPAGEDPAINTDEVICE_IMPL_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/qpagedpaintdevice.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qmargins.h>
#include <QtCore/qpoint.h>
#include <QtGui/qpagelayout.h>
#include <QtGui/qpageranges.h>
#include <QtGui/qpagesize.h>
#include <QtGui/qpaintdevice.h>
#include <QtGui/qpaintengine.h>
#include <QtGui/qpainter.h>
#include <QtJambi/RegistryAPI>


class QPagedPaintDevice_shell : public QPagedPaintDevice, public QtJambiShellInterface
{
public:
    ~QPagedPaintDevice_shell() override;

    void initPainter(QPainter* painter0) const override;
    int metric(QPaintDevice::PaintDeviceMetric metric0) const override;
    bool newPage() override;
    QPaintEngine* paintEngine() const override;
    QPaintDevice* redirected(QPoint* offset0) const override;
    bool setPageLayout(const QPageLayout& pageLayout0) override;
    bool setPageMargins(const QMarginsF& margins0, QPageLayout::Unit units1) override;
    bool setPageOrientation(QPageLayout::Orientation orientation0) override;
    void setPageRanges(const QPageRanges& ranges0) override;
    bool setPageSize(const QPageSize& pageSize0) override;
    QPainter* sharedPainter() const override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QPagedPaintDevice_access : public QPagedPaintDevice
{
    void __qt_initPainter_QPainter_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID painter0) const;
    jint __qt_metric_QPaintDevice_PaintDeviceMetric_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint metric0) const;
    jboolean __qt_newPage(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_paintEngine(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_redirected_QPoint_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID offset0) const;
    jboolean __qt_setPageLayout_cref_QPageLayout(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID pageLayout0);
    jboolean __qt_setPageMargins_cref_QMarginsF_QPageLayout_Unit(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID margins0, jint units1);
    jboolean __qt_setPageOrientation_QPageLayout_Orientation(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint orientation0);
    void __qt_setPageRanges_cref_QPageRanges(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID ranges0);
    jboolean __qt_setPageSize_cref_QPageSize(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID pageSize0);
    jobject __qt_sharedPainter(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QPAGEDPAINTDEVICE_IMPL_SHELL_H
