#include <QtCore/QtGlobal>
#include <QtCore/quuid.h>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qbytearrayview.h>
#include <QtCore/qdatastream.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QUuid(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QUuid")
    QUuid *_ptr = reinterpret_cast<QUuid *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QUuid()
void __qt_construct_QUuid_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QUuid()")
    Q_UNUSED(__java_arguments)
    QUuid *__qt_this = new(__qtjambi_ptr) QUuid();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QUuid(QAnyStringView)
void __qt_construct_QUuid_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QUuid(QAnyStringView)")
    QtJambiScope __qtjambi_scope;
    jstring string0 = static_cast<jstring>(__java_arguments[0].l);
    QAnyStringView  __qt_string0 = qtjambi_cast<QAnyStringView>(__jni_env, __qtjambi_scope, string0);
    QUuid *__qt_this = new(__qtjambi_ptr) QUuid(__qt_string0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QUuid(uint,ushort,ushort,uchar,uchar,uchar,uchar,uchar,uchar,uchar,uchar)
void __qt_construct_QUuid_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QUuid(uint,ushort,ushort,uchar,uchar,uchar,uchar,uchar,uchar,uchar,uchar)")
    jint l0 = __java_arguments[0].i;
    Q_UNUSED(l0)
    jshort w11 = __java_arguments[1].s;
    Q_UNUSED(w11)
    jshort w22 = __java_arguments[2].s;
    Q_UNUSED(w22)
    jbyte b13 = __java_arguments[3].b;
    Q_UNUSED(b13)
    jbyte b24 = __java_arguments[4].b;
    Q_UNUSED(b24)
    jbyte b35 = __java_arguments[5].b;
    Q_UNUSED(b35)
    jbyte b46 = __java_arguments[6].b;
    Q_UNUSED(b46)
    jbyte b57 = __java_arguments[7].b;
    Q_UNUSED(b57)
    jbyte b68 = __java_arguments[8].b;
    Q_UNUSED(b68)
    jbyte b79 = __java_arguments[9].b;
    Q_UNUSED(b79)
    jbyte b810 = __java_arguments[10].b;
    Q_UNUSED(b810)
    QUuid *__qt_this = new(__qtjambi_ptr) QUuid(static_cast<uint>(l0), static_cast<ushort>(w11), static_cast<ushort>(w22), static_cast<uchar>(b13), static_cast<uchar>(b24), static_cast<uchar>(b35), static_cast<uchar>(b46), static_cast<uchar>(b57), static_cast<uchar>(b68), static_cast<uchar>(b79), static_cast<uchar>(b810));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QUuid
void __qt_destruct_QUuid(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QUuid")
    reinterpret_cast<QUuid*>(ptr)->~QUuid();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QUuid::QUuid()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_initialize_1native__Lio_qt_core_QUuid_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUuid::QUuid()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QUuid_0, sizeof(QUuid), typeid(QUuid), false, &deleter_QUuid, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUuid::QUuid(QAnyStringView)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_initialize_1native__Lio_qt_core_QUuid_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring string0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUuid::QUuid(QAnyStringView)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = string0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QUuid_1, sizeof(QUuid), typeid(QUuid), false, &deleter_QUuid, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUuid::QUuid(uint,ushort,ushort,uchar,uchar,uchar,uchar,uchar,uchar,uchar,uchar)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_initialize_1native__Lio_qt_core_QUuid_2ISSBBBBBBBB)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint l0,
 jshort w11,
 jshort w22,
 jbyte b13,
 jbyte b24,
 jbyte b35,
 jbyte b46,
 jbyte b57,
 jbyte b68,
 jbyte b79,
 jbyte b810)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUuid::QUuid(uint,ushort,ushort,uchar,uchar,uchar,uchar,uchar,uchar,uchar,uchar)")
    QTJAMBI_TRY {
        jvalue arguments[11];
        arguments[0].i = l0;
        arguments[1].s = w11;
        arguments[2].s = w22;
        arguments[3].b = b13;
        arguments[4].b = b24;
        arguments[5].b = b35;
        arguments[6].b = b46;
        arguments[7].b = b57;
        arguments[8].b = b68;
        arguments[9].b = b79;
        arguments[10].b = b810;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QUuid_2, sizeof(QUuid), typeid(QUuid), false, &deleter_QUuid, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUuid::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUuid::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::operator<(QUuid)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_operator_1less_1native_1cref_1QUuid_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUuid::operator<(QUuid)const", __qt_this)
        const QUuid& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QUuid>(other0);
        __java_return_value = (*__qt_this) < __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::operator<<(QDataStream&,QUuid)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUuid::operator<<(QDataStream&,QUuid)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUuid::operator==(QUuid)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_equals_1native_1cref_1QUuid_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID orig0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUuid::operator==(QUuid)const", __qt_this)
        const QUuid& __qt_orig0 = QtJambiAPI::valueReferenceFromNativeId<QUuid>(orig0);
        __java_return_value = (*__qt_this) == __qt_orig0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::operator>>(QDataStream&,QUuid&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUuid::operator>>(QDataStream&,QUuid&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUuid::toByteArray(QUuid::StringFormat)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_toByteArray_1native_1QUuid_1StringFormat_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUuid::toByteArray(QUuid::StringFormat)const", __qt_this)
        QUuid::StringFormat __qt_mode0 = qtjambi_cast<QUuid::StringFormat>(__jni_env, mode0);
        QByteArray __qt_return_value = __qt_this->toByteArray(QUuid::StringFormat(__qt_mode0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::toRfc4122()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_toRfc4122_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUuid::toRfc4122()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->toRfc4122();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::toString(QUuid::StringFormat)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_toString_1native_1QUuid_1StringFormat_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUuid::toString(QUuid::StringFormat)const", __qt_this)
        QUuid::StringFormat __qt_mode0 = qtjambi_cast<QUuid::StringFormat>(__jni_env, mode0);
        QString __qt_return_value = __qt_this->toString(QUuid::StringFormat(__qt_mode0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::variant()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_variant_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUuid::variant()const", __qt_this)
        QUuid::Variant __qt_return_value = __qt_this->variant();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::version()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_version_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUuid::version()const", __qt_this)
        QUuid::Version __qt_return_value = __qt_this->version();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::createUuid()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_createUuid__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUuid::createUuid()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QUuid __qt_return_value = QUuid::createUuid();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::createUuidV3(QUuid,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_createUuidV3_1native_1cref_1QUuid_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID ns0,
 QtJambiNativeID baseData1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUuid::createUuidV3(QUuid,QByteArray)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QUuid& __qt_ns0 = QtJambiAPI::valueReferenceFromNativeId<QUuid>(ns0);
        const QByteArray& __qt_baseData1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(baseData1);
        QUuid __qt_return_value = QUuid::createUuidV3(__qt_ns0, __qt_baseData1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::createUuidV3(QUuid,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_createUuidV3_1native_1cref_1QUuid_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID ns0,
 jstring baseData1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUuid::createUuidV3(QUuid,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QUuid& __qt_ns0 = QtJambiAPI::valueReferenceFromNativeId<QUuid>(ns0);
        QString  __qt_baseData1 = qtjambi_cast<QString>(__jni_env, baseData1);
        QUuid __qt_return_value = QUuid::createUuidV3(__qt_ns0, __qt_baseData1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::createUuidV5(QUuid,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_createUuidV5_1native_1cref_1QUuid_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID ns0,
 QtJambiNativeID baseData1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUuid::createUuidV5(QUuid,QByteArray)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QUuid& __qt_ns0 = QtJambiAPI::valueReferenceFromNativeId<QUuid>(ns0);
        const QByteArray& __qt_baseData1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(baseData1);
        QUuid __qt_return_value = QUuid::createUuidV5(__qt_ns0, __qt_baseData1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::createUuidV5(QUuid,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_createUuidV5_1native_1cref_1QUuid_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID ns0,
 jstring baseData1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUuid::createUuidV5(QUuid,QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QUuid& __qt_ns0 = QtJambiAPI::valueReferenceFromNativeId<QUuid>(ns0);
        QString  __qt_baseData1 = qtjambi_cast<QString>(__jni_env, baseData1);
        QUuid __qt_return_value = QUuid::createUuidV5(__qt_ns0, __qt_baseData1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::fromRfc4122(QByteArrayView)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_fromRfc4122_1native_1QByteArrayView__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUuid::fromRfc4122(QByteArrayView)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArrayView __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(arg__1);
        QUuid __qt_return_value = QUuid::fromRfc4122(__qt_arg__1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUuid::fromString(QAnyStringView)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_fromString__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring string0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUuid::fromString(QAnyStringView)")
    QtJambiScope __qtjambi_scope;
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QAnyStringView  __qt_string0 = qtjambi_cast<QAnyStringView>(__jni_env, __qtjambi_scope, string0);
        QUuid __qt_return_value = QUuid::fromString(__qt_string0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting Field accessors (writeFieldAccessors)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_setData1_1native_1uint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint data10)
{
    QTJAMBI_TRY {
        Q_UNUSED(__this)
        QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __qt_this->data1 = static_cast<uint>(data10);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
}

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_data1_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        Q_UNUSED(__this)
        QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        uint  __qt_value = __qt_this->data1;
        __java_return_value = jint(__qt_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;
}

extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_setData2_1native_1ushort__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort data20)
{
    QTJAMBI_TRY {
        Q_UNUSED(__this)
        QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __qt_this->data2 = static_cast<ushort>(data20);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
}

extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_data2_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        Q_UNUSED(__this)
        QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        ushort  __qt_value = __qt_this->data2;
        __java_return_value = jshort(__qt_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;
}

extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_setData3_1native_1ushort__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort data30)
{
    QTJAMBI_TRY {
        Q_UNUSED(__this)
        QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __qt_this->data3 = static_cast<ushort>(data30);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
}

extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_data3_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        Q_UNUSED(__this)
        QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        ushort  __qt_value = __qt_this->data3;
        __java_return_value = jshort(__qt_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;
}

extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_setData4_1native_1cref_1Array__J_3B)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyteArray data40)
{
    QTJAMBI_TRY {
        Q_UNUSED(__this)
        QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        Q_ASSERT(__jni_env->GetArrayLength(jarray(data40)) >= 8);
        uchar  __qt_data40[8];
        __jni_env->GetByteArrayRegion( jbyteArray(data40), 0, 8, reinterpret_cast<jbyte *>(__qt_data40));
        __qt_this->data4[0] = static_cast<uchar>(__qt_data40[0]);
        __qt_this->data4[1] = static_cast<uchar>(__qt_data40[1]);
        __qt_this->data4[2] = static_cast<uchar>(__qt_data40[2]);
        __qt_this->data4[3] = static_cast<uchar>(__qt_data40[3]);
        __qt_this->data4[4] = static_cast<uchar>(__qt_data40[4]);
        __qt_this->data4[5] = static_cast<uchar>(__qt_data40[5]);
        __qt_this->data4[6] = static_cast<uchar>(__qt_data40[6]);
        __qt_this->data4[7] = static_cast<uchar>(__qt_data40[7]);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
}

extern "C" Q_DECL_EXPORT jbyteArray JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_data4_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    jbyteArray __java_return_value{0};
    QTJAMBI_TRY {
        Q_UNUSED(__this)
        QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        uchar * __qt_value = __qt_this->data4;
        __java_return_value = QtJambiAPI::toJByteArray(__jni_env, reinterpret_cast<jbyte *>(__qt_value), 8);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUuid_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QUuid *__qt_this = QtJambiAPI::objectFromNativeId<QUuid>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QUuid(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QUuid>("QUuid", "io/qt/core/QUuid");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QUuid, {
        ConstructorInfo(&__qt_construct_QUuid_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QUuid_1, "Ljava/lang/String;")
       ,ConstructorInfo(&__qt_construct_QUuid_2, "ISSBBBBBBBB")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QUuid);
    registerMetaType<QUuid>("QUuid");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QUuid::StringFormat>("QUuid::StringFormat", "io/qt/core/QUuid$StringFormat");
    registerEnumTypeInfo<QUuid::Variant>("QUuid::Variant", "io/qt/core/QUuid$Variant");
    registerEnumTypeInfo<QUuid::Version>("QUuid::Version", "io/qt/core/QUuid$Version");
// END: enums and flags
}
