#include <QtCore/QtGlobal>
#include <qtcore-config.h>
#if QT_CONFIG(itemmodel)
#include <QtCore/qitemselectionmodel.h>
#endif //QT_CONFIG(itemmodel)
#include <QtCore/QList>
#include <QtCore/QVariant>
#if QT_CONFIG(itemmodel)
#include <QtCore/qabstractitemmodel.h>
#endif //QT_CONFIG(itemmodel)

#include <QtJambi/QtJambiAPI>
#include <QtJambiCore/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

#if QT_CONFIG(itemmodel)


// emitting (writeClassCodeInjections)
namespace QtJambiPrivate{
    template<>
    struct supports_less_than<QItemSelection> : std::false_type{};
    template<>
    struct supports_stream_operators<QItemSelection> : std::false_type{};
    template<>
    struct supports_debugstream<QItemSelection> : std::false_type{};
}

void deleter_QItemSelection(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QItemSelection")
    QItemSelection *_ptr = reinterpret_cast<QItemSelection *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}


#endif // QT_CONFIG(itemmodel)

// emitting (writeConstructors)
// new QItemSelection(QModelIndex,QModelIndex)
void __qt_construct_QItemSelection_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QItemSelection(QModelIndex,QModelIndex)")
#if QT_CONFIG(itemmodel)
    jobject topLeft0 = __java_arguments[0].l;
    const QModelIndex& __qt_topLeft0 = qtjambi_cast<const QModelIndex& >(__jni_env, topLeft0);
    jobject bottomRight1 = __java_arguments[1].l;
    const QModelIndex& __qt_bottomRight1 = qtjambi_cast<const QModelIndex& >(__jni_env, bottomRight1);
    QItemSelection *__qt_this = new(__qtjambi_ptr) QItemSelection(__qt_topLeft0, __qt_bottomRight1);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(itemmodel)
}

// new 
void __qt_construct_QItemSelection_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct ")
#if QT_CONFIG(itemmodel)
    Q_UNUSED(__java_arguments)
    QItemSelection *__qt_this = new(__qtjambi_ptr) QItemSelection();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(itemmodel)
}

// new 
void __qt_construct_QItemSelection_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct ")
#if QT_CONFIG(itemmodel)
    QtJambiScope __qtjambi_scope;
    jobjectArray arg__1 = static_cast<jobjectArray>(__java_arguments[0].l);
    std::initializer_list<QItemSelectionRange> __qt_arg__1 = qtjambi_cast<std::initializer_list<QItemSelectionRange>>(__jni_env, __qtjambi_scope, arg__1);
    QItemSelection *__qt_this = new(__qtjambi_ptr) QItemSelection(__qt_arg__1);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(itemmodel)
}

// destruct QItemSelection
void __qt_destruct_QItemSelection(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QItemSelection")

#if QT_CONFIG(itemmodel)

    reinterpret_cast<QItemSelection*>(ptr)->~QItemSelection();

#else
    Q_UNUSED(ptr)

#endif // QT_CONFIG(itemmodel)

}

// emitting  (functionsInTargetLang writeFinalFunction)
// QItemSelection::QItemSelection(QModelIndex,QModelIndex)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QItemSelection_initialize_1native__Lio_qt_core_QItemSelection_2Lio_qt_core_QModelIndex_2Lio_qt_core_QModelIndex_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject topLeft0,
 jobject bottomRight1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QItemSelection::QItemSelection(QModelIndex,QModelIndex)")
    QTJAMBI_TRY {
#if QT_CONFIG(itemmodel)
        jvalue arguments[2];
        arguments[0].l = topLeft0;
        arguments[1].l = bottomRight1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QItemSelection_0, sizeof(QItemSelection), typeid(QItemSelection), false, QtJambiPrivate::QListAccess<QItemSelectionRange>::newInstance(), &deleter_QItemSelection, arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(topLeft0)
        Q_UNUSED(bottomRight1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(itemmodel)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QItemSelection::
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QItemSelection_initialize_1native__Lio_qt_core_QItemSelection_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QItemSelection::")
    QTJAMBI_TRY {
#if QT_CONFIG(itemmodel)
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QItemSelection_1, sizeof(QItemSelection), typeid(QItemSelection), false, QtJambiPrivate::QListAccess<QItemSelectionRange>::newInstance(), &deleter_QItemSelection, nullptr);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(itemmodel)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QItemSelection::
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QItemSelection_initialize_1native__Lio_qt_core_QItemSelection_2_3Lio_qt_core_QItemSelectionRange_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobjectArray arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QItemSelection::")
    QTJAMBI_TRY {
#if QT_CONFIG(itemmodel)
        jvalue arguments;
        arguments.l = arg__1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QItemSelection_2, sizeof(QItemSelection), typeid(QItemSelection), false, QtJambiPrivate::QListAccess<QItemSelectionRange>::newInstance(), &deleter_QItemSelection, &arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(arg__1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(itemmodel)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QItemSelection::contains(QModelIndex)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QItemSelection_contains_1native_1cref_1QModelIndex_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID index0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(itemmodel)
        const QItemSelection *__qt_this = QtJambiAPI::objectFromNativeId<QItemSelection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QItemSelection::contains(QModelIndex)const", __qt_this)
        const QModelIndex& __qt_index0 = QtJambiAPI::valueReferenceFromNativeId<QModelIndex>(index0);
        __java_return_value = __qt_this->contains(__qt_index0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(index0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(itemmodel)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QItemSelection::indexes()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QItemSelection_indexes_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(itemmodel)
        const QItemSelection *__qt_this = QtJambiAPI::objectFromNativeId<QItemSelection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QItemSelection::indexes()const", __qt_this)
        QList<QModelIndex> __qt_return_value = __qt_this->indexes();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(itemmodel)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QItemSelection::merge(QItemSelection,QItemSelectionModel::SelectionFlags)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QItemSelection_merge_1native_1cref_1QItemSelection_1QItemSelectionModel_1SelectionFlags__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0,
 jint command1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(itemmodel)
        QItemSelection *__qt_this = QtJambiAPI::objectFromNativeId<QItemSelection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QItemSelection::merge(QItemSelection,QItemSelectionModel::SelectionFlags)", __qt_this)
        const QItemSelection& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QItemSelection>(__jni_env, other0);
        QItemSelectionModel::SelectionFlags __qt_command1 = qtjambi_cast<QItemSelectionModel::SelectionFlags>(__jni_env, command1);
        __qt_this->merge(__qt_other0, QItemSelectionModel::SelectionFlags(__qt_command1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(other0)
        Q_UNUSED(command1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(itemmodel)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QItemSelection::select(QModelIndex,QModelIndex)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QItemSelection_select_1native_1cref_1QModelIndex_1cref_1QModelIndex__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID topLeft0,
 QtJambiNativeID bottomRight1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(itemmodel)
        QItemSelection *__qt_this = QtJambiAPI::objectFromNativeId<QItemSelection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QItemSelection::select(QModelIndex,QModelIndex)", __qt_this)
        const QModelIndex& __qt_topLeft0 = QtJambiAPI::valueReferenceFromNativeId<QModelIndex>(topLeft0);
        const QModelIndex& __qt_bottomRight1 = QtJambiAPI::valueReferenceFromNativeId<QModelIndex>(bottomRight1);
        __qt_this->select(__qt_topLeft0, __qt_bottomRight1);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(topLeft0)
        Q_UNUSED(bottomRight1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(itemmodel)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QItemSelection::swap(QItemSelection&,QItemSelection&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QItemSelection_swap_1native_1ref_1QItemSelection__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID value21)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(itemmodel)
        QItemSelection *__qt_this = QtJambiAPI::objectFromNativeId<QItemSelection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QItemSelection::swap(QItemSelection&,QItemSelection&)", __qt_this)
        QItemSelection& __qt_value21 = QtJambiAPI::objectReferenceFromNativeId<QItemSelection>(__jni_env, value21);
        swap(*__qt_this, __qt_value21);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(value21)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(itemmodel)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QItemSelection::split(QItemSelectionRange,QItemSelectionRange,QItemSelection*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QItemSelection_split_1native_1cref_1QItemSelectionRange_1cref_1QItemSelectionRange_1QItemSelection_1ptr__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID range0,
 QtJambiNativeID other1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QItemSelection::split(QItemSelectionRange,QItemSelectionRange,QItemSelection*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(itemmodel)
        const QItemSelectionRange& __qt_range0 = QtJambiAPI::valueReferenceFromNativeId<QItemSelectionRange>(range0);
        const QItemSelectionRange& __qt_other1 = QtJambiAPI::valueReferenceFromNativeId<QItemSelectionRange>(other1);
        QItemSelection result;
        QItemSelection * __qt_result2 = &result;
        QItemSelection::split(__qt_range0, __qt_other1, __qt_result2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, result);
#else
        Q_UNUSED(range0)
        Q_UNUSED(other1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(itemmodel)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QItemSelection_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {

#if QT_CONFIG(itemmodel)

        QItemSelection *__qt_this = QtJambiAPI::objectFromNativeId<QItemSelection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
#else
        Q_UNUSED(__this_nativeId)
#endif // QT_CONFIG(itemmodel)

    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QItemSelection_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {

#if QT_CONFIG(itemmodel)

        const QItemSelection *__qt_this = QtJambiAPI::objectFromNativeId<QItemSelection>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);

#else
        Q_UNUSED(__this_nativeId)
#endif // QT_CONFIG(itemmodel)

    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QItemSelection(){
    using namespace RegistryAPI;

#if QT_CONFIG(itemmodel)

    const std::type_info& typeId = registerValueTypeInfo<QItemSelection>("QItemSelection", "io/qt/core/QItemSelection");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QItemSelection, {
        ConstructorInfo(&__qt_construct_QItemSelection_0, "Lio/qt/core/QModelIndex;Lio/qt/core/QModelIndex;")
       ,ConstructorInfo(&__qt_construct_QItemSelection_1, nullptr)
       ,ConstructorInfo(&__qt_construct_QItemSelection_2, "[Lio/qt/core/QItemSelectionRange;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QItemSelection);
    registerMetaType<QItemSelection>("QItemSelection");
    registerContainerAccessFactory(typeId, NewContainerAccessFunction(&QtJambiPrivate::QListAccess<QItemSelectionRange>::newInstance));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags

#endif //QT_CONFIG(itemmodel)

}
