#include <QtCore/QtGlobal>
#include <QtCore/qdatetime.h>
#include <QtCore/QVariant>
#include <QtCore/qcalendar.h>
#include <QtCore/qdatastream.h>
#include <QtCore/qnamespace.h>
#include <QtCore/qtimezone.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QDateTime(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QDateTime")
    QDateTime *_ptr = reinterpret_cast<QDateTime *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QDateTime()
void __qt_construct_QDateTime_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDateTime()")
    Q_UNUSED(__java_arguments)
    QDateTime *__qt_this = new(__qtjambi_ptr) QDateTime();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QDateTime(QDate,QTime)
void __qt_construct_QDateTime_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDateTime(QDate,QTime)")
    jobject date0 = __java_arguments[0].l;
    QDate __qt_date0 = qtjambi_cast<QDate >(__jni_env, date0);
    jobject time1 = __java_arguments[1].l;
    QTime __qt_time1 = qtjambi_cast<QTime >(__jni_env, time1);
    QDateTime *__qt_this = new(__qtjambi_ptr) QDateTime(__qt_date0, __qt_time1);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QDateTime(QDate,QTime,QTimeZone)
void __qt_construct_QDateTime_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDateTime(QDate,QTime,QTimeZone)")
    jobject date0 = __java_arguments[0].l;
    QDate __qt_date0 = qtjambi_cast<QDate >(__jni_env, date0);
    jobject time1 = __java_arguments[1].l;
    QTime __qt_time1 = qtjambi_cast<QTime >(__jni_env, time1);
    jobject timeZone2 = __java_arguments[2].l;
    const QTimeZone& __qt_timeZone2 = qtjambi_cast<const QTimeZone& >(__jni_env, timeZone2);
    QDateTime *__qt_this = new(__qtjambi_ptr) QDateTime(__qt_date0, __qt_time1, __qt_timeZone2);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QDateTime(QDate,QTime,Qt::TimeSpec,int)
void __qt_construct_QDateTime_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDateTime(QDate,QTime,Qt::TimeSpec,int)")
    jobject date0 = __java_arguments[0].l;
    QDate __qt_date0 = qtjambi_cast<QDate >(__jni_env, date0);
    jobject time1 = __java_arguments[1].l;
    QTime __qt_time1 = qtjambi_cast<QTime >(__jni_env, time1);
    jobject spec2 = __java_arguments[2].l;
    Qt::TimeSpec __qt_spec2 = qtjambi_cast<Qt::TimeSpec>(__jni_env, spec2);
    QDateTime *__qt_this = new(__qtjambi_ptr) QDateTime(__qt_date0, __qt_time1, Qt::TimeSpec(__qt_spec2));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QDateTime(QDate,QTime,Qt::TimeSpec,int)
void __qt_construct_QDateTime_4(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDateTime(QDate,QTime,Qt::TimeSpec,int)")
    jobject date0 = __java_arguments[0].l;
    QDate __qt_date0 = qtjambi_cast<QDate >(__jni_env, date0);
    jobject time1 = __java_arguments[1].l;
    QTime __qt_time1 = qtjambi_cast<QTime >(__jni_env, time1);
    jobject spec2 = __java_arguments[2].l;
    Qt::TimeSpec __qt_spec2 = qtjambi_cast<Qt::TimeSpec>(__jni_env, spec2);
    jint offsetSeconds3 = __java_arguments[3].i;
    Q_UNUSED(offsetSeconds3)
    QDateTime *__qt_this = new(__qtjambi_ptr) QDateTime(__qt_date0, __qt_time1, Qt::TimeSpec(__qt_spec2), static_cast<int>(offsetSeconds3));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QDateTime(QDateTime)
void __qt_construct_QDateTime_5(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDateTime(QDateTime)")
    jobject other0 = __java_arguments[0].l;
    const QDateTime& __qt_other0 = qtjambi_cast<const QDateTime& >(__jni_env, other0);
    QDateTime *__qt_this = new(__qtjambi_ptr) QDateTime(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QDateTime
void __qt_destruct_QDateTime(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QDateTime")
    reinterpret_cast<QDateTime*>(ptr)->~QDateTime();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QDateTime::QDateTime()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_initialize_1native__Lio_qt_core_QDateTime_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::QDateTime()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDateTime_0, sizeof(QDateTime), typeid(QDateTime), false, &deleter_QDateTime, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::QDateTime(QDate,QTime)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_initialize_1native__Lio_qt_core_QDateTime_2Lio_qt_core_QDate_2Lio_qt_core_QTime_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject date0,
 jobject time1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::QDateTime(QDate,QTime)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = date0;
        arguments[1].l = time1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDateTime_1, sizeof(QDateTime), typeid(QDateTime), false, &deleter_QDateTime, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::QDateTime(QDate,QTime,QTimeZone)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_initialize_1native__Lio_qt_core_QDateTime_2Lio_qt_core_QDate_2Lio_qt_core_QTime_2Lio_qt_core_QTimeZone_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject date0,
 jobject time1,
 jobject timeZone2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::QDateTime(QDate,QTime,QTimeZone)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].l = date0;
        arguments[1].l = time1;
        arguments[2].l = timeZone2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDateTime_2, sizeof(QDateTime), typeid(QDateTime), false, &deleter_QDateTime, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::QDateTime(QDate,QTime,Qt::TimeSpec,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_initialize_1native__Lio_qt_core_QDateTime_2Lio_qt_core_QDate_2Lio_qt_core_QTime_2Lio_qt_core_Qt_00024TimeSpec_2I)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject date0,
 jobject time1,
 jobject spec2,
 jint offsetSeconds3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::QDateTime(QDate,QTime,Qt::TimeSpec,int)")
    QTJAMBI_TRY {
        jvalue arguments[4];
        arguments[0].l = date0;
        arguments[1].l = time1;
        arguments[2].l = spec2;
        arguments[3].i = offsetSeconds3;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDateTime_4, sizeof(QDateTime), typeid(QDateTime), false, &deleter_QDateTime, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::QDateTime(QDateTime)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_initialize_1native__Lio_qt_core_QDateTime_2Lio_qt_core_QDateTime_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::QDateTime(QDateTime)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDateTime_5, sizeof(QDateTime), typeid(QDateTime), false, &deleter_QDateTime, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::addDays(qint64)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_addDays_1native_1qint64_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong days0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::addDays(qint64)const", __qt_this)
        QDateTime __qt_return_value = __qt_this->addDays(static_cast<qint64>(days0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::addDuration(std::chrono::milliseconds)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_addDuration_1native_1std_1chrono_1milliseconds_1constfct__JLjava_time_temporal_TemporalAmount_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject msecs0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::addDuration(std::chrono::milliseconds)const", __qt_this)
        std::chrono::milliseconds  __qt_msecs0 = qtjambi_cast<std::chrono::milliseconds >(__jni_env, __qtjambi_scope, msecs0);
        QDateTime __qt_return_value = __qt_this->addDuration(__qt_msecs0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::addMSecs(qint64)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_addMSecs_1native_1qint64_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong msecs0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::addMSecs(qint64)const", __qt_this)
        QDateTime __qt_return_value = __qt_this->addMSecs(static_cast<qint64>(msecs0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::addMonths(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_addMonths_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint months0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::addMonths(int)const", __qt_this)
        QDateTime __qt_return_value = __qt_this->addMonths(static_cast<int>(months0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::addSecs(qint64)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_addSecs_1native_1qint64_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong secs0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::addSecs(qint64)const", __qt_this)
        QDateTime __qt_return_value = __qt_this->addSecs(static_cast<qint64>(secs0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::addYears(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_addYears_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint years0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::addYears(int)const", __qt_this)
        QDateTime __qt_return_value = __qt_this->addYears(static_cast<int>(years0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::date()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_date_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::date()const", __qt_this)
        QDate __qt_return_value = __qt_this->date();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::daysTo(QDateTime)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_daysTo_1native_1cref_1QDateTime_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::daysTo(QDateTime)const", __qt_this)
        const QDateTime& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(arg__1);
        qint64 __qt_return_value = __qt_this->daysTo(__qt_arg__1);
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::isDaylightTime()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_isDaylightTime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::isDaylightTime()const", __qt_this)
        __java_return_value = __qt_this->isDaylightTime();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::msecsTo(QDateTime)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_msecsTo_1native_1cref_1QDateTime_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::msecsTo(QDateTime)const", __qt_this)
        const QDateTime& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(arg__1);
        qint64 __qt_return_value = __qt_this->msecsTo(__qt_arg__1);
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::offsetFromUtc()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_offsetFromUtc_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::offsetFromUtc()const", __qt_this)
        __java_return_value = __qt_this->offsetFromUtc();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::operator!=(QDateTime,QDateTime)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_operator_1not_1equal_1native_1cref_1QDateTime__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::operator!=(QDateTime,QDateTime)", __qt_this)
        const QDateTime& __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(rhs1);
        __java_return_value = (*__qt_this) != __qt_rhs1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::operator+(QDateTime,std::chrono::milliseconds)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_plus_1native_1std_1chrono_1milliseconds__JLjava_time_temporal_TemporalAmount_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject duration1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::operator+(QDateTime,std::chrono::milliseconds)", __qt_this)
        std::chrono::milliseconds  __qt_duration1 = qtjambi_cast<std::chrono::milliseconds >(__jni_env, __qtjambi_scope, duration1);
        QDateTime __qt_return_value = (*__qt_this) + __qt_duration1;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::operator-(QDateTime,QDateTime)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_minus_1native_1cref_1QDateTime__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::operator-(QDateTime,QDateTime)", __qt_this)
        const QDateTime& __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(rhs1);
        std::chrono::milliseconds __qt_return_value = (*__qt_this) - __qt_rhs1;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::operator-(QDateTime,std::chrono::milliseconds)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_minus_1native_1std_1chrono_1milliseconds__JLjava_time_temporal_TemporalAmount_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject duration1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::operator-(QDateTime,std::chrono::milliseconds)", __qt_this)
        std::chrono::milliseconds  __qt_duration1 = qtjambi_cast<std::chrono::milliseconds >(__jni_env, __qtjambi_scope, duration1);
        QDateTime __qt_return_value = (*__qt_this) - __qt_duration1;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::operator<(QDateTime,QDateTime)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_operator_1less_1native_1cref_1QDateTime__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::operator<(QDateTime,QDateTime)", __qt_this)
        const QDateTime& __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(rhs1);
        __java_return_value = (*__qt_this) < __qt_rhs1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::operator<<(QDataStream&,QDateTime)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::operator<<(QDataStream&,QDateTime)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::operator=(QDateTime)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_assign_1native_1cref_1QDateTime__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::operator=(QDateTime)", __qt_this)
        const QDateTime& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::operator>>(QDataStream&,QDateTime&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::operator>>(QDataStream&,QDateTime&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::secsTo(QDateTime)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_secsTo_1native_1cref_1QDateTime_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::secsTo(QDateTime)const", __qt_this)
        const QDateTime& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(arg__1);
        qint64 __qt_return_value = __qt_this->secsTo(__qt_arg__1);
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::setDate(QDate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_setDate_1native_1QDate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID date0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::setDate(QDate)", __qt_this)
        QDate __qt_date0 = QtJambiAPI::valueReferenceFromNativeId<QDate>(date0);
        __qt_this->setDate(__qt_date0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::setMSecsSinceEpoch(qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_setMSecsSinceEpoch_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong msecs0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::setMSecsSinceEpoch(qint64)", __qt_this)
        __qt_this->setMSecsSinceEpoch(static_cast<qint64>(msecs0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::setOffsetFromUtc(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_setOffsetFromUtc_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint offsetSeconds0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::setOffsetFromUtc(int)", __qt_this)
        __qt_this->setOffsetFromUtc(static_cast<int>(offsetSeconds0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::setSecsSinceEpoch(qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_setSecsSinceEpoch_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong secs0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::setSecsSinceEpoch(qint64)", __qt_this)
        __qt_this->setSecsSinceEpoch(static_cast<qint64>(secs0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::setTime(QTime)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_setTime_1native_1QTime__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID time0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::setTime(QTime)", __qt_this)
        QTime __qt_time0 = QtJambiAPI::valueReferenceFromNativeId<QTime>(time0);
        __qt_this->setTime(__qt_time0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::setTimeSpec(Qt::TimeSpec)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_setTimeSpec_1native_1Qt_1TimeSpec__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint spec0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::setTimeSpec(Qt::TimeSpec)", __qt_this)
        Qt::TimeSpec __qt_spec0 = qtjambi_cast<Qt::TimeSpec>(__jni_env, spec0);
        __qt_this->setTimeSpec(Qt::TimeSpec(__qt_spec0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::setTimeZone(QTimeZone)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_setTimeZone_1native_1cref_1QTimeZone__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID toZone0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::setTimeZone(QTimeZone)", __qt_this)
        const QTimeZone& __qt_toZone0 = QtJambiAPI::valueReferenceFromNativeId<QTimeZone>(toZone0);
        __qt_this->setTimeZone(__qt_toZone0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::swap(QDateTime&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_swap_1native_1ref_1QDateTime__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::swap(QDateTime&)", __qt_this)
        QDateTime& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QDateTime>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDateTime::time()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_time_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::time()const", __qt_this)
        QTime __qt_return_value = __qt_this->time();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::timeRepresentation()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_timeRepresentation_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::timeRepresentation()const", __qt_this)
        QTimeZone __qt_return_value = __qt_this->timeRepresentation();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::timeSpec()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_timeSpec_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::timeSpec()const", __qt_this)
        Qt::TimeSpec __qt_return_value = __qt_this->timeSpec();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::timeZone()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_timeZone_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::timeZone()const", __qt_this)
        QTimeZone __qt_return_value = __qt_this->timeZone();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::timeZoneAbbreviation()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_timeZoneAbbreviation_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::timeZoneAbbreviation()const", __qt_this)
        QString __qt_return_value = __qt_this->timeZoneAbbreviation();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::toLocalTime()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_toLocalTime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::toLocalTime()const", __qt_this)
        QDateTime __qt_return_value = __qt_this->toLocalTime();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::toMSecsSinceEpoch()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_toMSecsSinceEpoch_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::toMSecsSinceEpoch()const", __qt_this)
        qint64 __qt_return_value = __qt_this->toMSecsSinceEpoch();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::toOffsetFromUtc(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_toOffsetFromUtc_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint offsetSeconds0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::toOffsetFromUtc(int)const", __qt_this)
        QDateTime __qt_return_value = __qt_this->toOffsetFromUtc(static_cast<int>(offsetSeconds0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::toSecsSinceEpoch()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_toSecsSinceEpoch_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::toSecsSinceEpoch()const", __qt_this)
        qint64 __qt_return_value = __qt_this->toSecsSinceEpoch();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::toString(QString,QCalendar)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_toString_1native_1cref_1QString_1QCalendar_1constfct__JLjava_lang_String_2J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring format0,
 QtJambiNativeID cal1)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::toString(QString,QCalendar)const", __qt_this)
        QString  __qt_format0 = qtjambi_cast<QString>(__jni_env, format0);
        QCalendar __qt_cal1 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal1);
        QString __qt_return_value = __qt_this->toString(__qt_format0, __qt_cal1);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::toString(Qt::DateFormat)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_toString_1native_1Qt_1DateFormat_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint format0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::toString(Qt::DateFormat)const", __qt_this)
        Qt::DateFormat __qt_format0 = qtjambi_cast<Qt::DateFormat>(__jni_env, format0);
        QString __qt_return_value = __qt_this->toString(Qt::DateFormat(__qt_format0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::toTimeSpec(Qt::TimeSpec)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_toTimeSpec_1native_1Qt_1TimeSpec_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint spec0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::toTimeSpec(Qt::TimeSpec)const", __qt_this)
        Qt::TimeSpec __qt_spec0 = qtjambi_cast<Qt::TimeSpec>(__jni_env, spec0);
        QDateTime __qt_return_value = __qt_this->toTimeSpec(Qt::TimeSpec(__qt_spec0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::toTimeZone(QTimeZone)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_toTimeZone_1native_1cref_1QTimeZone_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID toZone0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::toTimeZone(QTimeZone)const", __qt_this)
        const QTimeZone& __qt_toZone0 = QtJambiAPI::valueReferenceFromNativeId<QTimeZone>(toZone0);
        QDateTime __qt_return_value = __qt_this->toTimeZone(__qt_toZone0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::toUTC()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_toUTC_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDateTime::toUTC()const", __qt_this)
        QDateTime __qt_return_value = __qt_this->toUTC();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::currentDateTime()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_currentDateTime__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::currentDateTime()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDateTime __qt_return_value = QDateTime::currentDateTime();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::currentDateTime(QTimeZone)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_currentDateTime_1native_1cref_1QTimeZone__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID zone0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::currentDateTime(QTimeZone)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QTimeZone& __qt_zone0 = QtJambiAPI::valueReferenceFromNativeId<QTimeZone>(zone0);
        QDateTime __qt_return_value = QDateTime::currentDateTime(__qt_zone0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::currentDateTimeUtc()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_currentDateTimeUtc__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::currentDateTimeUtc()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDateTime __qt_return_value = QDateTime::currentDateTimeUtc();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::currentMSecsSinceEpoch()
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_currentMSecsSinceEpoch__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::currentMSecsSinceEpoch()")
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        qint64 __qt_return_value = QDateTime::currentMSecsSinceEpoch();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::currentSecsSinceEpoch()
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_currentSecsSinceEpoch__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::currentSecsSinceEpoch()")
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        qint64 __qt_return_value = QDateTime::currentSecsSinceEpoch();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::fromMSecsSinceEpoch(qint64)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_fromMSecsSinceEpoch__J)
(JNIEnv *__jni_env,
 jclass,
 jlong msecs0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::fromMSecsSinceEpoch(qint64)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDateTime __qt_return_value = QDateTime::fromMSecsSinceEpoch(static_cast<qint64>(msecs0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::fromMSecsSinceEpoch(qint64,QTimeZone)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_fromMSecsSinceEpoch_1native_1qint64_1cref_1QTimeZone__JJ)
(JNIEnv *__jni_env,
 jclass,
 jlong msecs0,
 QtJambiNativeID timeZone1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::fromMSecsSinceEpoch(qint64,QTimeZone)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QTimeZone& __qt_timeZone1 = QtJambiAPI::valueReferenceFromNativeId<QTimeZone>(timeZone1);
        QDateTime __qt_return_value = QDateTime::fromMSecsSinceEpoch(static_cast<qint64>(msecs0), __qt_timeZone1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::fromMSecsSinceEpoch(qint64,Qt::TimeSpec,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_fromMSecsSinceEpoch_1native_1qint64_1Qt_1TimeSpec_1int__JII)
(JNIEnv *__jni_env,
 jclass,
 jlong msecs0,
 jint spec1,
 jint offsetFromUtc2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::fromMSecsSinceEpoch(qint64,Qt::TimeSpec,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        Qt::TimeSpec __qt_spec1 = qtjambi_cast<Qt::TimeSpec>(__jni_env, spec1);
        QDateTime __qt_return_value = QDateTime::fromMSecsSinceEpoch(static_cast<qint64>(msecs0), Qt::TimeSpec(__qt_spec1), static_cast<int>(offsetFromUtc2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::fromSecsSinceEpoch(qint64)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_fromSecsSinceEpoch__J)
(JNIEnv *__jni_env,
 jclass,
 jlong secs0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::fromSecsSinceEpoch(qint64)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDateTime __qt_return_value = QDateTime::fromSecsSinceEpoch(static_cast<qint64>(secs0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::fromSecsSinceEpoch(qint64,QTimeZone)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_fromSecsSinceEpoch_1native_1qint64_1cref_1QTimeZone__JJ)
(JNIEnv *__jni_env,
 jclass,
 jlong secs0,
 QtJambiNativeID timeZone1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::fromSecsSinceEpoch(qint64,QTimeZone)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QTimeZone& __qt_timeZone1 = QtJambiAPI::valueReferenceFromNativeId<QTimeZone>(timeZone1);
        QDateTime __qt_return_value = QDateTime::fromSecsSinceEpoch(static_cast<qint64>(secs0), __qt_timeZone1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::fromSecsSinceEpoch(qint64,Qt::TimeSpec,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_fromSecsSinceEpoch_1native_1qint64_1Qt_1TimeSpec_1int__JII)
(JNIEnv *__jni_env,
 jclass,
 jlong secs0,
 jint spec1,
 jint offsetFromUtc2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::fromSecsSinceEpoch(qint64,Qt::TimeSpec,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        Qt::TimeSpec __qt_spec1 = qtjambi_cast<Qt::TimeSpec>(__jni_env, spec1);
        QDateTime __qt_return_value = QDateTime::fromSecsSinceEpoch(static_cast<qint64>(secs0), Qt::TimeSpec(__qt_spec1), static_cast<int>(offsetFromUtc2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::fromString(QString,QStringView,QCalendar)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_fromString_1native_1cref_1QString_1QStringView_1QCalendar__Ljava_lang_String_2Ljava_lang_String_2J)
(JNIEnv *__jni_env,
 jclass,
 jstring string0,
 jstring format1,
 QtJambiNativeID cal2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::fromString(QString,QStringView,QCalendar)")
    QtJambiScope __qtjambi_scope;
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_string0 = qtjambi_cast<QString>(__jni_env, string0);
        QStringView  __qt_format1 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, format1);
        QCalendar __qt_cal2 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal2);
        QDateTime __qt_return_value = QDateTime::fromString(__qt_string0, __qt_format1, __qt_cal2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDateTime::fromString(QStringView,Qt::DateFormat)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_fromString_1native_1QStringView_1Qt_1DateFormat__Ljava_lang_String_2I)
(JNIEnv *__jni_env,
 jclass,
 jstring string0,
 jint format1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDateTime::fromString(QStringView,Qt::DateFormat)")
    QtJambiScope __qtjambi_scope;
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QStringView  __qt_string0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, string0);
        Qt::DateFormat __qt_format1 = qtjambi_cast<Qt::DateFormat>(__jni_env, format1);
        QDateTime __qt_return_value = QDateTime::fromString(__qt_string0, Qt::DateFormat(__qt_format1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDateTime_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QDateTime *__qt_this = QtJambiAPI::objectFromNativeId<QDateTime>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QDateTime(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QDateTime>("QDateTime", "io/qt/core/QDateTime");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QDateTime, {
        ConstructorInfo(&__qt_construct_QDateTime_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QDateTime_1, "Lio/qt/core/QDate;Lio/qt/core/QTime;")
       ,ConstructorInfo(&__qt_construct_QDateTime_2, "Lio/qt/core/QDate;Lio/qt/core/QTime;Lio/qt/core/QTimeZone;")
       ,ConstructorInfo(&__qt_construct_QDateTime_3, "Lio/qt/core/QDate;Lio/qt/core/QTime;Lio/qt/core/Qt$TimeSpec;")
       ,ConstructorInfo(&__qt_construct_QDateTime_4, "Lio/qt/core/QDate;Lio/qt/core/QTime;Lio/qt/core/Qt$TimeSpec;I")
       ,ConstructorInfo(&__qt_construct_QDateTime_5, "Lio/qt/core/QDateTime;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QDateTime);
    registerMetaType<QDateTime>("QDateTime");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QDateTime::YearRange>("QDateTime::YearRange", "io/qt/core/QDateTime$YearRange");
// END: enums and flags
}
