#include <QtCore/QtGlobal>
#include <QtCore/qcryptographichash.h>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qbytearrayview.h>
#include <QtCore/qiodevice.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QCryptographicHash(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QCryptographicHash")
    QCryptographicHash *_ptr = reinterpret_cast<QCryptographicHash *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QCryptographicHash(QCryptographicHash::Algorithm)
void __qt_construct_QCryptographicHash_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCryptographicHash(QCryptographicHash::Algorithm)")
    jobject method0 = __java_arguments[0].l;
    QCryptographicHash::Algorithm __qt_method0 = qtjambi_cast<QCryptographicHash::Algorithm>(__jni_env, method0);
    QCryptographicHash *__qt_this = new(__qtjambi_ptr) QCryptographicHash(QCryptographicHash::Algorithm(__qt_method0));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QCryptographicHash
void __qt_destruct_QCryptographicHash(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QCryptographicHash")
    reinterpret_cast<QCryptographicHash*>(ptr)->~QCryptographicHash();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QCryptographicHash::QCryptographicHash(QCryptographicHash::Algorithm)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_initialize_1native__Lio_qt_core_QCryptographicHash_2Lio_qt_core_QCryptographicHash_00024Algorithm_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject method0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCryptographicHash::QCryptographicHash(QCryptographicHash::Algorithm)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = method0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCryptographicHash_0, sizeof(QCryptographicHash), typeid(QCryptographicHash), false, &deleter_QCryptographicHash, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCryptographicHash::addData(QByteArrayView)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_addData_1native_1QByteArrayView__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID data0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::addData(QByteArrayView)", __qt_this)
        QByteArrayView __qt_data0 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(data0);
        __qt_this->addData(__qt_data0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCryptographicHash::addData(QIODevice*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_addData_1native_1QIODevice_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID device0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::addData(QIODevice*)", __qt_this)
        QIODevice* __qt_device0 = QtJambiAPI::objectFromNativeId<QIODevice>(device0);
        __java_return_value = __qt_this->addData(__qt_device0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCryptographicHash::addData(const char*,qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_addData_1native_1const_1char_1ptr_1qsizetype__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring data0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::addData(const char*,qsizetype)", __qt_this)
        qsizetype length1{0};
        JBufferConstData __qt_data0_buffer(__jni_env, data0);
        const char* __qt_data0 = __qt_data0_buffer.data<char>();
        length1 = __qt_data0_buffer.size<char>();
        __qt_this->addData(__qt_data0, static_cast<qsizetype>(length1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCryptographicHash::algorithm()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_algorithm_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::algorithm()const", __qt_this)
        QCryptographicHash::Algorithm __qt_return_value = __qt_this->algorithm();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCryptographicHash::reset()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_reset_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::reset()", __qt_this)
        __qt_this->reset();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCryptographicHash::result()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_result_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::result()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->result();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCryptographicHash::resultView()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_resultView_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::resultView()const", __qt_this)
        QByteArrayView __qt_return_value = __qt_this->resultView();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCryptographicHash::swap(QCryptographicHash&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_swap_1native_1ref_1QCryptographicHash__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QCryptographicHash *__qt_this = QtJambiAPI::objectFromNativeId<QCryptographicHash>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCryptographicHash::swap(QCryptographicHash&)", __qt_this)
        QCryptographicHash& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QCryptographicHash>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCryptographicHash::hash(QByteArrayView,QCryptographicHash::Algorithm)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_hash_1native_1QByteArrayView_1QCryptographicHash_1Algorithm__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID data0,
 jint method1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCryptographicHash::hash(QByteArrayView,QCryptographicHash::Algorithm)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArrayView __qt_data0 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(data0);
        QCryptographicHash::Algorithm __qt_method1 = qtjambi_cast<QCryptographicHash::Algorithm>(__jni_env, method1);
        QByteArray __qt_return_value = QCryptographicHash::hash(__qt_data0, QCryptographicHash::Algorithm(__qt_method1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCryptographicHash::hashLength(QCryptographicHash::Algorithm)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_hashLength_1native_1QCryptographicHash_1Algorithm__I)
(JNIEnv *__jni_env,
 jclass,
 jint method0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCryptographicHash::hashLength(QCryptographicHash::Algorithm)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QCryptographicHash::Algorithm __qt_method0 = qtjambi_cast<QCryptographicHash::Algorithm>(__jni_env, method0);
        __java_return_value = QCryptographicHash::hashLength(QCryptographicHash::Algorithm(__qt_method0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCryptographicHash::supportsAlgorithm(QCryptographicHash::Algorithm)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCryptographicHash_supportsAlgorithm_1native_1QCryptographicHash_1Algorithm__I)
(JNIEnv *__jni_env,
 jclass,
 jint method0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCryptographicHash::supportsAlgorithm(QCryptographicHash::Algorithm)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QCryptographicHash::Algorithm __qt_method0 = qtjambi_cast<QCryptographicHash::Algorithm>(__jni_env, method0);
        __java_return_value = QCryptographicHash::supportsAlgorithm(QCryptographicHash::Algorithm(__qt_method0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QCryptographicHash(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QCryptographicHash>("QCryptographicHash", "io/qt/core/QCryptographicHash");
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QCryptographicHash, {
        ConstructorInfo(&__qt_construct_QCryptographicHash_0, "Lio/qt/core/QCryptographicHash$Algorithm;")
    });
// END: function table

    registerMetaObject(typeId, QCryptographicHash::staticMetaObject, false);
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QCryptographicHash);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QCryptographicHash::Algorithm>("QCryptographicHash::Algorithm", "io/qt/core/QCryptographicHash$Algorithm");
// END: enums and flags
}
