#ifndef QRHITEXTURE_SHELL_H
#define QRHITEXTURE_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/rhi/qrhi.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qsize.h>
#include <QtJambi/RegistryAPI>


class QRhiTexture_shell : public QRhiTexture, public QtJambiShellInterface
{
public:
    ~QRhiTexture_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QRhiTexture_oshell;
};


class QRhiTexture_oshell : public QRhiTexture_shell
{
public:
    using QRhiTexture_shell::QRhiTexture_shell;
    bool create() override;
    bool createFrom(QRhiTexture::NativeTexture src0) override;
    void destroy() override;
    QRhiTexture::NativeTexture nativeTexture() override;
    QRhiResource::Type resourceType() const override;
    void setNativeLayout(int layout0) override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QRhiTexture_access : public QRhiTexture
{
    jboolean __qt_create(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jboolean __qt_createFrom_QRhiTexture_NativeTexture(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID src0);
    void __qt_destroy(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_nativeTexture(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_resourceType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_setNativeLayout_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint layout0);
};

#endif // QRHITEXTURE_SHELL_H
