#ifndef QRHITEXTURERENDERTARGET_SHELL_H
#define QRHITEXTURERENDERTARGET_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/rhi/qrhi.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qsize.h>
#include <QtJambi/RegistryAPI>


class QRhiTextureRenderTarget_shell : public QRhiTextureRenderTarget, public QtJambiShellInterface
{
public:
    ~QRhiTextureRenderTarget_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QRhiTextureRenderTarget_oshell;
};


class QRhiTextureRenderTarget_oshell : public QRhiTextureRenderTarget_shell
{
public:
    using QRhiTextureRenderTarget_shell::QRhiTextureRenderTarget_shell;
    bool create() override;
    void destroy() override;
    float devicePixelRatio() const override;
    QRhiRenderPassDescriptor* newCompatibleRenderPassDescriptor() override;
    QSize pixelSize() const override;
    QRhiResource::Type resourceType() const override;
    int sampleCount() const override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QRhiTextureRenderTarget_access : public QRhiTextureRenderTarget
{
    jboolean __qt_create(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_destroy(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jfloat __qt_devicePixelRatio_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_newCompatibleRenderPassDescriptor(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_pixelSize_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_resourceType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_sampleCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QRHITEXTURERENDERTARGET_SHELL_H
