#include <QtCore/QtGlobal>
#include <QtGui/rhi/qrhi.h>
#include <QtCore/QList>
#include <QtCore/QVariant>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/JavaAPI>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QRhiShaderResourceBinding(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QRhiShaderResourceBinding")
    QRhiShaderResourceBinding *_ptr = reinterpret_cast<QRhiShaderResourceBinding *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QRhiShaderResourceBinding()
void __qt_construct_QRhiShaderResourceBinding(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRhiShaderResourceBinding()")
    Q_UNUSED(__java_arguments)
    QRhiShaderResourceBinding *__qt_this = new(__qtjambi_ptr) QRhiShaderResourceBinding();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QRhiShaderResourceBinding::QRhiShaderResourceBinding()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_initialize_1native__Lio_qt_gui_rhi_QRhiShaderResourceBinding_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::QRhiShaderResourceBinding()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRhiShaderResourceBinding, sizeof(QRhiShaderResourceBinding), typeid(QRhiShaderResourceBinding), 0, false, &deleter_QRhiShaderResourceBinding, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QRhiShaderResourceBinding(QRhiShaderResourceBinding)
void __qt_construct_QRhiShaderResourceBinding_cref_QRhiShaderResourceBinding(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRhiShaderResourceBinding(QRhiShaderResourceBinding)")
    jobject other0 = __java_arguments[0].l;
    const QRhiShaderResourceBinding& __qt_other0 = qtjambi_cast<const QRhiShaderResourceBinding&>(__jni_env, other0);
    QRhiShaderResourceBinding *__qt_this = new(__qtjambi_ptr) QRhiShaderResourceBinding(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QRhiShaderResourceBinding::QRhiShaderResourceBinding(QRhiShaderResourceBinding)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_initialize_1native__Lio_qt_gui_rhi_QRhiShaderResourceBinding_2Lio_qt_gui_rhi_QRhiShaderResourceBinding_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::QRhiShaderResourceBinding(QRhiShaderResourceBinding)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRhiShaderResourceBinding_cref_QRhiShaderResourceBinding, sizeof(QRhiShaderResourceBinding), typeid(QRhiShaderResourceBinding), 0, false, &deleter_QRhiShaderResourceBinding, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QRhiShaderResourceBinding
void __qt_destruct_QRhiShaderResourceBinding(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QRhiShaderResourceBinding")
    reinterpret_cast<QRhiShaderResourceBinding*>(ptr)->~QRhiShaderResourceBinding();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QRhiShaderResourceBinding::isLayoutCompatible(QRhiShaderResourceBinding)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_isLayoutCompatible_1native_1cref_1QRhiShaderResourceBinding_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRhiShaderResourceBinding *__qt_this = QtJambiAPI::objectFromNativeId<QRhiShaderResourceBinding>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRhiShaderResourceBinding::isLayoutCompatible(QRhiShaderResourceBinding)const", __this_nativeId)
        const QRhiShaderResourceBinding& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QRhiShaderResourceBinding>(__jni_env, other0);
        __java_return_value = __qt_this->isLayoutCompatible(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::operator==(QRhiShaderResourceBinding,QRhiShaderResourceBinding)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_equals_1native_1cref_1QRhiShaderResourceBinding__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID b1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding *__qt_this = QtJambiAPI::objectFromNativeId<QRhiShaderResourceBinding>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRhiShaderResourceBinding::operator==(QRhiShaderResourceBinding,QRhiShaderResourceBinding)", __this_nativeId)
        const QRhiShaderResourceBinding& __qt_b1 = QtJambiAPI::objectReferenceFromNativeId<QRhiShaderResourceBinding>(__jni_env, b1);
        __java_return_value = (*__qt_this) == __qt_b1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::bufferLoad(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_bufferLoad_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiBuffer_1ptr__IIJ)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID buf2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::bufferLoad(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiBuffer* __qt_buf2 = QtJambiAPI::objectFromNativeId<QRhiBuffer>(buf2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::bufferLoad(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_buf2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::bufferLoad(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*,quint32,quint32)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_bufferLoad_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiBuffer_1ptr_1quint32_1quint32__IIJII)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID buf2,
 jint offset3,
 jint size4)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::bufferLoad(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*,quint32,quint32)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiBuffer* __qt_buf2 = QtJambiAPI::objectFromNativeId<QRhiBuffer>(buf2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::bufferLoad(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_buf2, static_cast<quint32>(offset3), static_cast<quint32>(size4));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::bufferLoadStore(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_bufferLoadStore_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiBuffer_1ptr__IIJ)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID buf2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::bufferLoadStore(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiBuffer* __qt_buf2 = QtJambiAPI::objectFromNativeId<QRhiBuffer>(buf2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::bufferLoadStore(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_buf2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::bufferLoadStore(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*,quint32,quint32)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_bufferLoadStore_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiBuffer_1ptr_1quint32_1quint32__IIJII)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID buf2,
 jint offset3,
 jint size4)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::bufferLoadStore(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*,quint32,quint32)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiBuffer* __qt_buf2 = QtJambiAPI::objectFromNativeId<QRhiBuffer>(buf2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::bufferLoadStore(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_buf2, static_cast<quint32>(offset3), static_cast<quint32>(size4));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::bufferStore(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_bufferStore_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiBuffer_1ptr__IIJ)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID buf2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::bufferStore(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiBuffer* __qt_buf2 = QtJambiAPI::objectFromNativeId<QRhiBuffer>(buf2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::bufferStore(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_buf2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::bufferStore(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*,quint32,quint32)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_bufferStore_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiBuffer_1ptr_1quint32_1quint32__IIJII)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID buf2,
 jint offset3,
 jint size4)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::bufferStore(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*,quint32,quint32)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiBuffer* __qt_buf2 = QtJambiAPI::objectFromNativeId<QRhiBuffer>(buf2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::bufferStore(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_buf2, static_cast<quint32>(offset3), static_cast<quint32>(size4));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::imageLoad(int,QRhiShaderResourceBinding::StageFlags,QRhiTexture*,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_imageLoad_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiTexture_1ptr_1int__IIJI)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID tex2,
 jint level3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::imageLoad(int,QRhiShaderResourceBinding::StageFlags,QRhiTexture*,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiTexture* __qt_tex2 = QtJambiAPI::objectFromNativeId<QRhiTexture>(tex2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::imageLoad(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_tex2, static_cast<int>(level3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::imageLoadStore(int,QRhiShaderResourceBinding::StageFlags,QRhiTexture*,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_imageLoadStore_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiTexture_1ptr_1int__IIJI)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID tex2,
 jint level3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::imageLoadStore(int,QRhiShaderResourceBinding::StageFlags,QRhiTexture*,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiTexture* __qt_tex2 = QtJambiAPI::objectFromNativeId<QRhiTexture>(tex2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::imageLoadStore(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_tex2, static_cast<int>(level3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::imageStore(int,QRhiShaderResourceBinding::StageFlags,QRhiTexture*,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_imageStore_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiTexture_1ptr_1int__IIJI)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID tex2,
 jint level3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::imageStore(int,QRhiShaderResourceBinding::StageFlags,QRhiTexture*,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiTexture* __qt_tex2 = QtJambiAPI::objectFromNativeId<QRhiTexture>(tex2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::imageStore(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_tex2, static_cast<int>(level3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::sampledTexture(int,QRhiShaderResourceBinding::StageFlags,QRhiTexture*,QRhiSampler*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_sampledTexture_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiTexture_1ptr_1QRhiSampler_1ptr__IIJJ)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID tex2,
 QtJambiNativeID sampler3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::sampledTexture(int,QRhiShaderResourceBinding::StageFlags,QRhiTexture*,QRhiSampler*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiTexture* __qt_tex2 = QtJambiAPI::objectFromNativeId<QRhiTexture>(tex2);
        QRhiSampler* __qt_sampler3 = QtJambiAPI::objectFromNativeId<QRhiSampler>(sampler3);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::sampledTexture(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_tex2, __qt_sampler3);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::sampledTextures(int,QRhiShaderResourceBinding::StageFlags,int,const QRhiShaderResourceBinding::TextureAndSampler*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_sampledTextures_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1int_1const_1QRhiShaderResourceBinding_1TextureAndSampler_1ptr__IIIJ)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 jint count2,
 QtJambiNativeID texSamplers3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::sampledTextures(int,QRhiShaderResourceBinding::StageFlags,int,const QRhiShaderResourceBinding::TextureAndSampler*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        const QRhiShaderResourceBinding::TextureAndSampler* __qt_texSamplers3 = QtJambiAPI::objectFromNativeId<QRhiShaderResourceBinding::TextureAndSampler>(texSamplers3);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::sampledTextures(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), static_cast<int>(count2), __qt_texSamplers3);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::sampler(int,QRhiShaderResourceBinding::StageFlags,QRhiSampler*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_sampler_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiSampler_1ptr__IIJ)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID sampler2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::sampler(int,QRhiShaderResourceBinding::StageFlags,QRhiSampler*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiSampler* __qt_sampler2 = QtJambiAPI::objectFromNativeId<QRhiSampler>(sampler2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::sampler(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_sampler2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::serializeLayoutDescription<QList<quint32>>(const QRhiShaderResourceBinding*,const QRhiShaderResourceBinding*,QList)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_serializeLayoutDescription_1native_1const_1QRhiShaderResourceBinding_1ptr_1const_1QRhiShaderResourceBinding_1ptr_1QList___3Lio_qt_gui_rhi_QRhiShaderResourceBinding_2Ljava_util_Collection_2)
(JNIEnv *__jni_env,
 jclass,
 jobjectArray first0,
 jobject dst2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::serializeLayoutDescription<QList<quint32>>(const QRhiShaderResourceBinding*,const QRhiShaderResourceBinding*,QList)")
    QtJambiScope __qtjambi_scope;
    QTJAMBI_TRY {
        JObjectArrayPointer<QRhiShaderResourceBinding> array(__jni_env, first0,
            [](QRhiShaderResourceBinding & pointer,JNIEnv *env, jobject element){
                pointer = qtjambi_cast<QRhiShaderResourceBinding>(env, element);
            }
        );
        const QRhiShaderResourceBinding * __qt_first0 = array.pointer();
        const QRhiShaderResourceBinding * __qt_last1 = array.pointer()+array.size();
        auto __qt_dst2 = std::back_inserter(qtjambi_cast<QList<quint32>&>(__jni_env, __qtjambi_scope, dst2));
        QRhiShaderResourceBinding::serializeLayoutDescription(__qt_first0, __qt_last1, __qt_dst2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRhiShaderResourceBinding::serializeLayoutDescription<quint32*>(const QRhiShaderResourceBinding*,const QRhiShaderResourceBinding*,quint32*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_serializeLayoutDescription_1native_1const_1QRhiShaderResourceBinding_1ptr_1const_1QRhiShaderResourceBinding_1ptr_1quint32_1ptr___3Lio_qt_gui_rhi_QRhiShaderResourceBinding_2JLjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jclass,
 jobjectArray first0,
 QtJambiNativeID last1,
 jobject dst2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::serializeLayoutDescription<quint32*>(const QRhiShaderResourceBinding*,const QRhiShaderResourceBinding*,quint32*)")
    QTJAMBI_TRY {
        JObjectArrayPointer<QRhiShaderResourceBinding> array(__jni_env, first0,
            [](QRhiShaderResourceBinding & pointer,JNIEnv *env, jobject element){
                pointer = qtjambi_cast<QRhiShaderResourceBinding>(env, element);
            }
        );
        const QRhiShaderResourceBinding * __qt_first0 = array.pointer();
        const QRhiShaderResourceBinding* __qt_last1 = QtJambiAPI::objectFromNativeId<QRhiShaderResourceBinding>(last1);
        JBufferData __qt_dst2_buffer(__jni_env, dst2);
        quint32* __qt_dst2 = __qt_dst2_buffer.data<quint32>();
        QRhiShaderResourceBinding::serializeLayoutDescription(__qt_first0, __qt_last1, __qt_dst2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRhiShaderResourceBinding::texture(int,QRhiShaderResourceBinding::StageFlags,QRhiTexture*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_texture_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiTexture_1ptr__IIJ)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID tex2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::texture(int,QRhiShaderResourceBinding::StageFlags,QRhiTexture*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiTexture* __qt_tex2 = QtJambiAPI::objectFromNativeId<QRhiTexture>(tex2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::texture(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_tex2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::textures(int,QRhiShaderResourceBinding::StageFlags,int,QRhiTexture**)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_textures_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1int_1QRhiTexture_1ptr_1ptr__II_3Lio_qt_gui_rhi_QRhiTexture_2)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 jobjectArray tex3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::textures(int,QRhiShaderResourceBinding::StageFlags,int,QRhiTexture**)")
    QtJambiScope __qtjambi_scope;
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        int count2{0};
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiTexture** __qt_tex3 = qtjambi_array_cast<QRhiTexture**>(__jni_env, __qtjambi_scope, tex3, count2);

        if(count2 == 0 || count2 > QRhiShaderResourceBinding::Data::MAX_TEX_SAMPLER_ARRAY_SIZE){
            Java::Runtime::IllegalArgumentException::throwNew(__jni_env, "Array size must not be 0 or greater 16." QTJAMBI_STACKTRACEINFO );
        }

        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::textures(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), static_cast<int>(count2), __qt_tex3);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::uniformBuffer(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_uniformBuffer_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiBuffer_1ptr__IIJ)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID buf2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::uniformBuffer(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiBuffer* __qt_buf2 = QtJambiAPI::objectFromNativeId<QRhiBuffer>(buf2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::uniformBuffer(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_buf2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::uniformBuffer(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*,quint32,quint32)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_uniformBuffer_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiBuffer_1ptr_1quint32_1quint32__IIJII)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID buf2,
 jint offset3,
 jint size4)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::uniformBuffer(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*,quint32,quint32)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiBuffer* __qt_buf2 = QtJambiAPI::objectFromNativeId<QRhiBuffer>(buf2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::uniformBuffer(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_buf2, static_cast<quint32>(offset3), static_cast<quint32>(size4));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRhiShaderResourceBinding::uniformBufferWithDynamicOffset(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*,quint32)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_uniformBufferWithDynamicOffset_1native_1int_1QRhiShaderResourceBinding_1StageFlags_1QRhiBuffer_1ptr_1quint32__IIJI)
(JNIEnv *__jni_env,
 jclass,
 jint binding0,
 jint stage1,
 QtJambiNativeID buf2,
 jint size3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRhiShaderResourceBinding::uniformBufferWithDynamicOffset(int,QRhiShaderResourceBinding::StageFlags,QRhiBuffer*,quint32)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRhiShaderResourceBinding::StageFlags __qt_stage1 = qtjambi_cast<QRhiShaderResourceBinding::StageFlags>(__jni_env, stage1);
        QRhiBuffer* __qt_buf2 = QtJambiAPI::objectFromNativeId<QRhiBuffer>(buf2);
        QRhiShaderResourceBinding __qt_return_value = QRhiShaderResourceBinding::uniformBufferWithDynamicOffset(static_cast<int>(binding0), QRhiShaderResourceBinding::StageFlags(__qt_stage1), __qt_buf2, static_cast<quint32>(size3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QRhiShaderResourceBinding *__qt_this = QtJambiAPI::objectFromNativeId<QRhiShaderResourceBinding>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QRhiShaderResourceBinding *__qt_this = QtJambiAPI::objectFromNativeId<QRhiShaderResourceBinding>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_rhi_QRhiShaderResourceBinding_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QRhiShaderResourceBinding *__qt_this = QtJambiAPI::objectFromNativeId<QRhiShaderResourceBinding>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QRhiShaderResourceBinding(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QRhiShaderResourceBinding>("QRhiShaderResourceBinding", "io/qt/gui/rhi/QRhiShaderResourceBinding");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QRhiShaderResourceBinding, {
        ConstructorInfo(&__qt_construct_QRhiShaderResourceBinding, nullptr)
       ,ConstructorInfo(&__qt_construct_QRhiShaderResourceBinding_cref_QRhiShaderResourceBinding, "Lio/qt/gui/rhi/QRhiShaderResourceBinding;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QRhiShaderResourceBinding);
    registerMetaType<QRhiShaderResourceBinding>("QRhiShaderResourceBinding");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QRhiShaderResourceBinding::StageFlag>("QRhiShaderResourceBinding::StageFlag", "io/qt/gui/rhi/QRhiShaderResourceBinding$StageFlag", "QRhiShaderResourceBinding::StageFlags", "QFlags<QRhiShaderResourceBinding::StageFlag>", "io/qt/gui/rhi/QRhiShaderResourceBinding$StageFlags");
    registerEnumTypeInfo<QRhiShaderResourceBinding::Type>("QRhiShaderResourceBinding::Type", "io/qt/gui/rhi/QRhiShaderResourceBinding$Type");
// END: enums and flags
}
