#ifndef QRHIRESOURCE_SHELL_H
#define QRHIRESOURCE_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/rhi/qrhi.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtJambi/RegistryAPI>


class QRhiResource_shell : public QRhiResource, public QtJambiShellInterface
{
public:
    ~QRhiResource_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QRhiResource_oshell;
};


class QRhiResource_oshell : public QRhiResource_shell
{
public:
    using QRhiResource_shell::QRhiResource_shell;
    void destroy() override;
    QRhiResource::Type resourceType() const override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QRhiResource_access : public QRhiResource
{
    void __qt_destroy(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_resourceType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QRHIRESOURCE_SHELL_H
