#ifndef QRHIRENDERBUFFER_SHELL_H
#define QRHIRENDERBUFFER_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/rhi/qrhi.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qsize.h>
#include <QtJambi/RegistryAPI>


class QRhiRenderBuffer_shell : public QRhiRenderBuffer, public QtJambiShellInterface
{
public:
    ~QRhiRenderBuffer_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QRhiRenderBuffer_oshell;
};


class QRhiRenderBuffer_oshell : public QRhiRenderBuffer_shell
{
public:
    using QRhiRenderBuffer_shell::QRhiRenderBuffer_shell;
    QRhiTexture::Format backingFormat() const override;
    bool create() override;
    bool createFrom(QRhiRenderBuffer::NativeRenderBuffer src0) override;
    void destroy() override;
    QRhiResource::Type resourceType() const override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QRhiRenderBuffer_access : public QRhiRenderBuffer
{
    jint __qt_backingFormat_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_create(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jboolean __qt_createFrom_QRhiRenderBuffer_NativeRenderBuffer(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID src0);
    void __qt_destroy(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_resourceType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QRHIRENDERBUFFER_SHELL_H
