#ifndef QRHIGRAPHICSPIPELINE_SHELL_H
#define QRHIGRAPHICSPIPELINE_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/rhi/qrhi.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtJambi/RegistryAPI>


class QRhiGraphicsPipeline_shell : public QRhiGraphicsPipeline, public QtJambiShellInterface
{
public:
    ~QRhiGraphicsPipeline_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QRhiGraphicsPipeline_oshell;
};


class QRhiGraphicsPipeline_oshell : public QRhiGraphicsPipeline_shell
{
public:
    using QRhiGraphicsPipeline_shell::QRhiGraphicsPipeline_shell;
    bool create() override;
    void destroy() override;
    QRhiResource::Type resourceType() const override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QRhiGraphicsPipeline_access : public QRhiGraphicsPipeline
{
    jboolean __qt_create(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_destroy(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_resourceType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QRHIGRAPHICSPIPELINE_SHELL_H
