#ifndef QRHICOMPUTEPIPELINE_SHELL_H
#define QRHICOMPUTEPIPELINE_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/rhi/qrhi.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtJambi/RegistryAPI>


class QRhiComputePipeline_shell : public QRhiComputePipeline, public QtJambiShellInterface
{
public:
    ~QRhiComputePipeline_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QRhiComputePipeline_oshell;
};


class QRhiComputePipeline_oshell : public QRhiComputePipeline_shell
{
public:
    using QRhiComputePipeline_shell::QRhiComputePipeline_shell;
    bool create() override;
    void destroy() override;
    QRhiResource::Type resourceType() const override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QRhiComputePipeline_access : public QRhiComputePipeline
{
    jboolean __qt_create(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_destroy(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_resourceType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QRHICOMPUTEPIPELINE_SHELL_H
