#include "QPaintEngine_shell.h"
#include <QtJambi/Cast>

void deleter_QPaintEngine(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QPaintEngine")
    QPaintEngine *_ptr = reinterpret_cast<QPaintEngine *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QPaintEngine_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QPaintEngine_shell) ); }

jmethodID QPaintEngine_oshell::__shell_javaMethod(int pos) const { return QPaintEngine_shell::__shell()->javaMethod(typeid(QPaintEngine), pos); }

// emitting (writeShellDestructor)
QPaintEngine_shell::~QPaintEngine_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QPaintEngine::~QPaintEngine()", this)
    QPaintEngine_shell::__shell()->destructed(typeid(QPaintEngine));
}

// emitting (writeShellConstructor)
QPaintEngine_shell::QPaintEngine_shell(QPaintEngine::PaintEngineFeatures features0)
    : QPaintEngine(features0)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QPaintEngine::QPaintEngine_shell(QPaintEngine::PaintEngineFeatures features0)", this)
    QPaintEngine_shell::__shell()->constructed(typeid(QPaintEngine));
}

void QPaintEngine_oshell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QPaintEngine_oshell*>(ptr)->QPaintEngine_oshell::__shell()->tryDeleteShell(typeid(QPaintEngine));
}

// emitting Virtual overrides (virtualFunctions)
bool QPaintEngine_oshell::begin(QPaintDevice* pdev0)
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_pdev0 = qtjambi_cast<jobject>(__jni_env, pdev0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_pdev0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_pdev0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::begin(QPaintDevice*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::begin(QPaintDevice*)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

QPoint QPaintEngine_oshell::coordinateOffset() const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        if (JniEnvironmentExceptionHandler __jni_env{200}) {
            QPoint  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = qtjambi_cast<QPoint>(__jni_env, __java_return_value);
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::coordinateOffset()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::coordinateOffset()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintEngine::coordinateOffset();
        }
    }else{
        return QPaintEngine::coordinateOffset();
    }
}

QPixmap QPaintEngine_oshell::createPixmap(QSize size0)
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QPixmap  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_size0 = qtjambi_cast<jobject>(__jni_env, size0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_size0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = qtjambi_cast<QPixmap>(__jni_env, __java_return_value);
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::createPixmap(QSize)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::createPixmap(QSize)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintEngine::createPixmap(size0);
        }
    }else{
        return QPaintEngine::createPixmap(size0);
    }
}

QPixmap QPaintEngine_oshell::createPixmapFromImage(QImage image0, Qt::ImageConversionFlags flags1)
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        if (JniEnvironmentExceptionHandler __jni_env{400}) {
            QPixmap  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_image0 = qtjambi_cast<jobject>(__jni_env, image0);
                    jobject __java_flags1 = qtjambi_cast<jobject>(__jni_env, flags1);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_image0, __java_flags1);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = qtjambi_cast<QPixmap>(__jni_env, __java_return_value);
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::createPixmapFromImage(QImage,Qt::ImageConversionFlags)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::createPixmapFromImage(QImage,Qt::ImageConversionFlags)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintEngine::createPixmapFromImage(image0, Qt::ImageConversionFlags(flags1));
        }
    }else{
        return QPaintEngine::createPixmapFromImage(image0, Qt::ImageConversionFlags(flags1));
    }
}

void QPaintEngine_oshell::drawEllipse(const QRect& r0)
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_r0 = qtjambi_cast<jobject>(__jni_env, r0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_r0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawEllipse(QRect)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawEllipse(QRect)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawEllipse(r0);
        }
    }else{
        QPaintEngine::drawEllipse(r0);
    }
}

void QPaintEngine_oshell::drawEllipse(const QRectF& r0)
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_r0 = qtjambi_cast<jobject>(__jni_env, r0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_r0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawEllipse(QRectF)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawEllipse(QRectF)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawEllipse(r0);
        }
    }else{
        QPaintEngine::drawEllipse(r0);
    }
}

void QPaintEngine_oshell::drawImage(const QRectF& r0, const QImage& pm1, const QRectF& sr2, Qt::ImageConversionFlags flags3)
{
    if(jmethodID method_id = __shell_javaMethod(6)){
        if (JniEnvironmentExceptionHandler __jni_env{600}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_r0 = qtjambi_cast<jobject>(__jni_env, r0);
                    jobject __java_pm1 = qtjambi_cast<jobject>(__jni_env, pm1);
                    jobject __java_sr2 = qtjambi_cast<jobject>(__jni_env, sr2);
                    jobject __java_flags3 = qtjambi_cast<jobject>(__jni_env, flags3);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_r0, __java_pm1, __java_sr2, __java_flags3);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawImage(QRectF,QImage,QRectF,Qt::ImageConversionFlags)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawImage(QRectF,QImage,QRectF,Qt::ImageConversionFlags)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawImage(r0, pm1, sr2, Qt::ImageConversionFlags(flags3));
        }
    }else{
        QPaintEngine::drawImage(r0, pm1, sr2, Qt::ImageConversionFlags(flags3));
    }
}

void QPaintEngine_oshell::drawLines(const QLine* lines0, int lineCount1)
{
    if(jmethodID method_id = __shell_javaMethod(7)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QPaintEngine_shell::__shell(), 400}) {
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jobjectArray __java_lines0 = qtjambi_array_cast<jobjectArray>(__jni_env, __jni_env.scope(), lines0, lineCount1);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_lines0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawLines(const QLine*,int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawLines(const QLine*,int)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawLines(lines0, static_cast<int>(lineCount1));
        }
    }else{
        QPaintEngine::drawLines(lines0, static_cast<int>(lineCount1));
    }
}

void QPaintEngine_oshell::drawLines(const QLineF* lines0, int lineCount1)
{
    if(jmethodID method_id = __shell_javaMethod(8)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QPaintEngine_shell::__shell(), 400}) {
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jobjectArray __java_lines0 = qtjambi_array_cast<jobjectArray>(__jni_env, __jni_env.scope(), lines0, lineCount1);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_lines0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawLines(const QLineF*,int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawLines(const QLineF*,int)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawLines(lines0, static_cast<int>(lineCount1));
        }
    }else{
        QPaintEngine::drawLines(lines0, static_cast<int>(lineCount1));
    }
}

void QPaintEngine_oshell::drawPath(const QPainterPath& path0)
{
    if(jmethodID method_id = __shell_javaMethod(9)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_path0 = qtjambi_cast<jobject>(__jni_env, path0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_path0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawPath(QPainterPath)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawPath(QPainterPath)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawPath(path0);
        }
    }else{
        QPaintEngine::drawPath(path0);
    }
}

void QPaintEngine_oshell::drawPixmap(const QRectF& r0, const QPixmap& pm1, const QRectF& sr2)
{
    if(jmethodID method_id = __shell_javaMethod(10)){
        if (JniEnvironmentExceptionHandler __jni_env{500}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_r0 = qtjambi_cast<jobject>(__jni_env, r0);
                    jobject __java_pm1 = qtjambi_cast<jobject>(__jni_env, pm1);
                    jobject __java_sr2 = qtjambi_cast<jobject>(__jni_env, sr2);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_r0, __java_pm1, __java_sr2);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawPixmap(QRectF,QPixmap,QRectF)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawPixmap(QRectF,QPixmap,QRectF)");
            } QTJAMBI_TRY_END
        }
    }
}

void QPaintEngine_oshell::drawPoints(const QPoint* points0, int pointCount1)
{
    if(jmethodID method_id = __shell_javaMethod(11)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QPaintEngine_shell::__shell(), 400}) {
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jobjectArray __java_points0 = qtjambi_array_cast<jobjectArray>(__jni_env, __jni_env.scope(), points0, pointCount1);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_points0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawPoints(const QPoint*,int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawPoints(const QPoint*,int)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawPoints(points0, static_cast<int>(pointCount1));
        }
    }else{
        QPaintEngine::drawPoints(points0, static_cast<int>(pointCount1));
    }
}

void QPaintEngine_oshell::drawPoints(const QPointF* points0, int pointCount1)
{
    if(jmethodID method_id = __shell_javaMethod(12)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QPaintEngine_shell::__shell(), 400}) {
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jobjectArray __java_points0 = qtjambi_array_cast<jobjectArray>(__jni_env, __jni_env.scope(), points0, pointCount1);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_points0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawPoints(const QPointF*,int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawPoints(const QPointF*,int)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawPoints(points0, static_cast<int>(pointCount1));
        }
    }else{
        QPaintEngine::drawPoints(points0, static_cast<int>(pointCount1));
    }
}

void QPaintEngine_oshell::drawPolygon(const QPoint* points0, int pointCount1, QPaintEngine::PolygonDrawMode mode2)
{
    if(jmethodID method_id = __shell_javaMethod(13)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QPaintEngine_shell::__shell(), 500}) {
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jobjectArray __java_points0 = qtjambi_array_cast<jobjectArray>(__jni_env, __jni_env.scope(), points0, pointCount1);
                    jobject __java_mode2 = qtjambi_cast<jobject>(__jni_env, mode2);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_points0, __java_mode2);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawPolygon(const QPoint*,int,QPaintEngine::PolygonDrawMode)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawPolygon(const QPoint*,int,QPaintEngine::PolygonDrawMode)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawPolygon(points0, static_cast<int>(pointCount1), QPaintEngine::PolygonDrawMode(mode2));
        }
    }else{
        QPaintEngine::drawPolygon(points0, static_cast<int>(pointCount1), QPaintEngine::PolygonDrawMode(mode2));
    }
}

void QPaintEngine_oshell::drawPolygon(const QPointF* points0, int pointCount1, QPaintEngine::PolygonDrawMode mode2)
{
    if(jmethodID method_id = __shell_javaMethod(14)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QPaintEngine_shell::__shell(), 500}) {
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jobjectArray __java_points0 = qtjambi_array_cast<jobjectArray>(__jni_env, __jni_env.scope(), points0, pointCount1);
                    jobject __java_mode2 = qtjambi_cast<jobject>(__jni_env, mode2);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_points0, __java_mode2);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawPolygon(const QPointF*,int,QPaintEngine::PolygonDrawMode)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawPolygon(const QPointF*,int,QPaintEngine::PolygonDrawMode)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawPolygon(points0, static_cast<int>(pointCount1), QPaintEngine::PolygonDrawMode(mode2));
        }
    }else{
        QPaintEngine::drawPolygon(points0, static_cast<int>(pointCount1), QPaintEngine::PolygonDrawMode(mode2));
    }
}

void QPaintEngine_oshell::drawRects(const QRect* rects0, int rectCount1)
{
    if(jmethodID method_id = __shell_javaMethod(15)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QPaintEngine_shell::__shell(), 400}) {
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jobjectArray __java_rects0 = qtjambi_array_cast<jobjectArray>(__jni_env, __jni_env.scope(), rects0, rectCount1);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_rects0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawRects(const QRect*,int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawRects(const QRect*,int)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawRects(rects0, static_cast<int>(rectCount1));
        }
    }else{
        QPaintEngine::drawRects(rects0, static_cast<int>(rectCount1));
    }
}

void QPaintEngine_oshell::drawRects(const QRectF* rects0, int rectCount1)
{
    if(jmethodID method_id = __shell_javaMethod(16)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QPaintEngine_shell::__shell(), 400}) {
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jobjectArray __java_rects0 = qtjambi_array_cast<jobjectArray>(__jni_env, __jni_env.scope(), rects0, rectCount1);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_rects0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawRects(const QRectF*,int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawRects(const QRectF*,int)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawRects(rects0, static_cast<int>(rectCount1));
        }
    }else{
        QPaintEngine::drawRects(rects0, static_cast<int>(rectCount1));
    }
}

void QPaintEngine_oshell::drawTextItem(const QPointF& p0, const QTextItem& textItem1)
{
    if(jmethodID method_id = __shell_javaMethod(17)){
        if (JniEnvironmentExceptionHandler __jni_env{400}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_p0 = qtjambi_cast<jobject>(__jni_env, p0);
                    jobject __java_textItem1 = qtjambi_cast<jobject>(__jni_env, &textItem1);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_textItem1);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_p0, __java_textItem1);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawTextItem(QPointF,QTextItem)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawTextItem(QPointF,QTextItem)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawTextItem(p0, textItem1);
        }
    }else{
        QPaintEngine::drawTextItem(p0, textItem1);
    }
}

void QPaintEngine_oshell::drawTiledPixmap(const QRectF& r0, const QPixmap& pixmap1, const QPointF& s2)
{
    if(jmethodID method_id = __shell_javaMethod(18)){
        if (JniEnvironmentExceptionHandler __jni_env{500}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_r0 = qtjambi_cast<jobject>(__jni_env, r0);
                    jobject __java_pixmap1 = qtjambi_cast<jobject>(__jni_env, pixmap1);
                    jobject __java_s2 = qtjambi_cast<jobject>(__jni_env, s2);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_r0, __java_pixmap1, __java_s2);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::drawTiledPixmap(QRectF,QPixmap,QPointF)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::drawTiledPixmap(QRectF,QPixmap,QPointF)");
            } QTJAMBI_TRY_END
        }else{
            QPaintEngine::drawTiledPixmap(r0, pixmap1, s2);
        }
    }else{
        QPaintEngine::drawTiledPixmap(r0, pixmap1, s2);
    }
}

bool QPaintEngine_oshell::end()
{
    if(jmethodID method_id = __shell_javaMethod(19)){
        if (JniEnvironmentExceptionHandler __jni_env{200}) {
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::end()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::end()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

QPaintEngine::Type QPaintEngine_oshell::type() const
{
    if(jmethodID method_id = __shell_javaMethod(20)){
        if (JniEnvironmentExceptionHandler __jni_env{200}) {
            QPaintEngine::Type  __qt_return_value = QPaintEngine::Type(0);
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = qtjambi_cast<QPaintEngine::Type>(__jni_env, __java_return_value);
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::type()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::type()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintEngine::Type(0);
        }
    }else{
        return QPaintEngine::Type(0);
    }
}

void QPaintEngine_oshell::updateState(const QPaintEngineState& state0)
{
    if(jmethodID method_id = __shell_javaMethod(21)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QPaintEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_state0 = qtjambi_cast<jobject>(__jni_env, &state0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_state0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_state0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QPaintEngine_shell::__shell()->warnForMethod("QPaintEngine::updateState(QPaintEngineState)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QPaintEngine::updateState(QPaintEngineState)");
            } QTJAMBI_TRY_END
        }
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
jboolean QPaintEngine_access::__qt_begin_QPaintDevice_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID pdev0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPaintDevice* __qt_pdev0 = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(pdev0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QPaintEngine::begin(QPaintDevice * pdev)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QPaintEngine::begin(QPaintDevice * pdev).";
    } else {
        bool __qt_return_value = begin(__qt_pdev0);
        return jboolean(__qt_return_value);
    }
}

jobject QPaintEngine_access::__qt_coordinateOffset_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPoint __qt_return_value = QPaintEngine::coordinateOffset();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPoint __qt_return_value = coordinateOffset();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QPaintEngine_access::__qt_createPixmap_QSize(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID size0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QtJambiAPI::checkThreadQPixmap(__jni_env, typeid(QPaintEngine));
    QSize __qt_size0 = QtJambiAPI::valueReferenceFromNativeId<QSize>(size0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPixmap __qt_return_value = QPaintEngine::createPixmap(__qt_size0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPixmap __qt_return_value = createPixmap(__qt_size0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QPaintEngine_access::__qt_createPixmapFromImage_QImage_Qt_ImageConversionFlags(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID image0, jint flags1)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QtJambiAPI::checkThreadQPixmap(__jni_env, typeid(QPaintEngine));
    QImage __qt_image0 = QtJambiAPI::valueReferenceFromNativeId<QImage>(image0);
    Qt::ImageConversionFlags __qt_flags1 = qtjambi_cast<Qt::ImageConversionFlags>(__jni_env, flags1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPixmap __qt_return_value = QPaintEngine::createPixmapFromImage(__qt_image0, __qt_flags1);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPixmap __qt_return_value = createPixmapFromImage(__qt_image0, __qt_flags1);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

void QPaintEngine_access::__qt_drawEllipse_cref_QRect(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID r0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QRect& __qt_r0 = QtJambiAPI::valueReferenceFromNativeId<QRect>(r0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawEllipse(__qt_r0);
    } else {
        drawEllipse(__qt_r0);
    }
}

void QPaintEngine_access::__qt_drawEllipse_cref_QRectF(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID r0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QRectF& __qt_r0 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(r0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawEllipse(__qt_r0);
    } else {
        drawEllipse(__qt_r0);
    }
}

void QPaintEngine_access::__qt_drawImage_cref_QRectF_cref_QImage_cref_QRectF_Qt_ImageConversionFlags(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID r0, QtJambiNativeID pm1, QtJambiNativeID sr2, jint flags3)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QRectF& __qt_r0 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(r0);
    const QImage& __qt_pm1 = QtJambiAPI::valueReferenceFromNativeId<QImage>(pm1);
    const QRectF& __qt_sr2 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(sr2);
    Qt::ImageConversionFlags __qt_flags3 = qtjambi_cast<Qt::ImageConversionFlags>(__jni_env, flags3);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawImage(__qt_r0, __qt_pm1, __qt_sr2, __qt_flags3);
    } else {
        drawImage(__qt_r0, __qt_pm1, __qt_sr2, __qt_flags3);
    }
}

void QPaintEngine_access::__qt_drawLines_const_QLine_ptr_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray lines0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    int lineCount1{0};
    const QLine* __qt_lines0 = qtjambi_array_cast<const QLine*>(__jni_env, __qtjambi_scope, lines0, lineCount1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawLines(__qt_lines0, static_cast<int>(lineCount1));
    } else {
        drawLines(__qt_lines0, static_cast<int>(lineCount1));
    }
}

void QPaintEngine_access::__qt_drawLines_const_QLineF_ptr_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray lines0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    int lineCount1{0};
    const QLineF* __qt_lines0 = qtjambi_array_cast<const QLineF*>(__jni_env, __qtjambi_scope, lines0, lineCount1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawLines(__qt_lines0, static_cast<int>(lineCount1));
    } else {
        drawLines(__qt_lines0, static_cast<int>(lineCount1));
    }
}

void QPaintEngine_access::__qt_drawPath_cref_QPainterPath(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID path0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QPainterPath& __qt_path0 = QtJambiAPI::valueReferenceFromNativeId<QPainterPath>(path0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawPath(__qt_path0);
    } else {
        drawPath(__qt_path0);
    }
}

void QPaintEngine_access::__qt_drawPixmap_cref_QRectF_cref_QPixmap_cref_QRectF(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID r0, QtJambiNativeID pm1, QtJambiNativeID sr2)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QRectF& __qt_r0 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(r0);
    const QPixmap& __qt_pm1 = QtJambiAPI::valueReferenceFromNativeId<QPixmap>(pm1);
    QtJambiAPI::checkThreadOnArgumentQPixmap(__jni_env, "pm", typeid(QPixmap));
    const QRectF& __qt_sr2 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(sr2);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QPaintEngine::drawPixmap(const QRectF & r, const QPixmap & pm, const QRectF & sr)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QPaintEngine::drawPixmap(const QRectF & r, const QPixmap & pm, const QRectF & sr).";
    } else {
        drawPixmap(__qt_r0, __qt_pm1, __qt_sr2);
    }
}

void QPaintEngine_access::__qt_drawPoints_const_QPoint_ptr_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray points0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    int pointCount1{0};
    const QPoint* __qt_points0 = qtjambi_array_cast<const QPoint*>(__jni_env, __qtjambi_scope, points0, pointCount1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawPoints(__qt_points0, static_cast<int>(pointCount1));
    } else {
        drawPoints(__qt_points0, static_cast<int>(pointCount1));
    }
}

void QPaintEngine_access::__qt_drawPoints_const_QPointF_ptr_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray points0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    int pointCount1{0};
    const QPointF* __qt_points0 = qtjambi_array_cast<const QPointF*>(__jni_env, __qtjambi_scope, points0, pointCount1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawPoints(__qt_points0, static_cast<int>(pointCount1));
    } else {
        drawPoints(__qt_points0, static_cast<int>(pointCount1));
    }
}

void QPaintEngine_access::__qt_drawPolygon_const_QPoint_ptr_int_QPaintEngine_PolygonDrawMode(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray points0, jint mode2)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    int pointCount1{0};
    const QPoint* __qt_points0 = qtjambi_array_cast<const QPoint*>(__jni_env, __qtjambi_scope, points0, pointCount1);
    QPaintEngine::PolygonDrawMode __qt_mode2 = qtjambi_cast<QPaintEngine::PolygonDrawMode>(__jni_env, mode2);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawPolygon(__qt_points0, static_cast<int>(pointCount1), __qt_mode2);
    } else {
        drawPolygon(__qt_points0, static_cast<int>(pointCount1), __qt_mode2);
    }
}

void QPaintEngine_access::__qt_drawPolygon_const_QPointF_ptr_int_QPaintEngine_PolygonDrawMode(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray points0, jint mode2)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    int pointCount1{0};
    const QPointF* __qt_points0 = qtjambi_array_cast<const QPointF*>(__jni_env, __qtjambi_scope, points0, pointCount1);
    QPaintEngine::PolygonDrawMode __qt_mode2 = qtjambi_cast<QPaintEngine::PolygonDrawMode>(__jni_env, mode2);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawPolygon(__qt_points0, static_cast<int>(pointCount1), __qt_mode2);
    } else {
        drawPolygon(__qt_points0, static_cast<int>(pointCount1), __qt_mode2);
    }
}

void QPaintEngine_access::__qt_drawRects_const_QRect_ptr_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray rects0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    int rectCount1{0};
    const QRect* __qt_rects0 = qtjambi_array_cast<const QRect*>(__jni_env, __qtjambi_scope, rects0, rectCount1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawRects(__qt_rects0, static_cast<int>(rectCount1));
    } else {
        drawRects(__qt_rects0, static_cast<int>(rectCount1));
    }
}

void QPaintEngine_access::__qt_drawRects_const_QRectF_ptr_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobjectArray rects0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    int rectCount1{0};
    const QRectF* __qt_rects0 = qtjambi_array_cast<const QRectF*>(__jni_env, __qtjambi_scope, rects0, rectCount1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawRects(__qt_rects0, static_cast<int>(rectCount1));
    } else {
        drawRects(__qt_rects0, static_cast<int>(rectCount1));
    }
}

void QPaintEngine_access::__qt_drawTextItem_cref_QPointF_cref_QTextItem(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID p0, QtJambiNativeID textItem1)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
    const QTextItem& __qt_textItem1 = QtJambiAPI::objectReferenceFromNativeId<QTextItem>(__jni_env, textItem1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawTextItem(__qt_p0, __qt_textItem1);
    } else {
        drawTextItem(__qt_p0, __qt_textItem1);
    }
}

void QPaintEngine_access::__qt_drawTiledPixmap_cref_QRectF_cref_QPixmap_cref_QPointF(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID r0, QtJambiNativeID pixmap1, QtJambiNativeID s2)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QRectF& __qt_r0 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(r0);
    const QPixmap& __qt_pixmap1 = QtJambiAPI::valueReferenceFromNativeId<QPixmap>(pixmap1);
    QtJambiAPI::checkThreadOnArgumentQPixmap(__jni_env, "pixmap", typeid(QPixmap));
    const QPointF& __qt_s2 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(s2);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine::drawTiledPixmap(__qt_r0, __qt_pixmap1, __qt_s2);
    } else {
        drawTiledPixmap(__qt_r0, __qt_pixmap1, __qt_s2);
    }
}

jboolean QPaintEngine_access::__qt_end(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QPaintEngine::end()." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QPaintEngine::end().";
    } else {
        bool __qt_return_value = end();
        return jboolean(__qt_return_value);
    }
}

jint QPaintEngine_access::__qt_type_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QPaintEngine::type() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QPaintEngine::type() const.";
    } else {
        QPaintEngine::Type __qt_return_value = type();
        return __qt_return_value;
    }
}

void QPaintEngine_access::__qt_updateState_cref_QPaintEngineState(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID state0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QPaintEngineState& __qt_state0 = QtJambiAPI::objectReferenceFromNativeId<QPaintEngineState>(__jni_env, state0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QPaintEngine::updateState(const QPaintEngineState & state)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QPaintEngine::updateState(const QPaintEngineState & state).";
    } else {
        updateState(__qt_state0);
    }
}

// emitting (writeConstructors)
// new QPaintEngine(QPaintEngine::PaintEngineFeatures)
void __qt_construct_QPaintEngine(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPaintEngine(QPaintEngine::PaintEngineFeatures)")
    Q_UNUSED(__java_arguments)
    QPaintEngine *__qt_this = new(__qtjambi_ptr) QPaintEngine_oshell();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// new QPaintEngine(QPaintEngine::PaintEngineFeatures)
void __qt_construct_QPaintEngine_QPaintEngine_PaintEngineFeatures(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPaintEngine(QPaintEngine::PaintEngineFeatures)")
    jobject features0 = __java_arguments[0].l;
    QPaintEngine::PaintEngineFeatures __qt_features0 = qtjambi_cast<QPaintEngine::PaintEngineFeatures>(__jni_env, features0);
    QPaintEngine *__qt_this = new(__qtjambi_ptr) QPaintEngine_oshell(QPaintEngine::PaintEngineFeatures(__qt_features0));
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QPaintEngine::QPaintEngine(QPaintEngine::PaintEngineFeatures)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_initialize_1native__Lio_qt_gui_QPaintEngine_2Lio_qt_gui_QPaintEngine_00024PaintEngineFeatures_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject features0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPaintEngine::QPaintEngine(QPaintEngine::PaintEngineFeatures)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = features0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QPaintEngine_QPaintEngine_PaintEngineFeatures, sizeof(QPaintEngine_shell), typeid(QPaintEngine), 0, true, &deleter_QPaintEngine, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QPaintEngine_shell
void __qt_destruct_QPaintEngine(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QPaintEngine")
    reinterpret_cast<QPaintEngine_shell*>(ptr)->~QPaintEngine_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QPaintEngine::clearDirty(QPaintEngine::DirtyFlags)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_clearDirty_1native_1QPaintEngine_1DirtyFlags__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint df0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::clearDirty(QPaintEngine::DirtyFlags)", __this_nativeId)
        QPaintEngine::DirtyFlags __qt_df0 = qtjambi_cast<QPaintEngine::DirtyFlags>(__jni_env, df0);
        __qt_this->clearDirty(QPaintEngine::DirtyFlags(__qt_df0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::hasFeature(QPaintEngine::PaintEngineFeatures)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_hasFeature_1native_1QPaintEngine_1PaintEngineFeatures_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint feature0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::hasFeature(QPaintEngine::PaintEngineFeatures)const", __this_nativeId)
        QPaintEngine::PaintEngineFeatures __qt_feature0 = qtjambi_cast<QPaintEngine::PaintEngineFeatures>(__jni_env, feature0);
        __java_return_value = __qt_this->hasFeature(QPaintEngine::PaintEngineFeatures(__qt_feature0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::isActive()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_isActive_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::isActive()const", __this_nativeId)
        __java_return_value = __qt_this->isActive();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::isExtended()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_isExtended_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::isExtended()const", __this_nativeId)
        __java_return_value = __qt_this->isExtended();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::paintDevice()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_paintDevice_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::paintDevice()const", __this_nativeId)
        QPaintDevice* __qt_return_value = __qt_this->paintDevice();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::painter()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_painter_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::painter()const", __this_nativeId)
        QPainter* __qt_return_value = __qt_this->painter();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::setActive(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_setActive_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean newState0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::setActive(bool)", __this_nativeId)
        __qt_this->setActive(static_cast<bool>(newState0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::setDirty(QPaintEngine::DirtyFlags)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_setDirty_1native_1QPaintEngine_1DirtyFlags__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint df0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::setDirty(QPaintEngine::DirtyFlags)", __this_nativeId)
        QPaintEngine::DirtyFlags __qt_df0 = qtjambi_cast<QPaintEngine::DirtyFlags>(__jni_env, df0);
        __qt_this->setDirty(QPaintEngine::DirtyFlags(__qt_df0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::setSystemClip(QRegion)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_setSystemClip_1native_1cref_1QRegion__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID baseClip0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::setSystemClip(QRegion)", __this_nativeId)
        const QRegion& __qt_baseClip0 = QtJambiAPI::valueReferenceFromNativeId<QRegion>(baseClip0);
        __qt_this->setSystemClip(__qt_baseClip0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::setSystemRect(QRect)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_setSystemRect_1native_1cref_1QRect__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rect0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::setSystemRect(QRect)", __this_nativeId)
        const QRect& __qt_rect0 = QtJambiAPI::valueReferenceFromNativeId<QRect>(rect0);
        __qt_this->setSystemRect(__qt_rect0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::syncState()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_syncState_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::syncState()", __this_nativeId)
        __qt_this->syncState();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::systemClip()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_systemClip_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::systemClip()const", __this_nativeId)
        QRegion __qt_return_value = __qt_this->systemClip();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::systemRect()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_systemRect_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::systemRect()const", __this_nativeId)
        QRect __qt_return_value = __qt_this->systemRect();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::testDirty(QPaintEngine::DirtyFlags)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_testDirty_1native_1QPaintEngine_1DirtyFlags__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint df0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::testDirty(QPaintEngine::DirtyFlags)", __this_nativeId)
        QPaintEngine::DirtyFlags __qt_df0 = qtjambi_cast<QPaintEngine::DirtyFlags>(__jni_env, df0);
        __java_return_value = __qt_this->testDirty(QPaintEngine::DirtyFlags(__qt_df0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::begin(QPaintDevice*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_00024ConcreteWrapper_begin_1native_1QPaintDevice_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID pdev0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::begin(QPaintDevice*)", __this_nativeId)
        __java_return_value = static_cast<QPaintEngine_access*>(__qt_this)->__qt_begin_QPaintDevice_ptr(__jni_env, __this_nativeId, pdev0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::coordinateOffset()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_coordinateOffset_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::coordinateOffset()const", __this_nativeId)
        __java_return_value = static_cast<const QPaintEngine_access*>(__qt_this)->__qt_coordinateOffset_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::createPixmap(QSize)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_createPixmap_1native_1QSize__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID size0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::createPixmap(QSize)", __this_nativeId)
        __java_return_value = static_cast<QPaintEngine_access*>(__qt_this)->__qt_createPixmap_QSize(__jni_env, __this_nativeId, size0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::createPixmapFromImage(QImage,Qt::ImageConversionFlags)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_createPixmapFromImage_1native_1QImage_1Qt_1ImageConversionFlags__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID image0,
 jint flags1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::createPixmapFromImage(QImage,Qt::ImageConversionFlags)", __this_nativeId)
        __java_return_value = static_cast<QPaintEngine_access*>(__qt_this)->__qt_createPixmapFromImage_QImage_Qt_ImageConversionFlags(__jni_env, __this_nativeId, image0, flags1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::drawEllipse(QRect)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawEllipse_1native_1cref_1QRect__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawEllipse(QRect)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawEllipse_cref_QRect(__jni_env, __this_nativeId, r0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawEllipse(QRectF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawEllipse_1native_1cref_1QRectF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawEllipse(QRectF)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawEllipse_cref_QRectF(__jni_env, __this_nativeId, r0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawImage(QRectF,QImage,QRectF,Qt::ImageConversionFlags)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawImage_1native_1cref_1QRectF_1cref_1QImage_1cref_1QRectF_1Qt_1ImageConversionFlags__JJJJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r0,
 QtJambiNativeID pm1,
 QtJambiNativeID sr2,
 jint flags3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawImage(QRectF,QImage,QRectF,Qt::ImageConversionFlags)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawImage_cref_QRectF_cref_QImage_cref_QRectF_Qt_ImageConversionFlags(__jni_env, __this_nativeId, r0, pm1, sr2, flags3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawLines(const QLine*,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawLines_1native_1const_1QLine_1ptr_1int__J_3Lio_qt_core_QLine_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobjectArray lines0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawLines(const QLine*,int)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawLines_const_QLine_ptr_int(__jni_env, __this_nativeId, lines0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawLines(const QLineF*,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawLines_1native_1const_1QLineF_1ptr_1int__J_3Lio_qt_core_QLineF_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobjectArray lines0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawLines(const QLineF*,int)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawLines_const_QLineF_ptr_int(__jni_env, __this_nativeId, lines0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawPath(QPainterPath)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawPath_1native_1cref_1QPainterPath__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID path0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawPath(QPainterPath)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawPath_cref_QPainterPath(__jni_env, __this_nativeId, path0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawPixmap(QRectF,QPixmap,QRectF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_00024ConcreteWrapper_drawPixmap_1native_1cref_1QRectF_1cref_1QPixmap_1cref_1QRectF__JJJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r0,
 QtJambiNativeID pm1,
 QtJambiNativeID sr2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawPixmap(QRectF,QPixmap,QRectF)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawPixmap_cref_QRectF_cref_QPixmap_cref_QRectF(__jni_env, __this_nativeId, r0, pm1, sr2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawPoints(const QPoint*,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawPoints_1native_1const_1QPoint_1ptr_1int__J_3Lio_qt_core_QPoint_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobjectArray points0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawPoints(const QPoint*,int)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawPoints_const_QPoint_ptr_int(__jni_env, __this_nativeId, points0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawPoints(const QPointF*,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawPoints_1native_1const_1QPointF_1ptr_1int__J_3Lio_qt_core_QPointF_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobjectArray points0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawPoints(const QPointF*,int)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawPoints_const_QPointF_ptr_int(__jni_env, __this_nativeId, points0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawPolygon(const QPoint*,int,QPaintEngine::PolygonDrawMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawPolygon_1native_1const_1QPoint_1ptr_1int_1QPaintEngine_1PolygonDrawMode__J_3Lio_qt_core_QPoint_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobjectArray points0,
 jint mode2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawPolygon(const QPoint*,int,QPaintEngine::PolygonDrawMode)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawPolygon_const_QPoint_ptr_int_QPaintEngine_PolygonDrawMode(__jni_env, __this_nativeId, points0, mode2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawPolygon(const QPointF*,int,QPaintEngine::PolygonDrawMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawPolygon_1native_1const_1QPointF_1ptr_1int_1QPaintEngine_1PolygonDrawMode__J_3Lio_qt_core_QPointF_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobjectArray points0,
 jint mode2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawPolygon(const QPointF*,int,QPaintEngine::PolygonDrawMode)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawPolygon_const_QPointF_ptr_int_QPaintEngine_PolygonDrawMode(__jni_env, __this_nativeId, points0, mode2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawRects(const QRect*,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawRects_1native_1const_1QRect_1ptr_1int__J_3Lio_qt_core_QRect_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobjectArray rects0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawRects(const QRect*,int)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawRects_const_QRect_ptr_int(__jni_env, __this_nativeId, rects0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawRects(const QRectF*,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawRects_1native_1const_1QRectF_1ptr_1int__J_3Lio_qt_core_QRectF_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobjectArray rects0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawRects(const QRectF*,int)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawRects_const_QRectF_ptr_int(__jni_env, __this_nativeId, rects0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawTextItem(QPointF,QTextItem)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawTextItem_1native_1cref_1QPointF_1cref_1QTextItem__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0,
 QtJambiNativeID textItem1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawTextItem(QPointF,QTextItem)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawTextItem_cref_QPointF_cref_QTextItem(__jni_env, __this_nativeId, p0, textItem1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::drawTiledPixmap(QRectF,QPixmap,QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_drawTiledPixmap_1native_1cref_1QRectF_1cref_1QPixmap_1cref_1QPointF__JJJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r0,
 QtJambiNativeID pixmap1,
 QtJambiNativeID s2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::drawTiledPixmap(QRectF,QPixmap,QPointF)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_drawTiledPixmap_cref_QRectF_cref_QPixmap_cref_QPointF(__jni_env, __this_nativeId, r0, pixmap1, s2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPaintEngine::end()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_00024ConcreteWrapper_end_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::end()", __this_nativeId)
        __java_return_value = static_cast<QPaintEngine_access*>(__qt_this)->__qt_end(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::type()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_00024ConcreteWrapper_type_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::type()const", __this_nativeId)
        __java_return_value = static_cast<const QPaintEngine_access*>(__qt_this)->__qt_type_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPaintEngine::updateState(QPaintEngineState)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_00024ConcreteWrapper_updateState_1native_1cref_1QPaintEngineState__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID state0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPaintEngine::updateState(QPaintEngineState)", __this_nativeId)
        static_cast<QPaintEngine_access*>(__qt_this)->__qt_updateState_cref_QPaintEngineState(__jni_env, __this_nativeId, state0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting Field accessors (writeFieldAccessors)
void QPaintEngine_access::setExtended_uint(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jboolean extended0)
{
    Q_UNUSED(__this_nativeId)
    Q_UNUSED(__jni_env)
    this->QPaintEngine::extended = static_cast<uint>(extended0);
}

extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_setExtended_1native_1uint__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean extended0)
{
    QTJAMBI_TRY {
        Q_UNUSED(__this)
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        static_cast<QPaintEngine_access*>(__qt_this)->setExtended_uint(__jni_env, __this_nativeId, extended0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
}

void QPaintEngine_access::setFeatures_cref_QPaintEngine_PaintEngineFeatures(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint features0)
{
    Q_UNUSED(__this_nativeId)
    QPaintEngine::PaintEngineFeatures __qt_features0 = qtjambi_cast<QPaintEngine::PaintEngineFeatures>(__jni_env, features0);
    this->QPaintEngine::gccaps = QPaintEngine::PaintEngineFeatures(__qt_features0);
}

extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_setFeatures_1native_1cref_1QPaintEngine_1PaintEngineFeatures__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint features0)
{
    QTJAMBI_TRY {
        Q_UNUSED(__this)
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        static_cast<QPaintEngine_access*>(__qt_this)->setFeatures_cref_QPaintEngine_PaintEngineFeatures(__jni_env, __this_nativeId, features0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
}

jint QPaintEngine_access::features(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this_nativeId)
    Q_UNUSED(__jni_env)
    const QPaintEngine::PaintEngineFeatures&  __qt_value = this->QPaintEngine::gccaps;
    return __qt_value;
}

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPaintEngine_features_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        Q_UNUSED(__this)
        QPaintEngine *__qt_this = QtJambiAPI::objectFromNativeId<QPaintEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = static_cast<QPaintEngine_access*>(__qt_this)->features(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QPaintEngine(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QPaintEngine>("QPaintEngine", "io/qt/gui/QPaintEngine");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/*  0 */ "begin", "(Lio/qt/gui/QPaintDevice;)Z", FunctionInfo::Abstract),
        FunctionInfo(/*  1 */ "coordinateOffset", "()Lio/qt/core/QPoint;"),
        FunctionInfo(/*  2 */ "createPixmap", "(Lio/qt/core/QSize;)Lio/qt/gui/QPixmap;"),
        FunctionInfo(/*  3 */ "createPixmapFromImage", "(Lio/qt/gui/QImage;Lio/qt/core/Qt$ImageConversionFlags;)Lio/qt/gui/QPixmap;"),
        FunctionInfo(/*  4 */ "drawEllipse", "(Lio/qt/core/QRect;)V"),
        FunctionInfo(/*  5 */ "drawEllipse", "(Lio/qt/core/QRectF;)V"),
        FunctionInfo(/*  6 */ "drawImage", "(Lio/qt/core/QRectF;Lio/qt/gui/QImage;Lio/qt/core/QRectF;Lio/qt/core/Qt$ImageConversionFlags;)V"),
        FunctionInfo(/*  7 */ "drawLines", "([Lio/qt/core/QLine;)V"),
        FunctionInfo(/*  8 */ "drawLines", "([Lio/qt/core/QLineF;)V"),
        FunctionInfo(/*  9 */ "drawPath", "(Lio/qt/gui/QPainterPath;)V"),
        FunctionInfo(/* 10 */ "drawPixmap", "(Lio/qt/core/QRectF;Lio/qt/gui/QPixmap;Lio/qt/core/QRectF;)V", FunctionInfo::Abstract),
        FunctionInfo(/* 11 */ "drawPoints", "([Lio/qt/core/QPoint;)V"),
        FunctionInfo(/* 12 */ "drawPoints", "([Lio/qt/core/QPointF;)V"),
        FunctionInfo(/* 13 */ "drawPolygon", "([Lio/qt/core/QPoint;Lio/qt/gui/QPaintEngine$PolygonDrawMode;)V"),
        FunctionInfo(/* 14 */ "drawPolygon", "([Lio/qt/core/QPointF;Lio/qt/gui/QPaintEngine$PolygonDrawMode;)V"),
        FunctionInfo(/* 15 */ "drawRects", "([Lio/qt/core/QRect;)V"),
        FunctionInfo(/* 16 */ "drawRects", "([Lio/qt/core/QRectF;)V"),
        FunctionInfo(/* 17 */ "drawTextItem", "(Lio/qt/core/QPointF;Lio/qt/gui/QTextItem;)V"),
        FunctionInfo(/* 18 */ "drawTiledPixmap", "(Lio/qt/core/QRectF;Lio/qt/gui/QPixmap;Lio/qt/core/QPointF;)V"),
        FunctionInfo(/* 19 */ "end", "()Z", FunctionInfo::Abstract),
        FunctionInfo(/* 20 */ "type", "()Lio/qt/gui/QPaintEngine$Type;", FunctionInfo::Abstract),
        FunctionInfo(/* 21 */ "updateState", "(Lio/qt/gui/QPaintEngineState;)V", FunctionInfo::Abstract)});
    registerConstructorInfos(typeId, 0, &__qt_destruct_QPaintEngine, {
        ConstructorInfo(&__qt_construct_QPaintEngine, nullptr)
       ,ConstructorInfo(&__qt_construct_QPaintEngine_QPaintEngine_PaintEngineFeatures, "Lio/qt/gui/QPaintEngine$PaintEngineFeatures;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QPaintEngine);
    registerSizeOfShell(typeId, sizeof(QPaintEngine_shell));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QPaintEngine::DirtyFlag>("QPaintEngine::DirtyFlag", "io/qt/gui/QPaintEngine$DirtyFlag", "QPaintEngine::DirtyFlags", "QFlags<QPaintEngine::DirtyFlag>", "io/qt/gui/QPaintEngine$DirtyFlags");
    registerEnumTypeInfo<QPaintEngine::PaintEngineFeature>("QPaintEngine::PaintEngineFeature", "io/qt/gui/QPaintEngine$PaintEngineFeature", "QPaintEngine::PaintEngineFeatures", "QFlags<QPaintEngine::PaintEngineFeature>", "io/qt/gui/QPaintEngine$PaintEngineFeatures");
    registerEnumTypeInfo<QPaintEngine::PolygonDrawMode>("QPaintEngine::PolygonDrawMode", "io/qt/gui/QPaintEngine$PolygonDrawMode");
    registerEnumTypeInfo<QPaintEngine::Type>("QPaintEngine::Type", "io/qt/gui/QPaintEngine$Type");
// END: enums and flags
}
