#include <QtCore/QtGlobal>
#include <QtGui/qcolortransform.h>
#include <QtCore/QVariant>
#include <QtGui/qcolor.h>
#include <QtGui/qrgba64.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiGui/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

// emitting (writeClassCodeInjections)
hash_type qHash(const QColorTransform &value, hash_type seed = 0);

void deleter_QColorTransform(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QColorTransform")
    QColorTransform *_ptr = reinterpret_cast<QColorTransform *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QColorTransform()
void __qt_construct_QColorTransform(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QColorTransform()")
    Q_UNUSED(__java_arguments)
    QColorTransform *__qt_this = new(__qtjambi_ptr) QColorTransform();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QColorTransform::QColorTransform()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QColorTransform_initialize_1native__Lio_qt_gui_QColorTransform_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QColorTransform::QColorTransform()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QColorTransform, sizeof(QColorTransform), typeid(QColorTransform), 0, false, &deleter_QColorTransform, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QColorTransform(QColorTransform)
void __qt_construct_QColorTransform_cref_QColorTransform(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QColorTransform(QColorTransform)")
    jobject colorTransform0 = __java_arguments[0].l;
    const QColorTransform& __qt_colorTransform0 = qtjambi_cast<const QColorTransform&>(__jni_env, colorTransform0);
    QColorTransform *__qt_this = new(__qtjambi_ptr) QColorTransform(__qt_colorTransform0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QColorTransform::QColorTransform(QColorTransform)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QColorTransform_initialize_1native__Lio_qt_gui_QColorTransform_2Lio_qt_gui_QColorTransform_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject colorTransform0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QColorTransform::QColorTransform(QColorTransform)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = colorTransform0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QColorTransform_cref_QColorTransform, sizeof(QColorTransform), typeid(QColorTransform), 0, false, &deleter_QColorTransform, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QColorTransform
void __qt_destruct_QColorTransform(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QColorTransform")
    reinterpret_cast<QColorTransform*>(ptr)->~QColorTransform();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QColorTransform::isIdentity()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QColorTransform_isIdentity_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QColorTransform *__qt_this = QtJambiAPI::objectFromNativeId<QColorTransform>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColorTransform::isIdentity()const", __this_nativeId)
        __java_return_value = __qt_this->isIdentity();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QColorTransform::map(QColor)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QColorTransform_map_1native_1cref_1QColor_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID color0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QColorTransform *__qt_this = QtJambiAPI::objectFromNativeId<QColorTransform>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColorTransform::map(QColor)const", __this_nativeId)
        const QColor& __qt_color0 = QtJambiAPI::valueReferenceFromNativeId<QColor>(color0);
        QColor __qt_return_value = __qt_this->map(__qt_color0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QColorTransform::map(QRgba64)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QColorTransform_map_1native_1QRgba64_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rgba640)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QColorTransform *__qt_this = QtJambiAPI::objectFromNativeId<QColorTransform>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColorTransform::map(QRgba64)const", __this_nativeId)
        QRgba64 __qt_rgba640 = QtJambiAPI::valueReferenceFromNativeId<QRgba64>(rgba640);
        QRgba64 __qt_return_value = __qt_this->map(__qt_rgba640);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QColorTransform::map(QRgb)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QColorTransform_map_1native_1unsigned_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint argb0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QColorTransform *__qt_this = QtJambiAPI::objectFromNativeId<QColorTransform>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColorTransform::map(QRgb)const", __this_nativeId)
        unsigned int __qt_return_value = __qt_this->map(static_cast<unsigned int>(argb0));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QColorTransform::operator=(QColorTransform)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QColorTransform_assign_1native_1cref_1QColorTransform__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QColorTransform *__qt_this = QtJambiAPI::objectFromNativeId<QColorTransform>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColorTransform::operator=(QColorTransform)", __this_nativeId)
        const QColorTransform& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QColorTransform>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QColorTransform::operator==(QColorTransform,QColorTransform)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QColorTransform_equals_1native_1cref_1QColorTransform__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID ct21)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QColorTransform *__qt_this = QtJambiAPI::objectFromNativeId<QColorTransform>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColorTransform::operator==(QColorTransform,QColorTransform)", __this_nativeId)
        const QColorTransform& __qt_ct21 = QtJambiAPI::valueReferenceFromNativeId<QColorTransform>(ct21);
        __java_return_value = (*__qt_this) == __qt_ct21;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QColorTransform::swap(QColorTransform&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QColorTransform_swap_1native_1ref_1QColorTransform__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QColorTransform *__qt_this = QtJambiAPI::objectFromNativeId<QColorTransform>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColorTransform::swap(QColorTransform&)", __this_nativeId)
        QColorTransform& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QColorTransform>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QColorTransform_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QColorTransform *__qt_this = QtJambiAPI::objectFromNativeId<QColorTransform>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QColorTransform_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QColorTransform *__qt_this = QtJambiAPI::objectFromNativeId<QColorTransform>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QColorTransform(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QColorTransform>("QColorTransform", "io/qt/gui/QColorTransform");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QColorTransform, {
        ConstructorInfo(&__qt_construct_QColorTransform, nullptr)
       ,ConstructorInfo(&__qt_construct_QColorTransform_cref_QColorTransform, "Lio/qt/gui/QColorTransform;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QColorTransform);
    registerMetaType<QColorTransform>("QColorTransform");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
