#include "QAccessibleTextInterface_shell.h"
#include <QtJambi/Cast>

void deleter_QAccessibleTextInterface(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QAccessibleTextInterface")
    QAccessibleTextInterface *_ptr = reinterpret_cast<QAccessibleTextInterface *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QAccessibleTextInterface_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QAccessibleTextInterface_shell) ); }

jmethodID QAccessibleTextInterface_oshell::__shell_javaMethod(int pos) const { return QAccessibleTextInterface_shell::__shell()->javaMethod(typeid(QAccessibleTextInterface), pos); }

// emitting (writeShellDestructor)
QAccessibleTextInterface_shell::~QAccessibleTextInterface_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QAccessibleTextInterface::~QAccessibleTextInterface()", this)
    QAccessibleTextInterface_shell::__shell()->destructed(typeid(QAccessibleTextInterface));
}

// emitting (writeShellConstructor)
QAccessibleTextInterface_shell::QAccessibleTextInterface_shell()
    : QAccessibleTextInterface()
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QAccessibleTextInterface::QAccessibleTextInterface_shell()", this)
    QAccessibleTextInterface_shell::__shell()->constructed(typeid(QAccessibleTextInterface));
}

void QAccessibleTextInterface_oshell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QAccessibleTextInterface_oshell*>(ptr)->QAccessibleTextInterface_oshell::__shell()->tryDeleteShell(typeid(QAccessibleTextInterface));
}

// emitting Virtual overrides (virtualFunctions)
void QAccessibleTextInterface_oshell::addSelection(int startOffset0, int endOffset1)
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        if (JniEnvironmentExceptionHandler __jni_env{400}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTextInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    __jni_env->CallVoidMethod(__java_this, method_id, startOffset0, endOffset1);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::addSelection(int,int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::addSelection(int,int)");
            } QTJAMBI_TRY_END
        }
    }
}

QString QAccessibleTextInterface_oshell::attributes(int offset0, int* startOffset1, int* endOffset2) const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QAccessibleTextInterface_shell::__shell(), 500}) {
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jintArray __java_startOffset1 = qtjambi_array_cast<jintArray>(__jni_env, __jni_env.scope(), startOffset1, startOffset1 ? 1 : 0);
                    jintArray __java_endOffset2 = qtjambi_array_cast<jintArray>(__jni_env, __jni_env.scope(), endOffset2, endOffset2 ? 1 : 0);
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, offset0, __java_startOffset1, __java_endOffset2));
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::attributes(int,int*,int*)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::attributes(int,int*,int*)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QString();
        }
    }else{
        return QString();
    }
}

int QAccessibleTextInterface_oshell::characterCount() const
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        if (JniEnvironmentExceptionHandler __jni_env{200}) {
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTextInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::characterCount()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::characterCount()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}

QRect QAccessibleTextInterface_oshell::characterRect(int offset0) const
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QRect  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTextInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, offset0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = qtjambi_cast<QRect>(__jni_env, __java_return_value);
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::characterRect(int)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::characterRect(int)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QRect();
        }
    }else{
        return QRect();
    }
}

int QAccessibleTextInterface_oshell::cursorPosition() const
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        if (JniEnvironmentExceptionHandler __jni_env{200}) {
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTextInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::cursorPosition()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::cursorPosition()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}

int QAccessibleTextInterface_oshell::offsetAtPoint(const QPoint& point0) const
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTextInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_point0 = qtjambi_cast<jobject>(__jni_env, point0);
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_point0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::offsetAtPoint(QPoint)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::offsetAtPoint(QPoint)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}

void QAccessibleTextInterface_oshell::removeSelection(int selectionIndex0)
{
    if(jmethodID method_id = __shell_javaMethod(6)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTextInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    __jni_env->CallVoidMethod(__java_this, method_id, selectionIndex0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::removeSelection(int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::removeSelection(int)");
            } QTJAMBI_TRY_END
        }
    }
}

void QAccessibleTextInterface_oshell::scrollToSubstring(int startIndex0, int endIndex1)
{
    if(jmethodID method_id = __shell_javaMethod(7)){
        if (JniEnvironmentExceptionHandler __jni_env{400}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTextInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    __jni_env->CallVoidMethod(__java_this, method_id, startIndex0, endIndex1);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::scrollToSubstring(int,int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::scrollToSubstring(int,int)");
            } QTJAMBI_TRY_END
        }
    }
}

void QAccessibleTextInterface_oshell::selection(int selectionIndex0, int* startOffset1, int* endOffset2) const
{
    if(jmethodID method_id = __shell_javaMethod(8)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QAccessibleTextInterface_shell::__shell(), 500}) {
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jintArray __java_startOffset1 = qtjambi_array_cast<jintArray>(__jni_env, __jni_env.scope(), startOffset1, startOffset1 ? 1 : 0);
                    jintArray __java_endOffset2 = qtjambi_array_cast<jintArray>(__jni_env, __jni_env.scope(), endOffset2, endOffset2 ? 1 : 0);
                    __jni_env->CallVoidMethod(__java_this, method_id, selectionIndex0, __java_startOffset1, __java_endOffset2);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::selection(int,int*,int*)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::selection(int,int*,int*)const");
            } QTJAMBI_TRY_END
        }
    }
}

int QAccessibleTextInterface_oshell::selectionCount() const
{
    if(jmethodID method_id = __shell_javaMethod(9)){
        if (JniEnvironmentExceptionHandler __jni_env{200}) {
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTextInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::selectionCount()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::selectionCount()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}

void QAccessibleTextInterface_oshell::setCursorPosition(int position0)
{
    if(jmethodID method_id = __shell_javaMethod(10)){
        if (JniEnvironmentExceptionHandler __jni_env{300}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTextInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    __jni_env->CallVoidMethod(__java_this, method_id, position0);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::setCursorPosition(int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::setCursorPosition(int)");
            } QTJAMBI_TRY_END
        }
    }
}

void QAccessibleTextInterface_oshell::setSelection(int selectionIndex0, int startOffset1, int endOffset2)
{
    if(jmethodID method_id = __shell_javaMethod(11)){
        if (JniEnvironmentExceptionHandler __jni_env{500}) {
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTextInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    __jni_env->CallVoidMethod(__java_this, method_id, selectionIndex0, startOffset1, endOffset2);
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::setSelection(int,int,int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::setSelection(int,int,int)");
            } QTJAMBI_TRY_END
        }
    }
}

QString QAccessibleTextInterface_oshell::text(int startOffset0, int endOffset1) const
{
    if(jmethodID method_id = __shell_javaMethod(12)){
        if (JniEnvironmentExceptionHandler __jni_env{400}) {
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTextInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, startOffset0, endOffset1));
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::text(int,int)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::text(int,int)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QString();
        }
    }else{
        return QString();
    }
}

QString QAccessibleTextInterface_oshell::textAfterOffset(int offset0, QAccessible::TextBoundaryType boundaryType1, int* startOffset2, int* endOffset3) const
{
    if(jmethodID method_id = __shell_javaMethod(13)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QAccessibleTextInterface_shell::__shell(), 600}) {
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jobject __java_boundaryType1 = qtjambi_cast<jobject>(__jni_env, boundaryType1);
                    jintArray __java_startOffset2 = qtjambi_array_cast<jintArray>(__jni_env, __jni_env.scope(), startOffset2, startOffset2 ? 1 : 0);
                    jintArray __java_endOffset3 = qtjambi_array_cast<jintArray>(__jni_env, __jni_env.scope(), endOffset3, endOffset3 ? 1 : 0);
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, offset0, __java_boundaryType1, __java_startOffset2, __java_endOffset3));
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::textAfterOffset(int,QAccessible::TextBoundaryType,int*,int*)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::textAfterOffset(int,QAccessible::TextBoundaryType,int*,int*)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleTextInterface::textAfterOffset(static_cast<int>(offset0), QAccessible::TextBoundaryType(boundaryType1), startOffset2, endOffset3);
        }
    }else{
        return QAccessibleTextInterface::textAfterOffset(static_cast<int>(offset0), QAccessible::TextBoundaryType(boundaryType1), startOffset2, endOffset3);
    }
}

QString QAccessibleTextInterface_oshell::textAtOffset(int offset0, QAccessible::TextBoundaryType boundaryType1, int* startOffset2, int* endOffset3) const
{
    if(jmethodID method_id = __shell_javaMethod(14)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QAccessibleTextInterface_shell::__shell(), 600}) {
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jobject __java_boundaryType1 = qtjambi_cast<jobject>(__jni_env, boundaryType1);
                    jintArray __java_startOffset2 = qtjambi_array_cast<jintArray>(__jni_env, __jni_env.scope(), startOffset2, startOffset2 ? 1 : 0);
                    jintArray __java_endOffset3 = qtjambi_array_cast<jintArray>(__jni_env, __jni_env.scope(), endOffset3, endOffset3 ? 1 : 0);
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, offset0, __java_boundaryType1, __java_startOffset2, __java_endOffset3));
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::textAtOffset(int,QAccessible::TextBoundaryType,int*,int*)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::textAtOffset(int,QAccessible::TextBoundaryType,int*,int*)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleTextInterface::textAtOffset(static_cast<int>(offset0), QAccessible::TextBoundaryType(boundaryType1), startOffset2, endOffset3);
        }
    }else{
        return QAccessibleTextInterface::textAtOffset(static_cast<int>(offset0), QAccessible::TextBoundaryType(boundaryType1), startOffset2, endOffset3);
    }
}

QString QAccessibleTextInterface_oshell::textBeforeOffset(int offset0, QAccessible::TextBoundaryType boundaryType1, int* startOffset2, int* endOffset3) const
{
    if(jmethodID method_id = __shell_javaMethod(15)){
        if (JniEnvironmentScopeExceptionHandler __jni_env{QAccessibleTextInterface_shell::__shell(), 600}) {
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = __jni_env.getJavaObjectLocalRef()){
                    jobject __java_boundaryType1 = qtjambi_cast<jobject>(__jni_env, boundaryType1);
                    jintArray __java_startOffset2 = qtjambi_array_cast<jintArray>(__jni_env, __jni_env.scope(), startOffset2, startOffset2 ? 1 : 0);
                    jintArray __java_endOffset3 = qtjambi_array_cast<jintArray>(__jni_env, __jni_env.scope(), endOffset3, endOffset3 ? 1 : 0);
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, offset0, __java_boundaryType1, __java_startOffset2, __java_endOffset3));
                    __jni_env.checkException( QTJAMBI_STACKTRACEINFO_NOENV );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QAccessibleTextInterface_shell::__shell()->warnForMethod("QAccessibleTextInterface::textBeforeOffset(int,QAccessible::TextBoundaryType,int*,int*)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __jni_env.handleException(exn, "QAccessibleTextInterface::textBeforeOffset(int,QAccessible::TextBoundaryType,int*,int*)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleTextInterface::textBeforeOffset(static_cast<int>(offset0), QAccessible::TextBoundaryType(boundaryType1), startOffset2, endOffset3);
        }
    }else{
        return QAccessibleTextInterface::textBeforeOffset(static_cast<int>(offset0), QAccessible::TextBoundaryType(boundaryType1), startOffset2, endOffset3);
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
void QAccessibleTextInterface_access::__qt_addSelection_int_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint startOffset0, jint endOffset1)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::addSelection(int startOffset, int endOffset)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::addSelection(int startOffset, int endOffset).";
    } else {
        addSelection(static_cast<int>(startOffset0), static_cast<int>(endOffset1));
    }
}

jstring QAccessibleTextInterface_access::__qt_attributes_int_int_ptr_int_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint offset0, jintArray startOffset1, jintArray endOffset2) const
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    jsize __qt_startOffset1_size = 1;
    int* __qt_startOffset1 = qtjambi_array_cast<int*>(__jni_env, __qtjambi_scope, jintArray(startOffset1), __qt_startOffset1_size);
    jsize __qt_endOffset2_size = 1;
    int* __qt_endOffset2 = qtjambi_array_cast<int*>(__jni_env, __qtjambi_scope, jintArray(endOffset2), __qt_endOffset2_size);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::attributes(int offset, int * startOffset, int * endOffset) const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::attributes(int offset, int * startOffset, int * endOffset) const.";
    } else {
        QString __qt_return_value = attributes(static_cast<int>(offset0), __qt_startOffset1, __qt_endOffset2);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jint QAccessibleTextInterface_access::__qt_characterCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::characterCount() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::characterCount() const.";
    } else {
        int __qt_return_value = characterCount();
        return jint(__qt_return_value);
    }
}

jobject QAccessibleTextInterface_access::__qt_characterRect_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint offset0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::characterRect(int offset) const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::characterRect(int offset) const.";
    } else {
        QRect __qt_return_value = characterRect(static_cast<int>(offset0));
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QAccessibleTextInterface_access::__qt_cursorPosition_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::cursorPosition() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::cursorPosition() const.";
    } else {
        int __qt_return_value = cursorPosition();
        return jint(__qt_return_value);
    }
}

jint QAccessibleTextInterface_access::__qt_offsetAtPoint_cref_QPoint_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID point0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QPoint& __qt_point0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(point0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::offsetAtPoint(const QPoint & point) const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::offsetAtPoint(const QPoint & point) const.";
    } else {
        int __qt_return_value = offsetAtPoint(__qt_point0);
        return jint(__qt_return_value);
    }
}

void QAccessibleTextInterface_access::__qt_removeSelection_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint selectionIndex0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::removeSelection(int selectionIndex)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::removeSelection(int selectionIndex).";
    } else {
        removeSelection(static_cast<int>(selectionIndex0));
    }
}

void QAccessibleTextInterface_access::__qt_scrollToSubstring_int_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint startIndex0, jint endIndex1)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::scrollToSubstring(int startIndex, int endIndex)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::scrollToSubstring(int startIndex, int endIndex).";
    } else {
        scrollToSubstring(static_cast<int>(startIndex0), static_cast<int>(endIndex1));
    }
}

void QAccessibleTextInterface_access::__qt_selection_int_int_ptr_int_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint selectionIndex0, jintArray startOffset1, jintArray endOffset2) const
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    jsize __qt_startOffset1_size = 1;
    int* __qt_startOffset1 = qtjambi_array_cast<int*>(__jni_env, __qtjambi_scope, jintArray(startOffset1), __qt_startOffset1_size);
    jsize __qt_endOffset2_size = 1;
    int* __qt_endOffset2 = qtjambi_array_cast<int*>(__jni_env, __qtjambi_scope, jintArray(endOffset2), __qt_endOffset2_size);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::selection(int selectionIndex, int * startOffset, int * endOffset) const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::selection(int selectionIndex, int * startOffset, int * endOffset) const.";
    } else {
        selection(static_cast<int>(selectionIndex0), __qt_startOffset1, __qt_endOffset2);
    }
}

jint QAccessibleTextInterface_access::__qt_selectionCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::selectionCount() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::selectionCount() const.";
    } else {
        int __qt_return_value = selectionCount();
        return jint(__qt_return_value);
    }
}

void QAccessibleTextInterface_access::__qt_setCursorPosition_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint position0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::setCursorPosition(int position)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::setCursorPosition(int position).";
    } else {
        setCursorPosition(static_cast<int>(position0));
    }
}

void QAccessibleTextInterface_access::__qt_setSelection_int_int_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint selectionIndex0, jint startOffset1, jint endOffset2)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::setSelection(int selectionIndex, int startOffset, int endOffset)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::setSelection(int selectionIndex, int startOffset, int endOffset).";
    } else {
        setSelection(static_cast<int>(selectionIndex0), static_cast<int>(startOffset1), static_cast<int>(endOffset2));
    }
}

jstring QAccessibleTextInterface_access::__qt_text_int_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint startOffset0, jint endOffset1) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTextInterface::text(int startOffset, int endOffset) const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTextInterface::text(int startOffset, int endOffset) const.";
    } else {
        QString __qt_return_value = text(static_cast<int>(startOffset0), static_cast<int>(endOffset1));
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jstring QAccessibleTextInterface_access::__qt_textAfterOffset_int_QAccessible_TextBoundaryType_int_ptr_int_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint offset0, jint boundaryType1, jintArray startOffset2, jintArray endOffset3) const
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAccessible::TextBoundaryType __qt_boundaryType1 = qtjambi_cast<QAccessible::TextBoundaryType>(__jni_env, boundaryType1);
    jsize __qt_startOffset2_size = 1;
    int* __qt_startOffset2 = qtjambi_array_cast<int*>(__jni_env, __qtjambi_scope, jintArray(startOffset2), __qt_startOffset2_size);
    jsize __qt_endOffset3_size = 1;
    int* __qt_endOffset3 = qtjambi_array_cast<int*>(__jni_env, __qtjambi_scope, jintArray(endOffset3), __qt_endOffset3_size);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QAccessibleTextInterface::textAfterOffset(static_cast<int>(offset0), __qt_boundaryType1, __qt_startOffset2, __qt_endOffset3);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = textAfterOffset(static_cast<int>(offset0), __qt_boundaryType1, __qt_startOffset2, __qt_endOffset3);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jstring QAccessibleTextInterface_access::__qt_textAtOffset_int_QAccessible_TextBoundaryType_int_ptr_int_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint offset0, jint boundaryType1, jintArray startOffset2, jintArray endOffset3) const
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAccessible::TextBoundaryType __qt_boundaryType1 = qtjambi_cast<QAccessible::TextBoundaryType>(__jni_env, boundaryType1);
    jsize __qt_startOffset2_size = 1;
    int* __qt_startOffset2 = qtjambi_array_cast<int*>(__jni_env, __qtjambi_scope, jintArray(startOffset2), __qt_startOffset2_size);
    jsize __qt_endOffset3_size = 1;
    int* __qt_endOffset3 = qtjambi_array_cast<int*>(__jni_env, __qtjambi_scope, jintArray(endOffset3), __qt_endOffset3_size);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QAccessibleTextInterface::textAtOffset(static_cast<int>(offset0), __qt_boundaryType1, __qt_startOffset2, __qt_endOffset3);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = textAtOffset(static_cast<int>(offset0), __qt_boundaryType1, __qt_startOffset2, __qt_endOffset3);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jstring QAccessibleTextInterface_access::__qt_textBeforeOffset_int_QAccessible_TextBoundaryType_int_ptr_int_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint offset0, jint boundaryType1, jintArray startOffset2, jintArray endOffset3) const
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAccessible::TextBoundaryType __qt_boundaryType1 = qtjambi_cast<QAccessible::TextBoundaryType>(__jni_env, boundaryType1);
    jsize __qt_startOffset2_size = 1;
    int* __qt_startOffset2 = qtjambi_array_cast<int*>(__jni_env, __qtjambi_scope, jintArray(startOffset2), __qt_startOffset2_size);
    jsize __qt_endOffset3_size = 1;
    int* __qt_endOffset3 = qtjambi_array_cast<int*>(__jni_env, __qtjambi_scope, jintArray(endOffset3), __qt_endOffset3_size);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QAccessibleTextInterface::textBeforeOffset(static_cast<int>(offset0), __qt_boundaryType1, __qt_startOffset2, __qt_endOffset3);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = textBeforeOffset(static_cast<int>(offset0), __qt_boundaryType1, __qt_startOffset2, __qt_endOffset3);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

// emitting (writeConstructors)
// new QAccessibleTextInterface()
void __qt_construct_QAccessibleTextInterface(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAccessibleTextInterface()")
    Q_UNUSED(__java_arguments)
    QAccessibleTextInterface *__qt_this = new(__qtjambi_ptr) QAccessibleTextInterface_oshell();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QAccessibleTextInterface::QAccessibleTextInterface()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_initialize_1native__Lio_qt_gui_QAccessibleTextInterface_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleTextInterface::QAccessibleTextInterface()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAccessibleTextInterface, sizeof(QAccessibleTextInterface_shell), typeid(QAccessibleTextInterface), 0, true, &deleter_QAccessibleTextInterface, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QAccessibleTextInterface_shell
void __qt_destruct_QAccessibleTextInterface(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QAccessibleTextInterface")
    reinterpret_cast<QAccessibleTextInterface_shell*>(ptr)->~QAccessibleTextInterface_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QAccessibleTextInterface::addSelection(int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_addSelection_1native_1int_1int__JII)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint startOffset0,
 jint endOffset1)
{
    QTJAMBI_TRY {
        QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::addSelection(int,int)", __this_nativeId)
        static_cast<QAccessibleTextInterface_access*>(__qt_this)->__qt_addSelection_int_int(__jni_env, __this_nativeId, startOffset0, endOffset1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAccessibleTextInterface::attributes(int,int*,int*)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_attributes_1native_1int_1int_1ptr_1int_1ptr_1constfct__JI_3I_3I)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint offset0,
 jintArray startOffset1,
 jintArray endOffset2)
{
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::attributes(int,int*,int*)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTextInterface_access*>(__qt_this)->__qt_attributes_int_int_ptr_int_ptr_constfct(__jni_env, __this_nativeId, offset0, startOffset1, endOffset2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTextInterface::characterCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_characterCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::characterCount()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTextInterface_access*>(__qt_this)->__qt_characterCount_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTextInterface::characterRect(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_characterRect_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint offset0)
{
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::characterRect(int)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTextInterface_access*>(__qt_this)->__qt_characterRect_int_constfct(__jni_env, __this_nativeId, offset0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTextInterface::cursorPosition()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_cursorPosition_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::cursorPosition()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTextInterface_access*>(__qt_this)->__qt_cursorPosition_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTextInterface::offsetAtPoint(QPoint)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_offsetAtPoint_1native_1cref_1QPoint_1constfct__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID point0)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::offsetAtPoint(QPoint)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTextInterface_access*>(__qt_this)->__qt_offsetAtPoint_cref_QPoint_constfct(__jni_env, __this_nativeId, point0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTextInterface::removeSelection(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_removeSelection_1native_1int__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint selectionIndex0)
{
    QTJAMBI_TRY {
        QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::removeSelection(int)", __this_nativeId)
        static_cast<QAccessibleTextInterface_access*>(__qt_this)->__qt_removeSelection_int(__jni_env, __this_nativeId, selectionIndex0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAccessibleTextInterface::scrollToSubstring(int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_scrollToSubstring_1native_1int_1int__JII)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint startIndex0,
 jint endIndex1)
{
    QTJAMBI_TRY {
        QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::scrollToSubstring(int,int)", __this_nativeId)
        static_cast<QAccessibleTextInterface_access*>(__qt_this)->__qt_scrollToSubstring_int_int(__jni_env, __this_nativeId, startIndex0, endIndex1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAccessibleTextInterface::selection(int,int*,int*)const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_selection_1native_1int_1int_1ptr_1int_1ptr_1constfct__JI_3I_3I)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint selectionIndex0,
 jintArray startOffset1,
 jintArray endOffset2)
{
    QTJAMBI_TRY {
        const QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::selection(int,int*,int*)const", __this_nativeId)
        static_cast<const QAccessibleTextInterface_access*>(__qt_this)->__qt_selection_int_int_ptr_int_ptr_constfct(__jni_env, __this_nativeId, selectionIndex0, startOffset1, endOffset2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAccessibleTextInterface::selectionCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_selectionCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::selectionCount()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTextInterface_access*>(__qt_this)->__qt_selectionCount_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTextInterface::setCursorPosition(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_setCursorPosition_1native_1int__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint position0)
{
    QTJAMBI_TRY {
        QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::setCursorPosition(int)", __this_nativeId)
        static_cast<QAccessibleTextInterface_access*>(__qt_this)->__qt_setCursorPosition_int(__jni_env, __this_nativeId, position0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAccessibleTextInterface::setSelection(int,int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_setSelection_1native_1int_1int_1int__JIII)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint selectionIndex0,
 jint startOffset1,
 jint endOffset2)
{
    QTJAMBI_TRY {
        QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::setSelection(int,int,int)", __this_nativeId)
        static_cast<QAccessibleTextInterface_access*>(__qt_this)->__qt_setSelection_int_int_int(__jni_env, __this_nativeId, selectionIndex0, startOffset1, endOffset2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAccessibleTextInterface::text(int,int)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_00024ConcreteWrapper_text_1native_1int_1int_1constfct__JII)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint startOffset0,
 jint endOffset1)
{
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::text(int,int)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTextInterface_access*>(__qt_this)->__qt_text_int_int_constfct(__jni_env, __this_nativeId, startOffset0, endOffset1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTextInterface::textAfterOffset(int,QAccessible::TextBoundaryType,int*,int*)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_textAfterOffset_1native_1int_1QAccessible_1TextBoundaryType_1int_1ptr_1int_1ptr_1constfct__JII_3I_3I)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint offset0,
 jint boundaryType1,
 jintArray startOffset2,
 jintArray endOffset3)
{
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::textAfterOffset(int,QAccessible::TextBoundaryType,int*,int*)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTextInterface_access*>(__qt_this)->__qt_textAfterOffset_int_QAccessible_TextBoundaryType_int_ptr_int_ptr_constfct(__jni_env, __this_nativeId, offset0, boundaryType1, startOffset2, endOffset3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTextInterface::textAtOffset(int,QAccessible::TextBoundaryType,int*,int*)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_textAtOffset_1native_1int_1QAccessible_1TextBoundaryType_1int_1ptr_1int_1ptr_1constfct__JII_3I_3I)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint offset0,
 jint boundaryType1,
 jintArray startOffset2,
 jintArray endOffset3)
{
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::textAtOffset(int,QAccessible::TextBoundaryType,int*,int*)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTextInterface_access*>(__qt_this)->__qt_textAtOffset_int_QAccessible_TextBoundaryType_int_ptr_int_ptr_constfct(__jni_env, __this_nativeId, offset0, boundaryType1, startOffset2, endOffset3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTextInterface::textBeforeOffset(int,QAccessible::TextBoundaryType,int*,int*)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTextInterface_00024Impl_textBeforeOffset_1native_1int_1QAccessible_1TextBoundaryType_1int_1ptr_1int_1ptr_1constfct__JII_3I_3I)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint offset0,
 jint boundaryType1,
 jintArray startOffset2,
 jintArray endOffset3)
{
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTextInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTextInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTextInterface::textBeforeOffset(int,QAccessible::TextBoundaryType,int*,int*)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTextInterface_access*>(__qt_this)->__qt_textBeforeOffset_int_QAccessible_TextBoundaryType_int_ptr_int_ptr_constfct(__jni_env, __this_nativeId, offset0, boundaryType1, startOffset2, endOffset3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QAccessibleTextInterface(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerInterfaceTypeInfo<QAccessibleTextInterface>("QAccessibleTextInterface", "io/qt/gui/QAccessibleTextInterface");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/*  0 */ "addSelection", "(II)V", FunctionInfo::Abstract),
        FunctionInfo(/*  1 */ "attributes", "(I[I[I)Ljava/lang/String;", FunctionInfo::Abstract),
        FunctionInfo(/*  2 */ "characterCount", "()I", FunctionInfo::Abstract),
        FunctionInfo(/*  3 */ "characterRect", "(I)Lio/qt/core/QRect;", FunctionInfo::Abstract),
        FunctionInfo(/*  4 */ "cursorPosition", "()I", FunctionInfo::Abstract),
        FunctionInfo(/*  5 */ "offsetAtPoint", "(Lio/qt/core/QPoint;)I", FunctionInfo::Abstract),
        FunctionInfo(/*  6 */ "removeSelection", "(I)V", FunctionInfo::Abstract),
        FunctionInfo(/*  7 */ "scrollToSubstring", "(II)V", FunctionInfo::Abstract),
        FunctionInfo(/*  8 */ "selection", "(I[I[I)V", FunctionInfo::Abstract),
        FunctionInfo(/*  9 */ "selectionCount", "()I", FunctionInfo::Abstract),
        FunctionInfo(/* 10 */ "setCursorPosition", "(I)V", FunctionInfo::Abstract),
        FunctionInfo(/* 11 */ "setSelection", "(III)V", FunctionInfo::Abstract),
        FunctionInfo(/* 12 */ "text", "(II)Ljava/lang/String;", FunctionInfo::Abstract),
        FunctionInfo(/* 13 */ "textAfterOffset", "(ILio/qt/gui/QAccessible$TextBoundaryType;[I[I)Ljava/lang/String;"),
        FunctionInfo(/* 14 */ "textAtOffset", "(ILio/qt/gui/QAccessible$TextBoundaryType;[I[I)Ljava/lang/String;"),
        FunctionInfo(/* 15 */ "textBeforeOffset", "(ILio/qt/gui/QAccessible$TextBoundaryType;[I[I)Ljava/lang/String;")});
    registerConstructorInfos(typeId, 0, &__qt_destruct_QAccessibleTextInterface, {
        ConstructorInfo(&__qt_construct_QAccessibleTextInterface, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QAccessibleTextInterface);
    registerSizeOfShell(typeId, sizeof(QAccessibleTextInterface_shell));
// END: type registration

// BEGIN: polymorphic ids
    registerPolymorphyHandler(typeid(QObject), typeId, [](void *ptr, qintptr& offset) -> bool {
            QObject *object = reinterpret_cast<QObject *>(ptr);
            Q_ASSERT(object);
            bool _result = false;
            QTJAMBI_TRY_ANY {
                if(QAccessibleTextInterface* _object = dynamic_cast<QAccessibleTextInterface*>(object)){
                    offset = qintptr(object)-qintptr(_object);
                    _result = true;
                }
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
    registerPolymorphyHandler(typeId, typeid(QObject), [](void *ptr, qintptr& offset) -> bool {
            QAccessibleTextInterface *object = reinterpret_cast<QAccessibleTextInterface *>(ptr);
            Q_ASSERT(object);
            bool _result = false;
            QTJAMBI_TRY_ANY {
                if(QObject* _object = dynamic_cast<QObject*>(object)){
                    offset = qintptr(object)-qintptr(_object);
                    _result = true;
                }
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
    registerOwnerFunction(typeId, [](const void *ptr)->const QObject*{
        const QAccessibleTextInterface *object = reinterpret_cast<const QAccessibleTextInterface *>(ptr);
        const QObject* _result = nullptr;
        QTJAMBI_TRY_ANY {
            _result = dynamic_cast<const QObject*>(object);
        } QTJAMBI_CATCH_ANY{
        } QTJAMBI_TRY_END
        return _result;
    });
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
