#ifndef GLDEBUGPROC_SHELL_H
#define GLDEBUGPROC_SHELL_H

#include <QtCore/QtGlobal>
#include <QtJambi/QtJambiAPI>
#include <QtJambi/FunctionalBase>
#include <QtGui/QOpenGLExtraFunctions>


class GLDEBUGPROC_shell final : public FunctionalBase
{
public:
    GLDEBUGPROC_shell();
    ~GLDEBUGPROC_shell() override;
    void getFunctional(JNIEnv*, void*) override;
    static void operator delete(void * ptr) noexcept;

    class Functor final : private FunctorBase{
    public:
        Functor(const Functor& functor);
        ~Functor() override;
        void operator()(GLenum source0, GLenum type1, GLuint id2, GLenum severity3, GLsizei length4, const GLchar* message5, const void* userParam6);
    private:
        Functor(GLDEBUGPROC_shell& functional);
        friend class GLDEBUGPROC_shell;
    };

    static jobject resolveFunctional(JNIEnv *, const void*, bool* ok);

private:
    QtJambiShell* __shell() const override final;
    friend class GLDEBUGPROC_shell::Functor;
    std::function<void()> m_functionPointerDeleter;
    static std::function<const Functor*(GLDEBUGPROC)> reverseFunctionGetter;
};

#endif // GLDEBUGPROC_SHELL_H
