#include <QtCore/QtGlobal>
#include <qtcore-config.h>
#if QT_CONFIG(regularexpression)
#include <QtCore/qregularexpression.h>
#endif //QT_CONFIG(regularexpression)
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtCore/qnamespace.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

#if QT_CONFIG(regularexpression)


void deleter_QRegularExpression(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QRegularExpression")
    QRegularExpression *_ptr = reinterpret_cast<QRegularExpression *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}


#endif // QT_CONFIG(regularexpression)

// emitting (writeConstructors)
// new QRegularExpression()
void __qt_construct_QRegularExpression(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRegularExpression()")
#if QT_CONFIG(regularexpression)
    Q_UNUSED(__java_arguments)
    QRegularExpression *__qt_this = new(__qtjambi_ptr) QRegularExpression();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
}

// QRegularExpression::QRegularExpression()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_initialize_1native__Lio_qt_core_QRegularExpression_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRegularExpression::QRegularExpression()")
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRegularExpression, sizeof(QRegularExpression), typeid(QRegularExpression), 0, false, &deleter_QRegularExpression, nullptr);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QRegularExpression(QRegularExpression)
void __qt_construct_QRegularExpression_cref_QRegularExpression(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRegularExpression(QRegularExpression)")
#if QT_CONFIG(regularexpression)
    jobject re0 = __java_arguments[0].l;
    const QRegularExpression& __qt_re0 = qtjambi_cast<const QRegularExpression&>(__jni_env, re0);
    QRegularExpression *__qt_this = new(__qtjambi_ptr) QRegularExpression(__qt_re0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
}

// QRegularExpression::QRegularExpression(QRegularExpression)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_initialize_1native__Lio_qt_core_QRegularExpression_2Lio_qt_core_QRegularExpression_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject re0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRegularExpression::QRegularExpression(QRegularExpression)")
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        jvalue arguments;
        arguments.l = re0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRegularExpression_cref_QRegularExpression, sizeof(QRegularExpression), typeid(QRegularExpression), 0, false, &deleter_QRegularExpression, &arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(re0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QRegularExpression(QString,QRegularExpression::PatternOptions)
void __qt_construct_QRegularExpression_cref_QString(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRegularExpression(QString,QRegularExpression::PatternOptions)")
#if QT_CONFIG(regularexpression)
    jstring pattern0 = static_cast<jstring>(__java_arguments[0].l);
    QString __qt_pattern0 = qtjambi_cast<QString>(__jni_env, pattern0);
    QRegularExpression *__qt_this = new(__qtjambi_ptr) QRegularExpression(__qt_pattern0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
}

// new QRegularExpression(QString,QRegularExpression::PatternOptions)
void __qt_construct_QRegularExpression_cref_QString_QRegularExpression_PatternOptions(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRegularExpression(QString,QRegularExpression::PatternOptions)")
#if QT_CONFIG(regularexpression)
    jstring pattern0 = static_cast<jstring>(__java_arguments[0].l);
    QString __qt_pattern0 = qtjambi_cast<QString>(__jni_env, pattern0);
    jobject options1 = __java_arguments[1].l;
    QRegularExpression::PatternOptions __qt_options1 = qtjambi_cast<QRegularExpression::PatternOptions>(__jni_env, options1);
    QRegularExpression *__qt_this = new(__qtjambi_ptr) QRegularExpression(__qt_pattern0, QRegularExpression::PatternOptions(__qt_options1));
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
}

// QRegularExpression::QRegularExpression(QString,QRegularExpression::PatternOptions)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_initialize_1native__Lio_qt_core_QRegularExpression_2Ljava_lang_String_2Lio_qt_core_QRegularExpression_00024PatternOptions_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring pattern0,
 jobject options1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRegularExpression::QRegularExpression(QString,QRegularExpression::PatternOptions)")
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        jvalue arguments[2];
        arguments[0].l = pattern0;
        arguments[1].l = options1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRegularExpression_cref_QString_QRegularExpression_PatternOptions, sizeof(QRegularExpression), typeid(QRegularExpression), 0, false, &deleter_QRegularExpression, arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(pattern0)
        Q_UNUSED(options1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QRegularExpression
void __qt_destruct_QRegularExpression(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QRegularExpression")

#if QT_CONFIG(regularexpression)

    reinterpret_cast<QRegularExpression*>(ptr)->~QRegularExpression();

#else
    Q_UNUSED(ptr)

#endif // QT_CONFIG(regularexpression)

}

// emitting  (functionsInTargetLang writeFinalFunction)
// QRegularExpression::captureCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_captureCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        const QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::captureCount()const", __this_nativeId)
        __java_return_value = __qt_this->captureCount();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::errorString()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_errorString_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        const QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::errorString()const", __this_nativeId)
        QString __qt_return_value = __qt_this->errorString();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::globalMatchView(QStringView,qsizetype,QRegularExpression::MatchType,QRegularExpression::MatchOptions)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_globalMatch_1native_1QStringView_1qsizetype_1QRegularExpression_1MatchType_1QRegularExpression_1MatchOptions_1constfct__JLjava_lang_String_2JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring subjectView0,
 jlong offset1,
 jint matchType2,
 jint matchOptions3)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__qtjambi_scope)
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        const QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::globalMatchView(QStringView,qsizetype,QRegularExpression::MatchType,QRegularExpression::MatchOptions)const", __this_nativeId)
        QStringView __qt_subjectView0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, subjectView0);
        QRegularExpression::MatchType __qt_matchType2 = qtjambi_cast<QRegularExpression::MatchType>(__jni_env, matchType2);
        QRegularExpression::MatchOptions __qt_matchOptions3 = qtjambi_cast<QRegularExpression::MatchOptions>(__jni_env, matchOptions3);
        QRegularExpressionMatchIterator __qt_return_value = __qt_this->globalMatchView(__qt_subjectView0, static_cast<qsizetype>(offset1), QRegularExpression::MatchType(__qt_matchType2), QRegularExpression::MatchOptions(__qt_matchOptions3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(subjectView0)
        Q_UNUSED(offset1)
        Q_UNUSED(matchType2)
        Q_UNUSED(matchOptions3)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        const QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::isValid()const", __this_nativeId)
        __java_return_value = __qt_this->isValid();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::matchView(QStringView,qsizetype,QRegularExpression::MatchType,QRegularExpression::MatchOptions)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_match_1native_1QStringView_1qsizetype_1QRegularExpression_1MatchType_1QRegularExpression_1MatchOptions_1constfct__JLjava_lang_String_2JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring subjectView0,
 jlong offset1,
 jint matchType2,
 jint matchOptions3)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__qtjambi_scope)
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        const QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::matchView(QStringView,qsizetype,QRegularExpression::MatchType,QRegularExpression::MatchOptions)const", __this_nativeId)
        QStringView __qt_subjectView0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, subjectView0);
        QRegularExpression::MatchType __qt_matchType2 = qtjambi_cast<QRegularExpression::MatchType>(__jni_env, matchType2);
        QRegularExpression::MatchOptions __qt_matchOptions3 = qtjambi_cast<QRegularExpression::MatchOptions>(__jni_env, matchOptions3);
        QRegularExpressionMatch __qt_return_value = __qt_this->matchView(__qt_subjectView0, static_cast<qsizetype>(offset1), QRegularExpression::MatchType(__qt_matchType2), QRegularExpression::MatchOptions(__qt_matchOptions3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(subjectView0)
        Q_UNUSED(offset1)
        Q_UNUSED(matchType2)
        Q_UNUSED(matchOptions3)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::namedCaptureGroups()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_namedCaptureGroups_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        const QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::namedCaptureGroups()const", __this_nativeId)
        QStringList __qt_return_value = __qt_this->namedCaptureGroups();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::operator<<(QDataStream&,QRegularExpression)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID out0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::operator<<(QDataStream&,QRegularExpression)", __this_nativeId)
        QDataStream& __qt_out0 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, out0);
        __qt_out0 << (*__qt_this);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(out0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegularExpression::operator=(QRegularExpression)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_assign_1native_1cref_1QRegularExpression__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID re0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::operator=(QRegularExpression)", __this_nativeId)
        const QRegularExpression& __qt_re0 = QtJambiAPI::valueReferenceFromNativeId<QRegularExpression>(re0);
        (*__qt_this) = __qt_re0;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(re0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegularExpression::operator==(QRegularExpression)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_equals_1native_1cref_1QRegularExpression_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID re0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        const QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::operator==(QRegularExpression)const", __this_nativeId)
        const QRegularExpression& __qt_re0 = QtJambiAPI::valueReferenceFromNativeId<QRegularExpression>(re0);
        __java_return_value = (*__qt_this) == __qt_re0;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(re0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::operator>>(QDataStream&,QRegularExpression&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID in0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::operator>>(QDataStream&,QRegularExpression&)", __this_nativeId)
        QDataStream& __qt_in0 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, in0);
        __qt_in0 >> (*__qt_this);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(in0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegularExpression::optimize()const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_optimize_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        const QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::optimize()const", __this_nativeId)
        __qt_this->optimize();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegularExpression::pattern()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_pattern_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        const QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::pattern()const", __this_nativeId)
        QString __qt_return_value = __qt_this->pattern();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::patternErrorOffset()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_patternErrorOffset_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        const QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::patternErrorOffset()const", __this_nativeId)
        qsizetype __qt_return_value = __qt_this->patternErrorOffset();
        __java_return_value = jlong(__qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::patternOptions()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_patternOptions_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        const QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::patternOptions()const", __this_nativeId)
        QRegularExpression::PatternOptions __qt_return_value = __qt_this->patternOptions();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::setPattern(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_setPattern_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring pattern0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::setPattern(QString)", __this_nativeId)
        QString __qt_pattern0 = qtjambi_cast<QString>(__jni_env, pattern0);
        __qt_this->setPattern(__qt_pattern0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(pattern0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegularExpression::setPatternOptions(QRegularExpression::PatternOptions)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_setPatternOptions_1native_1QRegularExpression_1PatternOptions__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint options0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::setPatternOptions(QRegularExpression::PatternOptions)", __this_nativeId)
        QRegularExpression::PatternOptions __qt_options0 = qtjambi_cast<QRegularExpression::PatternOptions>(__jni_env, options0);
        __qt_this->setPatternOptions(QRegularExpression::PatternOptions(__qt_options0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(options0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegularExpression::swap(QRegularExpression&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_swap_1native_1ref_1QRegularExpression__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegularExpression::swap(QRegularExpression&)", __this_nativeId)
        QRegularExpression& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QRegularExpression>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(other0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegularExpression::anchoredPattern(QString)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_anchoredPattern__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring expression0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRegularExpression::anchoredPattern(QString)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        QString __qt_expression0 = qtjambi_cast<QString>(__jni_env, expression0);
        QString __qt_return_value = QRegularExpression::anchoredPattern(__qt_expression0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(expression0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::escape(QString)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_escape__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring str0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRegularExpression::escape(QString)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        QString __qt_str0 = qtjambi_cast<QString>(__jni_env, str0);
        QString __qt_return_value = QRegularExpression::escape(__qt_str0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(str0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::fromWildcard(QStringView,Qt::CaseSensitivity,QRegularExpression::WildcardConversionOptions)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_fromWildcard_1native_1QStringView_1Qt_1CaseSensitivity_1QRegularExpression_1WildcardConversionOptions__Ljava_lang_String_2II)
(JNIEnv *__jni_env,
 jclass,
 jstring pattern0,
 jint cs1,
 jint options2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRegularExpression::fromWildcard(QStringView,Qt::CaseSensitivity,QRegularExpression::WildcardConversionOptions)")
    QtJambiScope __qtjambi_scope;
    Q_UNUSED(__qtjambi_scope)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        QStringView __qt_pattern0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, pattern0);
        Qt::CaseSensitivity __qt_cs1 = qtjambi_cast<Qt::CaseSensitivity>(__jni_env, cs1);
        QRegularExpression::WildcardConversionOptions __qt_options2 = qtjambi_cast<QRegularExpression::WildcardConversionOptions>(__jni_env, options2);
        QRegularExpression __qt_return_value = QRegularExpression::fromWildcard(__qt_pattern0, Qt::CaseSensitivity(__qt_cs1), QRegularExpression::WildcardConversionOptions(__qt_options2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(pattern0)
        Q_UNUSED(cs1)
        Q_UNUSED(options2)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegularExpression::wildcardToRegularExpression(QString,QRegularExpression::WildcardConversionOptions)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_wildcardToRegularExpression_1native_1cref_1QString_1QRegularExpression_1WildcardConversionOptions__Ljava_lang_String_2I)
(JNIEnv *__jni_env,
 jclass,
 jstring str0,
 jint options1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRegularExpression::wildcardToRegularExpression(QString,QRegularExpression::WildcardConversionOptions)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(regularexpression)
        QString __qt_str0 = qtjambi_cast<QString>(__jni_env, str0);
        QRegularExpression::WildcardConversionOptions __qt_options1 = qtjambi_cast<QRegularExpression::WildcardConversionOptions>(__jni_env, options1);
        QString __qt_return_value = QRegularExpression::wildcardToRegularExpression(__qt_str0, QRegularExpression::WildcardConversionOptions(__qt_options1));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(str0)
        Q_UNUSED(options1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(regularexpression)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {

#if QT_CONFIG(regularexpression)

        QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
#else
        Q_UNUSED(__this_nativeId)
#endif // QT_CONFIG(regularexpression)

    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {

#if QT_CONFIG(regularexpression)

        QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);

#else
        Q_UNUSED(__this_nativeId)
#endif // QT_CONFIG(regularexpression)

    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegularExpression_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {

#if QT_CONFIG(regularexpression)

        const QRegularExpression *__qt_this = QtJambiAPI::objectFromNativeId<QRegularExpression>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);

#else
        Q_UNUSED(__this_nativeId)
#endif // QT_CONFIG(regularexpression)

    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QRegularExpression(){
    using namespace RegistryAPI;

#if QT_CONFIG(regularexpression)

    const std::type_info& typeId = registerValueTypeInfo<QRegularExpression>("QRegularExpression", "io/qt/core/QRegularExpression");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QRegularExpression, {
        ConstructorInfo(&__qt_construct_QRegularExpression, nullptr)
       ,ConstructorInfo(&__qt_construct_QRegularExpression_cref_QRegularExpression, "Lio/qt/core/QRegularExpression;")
       ,ConstructorInfo(&__qt_construct_QRegularExpression_cref_QString, "Ljava/lang/String;")
       ,ConstructorInfo(&__qt_construct_QRegularExpression_cref_QString_QRegularExpression_PatternOptions, "Ljava/lang/String;Lio/qt/core/QRegularExpression$PatternOptions;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QRegularExpression);
    registerMetaType<QRegularExpression>("QRegularExpression");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags

#if QT_CONFIG(regularexpression)
    registerEnumTypeInfo<QRegularExpression::MatchOption>("QRegularExpression::MatchOption", "io/qt/core/QRegularExpression$MatchOption", "QRegularExpression::MatchOptions", "QFlags<QRegularExpression::MatchOption>", "io/qt/core/QRegularExpression$MatchOptions");
#endif //QT_CONFIG(regularexpression)

#if QT_CONFIG(regularexpression)
    registerEnumTypeInfo<QRegularExpression::MatchType>("QRegularExpression::MatchType", "io/qt/core/QRegularExpression$MatchType");
#endif //QT_CONFIG(regularexpression)

#if QT_CONFIG(regularexpression)
    registerEnumTypeInfo<QRegularExpression::PatternOption>("QRegularExpression::PatternOption", "io/qt/core/QRegularExpression$PatternOption", "QRegularExpression::PatternOptions", "QFlags<QRegularExpression::PatternOption>", "io/qt/core/QRegularExpression$PatternOptions");
#endif //QT_CONFIG(regularexpression)

#if QT_CONFIG(regularexpression)
    registerEnumTypeInfo<QRegularExpression::WildcardConversionOption>("QRegularExpression::WildcardConversionOption", "io/qt/core/QRegularExpression$WildcardConversionOption", "QRegularExpression::WildcardConversionOptions", "QFlags<QRegularExpression::WildcardConversionOption>", "io/qt/core/QRegularExpression$WildcardConversionOptions");
#endif //QT_CONFIG(regularexpression)
// END: enums and flags

#endif //QT_CONFIG(regularexpression)

}
