#include <QtCore/QtGlobal>
#include <QtCore/qrandom.h>
#include <QtCore/QVariant>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QRandomGenerator(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QRandomGenerator")
    QRandomGenerator *_ptr = reinterpret_cast<QRandomGenerator *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QRandomGenerator(QRandomGenerator)
void __qt_construct_QRandomGenerator_cref_QRandomGenerator(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRandomGenerator(QRandomGenerator)")
    jobject other0 = __java_arguments[0].l;
    const QRandomGenerator& __qt_other0 = qtjambi_cast<const QRandomGenerator&>(__jni_env, other0);
    QRandomGenerator *__qt_this = new(__qtjambi_ptr) QRandomGenerator(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QRandomGenerator::QRandomGenerator(QRandomGenerator)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_initialize_1native__Lio_qt_core_QRandomGenerator_2Lio_qt_core_QRandomGenerator_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRandomGenerator::QRandomGenerator(QRandomGenerator)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRandomGenerator_cref_QRandomGenerator, sizeof(QRandomGenerator), typeid(QRandomGenerator), 0, false, &deleter_QRandomGenerator, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QRandomGenerator(quint32)
void __qt_construct_QRandomGenerator(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRandomGenerator(quint32)")
    Q_UNUSED(__java_arguments)
    QRandomGenerator *__qt_this = new(__qtjambi_ptr) QRandomGenerator();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// new QRandomGenerator(quint32)
void __qt_construct_QRandomGenerator_quint32(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRandomGenerator(quint32)")
    jint seedValue0 = __java_arguments[0].i;
    Q_UNUSED(seedValue0)
    QRandomGenerator *__qt_this = new(__qtjambi_ptr) QRandomGenerator(static_cast<quint32>(seedValue0));
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QRandomGenerator::QRandomGenerator(quint32)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_initialize_1native__Lio_qt_core_QRandomGenerator_2I)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint seedValue0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRandomGenerator::QRandomGenerator(quint32)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.i = seedValue0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRandomGenerator_quint32, sizeof(QRandomGenerator), typeid(QRandomGenerator), 0, false, &deleter_QRandomGenerator, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QRandomGenerator(std::initializer_list<uint>)
void __qt_construct_QRandomGenerator_cref_std_initializer_list(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRandomGenerator(std::initializer_list<uint>)")
    QtJambiScope __qtjambi_scope;
    jintArray sseq0 = static_cast<jintArray>(__java_arguments[0].l);
    std::initializer_list<uint> seed = qtjambi_cast<std::initializer_list<uint>>(__jni_env, __qtjambi_scope, sseq0);
    std::seed_seq __qt_sseq0(seed.begin(), seed.end());
    QRandomGenerator *__qt_this = new(__qtjambi_ptr) QRandomGenerator(__qt_sseq0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QRandomGenerator::QRandomGenerator(std::initializer_list<uint>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_initialize_1native__Lio_qt_core_QRandomGenerator_2_3I)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jintArray sseq0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRandomGenerator::QRandomGenerator(std::initializer_list<uint>)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = sseq0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRandomGenerator_cref_std_initializer_list, sizeof(QRandomGenerator), typeid(QRandomGenerator), 0, false, &deleter_QRandomGenerator, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QRandomGenerator
void __qt_destruct_QRandomGenerator(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QRandomGenerator")
    reinterpret_cast<QRandomGenerator*>(ptr)->~QRandomGenerator();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QRandomGenerator::discard(qulonglong)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_discard_1native_1unsigned_1long_1long__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong z0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRandomGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QRandomGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRandomGenerator::discard(qulonglong)", __this_nativeId)
        __qt_this->discard(static_cast<unsigned long long>(z0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRandomGenerator::generate()
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_generate_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QRandomGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QRandomGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRandomGenerator::generate()", __this_nativeId)
        quint32 __qt_return_value = __qt_this->generate();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRandomGenerator::generate(quint32*,quint32*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_generate_1native_1quint32_1ptr_1quint32_1ptr__J_3I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jintArray begin0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRandomGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QRandomGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRandomGenerator::generate(quint32*,quint32*)", __this_nativeId)
        jsize size = 0;
        quint32* __qt_begin0 = qtjambi_array_cast<quint32*>(__jni_env, __qtjambi_scope, begin0, size);
        quint32* __qt_end1 = __qt_begin0 + size;
        __qt_this->generate(__qt_begin0, __qt_end1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRandomGenerator::generate64()
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_generate64_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        QRandomGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QRandomGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRandomGenerator::generate64()", __this_nativeId)
        quint64 __qt_return_value = __qt_this->generate64();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRandomGenerator::generateDouble()
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_generateDouble_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        QRandomGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QRandomGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRandomGenerator::generateDouble()", __this_nativeId)
        __java_return_value = __qt_this->generateDouble();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRandomGenerator::operator()()
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_invoke_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QRandomGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QRandomGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRandomGenerator::operator()()", __this_nativeId)
        quint32 __qt_return_value = (*__qt_this)();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRandomGenerator::operator=(QRandomGenerator)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_assign_1native_1cref_1QRandomGenerator__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRandomGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QRandomGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRandomGenerator::operator=(QRandomGenerator)", __this_nativeId)
        const QRandomGenerator& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QRandomGenerator>(__jni_env, other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRandomGenerator::operator==(QRandomGenerator,QRandomGenerator)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_equals_1native_1cref_1QRandomGenerator__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rng21)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QRandomGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QRandomGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRandomGenerator::operator==(QRandomGenerator,QRandomGenerator)", __this_nativeId)
        const QRandomGenerator& __qt_rng21 = QtJambiAPI::objectReferenceFromNativeId<QRandomGenerator>(__jni_env, rng21);
        __java_return_value = (*__qt_this) == __qt_rng21;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRandomGenerator::seed(quint32)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_seed_1native_1quint32__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint s0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRandomGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QRandomGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRandomGenerator::seed(quint32)", __this_nativeId)
        __qt_this->seed(static_cast<quint32>(s0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRandomGenerator::seed(std::initializer_list<uint>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_seed_1native_1cref_1std_1initializer_1list__J_3I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jintArray sseq0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRandomGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QRandomGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRandomGenerator::seed(std::initializer_list<uint>)", __this_nativeId)
        std::initializer_list<uint> seed = qtjambi_cast<std::initializer_list<uint>>(__jni_env, __qtjambi_scope, sseq0);
        std::seed_seq __qt_sseq0(seed.begin(), seed.end());
        __qt_this->seed(__qt_sseq0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRandomGenerator::global()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_global__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRandomGenerator::global()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRandomGenerator* __qt_return_value = QRandomGenerator::global();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRandomGenerator::max()
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_max__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRandomGenerator::max()")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        quint32 __qt_return_value = QRandomGenerator::max();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRandomGenerator::min()
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_min__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRandomGenerator::min()")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        quint32 __qt_return_value = QRandomGenerator::min();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRandomGenerator::securelySeeded()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_securelySeeded__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRandomGenerator::securelySeeded()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRandomGenerator __qt_return_value = QRandomGenerator::securelySeeded();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRandomGenerator::system()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_system__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRandomGenerator::system()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRandomGenerator* __qt_return_value = QRandomGenerator::system();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRandomGenerator_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QRandomGenerator *__qt_this = QtJambiAPI::objectFromNativeId<QRandomGenerator>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QRandomGenerator(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QRandomGenerator>("QRandomGenerator", "io/qt/core/QRandomGenerator");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QRandomGenerator, {
        ConstructorInfo(&__qt_construct_QRandomGenerator_cref_QRandomGenerator, "Lio/qt/core/QRandomGenerator;")
       ,ConstructorInfo(&__qt_construct_QRandomGenerator, nullptr)
       ,ConstructorInfo(&__qt_construct_QRandomGenerator_quint32, "I")
       ,ConstructorInfo(&__qt_construct_QRandomGenerator_cref_std_initializer_list, "[I")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QRandomGenerator);
    registerMetaType<QRandomGenerator>("QRandomGenerator");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
