#include <QtCore/QtGlobal>
#include <QtCore/qlockfile.h>
#include <QtCore/QVariant>
#include <QtCore/qstring.h>
#include "utils_p.h"

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QLockFile(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QLockFile")
    QLockFile *_ptr = reinterpret_cast<QLockFile *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QLockFile(QString)
void __qt_construct_QLockFile_cref_QString(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QLockFile(QString)")
    jstring fileName0 = static_cast<jstring>(__java_arguments[0].l);
    QString __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
    QLockFile *__qt_this = new(__qtjambi_ptr) QLockFile(__qt_fileName0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QLockFile::QLockFile(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_initialize_1native__Lio_qt_core_QLockFile_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring fileName0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QLockFile::QLockFile(QString)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = fileName0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QLockFile_cref_QString, sizeof(QLockFile), typeid(QLockFile), 0, false, &deleter_QLockFile, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QLockFile
void __qt_destruct_QLockFile(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QLockFile")
    reinterpret_cast<QLockFile*>(ptr)->~QLockFile();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QLockFile::error()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_error_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::error()const", __this_nativeId)
        QLockFile::LockError __qt_return_value = __qt_this->error();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLockFile::fileName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_fileName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::fileName()const", __this_nativeId)
        QString __qt_return_value = __qt_this->fileName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLockFile::getLockInfo(qint64*,QString*,QString*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_getLockInfo_1native_1qint64_1ptr_1QString_1ptr_1QString_1ptr_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::getLockInfo(qint64*,QString*,QString*)const", __this_nativeId)
        long long pid(0);
        long long* __qt_pid0 = &pid;
        QString hostname;
        QString* __qt_hostname1 = &hostname;
        QString appname;
        QString* __qt_appname2 = &appname;
        bool __qt_return_value = __qt_this->getLockInfo(__qt_pid0, __qt_hostname1, __qt_appname2);
        __java_return_value = __qt_return_value ? Java::QtCore::QLockFile$LockInfo::newInstance(__jni_env, jlong(pid), qtjambi_cast<jstring>(__jni_env, hostname), qtjambi_cast<jstring>(__jni_env, appname)) : nullptr;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLockFile::isLocked()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_isLocked_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::isLocked()const", __this_nativeId)
        __java_return_value = __qt_this->isLocked();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLockFile::lock()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_lock_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::lock()", __this_nativeId)
        __java_return_value = __qt_this->lock();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLockFile::removeStaleLockFile()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_removeStaleLockFile_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::removeStaleLockFile()", __this_nativeId)
        __java_return_value = __qt_this->removeStaleLockFile();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLockFile::setStaleLockTime(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_setStaleLockTime_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::setStaleLockTime(int)", __this_nativeId)
        __qt_this->setStaleLockTime(static_cast<int>(arg__1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QLockFile::setStaleLockTime(std::chrono::milliseconds)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_setStaleLockTime_1native_1std_1chrono_1milliseconds__JLjava_time_temporal_TemporalAmount_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject value0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::setStaleLockTime(std::chrono::milliseconds)", __this_nativeId)
        std::chrono::milliseconds __qt_value0 = qtjambi_cast<std::chrono::milliseconds >(__jni_env, __qtjambi_scope, value0);
        __qt_this->setStaleLockTime(__qt_value0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QLockFile::staleLockTime()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_staleLockTime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::staleLockTime()const", __this_nativeId)
        __java_return_value = __qt_this->staleLockTime();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLockFile::staleLockTimeAsDuration()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_staleLockTimeAsDuration_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::staleLockTimeAsDuration()const", __this_nativeId)
        std::chrono::milliseconds __qt_return_value = __qt_this->staleLockTimeAsDuration();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLockFile::tryLock(int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_tryLock_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint timeout0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::tryLock(int)", __this_nativeId)
        __java_return_value = __qt_this->tryLock(static_cast<int>(timeout0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLockFile::tryLock(std::chrono::milliseconds)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_tryLock_1native_1std_1chrono_1milliseconds__JLjava_time_temporal_TemporalAmount_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject timeout0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::tryLock(std::chrono::milliseconds)", __this_nativeId)
        std::chrono::milliseconds __qt_timeout0 = qtjambi_cast<std::chrono::milliseconds >(__jni_env, __qtjambi_scope, timeout0);
        __java_return_value = __qt_this->tryLock(__qt_timeout0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLockFile::unlock()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLockFile_unlock_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLockFile *__qt_this = QtJambiAPI::objectFromNativeId<QLockFile>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLockFile::unlock()", __this_nativeId)
        __qt_this->unlock();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QLockFile(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QLockFile>("QLockFile", "io/qt/core/QLockFile");
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QLockFile, {
        ConstructorInfo(&__qt_construct_QLockFile_cref_QString, "Ljava/lang/String;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QLockFile);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QLockFile::LockError>("QLockFile::LockError", "io/qt/core/QLockFile$LockError");
// END: enums and flags
}
