#include <QtCore/QtGlobal>
#include <QtCore/qjsonobject.h>
#include <QtCore/QHash>
#include <QtCore/QMap>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtCore/qcontainerfwd.h>
#include <QtCore/qdatastream.h>
#include <QtCore/qjsonvalue.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QJsonObject(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QJsonObject")
    QJsonObject *_ptr = reinterpret_cast<QJsonObject *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QJsonObject()
void __qt_construct_QJsonObject(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonObject()")
    Q_UNUSED(__java_arguments)
    QJsonObject *__qt_this = new(__qtjambi_ptr) QJsonObject();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QJsonObject::QJsonObject()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_initialize_1native__Lio_qt_core_QJsonObject_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonObject::QJsonObject()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonObject, sizeof(QJsonObject), typeid(QJsonObject), 0, false, &deleter_QJsonObject, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QJsonObject(QJsonObject)
void __qt_construct_QJsonObject_cref_QJsonObject(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonObject(QJsonObject)")
    jobject other0 = __java_arguments[0].l;
    const QJsonObject& __qt_other0 = qtjambi_cast<const QJsonObject&>(__jni_env, other0);
    QJsonObject *__qt_this = new(__qtjambi_ptr) QJsonObject(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QJsonObject::QJsonObject(QJsonObject)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_initialize_1native__Lio_qt_core_QJsonObject_2Lio_qt_core_QJsonObject_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonObject::QJsonObject(QJsonObject)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonObject_cref_QJsonObject, sizeof(QJsonObject), typeid(QJsonObject), 0, false, &deleter_QJsonObject, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QJsonObject(std::initializer_list<std::pair<QString,QJsonValue>>)
void __qt_construct_QJsonObject_std_initializer_list(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonObject(std::initializer_list<std::pair<QString,QJsonValue>>)")
    QtJambiScope __qtjambi_scope;
    jobjectArray args0 = static_cast<jobjectArray>(__java_arguments[0].l);
    std::initializer_list<QPair<QString, QJsonValue> > __qt_args0 = qtjambi_cast<std::initializer_list<QPair<QString, QJsonValue> >>(__jni_env, __qtjambi_scope, args0);
    QJsonObject *__qt_this = new(__qtjambi_ptr) QJsonObject(__qt_args0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QJsonObject::QJsonObject(std::initializer_list<std::pair<QString,QJsonValue>>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_initialize_1native__Lio_qt_core_QJsonObject_2_3Lio_qt_core_QPair_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobjectArray args0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonObject::QJsonObject(std::initializer_list<std::pair<QString,QJsonValue>>)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = args0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonObject_std_initializer_list, sizeof(QJsonObject), typeid(QJsonObject), 0, false, &deleter_QJsonObject, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QJsonObject
void __qt_destruct_QJsonObject(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QJsonObject")
    reinterpret_cast<QJsonObject*>(ptr)->~QJsonObject();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QJsonObject::constBegin()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_constBegin_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::constBegin()const", __this_nativeId)
        QJsonObject::const_iterator __qt_return_value = __qt_this->constBegin();
        __java_return_value = qtjambi_cast_sequential_iterator(__jni_env, __qtjambi_scope, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::constEnd()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_constEnd_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::constEnd()const", __this_nativeId)
        QJsonObject::const_iterator __qt_return_value = __qt_this->constEnd();
        __java_return_value = qtjambi_cast_sequential_iterator(__jni_env, __qtjambi_scope, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::constFind(QStringView)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_constFind_1native_1QStringView_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::constFind(QStringView)const", __this_nativeId)
        QStringView __qt_key0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, key0);
        QJsonObject::const_iterator __qt_return_value = __qt_this->constFind(__qt_key0);
        __java_return_value = qtjambi_cast_sequential_iterator(__jni_env, __qtjambi_scope, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::contains(QStringView)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_contains_1native_1QStringView_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::contains(QStringView)const", __this_nativeId)
        QStringView __qt_key0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, key0);
        __java_return_value = __qt_this->contains(__qt_key0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::count()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_count_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::count()const", __this_nativeId)
        qsizetype __qt_return_value = __qt_this->count();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::erase(QJsonObject::iterator)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_erase_1native_1QJsonObject_1iterator__JLio_qt_core_QSequentialConstIterator_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject it0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::erase(QJsonObject::iterator)", __this_nativeId)
        QJsonObject::iterator __qt_it0 = reinterpret_deref_cast<QJsonObject::iterator >(__jni_env, QtJambiAPI::convertJavaObjectToNative(__jni_env, it0));
        QJsonObject::iterator __qt_return_value = __qt_this->erase(__qt_it0);
        __java_return_value = qtjambi_cast_sequential_iterator(__jni_env, __qtjambi_scope, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::find(QStringView)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_find_1native_1QStringView__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::find(QStringView)", __this_nativeId)
        QStringView __qt_key0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, key0);
        QJsonObject::iterator __qt_return_value = __qt_this->find(__qt_key0);
        __java_return_value = qtjambi_cast_sequential_iterator(__jni_env, __qtjambi_scope, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::insert(QStringView,QJsonValue)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_insert_1native_1QStringView_1cref_1QJsonValue__JLjava_lang_String_2J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0,
 QtJambiNativeID value1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::insert(QStringView,QJsonValue)", __this_nativeId)
        QStringView __qt_key0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, key0);
        const QJsonValue& __qt_value1 = QtJambiAPI::objectReferenceFromNativeId<QJsonValue>(__jni_env, value1);
        __qt_this->insert(__qt_key0, __qt_value1);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::isEmpty()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_isEmpty_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::isEmpty()const", __this_nativeId)
        __java_return_value = __qt_this->isEmpty();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::keys()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_keys_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::keys()const", __this_nativeId)
        QStringList __qt_return_value = __qt_this->keys();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::length()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_length_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::length()const", __this_nativeId)
        qsizetype __qt_return_value = __qt_this->length();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::operator<<(QDataStream&,QJsonObject)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::operator<<(QDataStream&,QJsonObject)", __this_nativeId)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonObject::operator=(QJsonObject)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_assign_1native_1cref_1QJsonObject__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::operator=(QJsonObject)", __this_nativeId)
        const QJsonObject& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QJsonObject>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonObject::operator==(QJsonObject)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_equals_1native_1cref_1QJsonObject_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::operator==(QJsonObject)const", __this_nativeId)
        const QJsonObject& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QJsonObject>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::operator>>(QDataStream&,QJsonObject&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::operator>>(QDataStream&,QJsonObject&)", __this_nativeId)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonObject::operator[](QStringView)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_get_1native_1QStringView_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::operator[](QStringView)const", __this_nativeId)
        QStringView __qt_key0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, key0);
        const QJsonValue __qt_return_value = (*__qt_this)[__qt_key0];
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::operator[](QStringView)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_set_1native_1QStringView_1const_1QJsonValue__JLjava_lang_String_2J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0,
 QtJambiNativeID value1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::operator[](QStringView)", __this_nativeId)
        QStringView __qt_key0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, key0);
        const QJsonValue __qt_value1 = QtJambiAPI::objectReferenceFromNativeId<QJsonValue>(__jni_env, value1);
        (*__qt_this)[__qt_key0] = __qt_value1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonObject::remove(QStringView)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_remove_1native_1QStringView__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::remove(QStringView)", __this_nativeId)
        QStringView __qt_key0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, key0);
        __qt_this->remove(__qt_key0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonObject::size()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::size()const", __this_nativeId)
        qsizetype __qt_return_value = __qt_this->size();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::swap(QJsonObject&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_swap_1native_1ref_1QJsonObject__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::swap(QJsonObject&)", __this_nativeId)
        QJsonObject& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QJsonObject>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonObject::take(QStringView)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_take_1native_1QStringView__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::take(QStringView)", __this_nativeId)
        QStringView __qt_key0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, key0);
        QJsonValue __qt_return_value = __qt_this->take(__qt_key0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::toVariantHash()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_toVariantHash_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::toVariantHash()const", __this_nativeId)
        QHash<QString, QVariant> __qt_return_value = __qt_this->toVariantHash();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::toVariantMap()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_toVariantMap_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::toVariantMap()const", __this_nativeId)
        QMap<QString, QVariant> __qt_return_value = __qt_this->toVariantMap();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::value(QStringView)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_value_1native_1QStringView_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonObject::value(QStringView)const", __this_nativeId)
        QStringView __qt_key0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, key0);
        QJsonValue __qt_return_value = __qt_this->value(__qt_key0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::fromVariantHash(QVariantHash)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_fromVariantHash__Ljava_util_Map_2)
(JNIEnv *__jni_env,
 jclass,
 jobject map0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonObject::fromVariantHash(QVariantHash)")
    QtJambiScope __qtjambi_scope;
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QHash<QString, QVariant>& __qt_map0 = qtjambi_cast<const QHash<QString, QVariant>& >(__jni_env, __qtjambi_scope, map0);
        QJsonObject __qt_return_value = QJsonObject::fromVariantHash(__qt_map0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonObject::fromVariantMap(QVariantMap)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_fromVariantMap__Ljava_util_NavigableMap_2)
(JNIEnv *__jni_env,
 jclass,
 jobject map0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonObject::fromVariantMap(QVariantMap)")
    QtJambiScope __qtjambi_scope;
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMap<QString, QVariant>& __qt_map0 = qtjambi_cast<const QMap<QString, QVariant>& >(__jni_env, __qtjambi_scope, map0);
        QJsonObject __qt_return_value = QJsonObject::fromVariantMap(__qt_map0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonObject_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QJsonObject *__qt_this = QtJambiAPI::objectFromNativeId<QJsonObject>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QJsonObject(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QJsonObject>("QJsonObject", "io/qt/core/QJsonObject");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QJsonObject, {
        ConstructorInfo(&__qt_construct_QJsonObject, nullptr)
       ,ConstructorInfo(&__qt_construct_QJsonObject_cref_QJsonObject, "Lio/qt/core/QJsonObject;")
       ,ConstructorInfo(&__qt_construct_QJsonObject_std_initializer_list, "[Lio/qt/core/QPair;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QJsonObject);
    registerMetaType<QJsonObject>("QJsonObject");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
