#include <QtCore/QtGlobal>
#include <QtCore/qdatastream.h>
#include <QtCore/QFloat16>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qiodevice.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QDataStream(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QDataStream")
    QDataStream *_ptr = reinterpret_cast<QDataStream *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QDataStream()
void __qt_construct_QDataStream(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDataStream()")
    Q_UNUSED(__java_arguments)
    QDataStream *__qt_this = new(__qtjambi_ptr) QDataStream();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QDataStream::QDataStream()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_initialize_1native__Lio_qt_core_QDataStream_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDataStream::QDataStream()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDataStream, sizeof(QDataStream), typeid(QDataStream), 0, false, &deleter_QDataStream, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDataStream(QByteArray)
void __qt_construct_QDataStream_cref_QByteArray(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDataStream(QByteArray)")
    jobject arg__1 = __java_arguments[0].l;
    const QByteArray& __qt_arg__1 = qtjambi_cast<const QByteArray&>(__jni_env, arg__1);
    QDataStream *__qt_this = new(__qtjambi_ptr) QDataStream(__qt_arg__1);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QDataStream::QDataStream(QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_initialize_1native__Lio_qt_core_QDataStream_2Lio_qt_core_QByteArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDataStream::QDataStream(QByteArray)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = arg__1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDataStream_cref_QByteArray, sizeof(QDataStream), typeid(QDataStream), 0, false, &deleter_QDataStream, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDataStream(QByteArray*,QIODeviceBase::OpenMode)
void __qt_construct_QDataStream_QByteArray_ptr_QIODeviceBase_OpenMode(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDataStream(QByteArray*,QIODeviceBase::OpenMode)")
    jobject arg__1 = __java_arguments[0].l;
    QByteArray* __qt_arg__1 = qtjambi_cast<QByteArray*>(__jni_env, arg__1);
    jobject flags1 = __java_arguments[1].l;
    QIODeviceBase::OpenMode __qt_flags1 = qtjambi_cast<QIODeviceBase::OpenMode>(__jni_env, flags1);
    QDataStream *__qt_this = new(__qtjambi_ptr) QDataStream(__qt_arg__1, QIODeviceBase::OpenMode(__qt_flags1));
    Q_UNUSED(__qt_this)
    if(__qtjambi_is_generic){
        Java::QtJambi::ReferenceUtility::setReferenceCount(__jni_env, __jni_object, nullptr, __jni_env->NewStringUTF("__rcDevice"), false, false, arg__1);
    }
}

// QDataStream::QDataStream(QByteArray*,QIODeviceBase::OpenMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_initialize_1native__Lio_qt_core_QDataStream_2Lio_qt_core_QByteArray_2Lio_qt_core_QIODeviceBase_00024OpenMode_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject arg__1,
 jobject flags1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDataStream::QDataStream(QByteArray*,QIODeviceBase::OpenMode)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = arg__1;
        arguments[1].l = flags1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDataStream_QByteArray_ptr_QIODeviceBase_OpenMode, sizeof(QDataStream), typeid(QDataStream), 0, false, &deleter_QDataStream, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDataStream(QIODevice*)
void __qt_construct_QDataStream_QIODevice_ptr(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDataStream(QIODevice*)")
    jobject arg__1 = __java_arguments[0].l;
    QIODevice* __qt_arg__1 = qtjambi_cast<QIODevice*>(__jni_env, arg__1);
    QDataStream *__qt_this = new(__qtjambi_ptr) QDataStream(__qt_arg__1);
    Q_UNUSED(__qt_this)
    if(__qtjambi_is_generic){
        Java::QtJambi::ReferenceUtility::setReferenceCount(__jni_env, __jni_object, nullptr, __jni_env->NewStringUTF("__rcDevice"), false, false, arg__1);
    }
}

// QDataStream::QDataStream(QIODevice*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_initialize_1native__Lio_qt_core_QDataStream_2Lio_qt_core_QIODevice_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDataStream::QDataStream(QIODevice*)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = arg__1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDataStream_QIODevice_ptr, sizeof(QDataStream), typeid(QDataStream), 0, false, &deleter_QDataStream, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QDataStream
void __qt_destruct_QDataStream(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QDataStream")
    reinterpret_cast<QDataStream*>(ptr)->~QDataStream();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QDataStream::abortTransaction()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_abortTransaction_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::abortTransaction()", __this_nativeId)
        __qt_this->abortTransaction();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDataStream::atEnd()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_atEnd_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::atEnd()const", __this_nativeId)
        __java_return_value = __qt_this->atEnd();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::byteOrder()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_byteOrder_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::byteOrder()const", __this_nativeId)
        QDataStream::ByteOrder __qt_return_value = __qt_this->byteOrder();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::commitTransaction()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_commitTransaction_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::commitTransaction()", __this_nativeId)
        __java_return_value = __qt_this->commitTransaction();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::device()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_device_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::device()const", __this_nativeId)
        QIODevice* __qt_return_value = __qt_this->device();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::floatingPointPrecision()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_floatingPointPrecision_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::floatingPointPrecision()const", __this_nativeId)
        QDataStream::FloatingPointPrecision __qt_return_value = __qt_this->floatingPointPrecision();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::isDeviceTransactionStarted()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_isDeviceTransactionStarted_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::isDeviceTransactionStarted()const", __this_nativeId)
        __java_return_value = __qt_this->isDeviceTransactionStarted();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator<<(bool)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_append_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean i0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator<<(bool)", __this_nativeId)
        (*__qt_this) << static_cast<bool>(i0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator<<(const char*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_append_1native_1const_1char_1ptr__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring str0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator<<(const char*)", __this_nativeId)
        const char* __qt_str0 = qtjambi_cast<const char*>(__jni_env, __qtjambi_scope, str0);
        (*__qt_this) << __qt_str0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator<<(double)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_append_1native_1double__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble f0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator<<(double)", __this_nativeId)
        (*__qt_this) << static_cast<double>(f0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator<<(float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_append_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat f0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator<<(float)", __this_nativeId)
        (*__qt_this) << static_cast<float>(f0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator<<(qint16)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_append_1native_1qint16__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort i0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator<<(qint16)", __this_nativeId)
        (*__qt_this) << static_cast<qint16>(i0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator<<(qint32)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_append_1native_1qint32__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator<<(qint32)", __this_nativeId)
        (*__qt_this) << static_cast<qint32>(i0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator<<(qint64)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_append_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong i0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator<<(qint64)", __this_nativeId)
        (*__qt_this) << static_cast<qint64>(i0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator<<(qint8)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_append_1native_1qint8__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte i0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator<<(qint8)", __this_nativeId)
        (*__qt_this) << static_cast<qint8>(i0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator<<(quint16)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_append_1native_1quint16__JC)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jchar i0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator<<(quint16)", __this_nativeId)
        (*__qt_this) << static_cast<quint16>(i0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator>>(bool&)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_readBoolean_1native_1ref_1bool__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator>>(bool&)", __this_nativeId)
        bool __qt_i0 = false;
        QDataStream& __qt_return_value = (*__qt_this) >> __qt_i0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = __qt_i0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator>>(char*&)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_readString_1native_1ref_1char_1ptr__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator>>(char*&)", __this_nativeId)
        char* __qt_str0 = nullptr;
        QDataStream& __qt_return_value = (*__qt_this) >> __qt_str0;
        Q_UNUSED(__qt_return_value)
        if(__qt_str0){
            __java_return_value = __jni_env->NewStringUTF(__qt_str0);
            delete[] __qt_str0;
        }
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator>>(double&)
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_readDouble_1native_1ref_1double__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator>>(double&)", __this_nativeId)
        double __qt_f0 = 0.0;
        QDataStream& __qt_return_value = (*__qt_this) >> __qt_f0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = __qt_f0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator>>(float&)
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_readFloat_1native_1ref_1float__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator>>(float&)", __this_nativeId)
        float __qt_f0 = 0.f;
        QDataStream& __qt_return_value = (*__qt_this) >> __qt_f0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = __qt_f0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator>>(qint16&)
extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_readShort_1native_1ref_1qint16__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator>>(qint16&)", __this_nativeId)
        short __qt_i0 = 0;
        QDataStream& __qt_return_value = (*__qt_this) >> __qt_i0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = __qt_i0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator>>(qint32&)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_readInt_1native_1ref_1qint32__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator>>(qint32&)", __this_nativeId)
        int __qt_i0 = 0;
        QDataStream& __qt_return_value = (*__qt_this) >> __qt_i0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = __qt_i0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator>>(qint64&)
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_readLong_1native_1ref_1qint64__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator>>(qint64&)", __this_nativeId)
        qint64 __qt_i0 = 0;
        QDataStream& __qt_return_value = (*__qt_this) >> __qt_i0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = __qt_i0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator>>(qint8&)
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_readByte_1native_1ref_1qint8__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator>>(qint8&)", __this_nativeId)
        signed char __qt_i0 = 0;
        QDataStream& __qt_return_value = (*__qt_this) >> __qt_i0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = __qt_i0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::operator>>(quint16&)
extern "C" Q_DECL_EXPORT jchar JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_readChar_1native_1ref_1quint16__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jchar __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::operator>>(quint16&)", __this_nativeId)
        unsigned short __qt_i0 = 0;
        QDataStream& __qt_return_value = (*__qt_this) >> __qt_i0;
        Q_UNUSED(__qt_return_value)
        __java_return_value = __qt_i0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::readRawData(char*,qint64)
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_readRawData_1native_1char_1ptr_1qint64__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject arg__1)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::readRawData(char*,qint64)", __this_nativeId)
        qint64 len1{0};
        JBufferData __qt_arg__1_buffer(__jni_env, arg__1);
        char* __qt_arg__1 = __qt_arg__1_buffer.data<char>();
        len1 = __qt_arg__1_buffer.size<char>();
        qint64 __qt_return_value = __qt_this->readRawData(__qt_arg__1, static_cast<qint64>(len1));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::resetStatus()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_resetStatus_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::resetStatus()", __this_nativeId)
        __qt_this->resetStatus();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDataStream::rollbackTransaction()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_rollbackTransaction_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::rollbackTransaction()", __this_nativeId)
        __qt_this->rollbackTransaction();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDataStream::setByteOrder(QDataStream::ByteOrder)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_setByteOrder_1native_1QDataStream_1ByteOrder__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::setByteOrder(QDataStream::ByteOrder)", __this_nativeId)
        QDataStream::ByteOrder __qt_arg__1 = qtjambi_cast<QDataStream::ByteOrder>(__jni_env, arg__1);
        __qt_this->setByteOrder(QDataStream::ByteOrder(__qt_arg__1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDataStream::setDevice(QIODevice*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_setDevice_1native_1QIODevice_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::setDevice(QIODevice*)", __this_nativeId)
        QIODevice* __qt_arg__1 = QtJambiAPI::objectFromNativeId<QIODevice>(arg__1);
        __qt_this->setDevice(__qt_arg__1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDataStream::setFloatingPointPrecision(QDataStream::FloatingPointPrecision)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_setFloatingPointPrecision_1native_1QDataStream_1FloatingPointPrecision__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint precision0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::setFloatingPointPrecision(QDataStream::FloatingPointPrecision)", __this_nativeId)
        QDataStream::FloatingPointPrecision __qt_precision0 = qtjambi_cast<QDataStream::FloatingPointPrecision>(__jni_env, precision0);
        __qt_this->setFloatingPointPrecision(QDataStream::FloatingPointPrecision(__qt_precision0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDataStream::setStatus(QDataStream::Status)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_setStatus_1native_1QDataStream_1Status__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint status0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::setStatus(QDataStream::Status)", __this_nativeId)
        QDataStream::Status __qt_status0 = qtjambi_cast<QDataStream::Status>(__jni_env, status0);
        __qt_this->setStatus(QDataStream::Status(__qt_status0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDataStream::setVersion(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_setVersion_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::setVersion(int)", __this_nativeId)
        __qt_this->setVersion(static_cast<int>(arg__1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDataStream::skipRawData(qint64)
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_skipRawData_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong len0)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::skipRawData(qint64)", __this_nativeId)
        qint64 __qt_return_value = __qt_this->skipRawData(static_cast<qint64>(len0));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::startTransaction()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_startTransaction_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::startTransaction()", __this_nativeId)
        __qt_this->startTransaction();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDataStream::status()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_status_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::status()const", __this_nativeId)
        QDataStream::Status __qt_return_value = __qt_this->status();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::version()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_version_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::version()const", __this_nativeId)
        __java_return_value = __qt_this->version();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDataStream::writeRawData(const char*,qint64)
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDataStream_writeRawData_1native_1const_1char_1ptr_1qint64__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring arg__1)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        QDataStream *__qt_this = QtJambiAPI::objectFromNativeId<QDataStream>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDataStream::writeRawData(const char*,qint64)", __this_nativeId)
        qint64 len1{0};
        JBufferConstData __qt_arg__1_buffer(__jni_env, arg__1);
        const char* __qt_arg__1 = __qt_arg__1_buffer.data<char>();
        len1 = __qt_arg__1_buffer.size<char>();
        qint64 __qt_return_value = __qt_this->writeRawData(__qt_arg__1, static_cast<qint64>(len1));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QDataStream(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QDataStream>("QDataStream", "io/qt/core/QDataStream");
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QDataStream, {
        ConstructorInfo(&__qt_construct_QDataStream, nullptr)
       ,ConstructorInfo(&__qt_construct_QDataStream_cref_QByteArray, "Lio/qt/core/QByteArray;")
       ,ConstructorInfo(&__qt_construct_QDataStream_QByteArray_ptr_QIODeviceBase_OpenMode, "Lio/qt/core/QByteArray;Lio/qt/core/QIODeviceBase$OpenMode;")
       ,ConstructorInfo(&__qt_construct_QDataStream_QIODevice_ptr, "Lio/qt/core/QIODevice;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QDataStream);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids

    registerInterfaceOffset(typeId, typeid(QIODeviceBase), int(reinterpret_cast<quintptr>(static_cast<QIODeviceBase *>(reinterpret_cast<QDataStream *>(0x10000000)))) - 0x10000000);

// BEGIN: enums and flags
    registerEnumTypeInfo<QDataStream::ByteOrder>("QDataStream::ByteOrder", "io/qt/core/QDataStream$ByteOrder");
    registerEnumTypeInfo<QDataStream::FloatingPointPrecision>("QDataStream::FloatingPointPrecision", "io/qt/core/QDataStream$FloatingPointPrecision");
    registerEnumTypeInfo<QDataStream::Status>("QDataStream::Status", "io/qt/core/QDataStream$Status");
    registerEnumTypeInfo<QDataStream::Version>("QDataStream::Version", "io/qt/core/QDataStream$Version");
// END: enums and flags
}
