#include <QtCore/QtGlobal>
#include <QtCore/qchar.h>
#include <QtCore/QVariant>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QChar(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QChar")
    QChar *_ptr = reinterpret_cast<QChar *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// emitting  (functionsInTargetLang writeFinalFunction)
// QChar::category(char32_t)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_category_1native_1char32_1t__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::category(char32_t)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QChar::Category __qt_return_value = QChar::category(static_cast<char32_t>(ucs40));
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::combiningClass(char32_t)
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_combiningClass__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::combiningClass(char32_t)")
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        unsigned char __qt_return_value = QChar::combiningClass(static_cast<char32_t>(ucs40));
        __java_return_value = jbyte(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::currentUnicodeVersion()
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_currentUnicodeVersion_1native__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::currentUnicodeVersion()")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QChar::UnicodeVersion __qt_return_value = QChar::currentUnicodeVersion();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::decomposition(char32_t)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_decomposition__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::decomposition(char32_t)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QChar::decomposition(static_cast<char32_t>(ucs40));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::decompositionTag(char32_t)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_decompositionTag_1native_1char32_1t__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::decompositionTag(char32_t)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QChar::Decomposition __qt_return_value = QChar::decompositionTag(static_cast<char32_t>(ucs40));
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::digitValue(char32_t)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_digitValue__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::digitValue(char32_t)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::digitValue(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::direction(char32_t)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_direction_1native_1char32_1t__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::direction(char32_t)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QChar::Direction __qt_return_value = QChar::direction(static_cast<char32_t>(ucs40));
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::fromLatin1(char)
extern "C" Q_DECL_EXPORT jchar JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_fromLatin1__B)
(JNIEnv *__jni_env,
 jclass,
 jbyte c0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::fromLatin1(char)")
    jchar __java_return_value{0};
    QTJAMBI_TRY {
        QChar __qt_return_value = QChar::fromLatin1(static_cast<char>(c0));
        __java_return_value = __qt_return_value.unicode();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::fromUcs4(char32_t)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_fromUcs4__I)
(JNIEnv *__jni_env,
 jclass,
 jint c0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::fromUcs4(char32_t)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        auto __qt_return_value = QChar::fromUcs4(static_cast<char32_t>(c0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, QStringView(__qt_return_value));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::hasMirrored(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_hasMirrored__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::hasMirrored(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::hasMirrored(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::highSurrogate(char32_t)
extern "C" Q_DECL_EXPORT jchar JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_highSurrogate__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::highSurrogate(char32_t)")
    jchar __java_return_value{0};
    QTJAMBI_TRY {
        char16_t __qt_return_value = QChar::highSurrogate(static_cast<char32_t>(ucs40));
        __java_return_value = jchar(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isDigit(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isDigit__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isDigit(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isDigit(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isHighSurrogate(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isHighSurrogate__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isHighSurrogate(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isHighSurrogate(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isLetter(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isLetter__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isLetter(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isLetter(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isLetterOrNumber(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isLetterOrNumber__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isLetterOrNumber(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isLetterOrNumber(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isLowSurrogate(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isLowSurrogate__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isLowSurrogate(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isLowSurrogate(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isLower(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isLower__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isLower(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isLower(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isMark(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isMark__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isMark(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isMark(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isNonCharacter(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isNonCharacter__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isNonCharacter(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isNonCharacter(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isNumber(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isNumber__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isNumber(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isNumber(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isPrint(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isPrint__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isPrint(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isPrint(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isPunct(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isPunct__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isPunct(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isPunct(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isSpace(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isSpace__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isSpace(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isSpace(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isSurrogate(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isSurrogate__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isSurrogate(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isSurrogate(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isSymbol(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isSymbol__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isSymbol(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isSymbol(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isTitleCase(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isTitleCase__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isTitleCase(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isTitleCase(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::isUpper(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_isUpper__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::isUpper(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::isUpper(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::joiningType(char32_t)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_joiningType_1native_1char32_1t__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::joiningType(char32_t)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QChar::JoiningType __qt_return_value = QChar::joiningType(static_cast<char32_t>(ucs40));
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::lowSurrogate(char32_t)
extern "C" Q_DECL_EXPORT jchar JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_lowSurrogate__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::lowSurrogate(char32_t)")
    jchar __java_return_value{0};
    QTJAMBI_TRY {
        char16_t __qt_return_value = QChar::lowSurrogate(static_cast<char32_t>(ucs40));
        __java_return_value = jchar(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::mirroredChar(char32_t)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_mirroredChar__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::mirroredChar(char32_t)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        char32_t __qt_return_value = QChar::mirroredChar(static_cast<char32_t>(ucs40));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::requiresSurrogates(char32_t)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_requiresSurrogates__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::requiresSurrogates(char32_t)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QChar::requiresSurrogates(static_cast<char32_t>(ucs40));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::script(char32_t)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_script_1native_1char32_1t__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::script(char32_t)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QChar::Script __qt_return_value = QChar::script(static_cast<char32_t>(ucs40));
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::surrogateToUcs4(QChar,QChar)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_surrogateToUcs4__CC)
(JNIEnv *__jni_env,
 jclass,
 jchar high0,
 jchar low1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::surrogateToUcs4(QChar,QChar)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QChar __qt_high0 = qtjambi_cast<QChar>(__jni_env, high0);
        QChar __qt_low1 = qtjambi_cast<QChar>(__jni_env, low1);
        char32_t __qt_return_value = QChar::surrogateToUcs4(__qt_high0, __qt_low1);
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::toCaseFolded(char32_t)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_toCaseFolded__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::toCaseFolded(char32_t)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        char32_t __qt_return_value = QChar::toCaseFolded(static_cast<char32_t>(ucs40));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::toLower(char32_t)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_toLower__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::toLower(char32_t)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        char32_t __qt_return_value = QChar::toLower(static_cast<char32_t>(ucs40));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::toTitleCase(char32_t)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_toTitleCase__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::toTitleCase(char32_t)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        char32_t __qt_return_value = QChar::toTitleCase(static_cast<char32_t>(ucs40));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::toUpper(char32_t)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_toUpper__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::toUpper(char32_t)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        char32_t __qt_return_value = QChar::toUpper(static_cast<char32_t>(ucs40));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QChar::unicodeVersion(char32_t)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_unicodeVersion_1native_1char32_1t__I)
(JNIEnv *__jni_env,
 jclass,
 jint ucs40)
{
    QTJAMBI_NATIVE_METHOD_CALL("QChar::unicodeVersion(char32_t)")
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QChar::UnicodeVersion __qt_return_value = QChar::unicodeVersion(static_cast<char32_t>(ucs40));
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QChar_toString_1native)(JNIEnv *__jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QChar *__qt_this = QtJambiAPI::objectFromNativeId<QChar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, QVariant(*__qt_this).toString());
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

void initialize_meta_info_QChar(){
    using namespace RegistryAPI;

// BEGIN: enums and flags
    registerEnumTypeInfo<QChar::Category>("QChar::Category", "io/qt/core/QChar$Category");
    registerEnumTypeInfo<QChar::CombiningClass>("QChar::CombiningClass", "io/qt/core/QChar$CombiningClass");
    registerEnumTypeInfo<QChar::Decomposition>("QChar::Decomposition", "io/qt/core/QChar$Decomposition");
    registerEnumTypeInfo<QChar::Direction>("QChar::Direction", "io/qt/core/QChar$Direction");
    registerEnumTypeInfo<QChar::JoiningType>("QChar::JoiningType", "io/qt/core/QChar$JoiningType");
    registerEnumTypeInfo<QChar::Script>("QChar::Script", "io/qt/core/QChar$Script");
    registerEnumTypeInfo<QChar::SpecialCharacter>("QChar::SpecialCharacter", "io/qt/core/QChar$SpecialCharacter");
    registerEnumTypeInfo<QChar::UnicodeVersion>("QChar::UnicodeVersion", "io/qt/core/QChar$UnicodeVersion");
// END: enums and flags
}
