#include <QtCore/QtGlobal>
#include <qtcore-config.h>
#if QT_CONFIG(cborstreamwriter)
#include <QtCore/qcborstreamwriter.h>
#endif //QT_CONFIG(cborstreamwriter)
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qcborcommon.h>
#include <QtCore/qiodevice.h>
#include "utils_p.h"

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

#if QT_CONFIG(cborstreamwriter)


void deleter_QCborStreamWriter(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QCborStreamWriter")
    QCborStreamWriter *_ptr = reinterpret_cast<QCborStreamWriter *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}


#endif // QT_CONFIG(cborstreamwriter)

// emitting (writeConstructors)
// new QCborStreamWriter(QByteArray*)
void __qt_construct_QCborStreamWriter_QByteArray_ptr(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCborStreamWriter(QByteArray*)")
#if QT_CONFIG(cborstreamwriter)
    jobject data0 = __java_arguments[0].l;
    QByteArray* __qt_data0 = qtjambi_cast<QByteArray*>(__jni_env, data0);
    QCborStreamWriter *__qt_this = new(__qtjambi_ptr) QCborStreamWriter(__qt_data0);
    Q_UNUSED(__qt_this)
    if(__qtjambi_is_generic){
        Java::QtJambi::ReferenceUtility::setReferenceCount(__jni_env, __jni_object, nullptr, __jni_env->NewStringUTF("__rcDevice"), false, false, data0);
    }
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
}

// QCborStreamWriter::QCborStreamWriter(QByteArray*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_initialize_1native__Lio_qt_core_QCborStreamWriter_2Lio_qt_core_QByteArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject data0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCborStreamWriter::QCborStreamWriter(QByteArray*)")
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        jvalue arguments;
        arguments.l = data0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCborStreamWriter_QByteArray_ptr, sizeof(QCborStreamWriter), typeid(QCborStreamWriter), 0, false, &deleter_QCborStreamWriter, &arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(data0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QCborStreamWriter(QIODevice*)
void __qt_construct_QCborStreamWriter_QIODevice_ptr(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCborStreamWriter(QIODevice*)")
#if QT_CONFIG(cborstreamwriter)
    jobject device0 = __java_arguments[0].l;
    QIODevice* __qt_device0 = qtjambi_cast<QIODevice*>(__jni_env, device0);
    QCborStreamWriter *__qt_this = new(__qtjambi_ptr) QCborStreamWriter(__qt_device0);
    Q_UNUSED(__qt_this)
    if(__qtjambi_is_generic){
        Java::QtJambi::ReferenceUtility::setReferenceCount(__jni_env, __jni_object, nullptr, __jni_env->NewStringUTF("__rcDevice"), false, false, device0);
    }
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
}

// QCborStreamWriter::QCborStreamWriter(QIODevice*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_initialize_1native__Lio_qt_core_QCborStreamWriter_2Lio_qt_core_QIODevice_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject device0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCborStreamWriter::QCborStreamWriter(QIODevice*)")
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        jvalue arguments;
        arguments.l = device0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCborStreamWriter_QIODevice_ptr, sizeof(QCborStreamWriter), typeid(QCborStreamWriter), 0, false, &deleter_QCborStreamWriter, &arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(device0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QCborStreamWriter
void __qt_destruct_QCborStreamWriter(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QCborStreamWriter")

#if QT_CONFIG(cborstreamwriter)

    reinterpret_cast<QCborStreamWriter*>(ptr)->~QCborStreamWriter();

#else
    Q_UNUSED(ptr)

#endif // QT_CONFIG(cborstreamwriter)

}

// emitting  (functionsInTargetLang writeFinalFunction)
// QCborStreamWriter::append(QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID ba0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::append(QByteArray)", __this_nativeId)
        const QByteArray& __qt_ba0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(ba0);
        __qt_this->append(__qt_ba0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(ba0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::append(QCborKnownTags)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1QCborKnownTags__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint tag0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::append(QCborKnownTags)", __this_nativeId)
        QCborKnownTags __qt_tag0 = qtjambi_cast<QCborKnownTags>(__jni_env, tag0);
        __qt_this->append(QCborKnownTags(__qt_tag0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(tag0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::append(QCborSimpleType)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1QCborSimpleType__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte st0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::append(QCborSimpleType)", __this_nativeId)
        QCborSimpleType __qt_st0 = qtjambi_cast<QCborSimpleType>(__jni_env, st0);
        __qt_this->append(QCborSimpleType(__qt_st0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(st0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::append(QCborTag)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1QCborTag__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong tag0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::append(QCborTag)", __this_nativeId)
        QCborTag __qt_tag0 = qtjambi_cast<QCborTag>(__jni_env, tag0);
        __qt_this->append(QCborTag(__qt_tag0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(tag0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::append(QStringView)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1QStringView__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring str0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__qtjambi_scope)
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::append(QStringView)", __this_nativeId)
        QStringView __qt_str0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, str0);
        __qt_this->append(__qt_str0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(str0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::append(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean b0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::append(bool)", __this_nativeId)
        __qt_this->append(static_cast<bool>(b0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(b0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::append(const char*,qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1const_1char_1ptr_1qsizetype__J_3BII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyteArray str0,
 jint __qt_offset_of_str0,
 jint size1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::append(const char*,qsizetype)", __this_nativeId)
        JByteArrayPointer __qt_str0_buffer(__jni_env, str0, false);
        const char* __qt_str0 = __qt_str0_buffer;
        if(__qt_str0){
            if(size1<0)
                size1 = decltype(size1)(__qt_str0_buffer.size());
            if(__qt_offset_of_str0>0)
                __qt_str0 += __qt_offset_of_str0;
            if(__qt_str0_buffer.size() - __qt_offset_of_str0 < size1)
                JavaException::raiseIndexOutOfBoundsException(__jni_env, "Given offset and length exceed actual array length." QTJAMBI_STACKTRACEINFO );
        }else{
            size1 = 0;
        }
        __qt_this->append(__qt_str0, static_cast<qsizetype>(size1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(str0)
        Q_UNUSED(size1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::append(double)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1double__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble d0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::append(double)", __this_nativeId)
        __qt_this->append(static_cast<double>(d0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(d0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::append(float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat f0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::append(float)", __this_nativeId)
        __qt_this->append(static_cast<float>(f0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(f0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::append(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::append(int)", __this_nativeId)
        __qt_this->append(static_cast<int>(i0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(i0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::append(qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong i0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::append(qint64)", __this_nativeId)
        __qt_this->append(static_cast<qint64>(i0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(i0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::append(quint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1quint64__JLjava_math_BigInteger_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject u0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::append(quint64)", __this_nativeId)
        BigIntegerValue bigIntegerValue = fromBigInteger(__jni_env, u0);
        if(bigIntegerValue.outOfRange){
            Java::Runtime::ArithmeticException::throwNew(__jni_env, "BigInteger is out of range of 64 Bit." QTJAMBI_STACKTRACEINFO );
            return;
        }
        if(bigIntegerValue.isNegative){
            __qt_this->append(QCborNegativeInteger(bigIntegerValue.value));
            return;
        }
        quint64 __qt_u0 = bigIntegerValue.value;
        __qt_this->append(quint64(__qt_u0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(u0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::appendByteString(const char*,qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_append_1native_1const_1char_1ptr_1qsizetype__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring data0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::appendByteString(const char*,qsizetype)", __this_nativeId)
        qsizetype len1{0};
        JBufferConstData __qt_data0_buffer(__jni_env, data0);
        const char* __qt_data0 = __qt_data0_buffer.data<char>();
        len1 = __qt_data0_buffer.size<char>();
        __qt_this->appendByteString(__qt_data0, static_cast<qsizetype>(len1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(data0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::appendNull()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_appendNull_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::appendNull()", __this_nativeId)
        __qt_this->appendNull();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::appendUndefined()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_appendUndefined_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::appendUndefined()", __this_nativeId)
        __qt_this->appendUndefined();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::device()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_device_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        const QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::device()const", __this_nativeId)
        QIODevice* __qt_return_value = __qt_this->device();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamWriter::endArray()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_endArray_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::endArray()", __this_nativeId)
        __java_return_value = __qt_this->endArray();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamWriter::endMap()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_endMap_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::endMap()", __this_nativeId)
        __java_return_value = __qt_this->endMap();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamWriter::setDevice(QIODevice*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_setDevice_1native_1QIODevice_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID device0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::setDevice(QIODevice*)", __this_nativeId)
        QIODevice* __qt_device0 = QtJambiAPI::objectFromNativeId<QIODevice>(device0);
        __qt_this->setDevice(__qt_device0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(device0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::startArray()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_startArray_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::startArray()", __this_nativeId)
        __qt_this->startArray();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::startArray(quint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_startArray_1native_1quint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong count0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::startArray(quint64)", __this_nativeId)
        __qt_this->startArray(static_cast<quint64>(count0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(count0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::startMap()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_startMap_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::startMap()", __this_nativeId)
        __qt_this->startMap();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamWriter::startMap(quint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamWriter_startMap_1native_1quint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong count0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamwriter)
        QCborStreamWriter *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamWriter>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamWriter::startMap(quint64)", __this_nativeId)
        __qt_this->startMap(static_cast<quint64>(count0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(count0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamwriter)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QCborStreamWriter(){
    using namespace RegistryAPI;

#if QT_CONFIG(cborstreamwriter)

    const std::type_info& typeId = registerObjectTypeInfo<QCborStreamWriter>("QCborStreamWriter", "io/qt/core/QCborStreamWriter");
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QCborStreamWriter, {
        ConstructorInfo(&__qt_construct_QCborStreamWriter_QByteArray_ptr, "Lio/qt/core/QByteArray;")
       ,ConstructorInfo(&__qt_construct_QCborStreamWriter_QIODevice_ptr, "Lio/qt/core/QIODevice;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QCborStreamWriter);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags

#endif //QT_CONFIG(cborstreamwriter)

}
