#ifndef QABSTRACTFILEENGINEHANDLER_SHELL_H
#define QABSTRACTFILEENGINEHANDLER_SHELL_H

#include <QtCore/QtGlobal>
#include <QtCore/private/qabstractfileengine_p.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtJambi/RegistryAPI>


class QAbstractFileEngineHandler_shell : public QAbstractFileEngineHandler, public QtJambiShellInterface
{
public:
    QAbstractFileEngineHandler_shell();
    ~QAbstractFileEngineHandler_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QAbstractFileEngineHandler_oshell;
};


class QAbstractFileEngineHandler_oshell : public QAbstractFileEngineHandler_shell
{
public:
    using QAbstractFileEngineHandler_shell::QAbstractFileEngineHandler_shell;
    QAbstractFileEngine* create(const QString& fileName0) const override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QAbstractFileEngineHandler_access : public QAbstractFileEngineHandler
{
    jobject __qt_create_cref_QString_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring fileName0) const;
};

#endif // QABSTRACTFILEENGINEHANDLER_SHELL_H
