#ifndef QLAYOUTITEM_IMPL_SHELL_H
#define QLAYOUTITEM_IMPL_SHELL_H

#include <QtCore/QtGlobal>
#include <QtWidgets/qlayoutitem.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qrect.h>
#include <QtCore/qsize.h>
#include <QtWidgets/qlayout.h>
#include <QtWidgets/qwidget.h>
#include <QtJambi/RegistryAPI>


class QLayoutItem_shell : public QLayoutItem, public QtJambiShellInterface
{
public:
    QLayoutItem_shell(Qt::Alignment alignment0 = Qt::Alignment());
    ~QLayoutItem_shell() override;

    QSizePolicy::ControlTypes controlTypes() const override;
    Qt::Orientations expandingDirections() const override;
    QRect geometry() const override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void invalidate() override;
    bool isEmpty() const override;
    QLayout* layout() override;
    QSize maximumSize() const override;
    int minimumHeightForWidth(int arg__1) const override;
    QSize minimumSize() const override;
    void setGeometry(const QRect& arg__1) override;
    QSize sizeHint() const override;
    QSpacerItem* spacerItem() override;
    QWidget* widget() override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QLayoutItem_access : public QLayoutItem
{
    jint __qt_controlTypes_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_expandingDirections_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_geometry_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_hasHeightForWidth_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_heightForWidth_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint arg__1) const;
    void __qt_invalidate(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jboolean __qt_isEmpty_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_layout(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_maximumSize_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_minimumHeightForWidth_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint arg__1) const;
    jobject __qt_minimumSize_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_setGeometry_cref_QRect(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID arg__1);
    jobject __qt_sizeHint_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_spacerItem(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_widget(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
};

#endif // QLAYOUTITEM_IMPL_SHELL_H
