#include <QtCore/QtGlobal>
#include <QtWidgets/qcolormap.h>
#include <QColor>
#include <QtCore/QVariant>
#include <QtCore/QVector>
#include <QtGui/qcolor.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QColormap(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QColormap")
    QColormap *_ptr = reinterpret_cast<QColormap *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QColormap(QColormap)
void __qt_construct_QColormap_cref_QColormap(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QColormap(QColormap)")
    jobject colormap0 = __java_arguments[0].l;
    const QColormap& __qt_colormap0 = qtjambi_cast<const QColormap& >(__jni_env, colormap0);
    QColormap *__qt_this = new(__qtjambi_ptr) QColormap(__qt_colormap0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QColormap::QColormap(QColormap)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QColormap_initialize_1native__Lio_qt_widgets_QColormap_2Lio_qt_widgets_QColormap_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject colormap0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QColormap::QColormap(QColormap)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = colormap0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QColormap_cref_QColormap, sizeof(QColormap), typeid(QColormap), false, &deleter_QColormap, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QColormap
void __qt_destruct_QColormap(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QColormap")
    reinterpret_cast<QColormap*>(ptr)->~QColormap();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QColormap::colorAt(uint)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QColormap_colorAt_1native_1uint_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pixel0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QColormap *__qt_this = QtJambiAPI::objectFromNativeId<QColormap>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColormap::colorAt(uint)const", __qt_this)
        const QColor __qt_return_value = __qt_this->colorAt(static_cast<uint>(pixel0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QColormap::colormap()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QColormap_colormap_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QColormap *__qt_this = QtJambiAPI::objectFromNativeId<QColormap>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColormap::colormap()const", __qt_this)
        const QVector<QColor> __qt_return_value = __qt_this->colormap();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QColormap::depth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QColormap_depth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QColormap *__qt_this = QtJambiAPI::objectFromNativeId<QColormap>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColormap::depth()const", __qt_this)
        __java_return_value = __qt_this->depth();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QColormap::mode()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QColormap_mode_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QColormap *__qt_this = QtJambiAPI::objectFromNativeId<QColormap>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColormap::mode()const", __qt_this)
        QColormap::Mode __qt_return_value = __qt_this->mode();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QColormap::operator=(QColormap)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QColormap_assign_1native_1cref_1QColormap__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID colormap0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QColormap *__qt_this = QtJambiAPI::objectFromNativeId<QColormap>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColormap::operator=(QColormap)", __qt_this)
        const QColormap& __qt_colormap0 = QtJambiAPI::objectReferenceFromNativeId<QColormap>(__jni_env, colormap0);
        (*__qt_this) = __qt_colormap0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QColormap::pixel(QColor)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QColormap_pixel_1native_1cref_1QColor_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID color0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QColormap *__qt_this = QtJambiAPI::objectFromNativeId<QColormap>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColormap::pixel(QColor)const", __qt_this)
        const QColor& __qt_color0 = QtJambiAPI::valueReferenceFromNativeId<QColor>(color0);
        uint __qt_return_value = __qt_this->pixel(__qt_color0);
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QColormap::size()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QColormap_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QColormap *__qt_this = QtJambiAPI::objectFromNativeId<QColormap>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QColormap::size()const", __qt_this)
        __java_return_value = __qt_this->size();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QColormap::instance(int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QColormap_instance__I)
(JNIEnv *__jni_env,
 jclass,
 jint screen0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QColormap::instance(int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QColormap __qt_return_value = QColormap::instance(static_cast<int>(screen0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeCustomStructors)
void* custom_constructor_QColormap(void* placement, const void * __in_var)
{
    Q_UNUSED(placement)
    const QColormap* copy = static_cast<const QColormap*>(__in_var);
    Q_UNUSED(copy)
    if(copy)
        return new(placement) QColormap(*copy);
    else
        return new(placement) QColormap(QColormap::instance());
}
// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QColormap_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QColormap *__qt_this = QtJambiAPI::objectFromNativeId<QColormap>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QColormap(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QColormap>("QColormap", "io/qt/widgets/QColormap");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QColormap, {
        ConstructorInfo(&__qt_construct_QColormap_cref_QColormap, "Lio/qt/widgets/QColormap;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QColormap);
    registerMetaType<QColormap>("QColormap", &custom_constructor_QColormap);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QColormap::Mode>("QColormap::Mode", "io/qt/widgets/QColormap$Mode");
// END: enums and flags
}
