#ifndef QPICTUREIOHANDLER_SHELL_H
#define QPICTUREIOHANDLER_SHELL_H

#include <QtCore/QtGlobal>
#include <QtJambi/QtJambiAPI>
#include <QtJambi/FunctionalBase>
#include <QtGui/QPictureIO>


class QPictureIOHandler_shell final : public FunctionalBase
{
public:
    QPictureIOHandler_shell();
    ~QPictureIOHandler_shell() override;
    void getFunctional(JNIEnv*, void*) override;
    static void operator delete(void * ptr) noexcept;

    class Functor final : private FunctorBase{
    public:
        Functor(const Functor& functor);
        ~Functor() override;
        void operator()(QPictureIO* arg__1);
    private:
        Functor(QPictureIOHandler_shell& functional);
        friend class QPictureIOHandler_shell;
    };

    static jobject resolveFunctional(JNIEnv *, const void*, bool* ok);

private:
    QtJambiShell* __shell() const override final;
    friend class QPictureIOHandler_shell::Functor;
    std::function<void()> m_functionPointerDeleter;
    static std::function<const Functor*(picture_io_handler)> reverseFunctionGetter;
};

#endif // QPICTUREIOHANDLER_SHELL_H
