#ifndef QPAGEDPAINTDEVICE_IMPL_SHELL_H
#define QPAGEDPAINTDEVICE_IMPL_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/qpagedpaintdevice.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qmargins.h>
#include <QtCore/qpoint.h>
#include <QtCore/qsize.h>
#include <QtGui/qpagelayout.h>
#include <QtGui/qpagesize.h>
#include <QtGui/qpaintdevice.h>
#include <QtGui/qpaintengine.h>
#include <QtGui/qpainter.h>
#include <QtJambi/RegistryAPI>


class QPagedPaintDevice_shell : public QPagedPaintDevice, public QtJambiShellInterface
{
public:
    QPagedPaintDevice_shell();
    ~QPagedPaintDevice_shell() override;

    void initPainter(QPainter* painter0) const override;
    int metric(QPaintDevice::PaintDeviceMetric metric0) const override;
    bool newPage() override;
    QPaintEngine* paintEngine() const override;
    QPaintDevice* redirected(QPoint* offset0) const override;
    void setMargins(const QPagedPaintDevice::Margins& margins0) override;
    void setPageSize(QPagedPaintDevice::PageSize size0) override;
    void setPageSizeMM(const QSizeF& size0) override;
    QPainter* sharedPainter() const override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QPagedPaintDevice_access : public QPagedPaintDevice
{
    jobject __qt_devicePageLayout_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_initPainter_QPainter_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID painter0) const;
    jint __qt_metric_QPaintDevice_PaintDeviceMetric_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint metric0) const;
    jboolean __qt_newPage(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_paintEngine_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_redirected_QPoint_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID offset0) const;
    void __qt_setMargins_cref_QPagedPaintDevice_Margins(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID margins0);
    void __qt_setPageSize_QPagedPaintDevice_PageSize(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint size0);
    void __qt_setPageSizeMM_cref_QSizeF(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID size0);
    jobject __qt_sharedPainter_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QPAGEDPAINTDEVICE_IMPL_SHELL_H
