#include "QOpenGLPaintDevice_shell.h"
#include <QtJambi/Cast>

void deleter_QOpenGLPaintDevice(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QOpenGLPaintDevice")
    QOpenGLPaintDevice *_ptr = reinterpret_cast<QOpenGLPaintDevice *>(ptr);
    if(!isShell){
        struct PaintDeviceAccess : QPaintDevice{
            inline QPainter* getSharedPainter() const { return sharedPainter(); }
        };
        if(QPainter* painter = reinterpret_cast<PaintDeviceAccess*>(dynamic_cast<QPaintDevice*>(_ptr))->getSharedPainter()){
            if(painter->isActive()){
                painter->end();
            }
        }
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QOpenGLPaintDevice_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QOpenGLPaintDevice_shell) ); }

jmethodID QOpenGLPaintDevice_shell::__shell_javaMethod(int pos) const { return QOpenGLPaintDevice_shell::__shell()->javaMethod(typeid(QOpenGLPaintDevice), pos); }

// emitting (writeShellConstructor)
QOpenGLPaintDevice_shell::QOpenGLPaintDevice_shell()
    : QOpenGLPaintDevice()
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QOpenGLPaintDevice::QOpenGLPaintDevice_shell()", QOpenGLPaintDevice_shell::__shell())
    QOpenGLPaintDevice_shell::__shell()->constructed(typeid(QOpenGLPaintDevice));
}

QOpenGLPaintDevice_shell::QOpenGLPaintDevice_shell(const QSize& size0)
    : QOpenGLPaintDevice(size0)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QOpenGLPaintDevice::QOpenGLPaintDevice_shell(const QSize& size0)", QOpenGLPaintDevice_shell::__shell())
    QOpenGLPaintDevice_shell::__shell()->constructed(typeid(QOpenGLPaintDevice));
}

QOpenGLPaintDevice_shell::QOpenGLPaintDevice_shell(int width0, int height1)
    : QOpenGLPaintDevice(width0, height1)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QOpenGLPaintDevice::QOpenGLPaintDevice_shell(int width0, int height1)", QOpenGLPaintDevice_shell::__shell())
    QOpenGLPaintDevice_shell::__shell()->constructed(typeid(QOpenGLPaintDevice));
}

// emitting (writeShellDestructor)
QOpenGLPaintDevice_shell::~QOpenGLPaintDevice_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QOpenGLPaintDevice::~QOpenGLPaintDevice()", QOpenGLPaintDevice_shell::__shell())
    if(QPainter* painter = QOpenGLPaintDevice_shell::sharedPainter()){
        if(painter->isActive()){
            painter->end();
        }
    }
    QOpenGLPaintDevice_shell::__shell()->destructed(typeid(QOpenGLPaintDevice));
}

void QOpenGLPaintDevice_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QOpenGLPaintDevice_shell*>(ptr)->QOpenGLPaintDevice_shell::__shell()->tryDeleteShell(typeid(QOpenGLPaintDevice));
}

// emitting Virtual overrides (virtualFunctions)
void QOpenGLPaintDevice_shell::ensureActiveTarget()
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QOpenGLPaintDevice::ensureActiveTarget()", QOpenGLPaintDevice_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QOpenGLPaintDevice_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    __jni_env->CallVoidMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QOpenGLPaintDevice_shell::__shell()->warnForMethod("QOpenGLPaintDevice::ensureActiveTarget()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QOpenGLPaintDevice::ensureActiveTarget()");
            } QTJAMBI_TRY_END
        }else{
            QOpenGLPaintDevice::ensureActiveTarget();
        }
    }else{
        QOpenGLPaintDevice::ensureActiveTarget();
    }
}

void QOpenGLPaintDevice_shell::initPainter(QPainter* painter0) const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QOpenGLPaintDevice::", QOpenGLPaintDevice_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QOpenGLPaintDevice_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_painter0 = qtjambi_cast<jobject>(__jni_env, painter0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_painter0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_painter0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QOpenGLPaintDevice_shell::__shell()->warnForMethod("QOpenGLPaintDevice::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QOpenGLPaintDevice::");
            } QTJAMBI_TRY_END
        }else{
            QPaintDevice::initPainter(painter0);
        }
    }else{
        QPaintDevice::initPainter(painter0);
    }
}

int QOpenGLPaintDevice_shell::metric(QPaintDevice::PaintDeviceMetric metric0) const
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QOpenGLPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const", QOpenGLPaintDevice_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QOpenGLPaintDevice_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_metric0 = qtjambi_cast<jobject>(__jni_env, metric0);
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_metric0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QOpenGLPaintDevice_shell::__shell()->warnForMethod("QOpenGLPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QOpenGLPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QOpenGLPaintDevice::metric(QPaintDevice::PaintDeviceMetric(metric0));
        }
    }else{
        return QOpenGLPaintDevice::metric(QPaintDevice::PaintDeviceMetric(metric0));
    }
}

QPaintEngine* QOpenGLPaintDevice_shell::paintEngine() const
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QOpenGLPaintDevice::paintEngine()const", QOpenGLPaintDevice_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPaintEngine*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QOpenGLPaintDevice_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPaintEngine* >(__jni_env, __java_return_value);
                } else {
                    QOpenGLPaintDevice_shell::__shell()->warnForMethod("QOpenGLPaintDevice::paintEngine()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QOpenGLPaintDevice::paintEngine()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QOpenGLPaintDevice::paintEngine();
        }
    }else{
        return QOpenGLPaintDevice::paintEngine();
    }
}

QPaintDevice* QOpenGLPaintDevice_shell::redirected(QPoint* offset0) const
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QOpenGLPaintDevice::", QOpenGLPaintDevice_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPaintDevice*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QOpenGLPaintDevice_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_offset0 = qtjambi_cast<jobject>(__jni_env, offset0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_offset0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_offset0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPaintDevice* >(__jni_env, __java_return_value);
                } else {
                    QOpenGLPaintDevice_shell::__shell()->warnForMethod("QOpenGLPaintDevice::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QOpenGLPaintDevice::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintDevice::redirected(offset0);
        }
    }else{
        return QPaintDevice::redirected(offset0);
    }
}

QPainter* QOpenGLPaintDevice_shell::sharedPainter() const
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        QTJAMBI_JAVA_METHOD_CALL("QOpenGLPaintDevice::", QOpenGLPaintDevice_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPainter*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QOpenGLPaintDevice_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPainter* >(__jni_env, __java_return_value);
                } else {
                    QOpenGLPaintDevice_shell::__shell()->warnForMethod("QOpenGLPaintDevice::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QOpenGLPaintDevice::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintDevice::sharedPainter();
        }
    }else{
        return QPaintDevice::sharedPainter();
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
void QOpenGLPaintDevice_access::__qt_ensureActiveTarget(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QOpenGLPaintDevice::ensureActiveTarget();
    } else {
        ensureActiveTarget();
    }
}

void QOpenGLPaintDevice_access::__qt_initPainter_QPainter_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID painter0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPainter* __qt_painter0 = QtJambiAPI::objectFromNativeId<QPainter>(painter0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintDevice::initPainter(__qt_painter0);
    } else {
        initPainter(__qt_painter0);
    }
}

jint QOpenGLPaintDevice_access::__qt_metric_QPaintDevice_PaintDeviceMetric_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint metric0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPaintDevice::PaintDeviceMetric __qt_metric0 = qtjambi_cast<QPaintDevice::PaintDeviceMetric>(__jni_env, metric0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QOpenGLPaintDevice::metric(__qt_metric0);
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = metric(__qt_metric0);
        return jint(__qt_return_value);
    }
}

jobject QOpenGLPaintDevice_access::__qt_paintEngine_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine* __qt_return_value = QOpenGLPaintDevice::paintEngine();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPaintEngine* __qt_return_value = paintEngine();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QOpenGLPaintDevice_access::__qt_redirected_QPoint_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID offset0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPoint* __qt_offset0 = QtJambiAPI::objectFromNativeId<QPoint>(offset0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintDevice* __qt_return_value = QPaintDevice::redirected(__qt_offset0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPaintDevice* __qt_return_value = redirected(__qt_offset0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QOpenGLPaintDevice_access::__qt_sharedPainter_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPainter* __qt_return_value = QPaintDevice::sharedPainter();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPainter* __qt_return_value = sharedPainter();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

// emitting (writeConstructors)
// new QOpenGLPaintDevice()
void __qt_construct_QOpenGLPaintDevice(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLPaintDevice()")
    Q_UNUSED(__java_arguments)
    QOpenGLPaintDevice *__qt_this = new(__qtjambi_ptr) QOpenGLPaintDevice_shell();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QOpenGLPaintDevice::QOpenGLPaintDevice()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_initialize_1native__Lio_qt_gui_QOpenGLPaintDevice_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLPaintDevice::QOpenGLPaintDevice()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLPaintDevice, sizeof(QOpenGLPaintDevice_shell), typeid(QOpenGLPaintDevice), true, &deleter_QOpenGLPaintDevice, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QOpenGLPaintDevice(QSize)
void __qt_construct_QOpenGLPaintDevice_cref_QSize(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLPaintDevice(QSize)")
    jobject size0 = __java_arguments[0].l;
    const QSize& __qt_size0 = qtjambi_cast<const QSize& >(__jni_env, size0);
    QOpenGLPaintDevice *__qt_this = new(__qtjambi_ptr) QOpenGLPaintDevice_shell(__qt_size0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QOpenGLPaintDevice::QOpenGLPaintDevice(QSize)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_initialize_1native__Lio_qt_gui_QOpenGLPaintDevice_2Lio_qt_core_QSize_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject size0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLPaintDevice::QOpenGLPaintDevice(QSize)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = size0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLPaintDevice_cref_QSize, sizeof(QOpenGLPaintDevice_shell), typeid(QOpenGLPaintDevice), true, &deleter_QOpenGLPaintDevice, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QOpenGLPaintDevice(int,int)
void __qt_construct_QOpenGLPaintDevice_int_int(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLPaintDevice(int,int)")
    jint width0 = __java_arguments[0].i;
    Q_UNUSED(width0)
    jint height1 = __java_arguments[1].i;
    Q_UNUSED(height1)
    QOpenGLPaintDevice *__qt_this = new(__qtjambi_ptr) QOpenGLPaintDevice_shell(static_cast<int>(width0), static_cast<int>(height1));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QOpenGLPaintDevice::QOpenGLPaintDevice(int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_initialize_1native__Lio_qt_gui_QOpenGLPaintDevice_2II)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint width0,
 jint height1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLPaintDevice::QOpenGLPaintDevice(int,int)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].i = width0;
        arguments[1].i = height1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLPaintDevice_int_int, sizeof(QOpenGLPaintDevice_shell), typeid(QOpenGLPaintDevice), true, &deleter_QOpenGLPaintDevice, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QOpenGLPaintDevice_shell
void __qt_destruct_QOpenGLPaintDevice(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QOpenGLPaintDevice")
    reinterpret_cast<QOpenGLPaintDevice_shell*>(ptr)->~QOpenGLPaintDevice_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QOpenGLPaintDevice::colorCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_colorCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::colorCount()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::colorCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::context()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_context_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::context()const", __qt_this)
        QOpenGLContext* __qt_return_value = __qt_this->context();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::depth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_depth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::depth()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::depth();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::devicePixelRatio()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_devicePixelRatio_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::devicePixelRatio()const", __qt_this)
        int __qt_return_value = __qt_this->QPaintDevice::devicePixelRatio();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::devicePixelRatioF()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_devicePixelRatioF_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::devicePixelRatioF()const", __qt_this)
        qreal __qt_return_value = __qt_this->QPaintDevice::devicePixelRatioF();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::dotsPerMeterX()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_dotsPerMeterX_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::dotsPerMeterX()const", __qt_this)
        qreal __qt_return_value = __qt_this->dotsPerMeterX();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::dotsPerMeterY()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_dotsPerMeterY_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::dotsPerMeterY()const", __qt_this)
        qreal __qt_return_value = __qt_this->dotsPerMeterY();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::height()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_height_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::height()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::height();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::heightMM()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_heightMM_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::heightMM()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::heightMM();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::logicalDpiX()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_logicalDpiX_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::logicalDpiX()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::logicalDpiX();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::logicalDpiY()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_logicalDpiY_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::logicalDpiY()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::logicalDpiY();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::paintFlipped()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_paintFlipped_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::paintFlipped()const", __qt_this)
        __java_return_value = __qt_this->paintFlipped();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::paintingActive()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_paintingActive_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::paintingActive()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::paintingActive();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::physicalDpiX()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_physicalDpiX_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::physicalDpiX()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::physicalDpiX();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::physicalDpiY()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_physicalDpiY_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::physicalDpiY()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::physicalDpiY();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::setDevicePixelRatio(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_setDevicePixelRatio_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble devicePixelRatio0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::setDevicePixelRatio(qreal)", __qt_this)
        __qt_this->setDevicePixelRatio(static_cast<qreal>(devicePixelRatio0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLPaintDevice::setDotsPerMeterX(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_setDotsPerMeterX_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::setDotsPerMeterX(qreal)", __qt_this)
        __qt_this->setDotsPerMeterX(static_cast<qreal>(arg__1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLPaintDevice::setDotsPerMeterY(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_setDotsPerMeterY_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::setDotsPerMeterY(qreal)", __qt_this)
        __qt_this->setDotsPerMeterY(static_cast<qreal>(arg__1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLPaintDevice::setPaintFlipped(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_setPaintFlipped_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean flipped0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::setPaintFlipped(bool)", __qt_this)
        __qt_this->setPaintFlipped(static_cast<bool>(flipped0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLPaintDevice::setSize(QSize)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_setSize_1native_1cref_1QSize__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID size0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::setSize(QSize)", __qt_this)
        const QSize& __qt_size0 = QtJambiAPI::valueReferenceFromNativeId<QSize>(size0);
        __qt_this->setSize(__qt_size0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLPaintDevice::size()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::size()const", __qt_this)
        QSize __qt_return_value = __qt_this->size();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::width()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_width_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::width()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::width();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::widthMM()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_widthMM_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::widthMM()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::widthMM();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::ensureActiveTarget()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_ensureActiveTarget_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::ensureActiveTarget()", __qt_this)
        static_cast<QOpenGLPaintDevice_access*>(__qt_this)->__qt_ensureActiveTarget(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLPaintDevice::initPainter(QPainter*)const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_initPainter_1native_1QPainter_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID painter0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::initPainter(QPainter*)const", __qt_this)
        static_cast<const QOpenGLPaintDevice_access*>(__qt_this)->__qt_initPainter_QPainter_ptr_constfct(__jni_env, __this_nativeId, painter0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_metric_1native_1QPaintDevice_1PaintDeviceMetric_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint metric0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const", __qt_this)
        __java_return_value = static_cast<const QOpenGLPaintDevice_access*>(__qt_this)->__qt_metric_QPaintDevice_PaintDeviceMetric_constfct(__jni_env, __this_nativeId, metric0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::paintEngine()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_paintEngine_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::paintEngine()const", __qt_this)
        __java_return_value = static_cast<const QOpenGLPaintDevice_access*>(__qt_this)->__qt_paintEngine_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::redirected(QPoint*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_redirected_1native_1QPoint_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID offset0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::redirected(QPoint*)const", __qt_this)
        __java_return_value = static_cast<const QOpenGLPaintDevice_access*>(__qt_this)->__qt_redirected_QPoint_ptr_constfct(__jni_env, __this_nativeId, offset0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::sharedPainter()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_sharedPainter_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLPaintDevice *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLPaintDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLPaintDevice::sharedPainter()const", __qt_this)
        __java_return_value = static_cast<const QOpenGLPaintDevice_access*>(__qt_this)->__qt_sharedPainter_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLPaintDevice::devicePixelRatioFScale()
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLPaintDevice_devicePixelRatioFScale__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLPaintDevice::devicePixelRatioFScale()")
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        qreal __qt_return_value = QOpenGLPaintDevice::devicePixelRatioFScale();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QOpenGLPaintDevice(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QOpenGLPaintDevice>("QOpenGLPaintDevice", "io/qt/gui/QOpenGLPaintDevice");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/* 0 */ "ensureActiveTarget", "()V"),
        FunctionInfo(/* 1 */ "initPainter", "(Lio/qt/gui/QPainter;)V"),
        FunctionInfo(/* 2 */ "metric", "(Lio/qt/gui/QPaintDevice$PaintDeviceMetric;)I"),
        FunctionInfo(/* 3 */ "paintEngine", "()Lio/qt/gui/QPaintEngine;"),
        FunctionInfo(/* 4 */ "redirected", "(Lio/qt/core/QPoint;)Lio/qt/gui/QPaintDevice;"),
        FunctionInfo(/* 5 */ "sharedPainter", "()Lio/qt/gui/QPainter;")});
    registerConstructorInfos(typeId, &__qt_destruct_QOpenGLPaintDevice, {
        ConstructorInfo(&__qt_construct_QOpenGLPaintDevice, nullptr)
       ,ConstructorInfo(&__qt_construct_QOpenGLPaintDevice_cref_QSize, "Lio/qt/core/QSize;")
       ,ConstructorInfo(&__qt_construct_QOpenGLPaintDevice_int_int, "II")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QOpenGLPaintDevice);
    registerSizeOfShell(typeId, sizeof(QOpenGLPaintDevice_shell));
// END: type registration

// BEGIN: polymorphic ids
    registerPolymorphyHandler(typeid(QPaintDevice), typeId, [](void *ptr, qintptr& offset) -> bool {
            QPaintDevice *object = reinterpret_cast<QPaintDevice *>(ptr);
            Q_ASSERT(object);
            bool _result = false;
            QTJAMBI_TRY_ANY {
                if(QOpenGLPaintDevice* _object = dynamic_cast<QOpenGLPaintDevice*>(object)){
                    offset = qintptr(object)-qintptr(_object);
                    _result = true;
                }
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
// END: polymorphic ids

    registerInterfaceOffset(typeId, typeid(QPaintDevice), int(reinterpret_cast<quintptr>(static_cast<QPaintDevice *>(reinterpret_cast<QOpenGLPaintDevice *>(0x10000000)))) - 0x10000000);

// BEGIN: enums and flags
// END: enums and flags
}
