#ifndef QIMAGEIOHANDLER_SHELL_H
#define QIMAGEIOHANDLER_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/qimageiohandler.h>
#include <QtJambi/QtJambiAPI>
#include <QRect>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qiodevice.h>
#include <QtCore/qrect.h>
#include <QtGui/qimage.h>
#include <QtJambi/RegistryAPI>


class QImageIOHandler_shell : public QImageIOHandler, public QtJambiShellInterface
{
public:
    QImageIOHandler_shell();
    ~QImageIOHandler_shell() override;

    bool canRead() const override;
    int currentImageNumber() const override;
    QRect currentImageRect() const override;
    int imageCount() const override;
    bool jumpToImage(int imageNumber0) override;
    bool jumpToNextImage() override;
    int loopCount() const override;
    int nextImageDelay() const override;
    QVariant option(QImageIOHandler::ImageOption option0) const override;
    bool read(QImage* image0) override;
    void setOption(QImageIOHandler::ImageOption option0, const QVariant& value1) override;
    bool supportsOption(QImageIOHandler::ImageOption option0) const override;
    bool write(const QImage& image0) override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QImageIOHandler_access : public QImageIOHandler
{
    jboolean __qt_canRead_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_currentImageNumber_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_currentImageRect_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_imageCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_jumpToImage_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint imageNumber0);
    jboolean __qt_jumpToNextImage(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jint __qt_loopCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_nextImageDelay_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_option_QImageIOHandler_ImageOption_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint option0) const;
    jobject __qt_read_QImage_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_setOption_QImageIOHandler_ImageOption_cref_QVariant(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint option0, jobject value1);
    jboolean __qt_supportsOption_QImageIOHandler_ImageOption_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint option0) const;
    jboolean __qt_write_cref_QImage(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID image0);
};

#endif // QIMAGEIOHANDLER_SHELL_H
