#include "QImageIOHandler_shell.h"
#include <QtJambi/Cast>

void deleter_QImageIOHandler(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QImageIOHandler")
    QImageIOHandler *_ptr = reinterpret_cast<QImageIOHandler *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QImageIOHandler_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QImageIOHandler_shell) ); }

jmethodID QImageIOHandler_shell::__shell_javaMethod(int pos) const { return QImageIOHandler_shell::__shell()->javaMethod(typeid(QImageIOHandler), pos); }

// emitting (writeShellConstructor)
QImageIOHandler_shell::QImageIOHandler_shell()
    : QImageIOHandler()
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QImageIOHandler::QImageIOHandler_shell()", QImageIOHandler_shell::__shell())
    QImageIOHandler_shell::__shell()->constructed(typeid(QImageIOHandler));
}

// emitting (writeShellDestructor)
QImageIOHandler_shell::~QImageIOHandler_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QImageIOHandler::~QImageIOHandler()", QImageIOHandler_shell::__shell())
    QImageIOHandler_shell::__shell()->destructed(typeid(QImageIOHandler));
}

void QImageIOHandler_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QImageIOHandler_shell*>(ptr)->QImageIOHandler_shell::__shell()->tryDeleteShell(typeid(QImageIOHandler));
}

// emitting Virtual overrides (virtualFunctions)
bool QImageIOHandler_shell::canRead() const
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::canRead()const", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::canRead()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::canRead()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

int QImageIOHandler_shell::currentImageNumber() const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::currentImageNumber()const", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::currentImageNumber()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::currentImageNumber()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QImageIOHandler::currentImageNumber();
        }
    }else{
        return QImageIOHandler::currentImageNumber();
    }
}

QRect QImageIOHandler_shell::currentImageRect() const
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::currentImageRect()const", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QRect  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QRect >(__jni_env, __java_return_value);
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::currentImageRect()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::currentImageRect()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QImageIOHandler::currentImageRect();
        }
    }else{
        return QImageIOHandler::currentImageRect();
    }
}

int QImageIOHandler_shell::imageCount() const
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::imageCount()const", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::imageCount()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::imageCount()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QImageIOHandler::imageCount();
        }
    }else{
        return QImageIOHandler::imageCount();
    }
}

bool QImageIOHandler_shell::jumpToImage(int imageNumber0)
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::jumpToImage(int)", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, imageNumber0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::jumpToImage(int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::jumpToImage(int)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QImageIOHandler::jumpToImage(static_cast<int>(imageNumber0));
        }
    }else{
        return QImageIOHandler::jumpToImage(static_cast<int>(imageNumber0));
    }
}

bool QImageIOHandler_shell::jumpToNextImage()
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::jumpToNextImage()", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::jumpToNextImage()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::jumpToNextImage()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QImageIOHandler::jumpToNextImage();
        }
    }else{
        return QImageIOHandler::jumpToNextImage();
    }
}

int QImageIOHandler_shell::loopCount() const
{
    if(jmethodID method_id = __shell_javaMethod(6)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::loopCount()const", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::loopCount()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::loopCount()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QImageIOHandler::loopCount();
        }
    }else{
        return QImageIOHandler::loopCount();
    }
}

int QImageIOHandler_shell::nextImageDelay() const
{
    if(jmethodID method_id = __shell_javaMethod(7)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::nextImageDelay()const", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::nextImageDelay()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::nextImageDelay()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QImageIOHandler::nextImageDelay();
        }
    }else{
        return QImageIOHandler::nextImageDelay();
    }
}

QVariant QImageIOHandler_shell::option(QImageIOHandler::ImageOption option0) const
{
    if(jmethodID method_id = __shell_javaMethod(8)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::option(QImageIOHandler::ImageOption)const", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QVariant  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_option0 = qtjambi_cast<jobject>(__jni_env, option0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_option0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QVariant >(__jni_env, __java_return_value);
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::option(QImageIOHandler::ImageOption)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::option(QImageIOHandler::ImageOption)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QImageIOHandler::option(QImageIOHandler::ImageOption(option0));
        }
    }else{
        return QImageIOHandler::option(QImageIOHandler::ImageOption(option0));
    }
}

bool QImageIOHandler_shell::read(QImage* image0)
{
    if(jmethodID method_id = __shell_javaMethod(9)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::read(QImage*)", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    bool __qt_return_value_tmp = __java_return_value!=nullptr;
                    if(__qt_return_value_tmp && image0)
                        *image0 = qtjambi_cast<const QImage&>(__jni_env, __java_return_value);
                    __qt_return_value = __qt_return_value_tmp;
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::read(QImage*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::read(QImage*)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

void QImageIOHandler_shell::setOption(QImageIOHandler::ImageOption option0, const QVariant& value1)
{
    if(jmethodID method_id = __shell_javaMethod(10)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::setOption(QImageIOHandler::ImageOption,QVariant)", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_option0 = qtjambi_cast<jobject>(__jni_env, option0);
                    jobject __java_value1 = qtjambi_cast<jobject>(__jni_env, value1);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_option0, __java_value1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::setOption(QImageIOHandler::ImageOption,QVariant)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::setOption(QImageIOHandler::ImageOption,QVariant)");
            } QTJAMBI_TRY_END
        }else{
            QImageIOHandler::setOption(QImageIOHandler::ImageOption(option0), value1);
        }
    }else{
        QImageIOHandler::setOption(QImageIOHandler::ImageOption(option0), value1);
    }
}

bool QImageIOHandler_shell::supportsOption(QImageIOHandler::ImageOption option0) const
{
    if(jmethodID method_id = __shell_javaMethod(11)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::supportsOption(QImageIOHandler::ImageOption)const", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_option0 = qtjambi_cast<jobject>(__jni_env, option0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_option0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::supportsOption(QImageIOHandler::ImageOption)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::supportsOption(QImageIOHandler::ImageOption)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QImageIOHandler::supportsOption(QImageIOHandler::ImageOption(option0));
        }
    }else{
        return QImageIOHandler::supportsOption(QImageIOHandler::ImageOption(option0));
    }
}

bool QImageIOHandler_shell::write(const QImage& image0)
{
    if(jmethodID method_id = __shell_javaMethod(12)){
        QTJAMBI_JAVA_METHOD_CALL("QImageIOHandler::write(QImage)", QImageIOHandler_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QImageIOHandler_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_image0 = qtjambi_cast<jobject>(__jni_env, image0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_image0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QImageIOHandler_shell::__shell()->warnForMethod("QImageIOHandler::write(QImage)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QImageIOHandler::write(QImage)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QImageIOHandler::write(image0);
        }
    }else{
        return QImageIOHandler::write(image0);
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
jboolean QImageIOHandler_access::__qt_canRead_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QImageIOHandler::canRead() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QImageIOHandler::canRead() const.";
    } else {
        bool __qt_return_value = canRead();
        return jboolean(__qt_return_value);
    }
}

jint QImageIOHandler_access::__qt_currentImageNumber_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QImageIOHandler::currentImageNumber();
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = currentImageNumber();
        return jint(__qt_return_value);
    }
}

jobject QImageIOHandler_access::__qt_currentImageRect_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QRect __qt_return_value = QImageIOHandler::currentImageRect();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QRect __qt_return_value = currentImageRect();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QImageIOHandler_access::__qt_imageCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QImageIOHandler::imageCount();
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = imageCount();
        return jint(__qt_return_value);
    }
}

jboolean QImageIOHandler_access::__qt_jumpToImage_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint imageNumber0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QImageIOHandler::jumpToImage(static_cast<int>(imageNumber0));
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = jumpToImage(static_cast<int>(imageNumber0));
        return jboolean(__qt_return_value);
    }
}

jboolean QImageIOHandler_access::__qt_jumpToNextImage(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QImageIOHandler::jumpToNextImage();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = jumpToNextImage();
        return jboolean(__qt_return_value);
    }
}

jint QImageIOHandler_access::__qt_loopCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QImageIOHandler::loopCount();
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = loopCount();
        return jint(__qt_return_value);
    }
}

jint QImageIOHandler_access::__qt_nextImageDelay_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QImageIOHandler::nextImageDelay();
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = nextImageDelay();
        return jint(__qt_return_value);
    }
}

jobject QImageIOHandler_access::__qt_option_QImageIOHandler_ImageOption_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint option0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QImageIOHandler::ImageOption __qt_option0 = qtjambi_cast<QImageIOHandler::ImageOption>(__jni_env, option0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QVariant __qt_return_value = QImageIOHandler::option(__qt_option0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QVariant __qt_return_value = option(__qt_option0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QImageIOHandler_access::__qt_read_QImage_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QImage __image;
    QImage* __qt_image0 = &__image;
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QImageIOHandler::read(QImage * image)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QImageIOHandler::read(QImage * image).";
    } else {
        bool __qt_return_value = read(__qt_image0);
        jobject __java_return_value = __qt_return_value ? qtjambi_cast<jobject>(__jni_env, __image) : nullptr;
        return __java_return_value;
    }
}

void QImageIOHandler_access::__qt_setOption_QImageIOHandler_ImageOption_cref_QVariant(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint option0, jobject value1)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QImageIOHandler::ImageOption __qt_option0 = qtjambi_cast<QImageIOHandler::ImageOption>(__jni_env, option0);
    QVariant  __qt_value1 = qtjambi_cast<QVariant >(__jni_env, value1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QImageIOHandler::setOption(__qt_option0, __qt_value1);
    } else {
        setOption(__qt_option0, __qt_value1);
    }
}

jboolean QImageIOHandler_access::__qt_supportsOption_QImageIOHandler_ImageOption_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint option0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QImageIOHandler::ImageOption __qt_option0 = qtjambi_cast<QImageIOHandler::ImageOption>(__jni_env, option0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QImageIOHandler::supportsOption(__qt_option0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = supportsOption(__qt_option0);
        return jboolean(__qt_return_value);
    }
}

jboolean QImageIOHandler_access::__qt_write_cref_QImage(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID image0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QImage& __qt_image0 = QtJambiAPI::valueReferenceFromNativeId<QImage>(image0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QImageIOHandler::write(__qt_image0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = write(__qt_image0);
        return jboolean(__qt_return_value);
    }
}

// emitting (writeConstructors)
// new QImageIOHandler()
void __qt_construct_QImageIOHandler(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QImageIOHandler()")
    Q_UNUSED(__java_arguments)
    QImageIOHandler *__qt_this = new(__qtjambi_ptr) QImageIOHandler_shell();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QImageIOHandler::QImageIOHandler()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_initialize_1native__Lio_qt_gui_QImageIOHandler_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QImageIOHandler::QImageIOHandler()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QImageIOHandler, sizeof(QImageIOHandler_shell), typeid(QImageIOHandler), true, &deleter_QImageIOHandler, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QImageIOHandler_shell
void __qt_destruct_QImageIOHandler(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QImageIOHandler")
    reinterpret_cast<QImageIOHandler_shell*>(ptr)->~QImageIOHandler_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QImageIOHandler::device()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_device_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::device()const", __qt_this)
        QIODevice* __qt_return_value = __qt_this->device();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::format()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_format_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::format()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->format();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::setDevice(QIODevice*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_setDevice_1native_1QIODevice_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID device0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::setDevice(QIODevice*)", __qt_this)
        QIODevice* __qt_device0 = QtJambiAPI::objectFromNativeId<QIODevice>(device0);
        __qt_this->setDevice(__qt_device0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QImageIOHandler::setFormat(QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_setFormat_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID format0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::setFormat(QByteArray)", __qt_this)
        const QByteArray& __qt_format0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(format0);
        __qt_this->setFormat(__qt_format0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QImageIOHandler::canRead()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_00024ConcreteWrapper_canRead_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::canRead()const", __qt_this)
        __java_return_value = static_cast<const QImageIOHandler_access*>(__qt_this)->__qt_canRead_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::currentImageNumber()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_currentImageNumber_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::currentImageNumber()const", __qt_this)
        __java_return_value = static_cast<const QImageIOHandler_access*>(__qt_this)->__qt_currentImageNumber_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::currentImageRect()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_currentImageRect_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::currentImageRect()const", __qt_this)
        __java_return_value = static_cast<const QImageIOHandler_access*>(__qt_this)->__qt_currentImageRect_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::imageCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_imageCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::imageCount()const", __qt_this)
        __java_return_value = static_cast<const QImageIOHandler_access*>(__qt_this)->__qt_imageCount_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::jumpToImage(int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_jumpToImage_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint imageNumber0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::jumpToImage(int)", __qt_this)
        __java_return_value = static_cast<QImageIOHandler_access*>(__qt_this)->__qt_jumpToImage_int(__jni_env, __this_nativeId, imageNumber0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::jumpToNextImage()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_jumpToNextImage_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::jumpToNextImage()", __qt_this)
        __java_return_value = static_cast<QImageIOHandler_access*>(__qt_this)->__qt_jumpToNextImage(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::loopCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_loopCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::loopCount()const", __qt_this)
        __java_return_value = static_cast<const QImageIOHandler_access*>(__qt_this)->__qt_loopCount_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::nextImageDelay()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_nextImageDelay_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::nextImageDelay()const", __qt_this)
        __java_return_value = static_cast<const QImageIOHandler_access*>(__qt_this)->__qt_nextImageDelay_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::option(QImageIOHandler::ImageOption)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_option_1native_1QImageIOHandler_1ImageOption_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint option0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::option(QImageIOHandler::ImageOption)const", __qt_this)
        __java_return_value = static_cast<const QImageIOHandler_access*>(__qt_this)->__qt_option_QImageIOHandler_ImageOption_constfct(__jni_env, __this_nativeId, option0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::read(QImage*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_00024ConcreteWrapper_read_1native_1QImage_1ptr__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::read(QImage*)", __qt_this)
        __java_return_value = static_cast<QImageIOHandler_access*>(__qt_this)->__qt_read_QImage_ptr(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::setOption(QImageIOHandler::ImageOption,QVariant)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_setOption_1native_1QImageIOHandler_1ImageOption_1cref_1QVariant__JILjava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint option0,
 jobject value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::setOption(QImageIOHandler::ImageOption,QVariant)", __qt_this)
        static_cast<QImageIOHandler_access*>(__qt_this)->__qt_setOption_QImageIOHandler_ImageOption_cref_QVariant(__jni_env, __this_nativeId, option0, value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QImageIOHandler::supportsOption(QImageIOHandler::ImageOption)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_supportsOption_1native_1QImageIOHandler_1ImageOption_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint option0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::supportsOption(QImageIOHandler::ImageOption)const", __qt_this)
        __java_return_value = static_cast<const QImageIOHandler_access*>(__qt_this)->__qt_supportsOption_QImageIOHandler_ImageOption_constfct(__jni_env, __this_nativeId, option0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QImageIOHandler::write(QImage)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QImageIOHandler_write_1native_1cref_1QImage__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID image0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QImageIOHandler *__qt_this = QtJambiAPI::objectFromNativeId<QImageIOHandler>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QImageIOHandler::write(QImage)", __qt_this)
        __java_return_value = static_cast<QImageIOHandler_access*>(__qt_this)->__qt_write_cref_QImage(__jni_env, __this_nativeId, image0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QImageIOHandler(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QImageIOHandler>("QImageIOHandler", "io/qt/gui/QImageIOHandler");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/*  0 */ "canRead", "()Z", FunctionInfo::Abstract),
        FunctionInfo(/*  1 */ "currentImageNumber", "()I"),
        FunctionInfo(/*  2 */ "currentImageRect", "()Lio/qt/core/QRect;"),
        FunctionInfo(/*  3 */ "imageCount", "()I"),
        FunctionInfo(/*  4 */ "jumpToImage", "(I)Z"),
        FunctionInfo(/*  5 */ "jumpToNextImage", "()Z"),
        FunctionInfo(/*  6 */ "loopCount", "()I"),
        FunctionInfo(/*  7 */ "nextImageDelay", "()I"),
        FunctionInfo(/*  8 */ "option", "(Lio/qt/gui/QImageIOHandler$ImageOption;)Ljava/lang/Object;"),
        FunctionInfo(/*  9 */ "read", "()Lio/qt/gui/QImage;", FunctionInfo::Abstract),
        FunctionInfo(/* 10 */ "setOption", "(Lio/qt/gui/QImageIOHandler$ImageOption;Ljava/lang/Object;)V"),
        FunctionInfo(/* 11 */ "supportsOption", "(Lio/qt/gui/QImageIOHandler$ImageOption;)Z"),
        FunctionInfo(/* 12 */ "write", "(Lio/qt/gui/QImage;)Z")});
    registerConstructorInfos(typeId, &__qt_destruct_QImageIOHandler, {
        ConstructorInfo(&__qt_construct_QImageIOHandler, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QImageIOHandler);
    registerSizeOfShell(typeId, sizeof(QImageIOHandler_shell));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QImageIOHandler::ImageOption>("QImageIOHandler::ImageOption", "io/qt/gui/QImageIOHandler$ImageOption");
    registerEnumTypeInfo<QImageIOHandler::Transformation>("QImageIOHandler::Transformation", "io/qt/gui/QImageIOHandler$Transformation", "QImageIOHandler::Transformations", "QFlags<QImageIOHandler::Transformation>", "io/qt/gui/QImageIOHandler$Transformations");
// END: enums and flags
}
