#include <QtCore/QtGlobal>
#include <QtCore/qregexp.h>
#include <QStringList>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtCore/qnamespace.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QRegExp(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QRegExp")
    QRegExp *_ptr = reinterpret_cast<QRegExp *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QRegExp()
void __qt_construct_QRegExp(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRegExp()")
    Q_UNUSED(__java_arguments)
    QRegExp *__qt_this = new(__qtjambi_ptr) QRegExp();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QRegExp::QRegExp()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_initialize_1native__Lio_qt_core_QRegExp_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRegExp::QRegExp()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRegExp, sizeof(QRegExp), typeid(QRegExp), false, &deleter_QRegExp, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QRegExp(QRegExp)
void __qt_construct_QRegExp_cref_QRegExp(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRegExp(QRegExp)")
    jobject rx0 = __java_arguments[0].l;
    const QRegExp& __qt_rx0 = qtjambi_cast<const QRegExp& >(__jni_env, rx0);
    QRegExp *__qt_this = new(__qtjambi_ptr) QRegExp(__qt_rx0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QRegExp::QRegExp(QRegExp)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_initialize_1native__Lio_qt_core_QRegExp_2Lio_qt_core_QRegExp_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject rx0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRegExp::QRegExp(QRegExp)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = rx0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRegExp_cref_QRegExp, sizeof(QRegExp), typeid(QRegExp), false, &deleter_QRegExp, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)
void __qt_construct_QRegExp_cref_QString(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)")
    jstring pattern0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_pattern0 = qtjambi_cast<QString>(__jni_env, pattern0);
    QRegExp *__qt_this = new(__qtjambi_ptr) QRegExp(__qt_pattern0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)
void __qt_construct_QRegExp_cref_QString_Qt_CaseSensitivity(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)")
    jstring pattern0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_pattern0 = qtjambi_cast<QString>(__jni_env, pattern0);
    jobject cs1 = __java_arguments[1].l;
    Qt::CaseSensitivity __qt_cs1 = qtjambi_cast<Qt::CaseSensitivity>(__jni_env, cs1);
    QRegExp *__qt_this = new(__qtjambi_ptr) QRegExp(__qt_pattern0, Qt::CaseSensitivity(__qt_cs1));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)
void __qt_construct_QRegExp_cref_QString_Qt_CaseSensitivity_QRegExp_PatternSyntax(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)")
    jstring pattern0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_pattern0 = qtjambi_cast<QString>(__jni_env, pattern0);
    jobject cs1 = __java_arguments[1].l;
    Qt::CaseSensitivity __qt_cs1 = qtjambi_cast<Qt::CaseSensitivity>(__jni_env, cs1);
    jobject syntax2 = __java_arguments[2].l;
    QRegExp::PatternSyntax __qt_syntax2 = qtjambi_cast<QRegExp::PatternSyntax>(__jni_env, syntax2);
    QRegExp *__qt_this = new(__qtjambi_ptr) QRegExp(__qt_pattern0, Qt::CaseSensitivity(__qt_cs1), QRegExp::PatternSyntax(__qt_syntax2));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QRegExp::QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_initialize_1native__Lio_qt_core_QRegExp_2Ljava_lang_String_2Lio_qt_core_Qt_00024CaseSensitivity_2Lio_qt_core_QRegExp_00024PatternSyntax_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring pattern0,
 jobject cs1,
 jobject syntax2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRegExp::QRegExp(QString,Qt::CaseSensitivity,QRegExp::PatternSyntax)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].l = pattern0;
        arguments[1].l = cs1;
        arguments[2].l = syntax2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRegExp_cref_QString_Qt_CaseSensitivity_QRegExp_PatternSyntax, sizeof(QRegExp), typeid(QRegExp), false, &deleter_QRegExp, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QRegExp
void __qt_destruct_QRegExp(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QRegExp")
    reinterpret_cast<QRegExp*>(ptr)->~QRegExp();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QRegExp::cap(int)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_cap_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint nth0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::cap(int)", __qt_this)
        QString __qt_return_value = __qt_this->cap(static_cast<int>(nth0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::captureCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_captureCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::captureCount()const", __qt_this)
        __java_return_value = __qt_this->captureCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::capturedTexts()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_capturedTexts_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::capturedTexts()", __qt_this)
        QStringList __qt_return_value = __qt_this->capturedTexts();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::caseSensitivity()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_caseSensitivity_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::caseSensitivity()const", __qt_this)
        Qt::CaseSensitivity __qt_return_value = __qt_this->caseSensitivity();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::errorString()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_errorString_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::errorString()", __qt_this)
        QString __qt_return_value = __qt_this->errorString();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::exactMatch(QString)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_exactMatch_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring str0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::exactMatch(QString)const", __qt_this)
        QString  __qt_str0 = qtjambi_cast<QString>(__jni_env, str0);
        __java_return_value = __qt_this->exactMatch(__qt_str0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::indexIn(QString,int,QRegExp::CaretMode)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_indexIn_1native_1cref_1QString_1int_1QRegExp_1CaretMode_1constfct__JLjava_lang_String_2II)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring str0,
 jint offset1,
 jint caretMode2)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::indexIn(QString,int,QRegExp::CaretMode)const", __qt_this)
        QString  __qt_str0 = qtjambi_cast<QString>(__jni_env, str0);
        QRegExp::CaretMode __qt_caretMode2 = qtjambi_cast<QRegExp::CaretMode>(__jni_env, caretMode2);
        __java_return_value = __qt_this->indexIn(__qt_str0, static_cast<int>(offset1), QRegExp::CaretMode(__qt_caretMode2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::isEmpty()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_isEmpty_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::isEmpty()const", __qt_this)
        __java_return_value = __qt_this->isEmpty();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::isMinimal()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_isMinimal_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::isMinimal()const", __qt_this)
        __java_return_value = __qt_this->isMinimal();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::lastIndexIn(QString,int,QRegExp::CaretMode)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_lastIndexIn_1native_1cref_1QString_1int_1QRegExp_1CaretMode_1constfct__JLjava_lang_String_2II)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring str0,
 jint offset1,
 jint caretMode2)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::lastIndexIn(QString,int,QRegExp::CaretMode)const", __qt_this)
        QString  __qt_str0 = qtjambi_cast<QString>(__jni_env, str0);
        QRegExp::CaretMode __qt_caretMode2 = qtjambi_cast<QRegExp::CaretMode>(__jni_env, caretMode2);
        __java_return_value = __qt_this->lastIndexIn(__qt_str0, static_cast<int>(offset1), QRegExp::CaretMode(__qt_caretMode2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::matchedLength()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_matchedLength_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::matchedLength()const", __qt_this)
        __java_return_value = __qt_this->matchedLength();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::operator<<(QDataStream&,QRegExp)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID out0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::operator<<(QDataStream&,QRegExp)", __qt_this)
        QDataStream& __qt_out0 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, out0);
        __qt_out0 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegExp::operator=(QRegExp)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_assign_1native_1cref_1QRegExp__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rx0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::operator=(QRegExp)", __qt_this)
        const QRegExp& __qt_rx0 = QtJambiAPI::valueReferenceFromNativeId<QRegExp>(rx0);
        (*__qt_this) = __qt_rx0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegExp::operator==(QRegExp)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_equals_1native_1cref_1QRegExp_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rx0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::operator==(QRegExp)const", __qt_this)
        const QRegExp& __qt_rx0 = QtJambiAPI::valueReferenceFromNativeId<QRegExp>(rx0);
        __java_return_value = (*__qt_this) == __qt_rx0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::operator>>(QDataStream&,QRegExp&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID in0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::operator>>(QDataStream&,QRegExp&)", __qt_this)
        QDataStream& __qt_in0 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, in0);
        __qt_in0 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegExp::pattern()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_pattern_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::pattern()const", __qt_this)
        QString __qt_return_value = __qt_this->pattern();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::patternSyntax()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_patternSyntax_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::patternSyntax()const", __qt_this)
        QRegExp::PatternSyntax __qt_return_value = __qt_this->patternSyntax();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::pos(int)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_pos_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint nth0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::pos(int)", __qt_this)
        __java_return_value = __qt_this->pos(static_cast<int>(nth0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRegExp::setCaseSensitivity(Qt::CaseSensitivity)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_setCaseSensitivity_1native_1Qt_1CaseSensitivity__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint cs0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::setCaseSensitivity(Qt::CaseSensitivity)", __qt_this)
        Qt::CaseSensitivity __qt_cs0 = qtjambi_cast<Qt::CaseSensitivity>(__jni_env, cs0);
        __qt_this->setCaseSensitivity(Qt::CaseSensitivity(__qt_cs0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegExp::setMinimal(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_setMinimal_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean minimal0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::setMinimal(bool)", __qt_this)
        __qt_this->setMinimal(static_cast<bool>(minimal0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegExp::setPattern(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_setPattern_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring pattern0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::setPattern(QString)", __qt_this)
        QString  __qt_pattern0 = qtjambi_cast<QString>(__jni_env, pattern0);
        __qt_this->setPattern(__qt_pattern0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegExp::setPatternSyntax(QRegExp::PatternSyntax)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_setPatternSyntax_1native_1QRegExp_1PatternSyntax__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint syntax0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::setPatternSyntax(QRegExp::PatternSyntax)", __qt_this)
        QRegExp::PatternSyntax __qt_syntax0 = qtjambi_cast<QRegExp::PatternSyntax>(__jni_env, syntax0);
        __qt_this->setPatternSyntax(QRegExp::PatternSyntax(__qt_syntax0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegExp::swap(QRegExp&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_swap_1native_1ref_1QRegExp__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRegExp::swap(QRegExp&)", __qt_this)
        QRegExp& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QRegExp>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRegExp::escape(QString)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_escape__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring str0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRegExp::escape(QString)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_str0 = qtjambi_cast<QString>(__jni_env, str0);
        QString __qt_return_value = QRegExp::escape(__qt_str0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRegExp_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QRegExp *__qt_this = QtJambiAPI::objectFromNativeId<QRegExp>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QRegExp(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QRegExp>("QRegExp", "io/qt/core/QRegExp");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QRegExp, {
        ConstructorInfo(&__qt_construct_QRegExp, nullptr)
       ,ConstructorInfo(&__qt_construct_QRegExp_cref_QRegExp, "Lio/qt/core/QRegExp;")
       ,ConstructorInfo(&__qt_construct_QRegExp_cref_QString, "Ljava/lang/String;")
       ,ConstructorInfo(&__qt_construct_QRegExp_cref_QString_Qt_CaseSensitivity, "Ljava/lang/String;Lio/qt/core/Qt$CaseSensitivity;")
       ,ConstructorInfo(&__qt_construct_QRegExp_cref_QString_Qt_CaseSensitivity_QRegExp_PatternSyntax, "Ljava/lang/String;Lio/qt/core/Qt$CaseSensitivity;Lio/qt/core/QRegExp$PatternSyntax;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QRegExp);
    registerMetaType<QRegExp>("QRegExp");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QRegExp::CaretMode>("QRegExp::CaretMode", "io/qt/core/QRegExp$CaretMode");
    registerEnumTypeInfo<QRegExp::PatternSyntax>("QRegExp::PatternSyntax", "io/qt/core/QRegExp$PatternSyntax");
// END: enums and flags
}
