#include <QtCore/QtGlobal>
#include <QtGui/qtouchdevice.h>
#include <QtCore/QList>
#include <QtCore/QVariant>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QTouchDevice(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QTouchDevice")
    QTouchDevice *_ptr = reinterpret_cast<QTouchDevice *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QTouchDevice()
void __qt_construct_QTouchDevice_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QTouchDevice()")
    Q_UNUSED(__java_arguments)
    QTouchDevice *__qt_this = new(__qtjambi_ptr) QTouchDevice();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QTouchDevice
void __qt_destruct_QTouchDevice(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QTouchDevice")
    reinterpret_cast<QTouchDevice*>(ptr)->~QTouchDevice();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QTouchDevice::QTouchDevice()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QTouchDevice_initialize_1native__Lio_qt_gui_QTouchDevice_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QTouchDevice::QTouchDevice()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QTouchDevice_0, sizeof(QTouchDevice), typeid(QTouchDevice), false, &deleter_QTouchDevice, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTouchDevice::capabilities()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QTouchDevice_capabilities_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QTouchDevice *__qt_this = QtJambiAPI::objectFromNativeId<QTouchDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTouchDevice::capabilities()const", __qt_this)
        QTouchDevice::Capabilities __qt_return_value = __qt_this->capabilities();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QTouchDevice::maximumTouchPoints()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QTouchDevice_maximumTouchPoints_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QTouchDevice *__qt_this = QtJambiAPI::objectFromNativeId<QTouchDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTouchDevice::maximumTouchPoints()const", __qt_this)
        __java_return_value = __qt_this->maximumTouchPoints();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QTouchDevice::name()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QTouchDevice_name_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QTouchDevice *__qt_this = QtJambiAPI::objectFromNativeId<QTouchDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTouchDevice::name()const", __qt_this)
        QString __qt_return_value = __qt_this->name();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QTouchDevice::setCapabilities(QTouchDevice::Capabilities)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QTouchDevice_setCapabilities_1native_1QTouchDevice_1Capabilities__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint caps0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTouchDevice *__qt_this = QtJambiAPI::objectFromNativeId<QTouchDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTouchDevice::setCapabilities(QTouchDevice::Capabilities)", __qt_this)
        QTouchDevice::Capabilities __qt_caps0 = qtjambi_cast<QTouchDevice::Capabilities>(__jni_env, caps0);
        __qt_this->setCapabilities(QTouchDevice::Capabilities(__qt_caps0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTouchDevice::setMaximumTouchPoints(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QTouchDevice_setMaximumTouchPoints_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint max0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTouchDevice *__qt_this = QtJambiAPI::objectFromNativeId<QTouchDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTouchDevice::setMaximumTouchPoints(int)", __qt_this)
        __qt_this->setMaximumTouchPoints(static_cast<int>(max0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTouchDevice::setName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QTouchDevice_setName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTouchDevice *__qt_this = QtJambiAPI::objectFromNativeId<QTouchDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTouchDevice::setName(QString)", __qt_this)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        __qt_this->setName(__qt_name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTouchDevice::setType(QTouchDevice::DeviceType)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QTouchDevice_setType_1native_1QTouchDevice_1DeviceType__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint devType0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QTouchDevice *__qt_this = QtJambiAPI::objectFromNativeId<QTouchDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTouchDevice::setType(QTouchDevice::DeviceType)", __qt_this)
        QTouchDevice::DeviceType __qt_devType0 = qtjambi_cast<QTouchDevice::DeviceType>(__jni_env, devType0);
        __qt_this->setType(QTouchDevice::DeviceType(__qt_devType0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QTouchDevice::type()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QTouchDevice_type_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QTouchDevice *__qt_this = QtJambiAPI::objectFromNativeId<QTouchDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QTouchDevice::type()const", __qt_this)
        QTouchDevice::DeviceType __qt_return_value = __qt_this->type();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QTouchDevice::devices()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QTouchDevice_devices__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QTouchDevice::devices()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QList<const QTouchDevice*> __qt_return_value = QTouchDevice::devices();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QTouchDevice_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QTouchDevice *__qt_this = QtJambiAPI::objectFromNativeId<QTouchDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << __qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QTouchDevice_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QTouchDevice *__qt_this = QtJambiAPI::objectFromNativeId<QTouchDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QTouchDevice(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QTouchDevice>("QTouchDevice", "io/qt/gui/QTouchDevice");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QTouchDevice, {
        ConstructorInfo(&__qt_construct_QTouchDevice_0, nullptr)
    });
// END: function table

    registerMetaObject(typeId, QTouchDevice::staticMetaObject, false);
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QTouchDevice);
    registerMetaType<QTouchDevice>("QTouchDevice");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QTouchDevice::CapabilityFlag>("QTouchDevice::CapabilityFlag", "io/qt/gui/QTouchDevice$CapabilityFlag", "QTouchDevice::Capabilities", "QFlags<QTouchDevice::CapabilityFlag>", "io/qt/gui/QTouchDevice$Capabilities");
    registerEnumTypeInfo<QTouchDevice::DeviceType>("QTouchDevice::DeviceType", "io/qt/gui/QTouchDevice$DeviceType");
// END: enums and flags
}
