#include "QPicture_shell.h"
#include <QtJambi/Cast>

void deleter_QPicture(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QPicture")
    QPicture *_ptr = reinterpret_cast<QPicture *>(ptr);
    if(!isShell){
        struct PaintDeviceAccess : QPaintDevice{
            inline QPainter* getSharedPainter() const { return sharedPainter(); }
        };
        if(QPainter* painter = reinterpret_cast<PaintDeviceAccess*>(dynamic_cast<QPaintDevice*>(_ptr))->getSharedPainter()){
            if(painter->isActive()){
                painter->end();
            }
        }
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QPicture_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QPicture_shell) ); }

jmethodID QPicture_shell::__shell_javaMethod(int pos) const { return QPicture_shell::__shell()->javaMethod(typeid(QPicture), pos); }

// emitting (writeShellConstructor)
QPicture_shell::QPicture_shell(const QPicture& arg__1)
    : QPicture(arg__1)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QPicture::QPicture_shell(const QPicture& arg__1)", QPicture_shell::__shell())
    QPicture_shell::__shell()->constructed(typeid(QPicture));
}

QPicture_shell::QPicture_shell(int formatVersion0)
    : QPicture(formatVersion0)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QPicture::QPicture_shell(int formatVersion0)", QPicture_shell::__shell())
    QPicture_shell::__shell()->constructed(typeid(QPicture));
}

// emitting (writeShellDestructor)
QPicture_shell::~QPicture_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QPicture::~QPicture()", QPicture_shell::__shell())
    if(QPainter* painter = QPicture_shell::sharedPainter()){
        if(painter->isActive()){
            painter->end();
        }
    }
    QPicture_shell::__shell()->destructed(typeid(QPicture));
}

void QPicture_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QPicture_shell*>(ptr)->QPicture_shell::__shell()->tryDeleteShell(typeid(QPicture));
}

// emitting Virtual overrides (virtualFunctions)
void QPicture_shell::initPainter(QPainter* painter0) const
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QPicture::", QPicture_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QPicture_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_painter0 = qtjambi_cast<jobject>(__jni_env, painter0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_painter0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_painter0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QPicture_shell::__shell()->warnForMethod("QPicture::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPicture::");
            } QTJAMBI_TRY_END
        }else{
            QPaintDevice::initPainter(painter0);
        }
    }else{
        QPaintDevice::initPainter(painter0);
    }
}

int QPicture_shell::metric(QPaintDevice::PaintDeviceMetric m0) const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QPicture::metric(QPaintDevice::PaintDeviceMetric)const", QPicture_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QPicture_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_m0 = qtjambi_cast<jobject>(__jni_env, m0);
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_m0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QPicture_shell::__shell()->warnForMethod("QPicture::metric(QPaintDevice::PaintDeviceMetric)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPicture::metric(QPaintDevice::PaintDeviceMetric)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPicture::metric(QPaintDevice::PaintDeviceMetric(m0));
        }
    }else{
        return QPicture::metric(QPaintDevice::PaintDeviceMetric(m0));
    }
}

QPaintEngine* QPicture_shell::paintEngine() const
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QPicture::paintEngine()const", QPicture_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPaintEngine*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QPicture_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPaintEngine* >(__jni_env, __java_return_value);
                } else {
                    QPicture_shell::__shell()->warnForMethod("QPicture::paintEngine()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPicture::paintEngine()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPicture::paintEngine();
        }
    }else{
        return QPicture::paintEngine();
    }
}

QPaintDevice* QPicture_shell::redirected(QPoint* offset0) const
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QPicture::", QPicture_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPaintDevice*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QPicture_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_offset0 = qtjambi_cast<jobject>(__jni_env, offset0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_offset0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_offset0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPaintDevice* >(__jni_env, __java_return_value);
                } else {
                    QPicture_shell::__shell()->warnForMethod("QPicture::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPicture::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintDevice::redirected(offset0);
        }
    }else{
        return QPaintDevice::redirected(offset0);
    }
}

void QPicture_shell::setData(const char* data0, uint size1)
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QPicture::setData(const char*,uint)", QPicture_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QPicture_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    DataJBuffer __java_data0_buffer(__jni_env, data0, size1);
                    jobject __java_data0 = __java_data0_buffer.buffer();
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_data0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QPicture_shell::__shell()->warnForMethod("QPicture::setData(const char*,uint)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPicture::setData(const char*,uint)");
            } QTJAMBI_TRY_END
        }else{
            QPicture::setData(data0, static_cast<uint>(size1));
        }
    }else{
        QPicture::setData(data0, static_cast<uint>(size1));
    }
}

QPainter* QPicture_shell::sharedPainter() const
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        QTJAMBI_JAVA_METHOD_CALL("QPicture::", QPicture_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPainter*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QPicture_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPainter* >(__jni_env, __java_return_value);
                } else {
                    QPicture_shell::__shell()->warnForMethod("QPicture::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QPicture::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QPaintDevice::sharedPainter();
        }
    }else{
        return QPaintDevice::sharedPainter();
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
void QPicture_access::__qt_initPainter_QPainter_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID painter0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPainter* __qt_painter0 = QtJambiAPI::objectFromNativeId<QPainter>(painter0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintDevice::initPainter(__qt_painter0);
    } else {
        initPainter(__qt_painter0);
    }
}

jint QPicture_access::__qt_metric_QPaintDevice_PaintDeviceMetric_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint m0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPaintDevice::PaintDeviceMetric __qt_m0 = qtjambi_cast<QPaintDevice::PaintDeviceMetric>(__jni_env, m0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QPicture::metric(__qt_m0);
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = metric(__qt_m0);
        return jint(__qt_return_value);
    }
}

jobject QPicture_access::__qt_paintEngine(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintEngine* __qt_return_value = QPicture::paintEngine();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPaintEngine* __qt_return_value = paintEngine();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QPicture_access::__qt_redirected_QPoint_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID offset0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPoint* __qt_offset0 = QtJambiAPI::objectFromNativeId<QPoint>(offset0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPaintDevice* __qt_return_value = QPaintDevice::redirected(__qt_offset0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPaintDevice* __qt_return_value = redirected(__qt_offset0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

void QPicture_access::__qt_setData_const_char_ptr_uint(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject data0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    uint size1{0};
    JBufferConstData __qt_data0_buffer(__jni_env, data0);
    const char* __qt_data0 = __qt_data0_buffer.data<char>();
    size1 = __qt_data0_buffer.size<char>();
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPicture::setData(__qt_data0, static_cast<uint>(size1));
    } else {
        setData(__qt_data0, static_cast<uint>(size1));
    }
}

jobject QPicture_access::__qt_sharedPainter(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPainter* __qt_return_value = QPaintDevice::sharedPainter();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPainter* __qt_return_value = sharedPainter();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

// emitting (writeConstructors)
// new QPicture(QPicture)
void __qt_construct_QPicture_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPicture(QPicture)")
    jobject arg__1 = __java_arguments[0].l;
    const QPicture& __qt_arg__1 = qtjambi_cast<const QPicture& >(__jni_env, arg__1);
    QPicture *__qt_this = new(__qtjambi_ptr) QPicture_shell(__qt_arg__1);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QPicture(int)
void __qt_construct_QPicture_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPicture(int)")
    Q_UNUSED(__java_arguments)
    QPicture *__qt_this = new(__qtjambi_ptr) QPicture_shell();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QPicture(int)
void __qt_construct_QPicture_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPicture(int)")
    jint formatVersion0 = __java_arguments[0].i;
    Q_UNUSED(formatVersion0)
    QPicture *__qt_this = new(__qtjambi_ptr) QPicture_shell(static_cast<int>(formatVersion0));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QPicture_shell
void __qt_destruct_QPicture(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QPicture")
    reinterpret_cast<QPicture_shell*>(ptr)->~QPicture_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QPicture::QPicture(QPicture)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_initialize_1native__Lio_qt_gui_QPicture_2Lio_qt_gui_QPicture_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPicture::QPicture(QPicture)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = arg__1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QPicture_0, sizeof(QPicture_shell), typeid(QPicture), true, &deleter_QPicture, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPicture::QPicture(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_initialize_1native__Lio_qt_gui_QPicture_2I)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint formatVersion0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPicture::QPicture(int)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.i = formatVersion0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QPicture_2, sizeof(QPicture_shell), typeid(QPicture), true, &deleter_QPicture, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPicture::boundingRect()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_boundingRect_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::boundingRect()const", __qt_this)
        QRect __qt_return_value = __qt_this->boundingRect();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::colorCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_colorCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::colorCount()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::colorCount();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::data()const
extern "C" Q_DECL_EXPORT jbyteArray JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_data_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyteArray __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::data()const", __qt_this)
        const char* __qt_return_value = __qt_this->data();
        jint size = jint(__qt_this->size());
        if(size>0){
            __java_return_value = __jni_env->NewByteArray(size);
            __jni_env->SetByteArrayRegion(__java_return_value, 0, size, reinterpret_cast<const jbyte *>(__qt_return_value));
        }
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::depth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_depth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::depth()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::depth();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::detach()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_detach_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::detach()", __qt_this)
        __qt_this->detach();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPicture::devicePixelRatio()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_devicePixelRatio_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::devicePixelRatio()const", __qt_this)
        int __qt_return_value = __qt_this->QPaintDevice::devicePixelRatio();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::devicePixelRatioF()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_devicePixelRatioF_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::devicePixelRatioF()const", __qt_this)
        qreal __qt_return_value = __qt_this->QPaintDevice::devicePixelRatioF();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::height()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_height_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::height()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::height();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::heightMM()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_heightMM_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::heightMM()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::heightMM();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::isDetached()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_isDetached_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::isDetached()const", __qt_this)
        __java_return_value = __qt_this->isDetached();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::load(QIODevice*,const char*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_load_1native_1QIODevice_1ptr_1const_1char_1ptr__JJLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID dev0,
 jstring format1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::load(QIODevice*,const char*)", __qt_this)
        QIODevice* __qt_dev0 = QtJambiAPI::objectFromNativeId<QIODevice>(dev0);
        const char*  __qt_format1 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, format1);
        __java_return_value = __qt_this->load(__qt_dev0, __qt_format1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::load(QString,const char*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_load_1native_1cref_1QString_1const_1char_1ptr__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0,
 jstring format1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::load(QString,const char*)", __qt_this)
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        const char*  __qt_format1 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, format1);
        __java_return_value = __qt_this->load(__qt_fileName0, __qt_format1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::logicalDpiX()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_logicalDpiX_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::logicalDpiX()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::logicalDpiX();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::logicalDpiY()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_logicalDpiY_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::logicalDpiY()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::logicalDpiY();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::operator<<(QDataStream&,QPicture)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::operator<<(QDataStream&,QPicture)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPicture::operator=(QPicture)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_assign_1native_1cref_1QPicture__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::operator=(QPicture)", __qt_this)
        const QPicture& __qt_p0 = QtJambiAPI::objectReferenceFromNativeId<QPicture>(__jni_env, p0);
        (*__qt_this) = __qt_p0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPicture::operator>>(QDataStream&,QPicture&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::operator>>(QDataStream&,QPicture&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPicture::paintingActive()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_paintingActive_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::paintingActive()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::paintingActive();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::physicalDpiX()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_physicalDpiX_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::physicalDpiX()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::physicalDpiX();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::physicalDpiY()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_physicalDpiY_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::physicalDpiY()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::physicalDpiY();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::play(QPainter*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_play_1native_1QPainter_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::play(QPainter*)", __qt_this)
        QPainter* __qt_p0 = QtJambiAPI::objectFromNativeId<QPainter>(p0);
        __java_return_value = __qt_this->play(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::save(QIODevice*,const char*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_save_1native_1QIODevice_1ptr_1const_1char_1ptr__JJLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID dev0,
 jstring format1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::save(QIODevice*,const char*)", __qt_this)
        QIODevice* __qt_dev0 = QtJambiAPI::objectFromNativeId<QIODevice>(dev0);
        const char*  __qt_format1 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, format1);
        __java_return_value = __qt_this->save(__qt_dev0, __qt_format1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::save(QString,const char*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_save_1native_1cref_1QString_1const_1char_1ptr__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0,
 jstring format1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::save(QString,const char*)", __qt_this)
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        const char*  __qt_format1 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, format1);
        __java_return_value = __qt_this->save(__qt_fileName0, __qt_format1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::setBoundingRect(QRect)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_setBoundingRect_1native_1cref_1QRect__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::setBoundingRect(QRect)", __qt_this)
        const QRect& __qt_r0 = QtJambiAPI::valueReferenceFromNativeId<QRect>(r0);
        __qt_this->setBoundingRect(__qt_r0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPicture::size()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::size()const", __qt_this)
        uint __qt_return_value = __qt_this->size();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::swap(QPicture&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_swap_1native_1ref_1QPicture__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::swap(QPicture&)", __qt_this)
        QPicture& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QPicture>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPicture::width()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_width_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::width()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::width();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::widthMM()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_widthMM_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::widthMM()const", __qt_this)
        __java_return_value = __qt_this->QPaintDevice::widthMM();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::initPainter(QPainter*)const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_initPainter_1native_1QPainter_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID painter0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::initPainter(QPainter*)const", __qt_this)
        static_cast<const QPicture_access*>(__qt_this)->__qt_initPainter_QPainter_ptr_constfct(__jni_env, __this_nativeId, painter0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPicture::metric(QPaintDevice::PaintDeviceMetric)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_metric_1native_1QPaintDevice_1PaintDeviceMetric_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint m0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::metric(QPaintDevice::PaintDeviceMetric)const", __qt_this)
        __java_return_value = static_cast<const QPicture_access*>(__qt_this)->__qt_metric_QPaintDevice_PaintDeviceMetric_constfct(__jni_env, __this_nativeId, m0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::paintEngine()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_paintEngine_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::paintEngine()const", __qt_this)
        __java_return_value = static_cast<const QPicture_access*>(__qt_this)->__qt_paintEngine(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::redirected(QPoint*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_redirected_1native_1QPoint_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID offset0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::redirected(QPoint*)const", __qt_this)
        __java_return_value = static_cast<const QPicture_access*>(__qt_this)->__qt_redirected_QPoint_ptr_constfct(__jni_env, __this_nativeId, offset0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::setData(const char*,uint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_setData_1native_1const_1char_1ptr_1uint__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring data0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::setData(const char*,uint)", __qt_this)
        static_cast<QPicture_access*>(__qt_this)->__qt_setData_const_char_ptr_uint(__jni_env, __this_nativeId, data0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPicture::sharedPainter()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_sharedPainter_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPicture::sharedPainter()const", __qt_this)
        __java_return_value = static_cast<const QPicture_access*>(__qt_this)->__qt_sharedPainter(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::devicePixelRatioFScale()
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_devicePixelRatioFScale__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPicture::devicePixelRatioFScale()")
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        qreal __qt_return_value = QPicture::devicePixelRatioFScale();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::inputFormatList()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_inputFormatList__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPicture::inputFormatList()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QStringList __qt_return_value = QPicture::inputFormatList();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::inputFormats()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_inputFormats__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPicture::inputFormats()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QList<QByteArray> __qt_return_value = QPicture::inputFormats();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::outputFormatList()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_outputFormatList__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPicture::outputFormatList()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QStringList __qt_return_value = QPicture::outputFormatList();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::outputFormats()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_outputFormats__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPicture::outputFormats()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QList<QByteArray> __qt_return_value = QPicture::outputFormats();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPicture::pictureFormat(QString)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_pictureFormat__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring fileName0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPicture::pictureFormat(QString)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        const char* __qt_return_value = QPicture::pictureFormat(__qt_fileName0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QPicture_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QPicture *__qt_this = QtJambiAPI::objectFromNativeId<QPicture>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QPicture(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QPicture>("QPicture", "io/qt/gui/QPicture");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/* 0 */ "initPainter", "(Lio/qt/gui/QPainter;)V"),
        FunctionInfo(/* 1 */ "metric", "(Lio/qt/gui/QPaintDevice$PaintDeviceMetric;)I"),
        FunctionInfo(/* 2 */ "paintEngine", "()Lio/qt/gui/QPaintEngine;"),
        FunctionInfo(/* 3 */ "redirected", "(Lio/qt/core/QPoint;)Lio/qt/gui/QPaintDevice;"),
        FunctionInfo(/* 4 */ "setData", "(Ljava/nio/ByteBuffer;)V"),
        FunctionInfo(/* 5 */ "sharedPainter", "()Lio/qt/gui/QPainter;")});
    registerConstructorInfos(typeId, &__qt_destruct_QPicture, {
        ConstructorInfo(&__qt_construct_QPicture_0, "Lio/qt/gui/QPicture;")
       ,ConstructorInfo(&__qt_construct_QPicture_1, nullptr)
       ,ConstructorInfo(&__qt_construct_QPicture_2, "I")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QPicture);
    registerMetaType<QPicture>("QPicture");
    registerSizeOfShell(typeId, sizeof(QPicture_shell));
// END: type registration

// BEGIN: polymorphic ids
    registerPolymorphyHandler(typeid(QPaintDevice), typeId, [](void *ptr, qintptr& offset) -> bool {
            QPaintDevice *object = reinterpret_cast<QPaintDevice *>(ptr);
            Q_ASSERT(object);
            bool _result = false;
            QTJAMBI_TRY_ANY {
                if(QPicture* _object = dynamic_cast<QPicture*>(object)){
                    offset = qintptr(object)-qintptr(_object);
                    _result = true;
                }
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
// END: polymorphic ids

    registerInterfaceOffset(typeId, typeid(QPaintDevice), int(reinterpret_cast<quintptr>(static_cast<QPaintDevice *>(reinterpret_cast<QPicture *>(0x10000000)))) - 0x10000000);

// BEGIN: enums and flags
// END: enums and flags
}
