#include <QtCore/QtGlobal>
#include <QtGui/qmatrix4x4.h>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtCore/qpoint.h>
#include <QtCore/qrect.h>
#include <QtGui/qquaternion.h>
#include <QtGui/qtransform.h>
#include <QtGui/qvector3d.h>
#include <QtGui/qvector4d.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/JavaAPI>
#include <QtJambiGui/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QMatrix4x4(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QMatrix4x4")
    QMatrix4x4 *_ptr = reinterpret_cast<QMatrix4x4 *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QMatrix4x4()
void __qt_construct_QMatrix4x4_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMatrix4x4()")
    Q_UNUSED(__java_arguments)
    QMatrix4x4 *__qt_this = new(__qtjambi_ptr) QMatrix4x4();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QMatrix4x4(QTransform)
void __qt_construct_QMatrix4x4_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMatrix4x4(QTransform)")
    jobject transform0 = __java_arguments[0].l;
    const QTransform& __qt_transform0 = qtjambi_cast<const QTransform& >(__jni_env, transform0);
    QMatrix4x4 *__qt_this = new(__qtjambi_ptr) QMatrix4x4(__qt_transform0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QMatrix4x4(const float*)
void __qt_construct_QMatrix4x4_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMatrix4x4(const float*)")
    jobject values0 = __java_arguments[0].l;
    JBufferConstData __qt_values0_buffer(__jni_env, values0);
    const float* __qt_values0 = __qt_values0_buffer.data<float>();
    QMatrix4x4 *__qt_this = new(__qtjambi_ptr) QMatrix4x4(__qt_values0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QMatrix4x4(const float*,int,int)
void __qt_construct_QMatrix4x4_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMatrix4x4(const float*,int,int)")
    jobject values0 = __java_arguments[0].l;
    JBufferConstData __qt_values0(__jni_env, values0);
    if(__qt_values0.size()<16){
        JavaException::raiseIndexOutOfBoundsException(__jni_env, "Buffer size is less 16." QTJAMBI_STACKTRACEINFO );
        return;
    }
    jint cols1 = __java_arguments[1].i;
    Q_UNUSED(cols1)
    jint rows2 = __java_arguments[2].i;
    Q_UNUSED(rows2)
    QMatrix4x4 *__qt_this = new(__qtjambi_ptr) QMatrix4x4(__qt_values0, static_cast<int>(cols1), static_cast<int>(rows2));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QMatrix4x4(float,float,float,float,float,float,float,float,float,float,float,float,float,float,float,float)
void __qt_construct_QMatrix4x4_4(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMatrix4x4(float,float,float,float,float,float,float,float,float,float,float,float,float,float,float,float)")
    jfloat m110 = __java_arguments[0].f;
    Q_UNUSED(m110)
    jfloat m121 = __java_arguments[1].f;
    Q_UNUSED(m121)
    jfloat m132 = __java_arguments[2].f;
    Q_UNUSED(m132)
    jfloat m143 = __java_arguments[3].f;
    Q_UNUSED(m143)
    jfloat m214 = __java_arguments[4].f;
    Q_UNUSED(m214)
    jfloat m225 = __java_arguments[5].f;
    Q_UNUSED(m225)
    jfloat m236 = __java_arguments[6].f;
    Q_UNUSED(m236)
    jfloat m247 = __java_arguments[7].f;
    Q_UNUSED(m247)
    jfloat m318 = __java_arguments[8].f;
    Q_UNUSED(m318)
    jfloat m329 = __java_arguments[9].f;
    Q_UNUSED(m329)
    jfloat m3310 = __java_arguments[10].f;
    Q_UNUSED(m3310)
    jfloat m3411 = __java_arguments[11].f;
    Q_UNUSED(m3411)
    jfloat m4112 = __java_arguments[12].f;
    Q_UNUSED(m4112)
    jfloat m4213 = __java_arguments[13].f;
    Q_UNUSED(m4213)
    jfloat m4314 = __java_arguments[14].f;
    Q_UNUSED(m4314)
    jfloat m4415 = __java_arguments[15].f;
    Q_UNUSED(m4415)
    QMatrix4x4 *__qt_this = new(__qtjambi_ptr) QMatrix4x4(static_cast<float>(m110), static_cast<float>(m121), static_cast<float>(m132), static_cast<float>(m143), static_cast<float>(m214), static_cast<float>(m225), static_cast<float>(m236), static_cast<float>(m247), static_cast<float>(m318), static_cast<float>(m329), static_cast<float>(m3310), static_cast<float>(m3411), static_cast<float>(m4112), static_cast<float>(m4213), static_cast<float>(m4314), static_cast<float>(m4415));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QMatrix4x4
void __qt_destruct_QMatrix4x4(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QMatrix4x4")
    reinterpret_cast<QMatrix4x4*>(ptr)->~QMatrix4x4();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QMatrix4x4::QMatrix4x4()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_initialize_1native__Lio_qt_gui_QMatrix4x4_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMatrix4x4::QMatrix4x4()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMatrix4x4_0, sizeof(QMatrix4x4), typeid(QMatrix4x4), false, &deleter_QMatrix4x4, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::QMatrix4x4(QTransform)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_initialize_1native__Lio_qt_gui_QMatrix4x4_2Lio_qt_gui_QTransform_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject transform0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMatrix4x4::QMatrix4x4(QTransform)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = transform0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMatrix4x4_1, sizeof(QMatrix4x4), typeid(QMatrix4x4), false, &deleter_QMatrix4x4, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::QMatrix4x4(const float*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_initialize_1native__Lio_qt_gui_QMatrix4x4_2Ljava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject values0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMatrix4x4::QMatrix4x4(const float*)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = values0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMatrix4x4_2, sizeof(QMatrix4x4), typeid(QMatrix4x4), false, &deleter_QMatrix4x4, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::QMatrix4x4(const float*,int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_initialize_1native__Lio_qt_gui_QMatrix4x4_2Ljava_nio_FloatBuffer_2II)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject values0,
 jint cols1,
 jint rows2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMatrix4x4::QMatrix4x4(const float*,int,int)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].l = values0;
        arguments[1].i = cols1;
        arguments[2].i = rows2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMatrix4x4_3, sizeof(QMatrix4x4), typeid(QMatrix4x4), false, &deleter_QMatrix4x4, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::QMatrix4x4(float,float,float,float,float,float,float,float,float,float,float,float,float,float,float,float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_initialize_1native__Lio_qt_gui_QMatrix4x4_2FFFFFFFFFFFFFFFF)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jfloat m110,
 jfloat m121,
 jfloat m132,
 jfloat m143,
 jfloat m214,
 jfloat m225,
 jfloat m236,
 jfloat m247,
 jfloat m318,
 jfloat m329,
 jfloat m3310,
 jfloat m3411,
 jfloat m4112,
 jfloat m4213,
 jfloat m4314,
 jfloat m4415)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMatrix4x4::QMatrix4x4(float,float,float,float,float,float,float,float,float,float,float,float,float,float,float,float)")
    QTJAMBI_TRY {
        jvalue arguments[16];
        arguments[0].f = m110;
        arguments[1].f = m121;
        arguments[2].f = m132;
        arguments[3].f = m143;
        arguments[4].f = m214;
        arguments[5].f = m225;
        arguments[6].f = m236;
        arguments[7].f = m247;
        arguments[8].f = m318;
        arguments[9].f = m329;
        arguments[10].f = m3310;
        arguments[11].f = m3411;
        arguments[12].f = m4112;
        arguments[13].f = m4213;
        arguments[14].f = m4314;
        arguments[15].f = m4415;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMatrix4x4_4, sizeof(QMatrix4x4), typeid(QMatrix4x4), false, &deleter_QMatrix4x4, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::column(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_column_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::column(int)const", __qt_this)
        QVector4D __qt_return_value = __qt_this->column(static_cast<int>(index0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::copyDataTo(float*)const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_copyDataTo_1native_1float_1ptr_1constfct__JLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject values0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::copyDataTo(float*)const", __qt_this)
        JBufferData __qt_values0_buffer(__jni_env, values0);
        float* __qt_values0 = __qt_values0_buffer.data<float>();
        __qt_this->copyDataTo(__qt_values0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::data()const
extern "C" Q_DECL_EXPORT jfloatArray JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_array_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jfloatArray __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::data()const", __qt_this)
        const float* __qt_return_value = __qt_this->data();
        __java_return_value = qtjambi_array_cast<jfloatArray>(__jni_env, __qtjambi_scope, __qt_return_value, 16);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::determinant()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_determinant_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::determinant()const", __qt_this)
        __java_return_value = __qt_this->determinant();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::fill(float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_fill_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat value0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::fill(float)", __qt_this)
        __qt_this->fill(static_cast<float>(value0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::flipCoordinates()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_flipCoordinates_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::flipCoordinates()", __qt_this)
        __qt_this->flipCoordinates();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::frustum(float,float,float,float,float,float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_frustum_1native_1float_1float_1float_1float_1float_1float__JFFFFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat left0,
 jfloat right1,
 jfloat bottom2,
 jfloat top3,
 jfloat nearPlane4,
 jfloat farPlane5)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::frustum(float,float,float,float,float,float)", __qt_this)
        __qt_this->frustum(static_cast<float>(left0), static_cast<float>(right1), static_cast<float>(bottom2), static_cast<float>(top3), static_cast<float>(nearPlane4), static_cast<float>(farPlane5));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::inverted(bool*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_inverted_1native_1bool_1ptr_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::inverted(bool*)const", __qt_this)
        bool ok(false);
        bool* __qt_invertible0 = &ok;
        QMatrix4x4 __qt_return_value = __qt_this->inverted(__qt_invertible0);
        __java_return_value = ok ? qtjambi_cast<jobject>(__jni_env, __qt_return_value) : nullptr;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::isAffine()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_isAffine_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::isAffine()const", __qt_this)
        __java_return_value = __qt_this->isAffine();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::isIdentity()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_isIdentity_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::isIdentity()const", __qt_this)
        __java_return_value = __qt_this->isIdentity();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::lookAt(QVector3D,QVector3D,QVector3D)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_lookAt_1native_1cref_1QVector3D_1cref_1QVector3D_1cref_1QVector3D__JJJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID eye0,
 QtJambiNativeID center1,
 QtJambiNativeID up2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::lookAt(QVector3D,QVector3D,QVector3D)", __qt_this)
        const QVector3D& __qt_eye0 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(eye0);
        const QVector3D& __qt_center1 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(center1);
        const QVector3D& __qt_up2 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(up2);
        __qt_this->lookAt(__qt_eye0, __qt_center1, __qt_up2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::map(QPoint)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_map_1native_1cref_1QPoint_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID point0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::map(QPoint)const", __qt_this)
        const QPoint& __qt_point0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(point0);
        QPoint __qt_return_value = __qt_this->map(__qt_point0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::map(QPointF)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_map_1native_1cref_1QPointF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID point0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::map(QPointF)const", __qt_this)
        const QPointF& __qt_point0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(point0);
        QPointF __qt_return_value = __qt_this->map(__qt_point0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::map(QVector3D)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_map_1native_1cref_1QVector3D_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID point0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::map(QVector3D)const", __qt_this)
        const QVector3D& __qt_point0 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(point0);
        QVector3D __qt_return_value = __qt_this->map(__qt_point0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::map(QVector4D)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_map_1native_1cref_1QVector4D_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID point0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::map(QVector4D)const", __qt_this)
        const QVector4D& __qt_point0 = QtJambiAPI::valueReferenceFromNativeId<QVector4D>(point0);
        QVector4D __qt_return_value = __qt_this->map(__qt_point0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::mapRect(QRect)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_mapRect_1native_1cref_1QRect_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rect0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::mapRect(QRect)const", __qt_this)
        const QRect& __qt_rect0 = QtJambiAPI::valueReferenceFromNativeId<QRect>(rect0);
        QRect __qt_return_value = __qt_this->mapRect(__qt_rect0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::mapRect(QRectF)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_mapRect_1native_1cref_1QRectF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rect0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::mapRect(QRectF)const", __qt_this)
        const QRectF& __qt_rect0 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(rect0);
        QRectF __qt_return_value = __qt_this->mapRect(__qt_rect0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::mapVector(QVector3D)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_mapVector_1native_1cref_1QVector3D_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID vector0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::mapVector(QVector3D)const", __qt_this)
        const QVector3D& __qt_vector0 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(vector0);
        QVector3D __qt_return_value = __qt_this->mapVector(__qt_vector0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::normalMatrix()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_normalMatrix_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::normalMatrix()const", __qt_this)
        QMatrix3x3 __qt_return_value = __qt_this->normalMatrix();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator()(int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_setValue_1native_1int_1int__JIIF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint row0,
 jint column1,
 jfloat value)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator()(int,int)", __qt_this)
        float& __qt_return_value = (*__qt_this)(static_cast<int>(row0), static_cast<int>(column1));
        Q_UNUSED(__qt_return_value)


        __qt_return_value = value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::operator()(int,int)const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_value_1native_1int_1int_1constfct__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint row0,
 jint column1)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator()(int,int)const", __qt_this)
        __java_return_value = (*__qt_this)(static_cast<int>(row0), static_cast<int>(column1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator*(QMatrix4x4,QMatrix4x4)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_times_1native_1cref_1QMatrix4x4__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID m21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator*(QMatrix4x4,QMatrix4x4)", __qt_this)
        const QMatrix4x4& __qt_m21 = QtJambiAPI::valueReferenceFromNativeId<QMatrix4x4>(m21);
        QMatrix4x4 __qt_return_value = (*__qt_this) * __qt_m21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator*(QMatrix4x4,QPoint)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_times_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID point1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator*(QMatrix4x4,QPoint)", __qt_this)
        const QPoint& __qt_point1 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(point1);
        QPoint __qt_return_value = (*__qt_this) * __qt_point1;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator*(QMatrix4x4,QPointF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_times_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID point1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator*(QMatrix4x4,QPointF)", __qt_this)
        const QPointF& __qt_point1 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(point1);
        QPointF __qt_return_value = (*__qt_this) * __qt_point1;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator*(QMatrix4x4,QVector3D)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_times_1native_1cref_1QVector3D__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID vector1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator*(QMatrix4x4,QVector3D)", __qt_this)
        const QVector3D& __qt_vector1 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(vector1);
        QVector3D __qt_return_value = (*__qt_this) * __qt_vector1;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator*(QMatrix4x4,QVector4D)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_times_1native_1cref_1QVector4D__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID vector1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator*(QMatrix4x4,QVector4D)", __qt_this)
        const QVector4D& __qt_vector1 = QtJambiAPI::valueReferenceFromNativeId<QVector4D>(vector1);
        QVector4D __qt_return_value = (*__qt_this) * __qt_vector1;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator*(QMatrix4x4,float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_times_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat factor1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator*(QMatrix4x4,float)", __qt_this)
        QMatrix4x4 __qt_return_value = (*__qt_this) * static_cast<float>(factor1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator*=(QMatrix4x4)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_multiply_1native_1cref_1QMatrix4x4__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator*=(QMatrix4x4)", __qt_this)
        const QMatrix4x4& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QMatrix4x4>(other0);
        (*__qt_this) *= __qt_other0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator*=(float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_multiply_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat factor0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator*=(float)", __qt_this)
        (*__qt_this) *= static_cast<float>(factor0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator+(QMatrix4x4,QMatrix4x4)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_plus_1native_1cref_1QMatrix4x4__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID m21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator+(QMatrix4x4,QMatrix4x4)", __qt_this)
        const QMatrix4x4& __qt_m21 = QtJambiAPI::valueReferenceFromNativeId<QMatrix4x4>(m21);
        QMatrix4x4 __qt_return_value = (*__qt_this) + __qt_m21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator+=(QMatrix4x4)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_add_1native_1cref_1QMatrix4x4__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator+=(QMatrix4x4)", __qt_this)
        const QMatrix4x4& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QMatrix4x4>(other0);
        (*__qt_this) += __qt_other0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator-(QMatrix4x4)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_unaryMinus_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator-(QMatrix4x4)", __qt_this)
        QMatrix4x4 __qt_return_value = -(*__qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator-(QMatrix4x4,QMatrix4x4)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_minus_1native_1cref_1QMatrix4x4__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID m21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator-(QMatrix4x4,QMatrix4x4)", __qt_this)
        const QMatrix4x4& __qt_m21 = QtJambiAPI::valueReferenceFromNativeId<QMatrix4x4>(m21);
        QMatrix4x4 __qt_return_value = (*__qt_this) - __qt_m21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator-=(QMatrix4x4)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_subtract_1native_1cref_1QMatrix4x4__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator-=(QMatrix4x4)", __qt_this)
        const QMatrix4x4& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QMatrix4x4>(other0);
        (*__qt_this) -= __qt_other0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator/(QMatrix4x4,float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_div_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat divisor1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator/(QMatrix4x4,float)", __qt_this)
        QMatrix4x4 __qt_return_value = (*__qt_this) / static_cast<float>(divisor1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator/=(float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_divide_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat divisor0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator/=(float)", __qt_this)
        (*__qt_this) /= static_cast<float>(divisor0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator<<(QDataStream&,QMatrix4x4)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator<<(QDataStream&,QMatrix4x4)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::operator==(QMatrix4x4)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_equals_1native_1cref_1QMatrix4x4_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator==(QMatrix4x4)const", __qt_this)
        const QMatrix4x4& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QMatrix4x4>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::operator>>(QDataStream&,QMatrix4x4&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::operator>>(QDataStream&,QMatrix4x4&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::optimize()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_optimize_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::optimize()", __qt_this)
        __qt_this->optimize();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::ortho(QRect)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_ortho_1native_1cref_1QRect__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rect0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::ortho(QRect)", __qt_this)
        const QRect& __qt_rect0 = QtJambiAPI::valueReferenceFromNativeId<QRect>(rect0);
        __qt_this->ortho(__qt_rect0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::ortho(QRectF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_ortho_1native_1cref_1QRectF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rect0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::ortho(QRectF)", __qt_this)
        const QRectF& __qt_rect0 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(rect0);
        __qt_this->ortho(__qt_rect0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::ortho(float,float,float,float,float,float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_ortho_1native_1float_1float_1float_1float_1float_1float__JFFFFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat left0,
 jfloat right1,
 jfloat bottom2,
 jfloat top3,
 jfloat nearPlane4,
 jfloat farPlane5)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::ortho(float,float,float,float,float,float)", __qt_this)
        __qt_this->ortho(static_cast<float>(left0), static_cast<float>(right1), static_cast<float>(bottom2), static_cast<float>(top3), static_cast<float>(nearPlane4), static_cast<float>(farPlane5));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::perspective(float,float,float,float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_perspective_1native_1float_1float_1float_1float__JFFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat verticalAngle0,
 jfloat aspectRatio1,
 jfloat nearPlane2,
 jfloat farPlane3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::perspective(float,float,float,float)", __qt_this)
        __qt_this->perspective(static_cast<float>(verticalAngle0), static_cast<float>(aspectRatio1), static_cast<float>(nearPlane2), static_cast<float>(farPlane3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::rotate(QQuaternion)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_rotate_1native_1cref_1QQuaternion__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID quaternion0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::rotate(QQuaternion)", __qt_this)
        const QQuaternion& __qt_quaternion0 = QtJambiAPI::valueReferenceFromNativeId<QQuaternion>(quaternion0);
        __qt_this->rotate(__qt_quaternion0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::rotate(float,QVector3D)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_rotate_1native_1float_1cref_1QVector3D__JFJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat angle0,
 QtJambiNativeID vector1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::rotate(float,QVector3D)", __qt_this)
        const QVector3D& __qt_vector1 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(vector1);
        __qt_this->rotate(static_cast<float>(angle0), __qt_vector1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::rotate(float,float,float,float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_rotate_1native_1float_1float_1float_1float__JFFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat angle0,
 jfloat x1,
 jfloat y2,
 jfloat z3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::rotate(float,float,float,float)", __qt_this)
        __qt_this->rotate(static_cast<float>(angle0), static_cast<float>(x1), static_cast<float>(y2), static_cast<float>(z3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::row(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_row_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::row(int)const", __qt_this)
        QVector4D __qt_return_value = __qt_this->row(static_cast<int>(index0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::scale(QVector3D)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_scale_1native_1cref_1QVector3D__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID vector0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::scale(QVector3D)", __qt_this)
        const QVector3D& __qt_vector0 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(vector0);
        __qt_this->scale(__qt_vector0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::scale(float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_scale_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat factor0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::scale(float)", __qt_this)
        __qt_this->scale(static_cast<float>(factor0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::scale(float,float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_scale_1native_1float_1float__JFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat x0,
 jfloat y1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::scale(float,float)", __qt_this)
        __qt_this->scale(static_cast<float>(x0), static_cast<float>(y1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::scale(float,float,float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_scale_1native_1float_1float_1float__JFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat x0,
 jfloat y1,
 jfloat z2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::scale(float,float,float)", __qt_this)
        __qt_this->scale(static_cast<float>(x0), static_cast<float>(y1), static_cast<float>(z2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::setColumn(int,QVector4D)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_setColumn_1native_1int_1cref_1QVector4D__JIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 QtJambiNativeID value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::setColumn(int,QVector4D)", __qt_this)
        const QVector4D& __qt_value1 = QtJambiAPI::valueReferenceFromNativeId<QVector4D>(value1);
        __qt_this->setColumn(static_cast<int>(index0), __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::setRow(int,QVector4D)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_setRow_1native_1int_1cref_1QVector4D__JIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 QtJambiNativeID value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::setRow(int,QVector4D)", __qt_this)
        const QVector4D& __qt_value1 = QtJambiAPI::valueReferenceFromNativeId<QVector4D>(value1);
        __qt_this->setRow(static_cast<int>(index0), __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::setToIdentity()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_setToIdentity_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::setToIdentity()", __qt_this)
        __qt_this->setToIdentity();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::toTransform()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_toTransform_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::toTransform()const", __qt_this)
        QTransform __qt_return_value = __qt_this->toTransform();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::toTransform(float)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_toTransform_1native_1float_1constfct__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat distanceToPlane0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::toTransform(float)const", __qt_this)
        QTransform __qt_return_value = __qt_this->toTransform(static_cast<float>(distanceToPlane0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::translate(QVector3D)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_translate_1native_1cref_1QVector3D__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID vector0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::translate(QVector3D)", __qt_this)
        const QVector3D& __qt_vector0 = QtJambiAPI::valueReferenceFromNativeId<QVector3D>(vector0);
        __qt_this->translate(__qt_vector0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::translate(float,float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_translate_1native_1float_1float__JFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat x0,
 jfloat y1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::translate(float,float)", __qt_this)
        __qt_this->translate(static_cast<float>(x0), static_cast<float>(y1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::translate(float,float,float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_translate_1native_1float_1float_1float__JFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat x0,
 jfloat y1,
 jfloat z2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::translate(float,float,float)", __qt_this)
        __qt_this->translate(static_cast<float>(x0), static_cast<float>(y1), static_cast<float>(z2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::transposed()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_transposed_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::transposed()const", __qt_this)
        QMatrix4x4 __qt_return_value = __qt_this->transposed();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMatrix4x4::viewport(QRectF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_viewport_1native_1cref_1QRectF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rect0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::viewport(QRectF)", __qt_this)
        const QRectF& __qt_rect0 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(rect0);
        __qt_this->viewport(__qt_rect0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::viewport(float,float,float,float,float,float)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_viewport_1native_1float_1float_1float_1float_1float_1float__JFFFFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat left0,
 jfloat bottom1,
 jfloat width2,
 jfloat height3,
 jfloat nearPlane4,
 jfloat farPlane5)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMatrix4x4::viewport(float,float,float,float,float,float)", __qt_this)
        __qt_this->viewport(static_cast<float>(left0), static_cast<float>(bottom1), static_cast<float>(width2), static_cast<float>(height3), static_cast<float>(nearPlane4), static_cast<float>(farPlane5));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QMatrix4x4::qFuzzyCompare(QMatrix4x4,QMatrix4x4)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_qFuzzyCompare_1native_1cref_1QMatrix4x4_1cref_1QMatrix4x4__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID m10,
 QtJambiNativeID m21)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMatrix4x4::qFuzzyCompare(QMatrix4x4,QMatrix4x4)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QMatrix4x4& __qt_m10 = QtJambiAPI::valueReferenceFromNativeId<QMatrix4x4>(m10);
        const QMatrix4x4& __qt_m21 = QtJambiAPI::valueReferenceFromNativeId<QMatrix4x4>(m21);
        __java_return_value = qFuzzyCompare(__qt_m10, __qt_m21);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QMatrix4x4_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QMatrix4x4 *__qt_this = QtJambiAPI::objectFromNativeId<QMatrix4x4>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QMatrix4x4(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QMatrix4x4>("QMatrix4x4", "io/qt/gui/QMatrix4x4");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QMatrix4x4, {
        ConstructorInfo(&__qt_construct_QMatrix4x4_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QMatrix4x4_1, "Lio/qt/gui/QTransform;")
       ,ConstructorInfo(&__qt_construct_QMatrix4x4_2, "Ljava/nio/FloatBuffer;")
       ,ConstructorInfo(&__qt_construct_QMatrix4x4_3, "Ljava/nio/FloatBuffer;II")
       ,ConstructorInfo(&__qt_construct_QMatrix4x4_4, "FFFFFFFFFFFFFFFF")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QMatrix4x4);
    registerMetaType<QMatrix4x4>("QMatrix4x4");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
