#include <QtCore/QtGlobal>
#include <QtCore/qxmlstream.h>
#include <QtCore/QVariant>

#include <QtJambi/QtJambiAPI>
#include <QtJambiCore/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

// emitting (writeClassCodeInjections)
bool operator<(const QXmlStreamAttribute& lhs, const QXmlStreamAttribute& rhs)
{
    return qHash(lhs) < qHash(rhs);
}
namespace QtJambiPrivate{
    template<>
    struct supports_less_than<QXmlStreamAttributes> : std::false_type{};
    template<>
    struct supports_stream_operators<QXmlStreamAttributes> : std::false_type{};
    template<>
    struct supports_debugstream<QXmlStreamAttributes> : std::false_type{};
}

void deleter_QXmlStreamAttributes(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QXmlStreamAttributes")
    QXmlStreamAttributes *_ptr = reinterpret_cast<QXmlStreamAttributes *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QXmlStreamAttributes()
void __qt_construct_QXmlStreamAttributes_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QXmlStreamAttributes()")
    Q_UNUSED(__java_arguments)
    QXmlStreamAttributes *__qt_this = new(__qtjambi_ptr) QXmlStreamAttributes();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QXmlStreamAttributes
void __qt_destruct_QXmlStreamAttributes(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QXmlStreamAttributes")
    reinterpret_cast<QXmlStreamAttributes*>(ptr)->~QXmlStreamAttributes();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QXmlStreamAttributes::QXmlStreamAttributes()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QXmlStreamAttributes_initialize_1native__Lio_qt_core_QXmlStreamAttributes_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QXmlStreamAttributes::QXmlStreamAttributes()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QXmlStreamAttributes_0, sizeof(QXmlStreamAttributes), typeid(QXmlStreamAttributes), false, QtJambiPrivate::QVectorAccess<QXmlStreamAttribute>::newInstance(), &deleter_QXmlStreamAttributes, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QXmlStreamAttributes::append(QString,QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QXmlStreamAttributes_append_1native_1cref_1QString_1cref_1QString__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring qualifiedName0,
 jstring value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QXmlStreamAttributes *__qt_this = QtJambiAPI::objectFromNativeId<QXmlStreamAttributes>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlStreamAttributes::append(QString,QString)", __qt_this)
        QString  __qt_qualifiedName0 = qtjambi_cast<QString>(__jni_env, qualifiedName0);
        QString  __qt_value1 = qtjambi_cast<QString>(__jni_env, value1);
        __qt_this->append(__qt_qualifiedName0, __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QXmlStreamAttributes::append(QString,QString,QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QXmlStreamAttributes_append_1native_1cref_1QString_1cref_1QString_1cref_1QString__JLjava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring namespaceUri0,
 jstring name1,
 jstring value2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QXmlStreamAttributes *__qt_this = QtJambiAPI::objectFromNativeId<QXmlStreamAttributes>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlStreamAttributes::append(QString,QString,QString)", __qt_this)
        QString  __qt_namespaceUri0 = qtjambi_cast<QString>(__jni_env, namespaceUri0);
        QString  __qt_name1 = qtjambi_cast<QString>(__jni_env, name1);
        QString  __qt_value2 = qtjambi_cast<QString>(__jni_env, value2);
        __qt_this->append(__qt_namespaceUri0, __qt_name1, __qt_value2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QXmlStreamAttributes::hasAttribute(QString)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QXmlStreamAttributes_hasAttribute_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring qualifiedName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QXmlStreamAttributes *__qt_this = QtJambiAPI::objectFromNativeId<QXmlStreamAttributes>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlStreamAttributes::hasAttribute(QString)const", __qt_this)
        QString  __qt_qualifiedName0 = qtjambi_cast<QString>(__jni_env, qualifiedName0);
        __java_return_value = __qt_this->hasAttribute(__qt_qualifiedName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QXmlStreamAttributes::hasAttribute(QString,QString)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QXmlStreamAttributes_hasAttribute_1native_1cref_1QString_1cref_1QString_1constfct__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring namespaceUri0,
 jstring name1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QXmlStreamAttributes *__qt_this = QtJambiAPI::objectFromNativeId<QXmlStreamAttributes>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlStreamAttributes::hasAttribute(QString,QString)const", __qt_this)
        QString  __qt_namespaceUri0 = qtjambi_cast<QString>(__jni_env, namespaceUri0);
        QString  __qt_name1 = qtjambi_cast<QString>(__jni_env, name1);
        __java_return_value = __qt_this->hasAttribute(__qt_namespaceUri0, __qt_name1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QXmlStreamAttributes::value(QString)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QXmlStreamAttributes_value_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring qualifiedName0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QXmlStreamAttributes *__qt_this = QtJambiAPI::objectFromNativeId<QXmlStreamAttributes>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlStreamAttributes::value(QString)const", __qt_this)
        QString  __qt_qualifiedName0 = qtjambi_cast<QString>(__jni_env, qualifiedName0);
        QStringRef __qt_return_value = __qt_this->value(__qt_qualifiedName0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QXmlStreamAttributes::value(QString,QString)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QXmlStreamAttributes_value_1native_1cref_1QString_1cref_1QString_1constfct__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring namespaceUri0,
 jstring name1)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QXmlStreamAttributes *__qt_this = QtJambiAPI::objectFromNativeId<QXmlStreamAttributes>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlStreamAttributes::value(QString,QString)const", __qt_this)
        QString  __qt_namespaceUri0 = qtjambi_cast<QString>(__jni_env, namespaceUri0);
        QString  __qt_name1 = qtjambi_cast<QString>(__jni_env, name1);
        QStringRef __qt_return_value = __qt_this->value(__qt_namespaceUri0, __qt_name1);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QXmlStreamAttributes_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QXmlStreamAttributes *__qt_this = QtJambiAPI::objectFromNativeId<QXmlStreamAttributes>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QXmlStreamAttributes_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QXmlStreamAttributes *__qt_this = QtJambiAPI::objectFromNativeId<QXmlStreamAttributes>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QXmlStreamAttributes(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QXmlStreamAttributes>("QXmlStreamAttributes", "io/qt/core/QXmlStreamAttributes");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QXmlStreamAttributes, {
        ConstructorInfo(&__qt_construct_QXmlStreamAttributes_0, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QXmlStreamAttributes);
    registerMetaType<QXmlStreamAttributes>("QXmlStreamAttributes");
    registerContainerAccessFactory(typeId, NewContainerAccessFunction(&QtJambiPrivate::QVectorAccess<QXmlStreamAttribute>::newInstance));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
