#include <QtCore/QtGlobal>
#include <QtCore/qrect.h>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtCore/qmargins.h>
#include <QtCore/qpoint.h>
#include <QtCore/qsize.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiCore/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QRect(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QRect")
    QRect *_ptr = reinterpret_cast<QRect *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QRect()
void __qt_construct_QRect_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRect()")
    Q_UNUSED(__java_arguments)
    QRect *__qt_this = new(__qtjambi_ptr) QRect();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QRect(QPoint,QPoint)
void __qt_construct_QRect_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRect(QPoint,QPoint)")
    jobject topleft0 = __java_arguments[0].l;
    const QPoint& __qt_topleft0 = qtjambi_cast<const QPoint& >(__jni_env, topleft0);
    jobject bottomright1 = __java_arguments[1].l;
    const QPoint& __qt_bottomright1 = qtjambi_cast<const QPoint& >(__jni_env, bottomright1);
    QRect *__qt_this = new(__qtjambi_ptr) QRect(__qt_topleft0, __qt_bottomright1);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QRect(QPoint,QSize)
void __qt_construct_QRect_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRect(QPoint,QSize)")
    jobject topleft0 = __java_arguments[0].l;
    const QPoint& __qt_topleft0 = qtjambi_cast<const QPoint& >(__jni_env, topleft0);
    jobject size1 = __java_arguments[1].l;
    const QSize& __qt_size1 = qtjambi_cast<const QSize& >(__jni_env, size1);
    QRect *__qt_this = new(__qtjambi_ptr) QRect(__qt_topleft0, __qt_size1);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QRect(int,int,int,int)
void __qt_construct_QRect_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRect(int,int,int,int)")
    jint left0 = __java_arguments[0].i;
    Q_UNUSED(left0)
    jint top1 = __java_arguments[1].i;
    Q_UNUSED(top1)
    jint width2 = __java_arguments[2].i;
    Q_UNUSED(width2)
    jint height3 = __java_arguments[3].i;
    Q_UNUSED(height3)
    QRect *__qt_this = new(__qtjambi_ptr) QRect(static_cast<int>(left0), static_cast<int>(top1), static_cast<int>(width2), static_cast<int>(height3));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QRect
void __qt_destruct_QRect(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QRect")
    reinterpret_cast<QRect*>(ptr)->~QRect();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QRect::QRect()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_initialize_1native__Lio_qt_core_QRect_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRect::QRect()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRect_0, sizeof(QRect), typeid(QRect), false, &deleter_QRect, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::QRect(QPoint,QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_initialize_1native__Lio_qt_core_QRect_2Lio_qt_core_QPoint_2Lio_qt_core_QPoint_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject topleft0,
 jobject bottomright1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRect::QRect(QPoint,QPoint)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = topleft0;
        arguments[1].l = bottomright1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRect_1, sizeof(QRect), typeid(QRect), false, &deleter_QRect, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::QRect(QPoint,QSize)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_initialize_1native__Lio_qt_core_QRect_2Lio_qt_core_QPoint_2Lio_qt_core_QSize_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject topleft0,
 jobject size1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRect::QRect(QPoint,QSize)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = topleft0;
        arguments[1].l = size1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRect_2, sizeof(QRect), typeid(QRect), false, &deleter_QRect, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::QRect(int,int,int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_initialize_1native__Lio_qt_core_QRect_2IIII)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint left0,
 jint top1,
 jint width2,
 jint height3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRect::QRect(int,int,int,int)")
    QTJAMBI_TRY {
        jvalue arguments[4];
        arguments[0].i = left0;
        arguments[1].i = top1;
        arguments[2].i = width2;
        arguments[3].i = height3;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRect_3, sizeof(QRect), typeid(QRect), false, &deleter_QRect, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::adjust(int,int,int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_adjust_1native_1int_1int_1int_1int__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint x10,
 jint y11,
 jint x22,
 jint y23)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::adjust(int,int,int,int)", __qt_this)
        __qt_this->adjust(static_cast<int>(x10), static_cast<int>(y11), static_cast<int>(x22), static_cast<int>(y23));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::adjusted(int,int,int,int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_adjusted_1native_1int_1int_1int_1int_1constfct__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint x10,
 jint y11,
 jint x22,
 jint y23)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::adjusted(int,int,int,int)const", __qt_this)
        QRect __qt_return_value = __qt_this->adjusted(static_cast<int>(x10), static_cast<int>(y11), static_cast<int>(x22), static_cast<int>(y23));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::bottom()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_bottom_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::bottom()const", __qt_this)
        __java_return_value = __qt_this->bottom();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::bottomLeft()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_bottomLeft_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::bottomLeft()const", __qt_this)
        QPoint __qt_return_value = __qt_this->bottomLeft();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::bottomRight()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_bottomRight_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::bottomRight()const", __qt_this)
        QPoint __qt_return_value = __qt_this->bottomRight();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::center()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_center_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::center()const", __qt_this)
        QPoint __qt_return_value = __qt_this->center();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::contains(QPoint,bool)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_contains_1native_1cref_1QPoint_1bool_1constfct__JJZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0,
 jboolean proper1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::contains(QPoint,bool)const", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        __java_return_value = __qt_this->contains(__qt_p0, static_cast<bool>(proper1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::contains(QRect,bool)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_contains_1native_1cref_1QRect_1bool_1constfct__JJZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r0,
 jboolean proper1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::contains(QRect,bool)const", __qt_this)
        const QRect& __qt_r0 = QtJambiAPI::valueReferenceFromNativeId<QRect>(r0);
        __java_return_value = __qt_this->contains(__qt_r0, static_cast<bool>(proper1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::contains(int,int)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_contains_1native_1int_1int_1constfct__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint x0,
 jint y1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::contains(int,int)const", __qt_this)
        __java_return_value = __qt_this->contains(static_cast<int>(x0), static_cast<int>(y1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::contains(int,int,bool)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_contains_1native_1int_1int_1bool_1constfct__JIIZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint x0,
 jint y1,
 jboolean proper2)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::contains(int,int,bool)const", __qt_this)
        __java_return_value = __qt_this->contains(static_cast<int>(x0), static_cast<int>(y1), static_cast<bool>(proper2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::height()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_height_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::height()const", __qt_this)
        __java_return_value = __qt_this->height();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::intersected(QRect)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_intersected_1native_1cref_1QRect_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::intersected(QRect)const", __qt_this)
        const QRect& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QRect>(other0);
        QRect __qt_return_value = __qt_this->intersected(__qt_other0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::intersects(QRect)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_intersects_1native_1cref_1QRect_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::intersects(QRect)const", __qt_this)
        const QRect& __qt_r0 = QtJambiAPI::valueReferenceFromNativeId<QRect>(r0);
        __java_return_value = __qt_this->intersects(__qt_r0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::isEmpty()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_isEmpty_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::isEmpty()const", __qt_this)
        __java_return_value = __qt_this->isEmpty();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::left()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_left_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::left()const", __qt_this)
        __java_return_value = __qt_this->left();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::marginsAdded(QMargins)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_marginsAdded_1native_1cref_1QMargins_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID margins0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::marginsAdded(QMargins)const", __qt_this)
        const QMargins& __qt_margins0 = QtJambiAPI::valueReferenceFromNativeId<QMargins>(margins0);
        QRect __qt_return_value = __qt_this->marginsAdded(__qt_margins0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::marginsRemoved(QMargins)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_marginsRemoved_1native_1cref_1QMargins_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID margins0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::marginsRemoved(QMargins)const", __qt_this)
        const QMargins& __qt_margins0 = QtJambiAPI::valueReferenceFromNativeId<QMargins>(margins0);
        QRect __qt_return_value = __qt_this->marginsRemoved(__qt_margins0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::moveBottom(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_moveBottom_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::moveBottom(int)", __qt_this)
        __qt_this->moveBottom(static_cast<int>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::moveBottomLeft(QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_moveBottomLeft_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::moveBottomLeft(QPoint)", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        __qt_this->moveBottomLeft(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::moveBottomRight(QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_moveBottomRight_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::moveBottomRight(QPoint)", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        __qt_this->moveBottomRight(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::moveCenter(QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_moveCenter_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::moveCenter(QPoint)", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        __qt_this->moveCenter(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::moveLeft(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_moveLeft_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::moveLeft(int)", __qt_this)
        __qt_this->moveLeft(static_cast<int>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::moveRight(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_moveRight_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::moveRight(int)", __qt_this)
        __qt_this->moveRight(static_cast<int>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::moveTo(QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_moveTo_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::moveTo(QPoint)", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        __qt_this->moveTo(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::moveTo(int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_moveTo_1native_1int_1int__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint x0,
 jint t1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::moveTo(int,int)", __qt_this)
        __qt_this->moveTo(static_cast<int>(x0), static_cast<int>(t1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::moveTop(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_moveTop_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::moveTop(int)", __qt_this)
        __qt_this->moveTop(static_cast<int>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::moveTopLeft(QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_moveTopLeft_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::moveTopLeft(QPoint)", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        __qt_this->moveTopLeft(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::moveTopRight(QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_moveTopRight_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::moveTopRight(QPoint)", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        __qt_this->moveTopRight(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::normalized()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_normalized_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::normalized()const", __qt_this)
        QRect __qt_return_value = __qt_this->normalized();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::operator+(QRect,QMargins)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_plus_1native_1cref_1QMargins__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID margins1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::operator+(QRect,QMargins)", __qt_this)
        const QMargins& __qt_margins1 = QtJambiAPI::valueReferenceFromNativeId<QMargins>(margins1);
        QRect __qt_return_value = (*__qt_this) + __qt_margins1;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::operator+=(QMargins)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_add_1native_1cref_1QMargins__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID margins0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::operator+=(QMargins)", __qt_this)
        const QMargins& __qt_margins0 = QtJambiAPI::valueReferenceFromNativeId<QMargins>(margins0);
        (*__qt_this) += __qt_margins0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::operator-(QRect,QMargins)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_minus_1native_1cref_1QMargins__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::operator-(QRect,QMargins)", __qt_this)
        const QMargins& __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QMargins>(rhs1);
        QRect __qt_return_value = (*__qt_this) - __qt_rhs1;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::operator-=(QMargins)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_subtract_1native_1cref_1QMargins__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID margins0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::operator-=(QMargins)", __qt_this)
        const QMargins& __qt_margins0 = QtJambiAPI::valueReferenceFromNativeId<QMargins>(margins0);
        (*__qt_this) -= __qt_margins0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::operator<<(QDataStream&,QRect)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::operator<<(QDataStream&,QRect)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::operator==(QRect,QRect)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_equals_1native_1cref_1QRect__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__2)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::operator==(QRect,QRect)", __qt_this)
        const QRect& __qt_arg__2 = QtJambiAPI::valueReferenceFromNativeId<QRect>(arg__2);
        __java_return_value = (*__qt_this) == __qt_arg__2;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::operator>>(QDataStream&,QRect&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::operator>>(QDataStream&,QRect&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::right()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_right_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::right()const", __qt_this)
        __java_return_value = __qt_this->right();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::setBottom(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setBottom_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setBottom(int)", __qt_this)
        __qt_this->setBottom(static_cast<int>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setBottomLeft(QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setBottomLeft_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setBottomLeft(QPoint)", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        __qt_this->setBottomLeft(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setBottomRight(QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setBottomRight_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setBottomRight(QPoint)", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        __qt_this->setBottomRight(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setCoords(int,int,int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setCoords_1native_1int_1int_1int_1int__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint x10,
 jint y11,
 jint x22,
 jint y23)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setCoords(int,int,int,int)", __qt_this)
        __qt_this->setCoords(static_cast<int>(x10), static_cast<int>(y11), static_cast<int>(x22), static_cast<int>(y23));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setHeight(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setHeight_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint h0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setHeight(int)", __qt_this)
        __qt_this->setHeight(static_cast<int>(h0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setLeft(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setLeft_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setLeft(int)", __qt_this)
        __qt_this->setLeft(static_cast<int>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setRect(int,int,int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setRect_1native_1int_1int_1int_1int__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint x0,
 jint y1,
 jint w2,
 jint h3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setRect(int,int,int,int)", __qt_this)
        __qt_this->setRect(static_cast<int>(x0), static_cast<int>(y1), static_cast<int>(w2), static_cast<int>(h3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setRight(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setRight_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setRight(int)", __qt_this)
        __qt_this->setRight(static_cast<int>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setSize(QSize)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setSize_1native_1cref_1QSize__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID s0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setSize(QSize)", __qt_this)
        const QSize& __qt_s0 = QtJambiAPI::valueReferenceFromNativeId<QSize>(s0);
        __qt_this->setSize(__qt_s0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setTop(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setTop_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setTop(int)", __qt_this)
        __qt_this->setTop(static_cast<int>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setTopLeft(QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setTopLeft_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setTopLeft(QPoint)", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        __qt_this->setTopLeft(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setTopRight(QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setTopRight_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setTopRight(QPoint)", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        __qt_this->setTopRight(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setWidth(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setWidth_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint w0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setWidth(int)", __qt_this)
        __qt_this->setWidth(static_cast<int>(w0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setX(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setX_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint x0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setX(int)", __qt_this)
        __qt_this->setX(static_cast<int>(x0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::setY(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_setY_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint y0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::setY(int)", __qt_this)
        __qt_this->setY(static_cast<int>(y0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::size()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::size()const", __qt_this)
        QSize __qt_return_value = __qt_this->size();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::top()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_top_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::top()const", __qt_this)
        __java_return_value = __qt_this->top();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::topLeft()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_topLeft_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::topLeft()const", __qt_this)
        QPoint __qt_return_value = __qt_this->topLeft();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::topRight()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_topRight_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::topRight()const", __qt_this)
        QPoint __qt_return_value = __qt_this->topRight();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::translate(QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_translate_1native_1cref_1QPoint__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::translate(QPoint)", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        __qt_this->translate(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::translate(int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_translate_1native_1int_1int__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint dx0,
 jint dy1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::translate(int,int)", __qt_this)
        __qt_this->translate(static_cast<int>(dx0), static_cast<int>(dy1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRect::translated(QPoint)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_translated_1native_1cref_1QPoint_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::translated(QPoint)const", __qt_this)
        const QPoint& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPoint>(p0);
        QRect __qt_return_value = __qt_this->translated(__qt_p0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::translated(int,int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_translated_1native_1int_1int_1constfct__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint dx0,
 jint dy1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::translated(int,int)const", __qt_this)
        QRect __qt_return_value = __qt_this->translated(static_cast<int>(dx0), static_cast<int>(dy1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::transposed()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_transposed_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::transposed()const", __qt_this)
        QRect __qt_return_value = __qt_this->transposed();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::united(QRect)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_united_1native_1cref_1QRect_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::united(QRect)const", __qt_this)
        const QRect& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QRect>(other0);
        QRect __qt_return_value = __qt_this->united(__qt_other0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::width()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_width_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::width()const", __qt_this)
        __java_return_value = __qt_this->width();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::x()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_x_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::x()const", __qt_this)
        __java_return_value = __qt_this->x();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRect::y()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_y_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRect::y()const", __qt_this)
        __java_return_value = __qt_this->y();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRect_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QRect *__qt_this = QtJambiAPI::objectFromNativeId<QRect>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QRect(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QRect>("QRect", "io/qt/core/QRect");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QRect, {
        ConstructorInfo(&__qt_construct_QRect_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QRect_1, "Lio/qt/core/QPoint;Lio/qt/core/QPoint;")
       ,ConstructorInfo(&__qt_construct_QRect_2, "Lio/qt/core/QPoint;Lio/qt/core/QSize;")
       ,ConstructorInfo(&__qt_construct_QRect_3, "IIII")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QRect);
    registerMetaType<QRect>("QRect");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
