#include <QtCore/QtGlobal>
#include <QtCore/qjsonvalue.h>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtCore/qjsonarray.h>
#include <QtCore/qjsonobject.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QJsonValue(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QJsonValue")
    QJsonValue *_ptr = reinterpret_cast<QJsonValue *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QJsonValue(QJsonArray)
void __qt_construct_QJsonValue_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonValue(QJsonArray)")
    jobject a0 = __java_arguments[0].l;
    const QJsonArray& __qt_a0 = qtjambi_cast<const QJsonArray& >(__jni_env, a0);
    QJsonValue *__qt_this = new(__qtjambi_ptr) QJsonValue(__qt_a0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QJsonValue(QJsonObject)
void __qt_construct_QJsonValue_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonValue(QJsonObject)")
    jobject o0 = __java_arguments[0].l;
    const QJsonObject& __qt_o0 = qtjambi_cast<const QJsonObject& >(__jni_env, o0);
    QJsonValue *__qt_this = new(__qtjambi_ptr) QJsonValue(__qt_o0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QJsonValue(QJsonValue)
void __qt_construct_QJsonValue_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonValue(QJsonValue)")
    jobject other0 = __java_arguments[0].l;
    const QJsonValue& __qt_other0 = qtjambi_cast<const QJsonValue& >(__jni_env, other0);
    QJsonValue *__qt_this = new(__qtjambi_ptr) QJsonValue(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QJsonValue(QJsonValue::Type)
void __qt_construct_QJsonValue_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonValue(QJsonValue::Type)")
    Q_UNUSED(__java_arguments)
    QJsonValue *__qt_this = new(__qtjambi_ptr) QJsonValue();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QJsonValue(QJsonValue::Type)
void __qt_construct_QJsonValue_4(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonValue(QJsonValue::Type)")
    jobject arg__1 = __java_arguments[0].l;
    QJsonValue::Type __qt_arg__1 = qtjambi_cast<QJsonValue::Type>(__jni_env, arg__1);
    QJsonValue *__qt_this = new(__qtjambi_ptr) QJsonValue(QJsonValue::Type(__qt_arg__1));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QJsonValue(QString)
void __qt_construct_QJsonValue_5(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonValue(QString)")
    jstring s0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_s0 = qtjambi_cast<QString>(__jni_env, s0);
    QJsonValue *__qt_this = new(__qtjambi_ptr) QJsonValue(__qt_s0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QJsonValue(bool)
void __qt_construct_QJsonValue_6(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonValue(bool)")
    jboolean b0 = __java_arguments[0].z;
    Q_UNUSED(b0)
    QJsonValue *__qt_this = new(__qtjambi_ptr) QJsonValue(static_cast<bool>(b0));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QJsonValue(double)
void __qt_construct_QJsonValue_7(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonValue(double)")
    jdouble n0 = __java_arguments[0].d;
    Q_UNUSED(n0)
    QJsonValue *__qt_this = new(__qtjambi_ptr) QJsonValue(static_cast<double>(n0));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QJsonValue(int)
void __qt_construct_QJsonValue_8(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonValue(int)")
    jint n0 = __java_arguments[0].i;
    Q_UNUSED(n0)
    QJsonValue *__qt_this = new(__qtjambi_ptr) QJsonValue(static_cast<int>(n0));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QJsonValue(qint64)
void __qt_construct_QJsonValue_9(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonValue(qint64)")
    jlong v0 = __java_arguments[0].j;
    Q_UNUSED(v0)
    QJsonValue *__qt_this = new(__qtjambi_ptr) QJsonValue(static_cast<qint64>(v0));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QJsonValue
void __qt_destruct_QJsonValue(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QJsonValue")
    reinterpret_cast<QJsonValue*>(ptr)->~QJsonValue();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QJsonValue::QJsonValue(QJsonArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_initialize_1native__Lio_qt_core_QJsonValue_2Lio_qt_core_QJsonArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject a0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonValue::QJsonValue(QJsonArray)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = a0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonValue_0, sizeof(QJsonValue), typeid(QJsonValue), false, &deleter_QJsonValue, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::QJsonValue(QJsonObject)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_initialize_1native__Lio_qt_core_QJsonValue_2Lio_qt_core_QJsonObject_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject o0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonValue::QJsonValue(QJsonObject)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = o0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonValue_1, sizeof(QJsonValue), typeid(QJsonValue), false, &deleter_QJsonValue, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::QJsonValue(QJsonValue)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_initialize_1native__Lio_qt_core_QJsonValue_2Lio_qt_core_QJsonValue_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonValue::QJsonValue(QJsonValue)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonValue_2, sizeof(QJsonValue), typeid(QJsonValue), false, &deleter_QJsonValue, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::QJsonValue(QJsonValue::Type)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_initialize_1native__Lio_qt_core_QJsonValue_2Lio_qt_core_QJsonValue_00024Type_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonValue::QJsonValue(QJsonValue::Type)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = arg__1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonValue_4, sizeof(QJsonValue), typeid(QJsonValue), false, &deleter_QJsonValue, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::QJsonValue(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_initialize_1native__Lio_qt_core_QJsonValue_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring s0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonValue::QJsonValue(QString)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = s0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonValue_5, sizeof(QJsonValue), typeid(QJsonValue), false, &deleter_QJsonValue, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::QJsonValue(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_initialize_1native__Lio_qt_core_QJsonValue_2Z)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jboolean b0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonValue::QJsonValue(bool)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.z = b0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonValue_6, sizeof(QJsonValue), typeid(QJsonValue), false, &deleter_QJsonValue, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::QJsonValue(double)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_initialize_1native__Lio_qt_core_QJsonValue_2D)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jdouble n0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonValue::QJsonValue(double)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.d = n0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonValue_7, sizeof(QJsonValue), typeid(QJsonValue), false, &deleter_QJsonValue, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::QJsonValue(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_initialize_1native__Lio_qt_core_QJsonValue_2I)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint n0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonValue::QJsonValue(int)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.i = n0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonValue_8, sizeof(QJsonValue), typeid(QJsonValue), false, &deleter_QJsonValue, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::QJsonValue(qint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_initialize_1native__Lio_qt_core_QJsonValue_2J)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jlong v0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonValue::QJsonValue(qint64)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.j = v0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonValue_9, sizeof(QJsonValue), typeid(QJsonValue), false, &deleter_QJsonValue, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::isArray()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_isArray_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::isArray()const", __qt_this)
        __java_return_value = __qt_this->isArray();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::isBool()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_isBool_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::isBool()const", __qt_this)
        __java_return_value = __qt_this->isBool();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::isDouble()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_isDouble_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::isDouble()const", __qt_this)
        __java_return_value = __qt_this->isDouble();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::isObject()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_isObject_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::isObject()const", __qt_this)
        __java_return_value = __qt_this->isObject();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::isString()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_isString_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::isString()const", __qt_this)
        __java_return_value = __qt_this->isString();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::isUndefined()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_isUndefined_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::isUndefined()const", __qt_this)
        __java_return_value = __qt_this->isUndefined();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::operator<<(QDataStream&,QJsonValue)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::operator<<(QDataStream&,QJsonValue)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::operator=(QJsonValue)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_assign_1native_1cref_1QJsonValue__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::operator=(QJsonValue)", __qt_this)
        const QJsonValue& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QJsonValue>(__jni_env, other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::operator==(QJsonValue)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_equals_1native_1cref_1QJsonValue_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::operator==(QJsonValue)const", __qt_this)
        const QJsonValue& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QJsonValue>(__jni_env, other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::operator>>(QDataStream&,QJsonValue&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::operator>>(QDataStream&,QJsonValue&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::operator[](QStringView)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_get_1native_1QStringView_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::operator[](QStringView)const", __qt_this)
        QStringView  __qt_key0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, key0);
        const QJsonValue __qt_return_value = (*__qt_this)[__qt_key0];
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::operator[](int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_get_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::operator[](int)const", __qt_this)
        const QJsonValue __qt_return_value = (*__qt_this)[static_cast<int>(i0)];
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::swap(QJsonValue&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_swap_1native_1ref_1QJsonValue__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::swap(QJsonValue&)", __qt_this)
        QJsonValue& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QJsonValue>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonValue::toArray()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_toArray_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::toArray()const", __qt_this)
        QJsonArray __qt_return_value = __qt_this->toArray();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::toArray(QJsonArray)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_toArray_1native_1cref_1QJsonArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID defaultValue0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::toArray(QJsonArray)const", __qt_this)
        const QJsonArray& __qt_defaultValue0 = QtJambiAPI::valueReferenceFromNativeId<QJsonArray>(defaultValue0);
        QJsonArray __qt_return_value = __qt_this->toArray(__qt_defaultValue0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::toBool(bool)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_toBoolean_1native_1bool_1constfct__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean defaultValue0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::toBool(bool)const", __qt_this)
        __java_return_value = __qt_this->toBool(static_cast<bool>(defaultValue0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::toDouble(double)const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_toDouble_1native_1double_1constfct__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble defaultValue0)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::toDouble(double)const", __qt_this)
        __java_return_value = __qt_this->toDouble(static_cast<double>(defaultValue0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::toInt(int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_toInt_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint defaultValue0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::toInt(int)const", __qt_this)
        __java_return_value = __qt_this->toInt(static_cast<int>(defaultValue0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::toObject()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_toObject_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::toObject()const", __qt_this)
        QJsonObject __qt_return_value = __qt_this->toObject();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::toObject(QJsonObject)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_toObject_1native_1cref_1QJsonObject_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID defaultValue0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::toObject(QJsonObject)const", __qt_this)
        const QJsonObject& __qt_defaultValue0 = QtJambiAPI::valueReferenceFromNativeId<QJsonObject>(defaultValue0);
        QJsonObject __qt_return_value = __qt_this->toObject(__qt_defaultValue0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::toString()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_toString_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::toString()const", __qt_this)
        QString __qt_return_value = __qt_this->toString();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::toString(QString)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_toString_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring defaultValue0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::toString(QString)const", __qt_this)
        QString  __qt_defaultValue0 = qtjambi_cast<QString>(__jni_env, defaultValue0);
        QString __qt_return_value = __qt_this->toString(__qt_defaultValue0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::toVariant()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_toVariant_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::toVariant()const", __qt_this)
        QVariant __qt_return_value = __qt_this->toVariant();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::type()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_type_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonValue::type()const", __qt_this)
        QJsonValue::Type __qt_return_value = __qt_this->type();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonValue::fromVariant(QVariant)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_fromVariant__Ljava_lang_Object_2)
(JNIEnv *__jni_env,
 jclass,
 jobject variant0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonValue::fromVariant(QVariant)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QVariant  __qt_variant0 = qtjambi_cast<QVariant >(__jni_env, variant0);
        QJsonValue __qt_return_value = QJsonValue::fromVariant(__qt_variant0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonValue_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QJsonValue *__qt_this = QtJambiAPI::objectFromNativeId<QJsonValue>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QJsonValue(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QJsonValue>("QJsonValue", "io/qt/core/QJsonValue");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QJsonValue, {
        ConstructorInfo(&__qt_construct_QJsonValue_0, "Lio/qt/core/QJsonArray;")
       ,ConstructorInfo(&__qt_construct_QJsonValue_1, "Lio/qt/core/QJsonObject;")
       ,ConstructorInfo(&__qt_construct_QJsonValue_2, "Lio/qt/core/QJsonValue;")
       ,ConstructorInfo(&__qt_construct_QJsonValue_3, nullptr)
       ,ConstructorInfo(&__qt_construct_QJsonValue_4, "Lio/qt/core/QJsonValue$Type;")
       ,ConstructorInfo(&__qt_construct_QJsonValue_5, "Ljava/lang/String;")
       ,ConstructorInfo(&__qt_construct_QJsonValue_6, "Z")
       ,ConstructorInfo(&__qt_construct_QJsonValue_7, "D")
       ,ConstructorInfo(&__qt_construct_QJsonValue_8, "I")
       ,ConstructorInfo(&__qt_construct_QJsonValue_9, "J")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QJsonValue);
    registerMetaType<QJsonValue>("QJsonValue");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QJsonValue::Type>("QJsonValue::Type", "io/qt/core/QJsonValue$Type");
// END: enums and flags
}
