#include "QFSFileEngine_shell.h"
#include <QtJambi/Cast>

void deleter_QFSFileEngine(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QFSFileEngine")
    QFSFileEngine *_ptr = reinterpret_cast<QFSFileEngine *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QFSFileEngine_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QFSFileEngine_shell) ); }

jmethodID QFSFileEngine_shell::__shell_javaMethod(int pos) const { return QFSFileEngine_shell::__shell()->javaMethod(typeid(QFSFileEngine), pos); }

// emitting (writeShellConstructor)
QFSFileEngine_shell::QFSFileEngine_shell()
    : QFSFileEngine()
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QFSFileEngine::QFSFileEngine_shell()", QFSFileEngine_shell::__shell())
    QFSFileEngine_shell::__shell()->constructed(typeid(QFSFileEngine));
}

QFSFileEngine_shell::QFSFileEngine_shell(const QString& file0)
    : QFSFileEngine(file0)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QFSFileEngine::QFSFileEngine_shell(const QString& file0)", QFSFileEngine_shell::__shell())
    QFSFileEngine_shell::__shell()->constructed(typeid(QFSFileEngine));
}

// emitting (writeShellDestructor)
QFSFileEngine_shell::~QFSFileEngine_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QFSFileEngine::~QFSFileEngine()", QFSFileEngine_shell::__shell())
    QFSFileEngine_shell::__shell()->destructed(typeid(QFSFileEngine));
}

void QFSFileEngine_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QFSFileEngine_shell*>(ptr)->QFSFileEngine_shell::__shell()->tryDeleteShell(typeid(QFSFileEngine));
}

// emitting Virtual overrides (virtualFunctions)
QAbstractFileEngineIterator* QFSFileEngine_shell::beginEntryList(QDir::Filters filters0, const QStringList& filterNames1)
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::beginEntryList(QDir::Filters,QStringList)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAbstractFileEngineIterator*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_filters0 = qtjambi_cast<jobject>(__jni_env, filters0);
                    jobject __java_filterNames1 = qtjambi_cast<jobject>(__jni_env, filterNames1);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_filters0, __java_filterNames1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAbstractFileEngineIterator* >(__jni_env, __java_return_value);
                    QtJambiAPI::setCppOwnership(__jni_env, __java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::beginEntryList(QDir::Filters,QStringList)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::beginEntryList(QDir::Filters,QStringList)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::beginEntryList(QDir::Filters(filters0), filterNames1);
        }
    }else{
        return QFSFileEngine::beginEntryList(QDir::Filters(filters0), filterNames1);
    }
}

bool QFSFileEngine_shell::caseSensitive() const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::caseSensitive()const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::caseSensitive()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::caseSensitive()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::caseSensitive();
        }
    }else{
        return QFSFileEngine::caseSensitive();
    }
}

bool QFSFileEngine_shell::cloneTo(QAbstractFileEngine* target0)
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::cloneTo(QAbstractFileEngine*)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_target0 = qtjambi_cast<jobject>(__jni_env, target0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_target0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_target0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::cloneTo(QAbstractFileEngine*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::cloneTo(QAbstractFileEngine*)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::cloneTo(target0);
        }
    }else{
        return QFSFileEngine::cloneTo(target0);
    }
}

bool QFSFileEngine_shell::close()
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::close()", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::close()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::close()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::close();
        }
    }else{
        return QFSFileEngine::close();
    }
}

bool QFSFileEngine_shell::copy(const QString& newName0)
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::copy(QString)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_newName0 = qtjambi_cast<jstring>(__jni_env, newName0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_newName0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::copy(QString)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::copy(QString)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::copy(newName0);
        }
    }else{
        return QFSFileEngine::copy(newName0);
    }
}

QAbstractFileEngineIterator* QFSFileEngine_shell::endEntryList()
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::endEntryList()", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAbstractFileEngineIterator*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAbstractFileEngineIterator* >(__jni_env, __java_return_value);
                    QtJambiAPI::setCppOwnership(__jni_env, __java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::endEntryList()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::endEntryList()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::endEntryList();
        }
    }else{
        return QFSFileEngine::endEntryList();
    }
}

QStringList QFSFileEngine_shell::entryList(QDir::Filters filters0, const QStringList& filterNames1) const
{
    if(jmethodID method_id = __shell_javaMethod(6)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::entryList(QDir::Filters,QStringList)const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QStringList  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    QtJambiScope __qtjambi_scope(QFSFileEngine_shell::__shell());
                    jobject __java_filters0 = qtjambi_cast<jobject>(__jni_env, filters0);
                    jobject __java_filterNames1 = qtjambi_cast<jobject>(__jni_env, filterNames1);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_filters0, __java_filterNames1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QStringList >(__jni_env, __qtjambi_scope, __java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::entryList(QDir::Filters,QStringList)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::entryList(QDir::Filters,QStringList)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::entryList(QDir::Filters(filters0), filterNames1);
        }
    }else{
        return QFSFileEngine::entryList(QDir::Filters(filters0), filterNames1);
    }
}

QAbstractFileEngine::FileFlags QFSFileEngine_shell::fileFlags(QAbstractFileEngine::FileFlags type0) const
{
    if(jmethodID method_id = __shell_javaMethod(7)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::fileFlags(QAbstractFileEngine::FileFlags)const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAbstractFileEngine::FileFlags  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_type0 = qtjambi_cast<jobject>(__jni_env, type0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_type0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAbstractFileEngine::FileFlags>(__jni_env, __java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::fileFlags(QAbstractFileEngine::FileFlags)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::fileFlags(QAbstractFileEngine::FileFlags)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::fileFlags(QAbstractFileEngine::FileFlags(type0));
        }
    }else{
        return QFSFileEngine::fileFlags(QAbstractFileEngine::FileFlags(type0));
    }
}

QString QFSFileEngine_shell::fileName(QAbstractFileEngine::FileName file0) const
{
    if(jmethodID method_id = __shell_javaMethod(8)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::fileName(QAbstractFileEngine::FileName)const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_file0 = qtjambi_cast<jobject>(__jni_env, file0);
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, __java_file0));
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::fileName(QAbstractFileEngine::FileName)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::fileName(QAbstractFileEngine::FileName)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::fileName(QAbstractFileEngine::FileName(file0));
        }
    }else{
        return QFSFileEngine::fileName(QAbstractFileEngine::FileName(file0));
    }
}

QDateTime QFSFileEngine_shell::fileTime(QAbstractFileEngine::FileTime time0) const
{
    if(jmethodID method_id = __shell_javaMethod(9)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::fileTime(QAbstractFileEngine::FileTime)const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QDateTime  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_time0 = qtjambi_cast<jobject>(__jni_env, time0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_time0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QDateTime >(__jni_env, __java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::fileTime(QAbstractFileEngine::FileTime)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::fileTime(QAbstractFileEngine::FileTime)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::fileTime(QAbstractFileEngine::FileTime(time0));
        }
    }else{
        return QFSFileEngine::fileTime(QAbstractFileEngine::FileTime(time0));
    }
}

bool QFSFileEngine_shell::flush()
{
    if(jmethodID method_id = __shell_javaMethod(10)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::flush()", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::flush()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::flush()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::flush();
        }
    }else{
        return QFSFileEngine::flush();
    }
}

int QFSFileEngine_shell::handle() const
{
    if(jmethodID method_id = __shell_javaMethod(11)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::handle()const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::handle()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::handle()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::handle();
        }
    }else{
        return QFSFileEngine::handle();
    }
}

QByteArray QFSFileEngine_shell::id() const
{
    if(jmethodID method_id = __shell_javaMethod(12)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::id()const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QByteArray  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QByteArray >(__jni_env, __java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::id()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::id()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::id();
        }
    }else{
        return QFSFileEngine::id();
    }
}

bool QFSFileEngine_shell::isRelativePath() const
{
    if(jmethodID method_id = __shell_javaMethod(13)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::isRelativePath()const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::isRelativePath()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::isRelativePath()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::isRelativePath();
        }
    }else{
        return QFSFileEngine::isRelativePath();
    }
}

bool QFSFileEngine_shell::isSequential() const
{
    if(jmethodID method_id = __shell_javaMethod(14)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::isSequential()const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::isSequential()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::isSequential()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::isSequential();
        }
    }else{
        return QFSFileEngine::isSequential();
    }
}

bool QFSFileEngine_shell::isUnnamedFile() const
{
    if(jmethodID method_id = __shell_javaMethod(15)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::isUnnamedFile()const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::isUnnamedFile()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::isUnnamedFile()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::isUnnamedFile();
        }
    }else{
        return QFSFileEngine::isUnnamedFile();
    }
}

bool QFSFileEngine_shell::link(const QString& newName0)
{
    if(jmethodID method_id = __shell_javaMethod(16)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::link(QString)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_newName0 = qtjambi_cast<jstring>(__jni_env, newName0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_newName0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::link(QString)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::link(QString)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::link(newName0);
        }
    }else{
        return QFSFileEngine::link(newName0);
    }
}

bool QFSFileEngine_shell::mkdir(const QString& dirName0, bool createParentDirectories1) const
{
    if(jmethodID method_id = __shell_javaMethod(17)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::mkdir(QString,bool)const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_dirName0 = qtjambi_cast<jstring>(__jni_env, dirName0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_dirName0, createParentDirectories1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::mkdir(QString,bool)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::mkdir(QString,bool)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::mkdir(dirName0, static_cast<bool>(createParentDirectories1));
        }
    }else{
        return QFSFileEngine::mkdir(dirName0, static_cast<bool>(createParentDirectories1));
    }
}

bool QFSFileEngine_shell::open(QIODevice::OpenMode openMode0)
{
    if(jmethodID method_id = __shell_javaMethod(18)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::open(QIODevice::OpenMode)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_openMode0 = qtjambi_cast<jobject>(__jni_env, openMode0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_openMode0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::open(QIODevice::OpenMode)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::open(QIODevice::OpenMode)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::open(QIODevice::OpenMode(openMode0));
        }
    }else{
        return QFSFileEngine::open(QIODevice::OpenMode(openMode0));
    }
}

QString QFSFileEngine_shell::owner(QAbstractFileEngine::FileOwner arg__1) const
{
    if(jmethodID method_id = __shell_javaMethod(19)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::owner(QAbstractFileEngine::FileOwner)const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_arg__1 = qtjambi_cast<jobject>(__jni_env, arg__1);
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, __java_arg__1));
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::owner(QAbstractFileEngine::FileOwner)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::owner(QAbstractFileEngine::FileOwner)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::owner(QAbstractFileEngine::FileOwner(arg__1));
        }
    }else{
        return QFSFileEngine::owner(QAbstractFileEngine::FileOwner(arg__1));
    }
}

uint QFSFileEngine_shell::ownerId(QAbstractFileEngine::FileOwner arg__1) const
{
    if(jmethodID method_id = __shell_javaMethod(20)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::ownerId(QAbstractFileEngine::FileOwner)const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            uint  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_arg__1 = qtjambi_cast<jobject>(__jni_env, arg__1);
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_arg__1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<uint>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::ownerId(QAbstractFileEngine::FileOwner)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::ownerId(QAbstractFileEngine::FileOwner)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::ownerId(QAbstractFileEngine::FileOwner(arg__1));
        }
    }else{
        return QFSFileEngine::ownerId(QAbstractFileEngine::FileOwner(arg__1));
    }
}

qint64 QFSFileEngine_shell::pos() const
{
    if(jmethodID method_id = __shell_javaMethod(21)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::pos()const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            qint64  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jlong __java_return_value = __jni_env->CallLongMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<qint64>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::pos()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::pos()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::pos();
        }
    }else{
        return QFSFileEngine::pos();
    }
}

qint64 QFSFileEngine_shell::read(char* data0, qint64 maxlen1)
{
    if(jmethodID method_id = __shell_javaMethod(22)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::read(char*,qint64)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            qint64  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    DataJBuffer __java_data0_buffer(__jni_env, data0, maxlen1);
                    jobject __java_data0 = __java_data0_buffer.buffer();
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_data0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<qint64>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::read(char*,qint64)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::read(char*,qint64)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::read(data0, static_cast<qint64>(maxlen1));
        }
    }else{
        return QFSFileEngine::read(data0, static_cast<qint64>(maxlen1));
    }
}

qint64 QFSFileEngine_shell::readLine(char* data0, qint64 maxlen1)
{
    if(jmethodID method_id = __shell_javaMethod(23)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::readLine(char*,qint64)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            qint64  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    DataJBuffer __java_data0_buffer(__jni_env, data0, maxlen1);
                    jobject __java_data0 = __java_data0_buffer.buffer();
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_data0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<qint64>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::readLine(char*,qint64)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::readLine(char*,qint64)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::readLine(data0, static_cast<qint64>(maxlen1));
        }
    }else{
        return QFSFileEngine::readLine(data0, static_cast<qint64>(maxlen1));
    }
}

bool QFSFileEngine_shell::remove()
{
    if(jmethodID method_id = __shell_javaMethod(24)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::remove()", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::remove()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::remove()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::remove();
        }
    }else{
        return QFSFileEngine::remove();
    }
}

bool QFSFileEngine_shell::rename(const QString& newName0)
{
    if(jmethodID method_id = __shell_javaMethod(25)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::rename(QString)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_newName0 = qtjambi_cast<jstring>(__jni_env, newName0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_newName0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::rename(QString)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::rename(QString)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::rename(newName0);
        }
    }else{
        return QFSFileEngine::rename(newName0);
    }
}

bool QFSFileEngine_shell::renameOverwrite(const QString& newName0)
{
    if(jmethodID method_id = __shell_javaMethod(26)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::renameOverwrite(QString)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_newName0 = qtjambi_cast<jstring>(__jni_env, newName0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_newName0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::renameOverwrite(QString)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::renameOverwrite(QString)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::renameOverwrite(newName0);
        }
    }else{
        return QFSFileEngine::renameOverwrite(newName0);
    }
}

bool QFSFileEngine_shell::rmdir(const QString& dirName0, bool recurseParentDirectories1) const
{
    if(jmethodID method_id = __shell_javaMethod(27)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::rmdir(QString,bool)const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_dirName0 = qtjambi_cast<jstring>(__jni_env, dirName0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_dirName0, recurseParentDirectories1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::rmdir(QString,bool)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::rmdir(QString,bool)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::rmdir(dirName0, static_cast<bool>(recurseParentDirectories1));
        }
    }else{
        return QFSFileEngine::rmdir(dirName0, static_cast<bool>(recurseParentDirectories1));
    }
}

bool QFSFileEngine_shell::seek(qint64 arg__1)
{
    if(jmethodID method_id = __shell_javaMethod(28)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::seek(qint64)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, arg__1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::seek(qint64)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::seek(qint64)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::seek(static_cast<qint64>(arg__1));
        }
    }else{
        return QFSFileEngine::seek(static_cast<qint64>(arg__1));
    }
}

void QFSFileEngine_shell::setFileName(const QString& file0)
{
    if(jmethodID method_id = __shell_javaMethod(29)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::setFileName(QString)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_file0 = qtjambi_cast<jstring>(__jni_env, file0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_file0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::setFileName(QString)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::setFileName(QString)");
            } QTJAMBI_TRY_END
        }else{
            QFSFileEngine::setFileName(file0);
        }
    }else{
        QFSFileEngine::setFileName(file0);
    }
}

bool QFSFileEngine_shell::setFileTime(const QDateTime& newDate0, QAbstractFileEngine::FileTime time1)
{
    if(jmethodID method_id = __shell_javaMethod(30)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::setFileTime(QDateTime,QAbstractFileEngine::FileTime)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_newDate0 = qtjambi_cast<jobject>(__jni_env, newDate0);
                    jobject __java_time1 = qtjambi_cast<jobject>(__jni_env, time1);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_newDate0, __java_time1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::setFileTime(QDateTime,QAbstractFileEngine::FileTime)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::setFileTime(QDateTime,QAbstractFileEngine::FileTime)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::setFileTime(newDate0, QAbstractFileEngine::FileTime(time1));
        }
    }else{
        return QFSFileEngine::setFileTime(newDate0, QAbstractFileEngine::FileTime(time1));
    }
}

bool QFSFileEngine_shell::setPermissions(uint perms0)
{
    if(jmethodID method_id = __shell_javaMethod(31)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::setPermissions(uint)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, perms0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::setPermissions(uint)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::setPermissions(uint)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::setPermissions(static_cast<uint>(perms0));
        }
    }else{
        return QFSFileEngine::setPermissions(static_cast<uint>(perms0));
    }
}

bool QFSFileEngine_shell::setSize(qint64 size0)
{
    if(jmethodID method_id = __shell_javaMethod(32)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::setSize(qint64)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, size0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::setSize(qint64)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::setSize(qint64)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::setSize(static_cast<qint64>(size0));
        }
    }else{
        return QFSFileEngine::setSize(static_cast<qint64>(size0));
    }
}

qint64 QFSFileEngine_shell::size() const
{
    if(jmethodID method_id = __shell_javaMethod(33)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::size()const", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            qint64  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jlong __java_return_value = __jni_env->CallLongMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<qint64>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::size()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::size()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::size();
        }
    }else{
        return QFSFileEngine::size();
    }
}

bool QFSFileEngine_shell::syncToDisk()
{
    if(jmethodID method_id = __shell_javaMethod(34)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::syncToDisk()", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::syncToDisk()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::syncToDisk()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::syncToDisk();
        }
    }else{
        return QFSFileEngine::syncToDisk();
    }
}

qint64 QFSFileEngine_shell::write(const char* data0, qint64 len1)
{
    if(jmethodID method_id = __shell_javaMethod(35)){
        QTJAMBI_JAVA_METHOD_CALL("QFSFileEngine::write(const char*,qint64)", QFSFileEngine_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            qint64  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QFSFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    DataJBuffer __java_data0_buffer(__jni_env, data0, len1);
                    jobject __java_data0 = __java_data0_buffer.buffer();
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_data0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<qint64>(__java_return_value);
                } else {
                    QFSFileEngine_shell::__shell()->warnForMethod("QFSFileEngine::write(const char*,qint64)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QFSFileEngine::write(const char*,qint64)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QFSFileEngine::write(data0, static_cast<qint64>(len1));
        }
    }else{
        return QFSFileEngine::write(data0, static_cast<qint64>(len1));
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
jobject QFSFileEngine_access::__qt_beginEntryList_QDir_Filters_cref_QStringList(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint filters0, jobject filterNames1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QDir::Filters __qt_filters0 = qtjambi_cast<QDir::Filters>(__jni_env, filters0);
    const QStringList&  __qt_filterNames1 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, filterNames1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAbstractFileEngineIterator* __qt_return_value = QFSFileEngine::beginEntryList(__qt_filters0, __qt_filterNames1);
        jobject __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnership(__jni_env, __java_return_value);
        return __java_return_value;
    } else {
        QAbstractFileEngineIterator* __qt_return_value = beginEntryList(__qt_filters0, __qt_filterNames1);
        jobject __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnership(__jni_env, __java_return_value);
        return __java_return_value;
    }
}

jboolean QFSFileEngine_access::__qt_caseSensitive(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::caseSensitive();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = caseSensitive();
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_cloneTo_QAbstractFileEngine_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID target0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAbstractFileEngine* __qt_target0 = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(target0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::cloneTo(__qt_target0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = cloneTo(__qt_target0);
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_close(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::close();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = close();
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_copy_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring newName0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_newName0 = qtjambi_cast<QString>(__jni_env, newName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::copy(__qt_newName0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = copy(__qt_newName0);
        return jboolean(__qt_return_value);
    }
}

jobject QFSFileEngine_access::__qt_endEntryList(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAbstractFileEngineIterator* __qt_return_value = QFSFileEngine::endEntryList();
        jobject __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnership(__jni_env, __java_return_value);
        return __java_return_value;
    } else {
        QAbstractFileEngineIterator* __qt_return_value = endEntryList();
        jobject __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnership(__jni_env, __java_return_value);
        return __java_return_value;
    }
}

jobject QFSFileEngine_access::__qt_entryList_QDir_Filters_cref_QStringList_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint filters0, jobject filterNames1) const
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QDir::Filters __qt_filters0 = qtjambi_cast<QDir::Filters>(__jni_env, filters0);
    const QStringList&  __qt_filterNames1 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, filterNames1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QStringList __qt_return_value = QFSFileEngine::entryList(__qt_filters0, __qt_filterNames1);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QStringList __qt_return_value = entryList(__qt_filters0, __qt_filterNames1);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QFSFileEngine_access::__qt_fileFlags_QAbstractFileEngine_FileFlags_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint type0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAbstractFileEngine::FileFlags __qt_type0 = qtjambi_cast<QAbstractFileEngine::FileFlags>(__jni_env, type0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAbstractFileEngine::FileFlags __qt_return_value = QFSFileEngine::fileFlags(__qt_type0);
        return __qt_return_value;
    } else {
        QAbstractFileEngine::FileFlags __qt_return_value = fileFlags(__qt_type0);
        return __qt_return_value;
    }
}

jstring QFSFileEngine_access::__qt_fileName_QAbstractFileEngine_FileName_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint file0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAbstractFileEngine::FileName __qt_file0 = qtjambi_cast<QAbstractFileEngine::FileName>(__jni_env, file0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QFSFileEngine::fileName(__qt_file0);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = fileName(__qt_file0);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jobject QFSFileEngine_access::__qt_fileTime_QAbstractFileEngine_FileTime_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint time0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAbstractFileEngine::FileTime __qt_time0 = qtjambi_cast<QAbstractFileEngine::FileTime>(__jni_env, time0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QDateTime __qt_return_value = QFSFileEngine::fileTime(__qt_time0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QDateTime __qt_return_value = fileTime(__qt_time0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_flush(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::flush();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = flush();
        return jboolean(__qt_return_value);
    }
}

jint QFSFileEngine_access::__qt_handle(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QFSFileEngine::handle();
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = handle();
        return jint(__qt_return_value);
    }
}

jobject QFSFileEngine_access::__qt_id(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QByteArray __qt_return_value = QFSFileEngine::id();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QByteArray __qt_return_value = id();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_isRelativePath(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::isRelativePath();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = isRelativePath();
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_isSequential(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::isSequential();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = isSequential();
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_isUnnamedFile(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::isUnnamedFile();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = isUnnamedFile();
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_link_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring newName0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_newName0 = qtjambi_cast<QString>(__jni_env, newName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::link(__qt_newName0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = link(__qt_newName0);
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_mkdir_cref_QString_bool_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring dirName0, jboolean createParentDirectories1) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_dirName0 = qtjambi_cast<QString>(__jni_env, dirName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::mkdir(__qt_dirName0, static_cast<bool>(createParentDirectories1));
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = mkdir(__qt_dirName0, static_cast<bool>(createParentDirectories1));
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_open_QIODevice_OpenMode(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint openMode0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QIODevice::OpenMode __qt_openMode0 = qtjambi_cast<QIODevice::OpenMode>(__jni_env, openMode0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::open(__qt_openMode0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = open(__qt_openMode0);
        return jboolean(__qt_return_value);
    }
}

jstring QFSFileEngine_access::__qt_owner_QAbstractFileEngine_FileOwner_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint arg__1) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAbstractFileEngine::FileOwner __qt_arg__1 = qtjambi_cast<QAbstractFileEngine::FileOwner>(__jni_env, arg__1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QFSFileEngine::owner(__qt_arg__1);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = owner(__qt_arg__1);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jint QFSFileEngine_access::__qt_ownerId_QAbstractFileEngine_FileOwner_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint arg__1) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAbstractFileEngine::FileOwner __qt_arg__1 = qtjambi_cast<QAbstractFileEngine::FileOwner>(__jni_env, arg__1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        uint __qt_return_value = QFSFileEngine::ownerId(__qt_arg__1);
        return jint(__qt_return_value);
    } else {
        uint __qt_return_value = ownerId(__qt_arg__1);
        return jint(__qt_return_value);
    }
}

jlong QFSFileEngine_access::__qt_pos(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        qint64 __qt_return_value = QFSFileEngine::pos();
        return jlong(__qt_return_value);
    } else {
        qint64 __qt_return_value = pos();
        return jlong(__qt_return_value);
    }
}

jint QFSFileEngine_access::__qt_read_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject data0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    qint64 maxlen1{0};
    JBufferData __qt_data0_buffer(__jni_env, data0);
    char* __qt_data0 = __qt_data0_buffer.data<char>();
    maxlen1 = __qt_data0_buffer.size<char>();
    if (QtJambiAPI::isShell(__this_nativeId)) {
        qint64 __qt_return_value = QFSFileEngine::read(__qt_data0, static_cast<qint64>(maxlen1));
        return jint(__qt_return_value);
    } else {
        qint64 __qt_return_value = read(__qt_data0, static_cast<qint64>(maxlen1));
        return jint(__qt_return_value);
    }
}

jint QFSFileEngine_access::__qt_readLine_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject data0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    qint64 maxlen1{0};
    JBufferData __qt_data0_buffer(__jni_env, data0);
    char* __qt_data0 = __qt_data0_buffer.data<char>();
    maxlen1 = __qt_data0_buffer.size<char>();
    if (QtJambiAPI::isShell(__this_nativeId)) {
        qint64 __qt_return_value = QFSFileEngine::readLine(__qt_data0, static_cast<qint64>(maxlen1));
        return jint(__qt_return_value);
    } else {
        qint64 __qt_return_value = readLine(__qt_data0, static_cast<qint64>(maxlen1));
        return jint(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_remove(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::remove();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = remove();
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_rename_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring newName0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_newName0 = qtjambi_cast<QString>(__jni_env, newName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::rename(__qt_newName0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = rename(__qt_newName0);
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_renameOverwrite_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring newName0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_newName0 = qtjambi_cast<QString>(__jni_env, newName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::renameOverwrite(__qt_newName0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = renameOverwrite(__qt_newName0);
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_rmdir_cref_QString_bool_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring dirName0, jboolean recurseParentDirectories1) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_dirName0 = qtjambi_cast<QString>(__jni_env, dirName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::rmdir(__qt_dirName0, static_cast<bool>(recurseParentDirectories1));
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = rmdir(__qt_dirName0, static_cast<bool>(recurseParentDirectories1));
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_seek_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jlong arg__1)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::seek(static_cast<qint64>(arg__1));
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = seek(static_cast<qint64>(arg__1));
        return jboolean(__qt_return_value);
    }
}

void QFSFileEngine_access::__qt_setFileName_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring file0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_file0 = qtjambi_cast<QString>(__jni_env, file0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QFSFileEngine::setFileName(__qt_file0);
    } else {
        setFileName(__qt_file0);
    }
}

jboolean QFSFileEngine_access::__qt_setFileTime_cref_QDateTime_QAbstractFileEngine_FileTime(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID newDate0, jint time1)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QDateTime& __qt_newDate0 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(newDate0);
    QAbstractFileEngine::FileTime __qt_time1 = qtjambi_cast<QAbstractFileEngine::FileTime>(__jni_env, time1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::setFileTime(__qt_newDate0, __qt_time1);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = setFileTime(__qt_newDate0, __qt_time1);
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_setPermissions_uint(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint perms0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::setPermissions(static_cast<uint>(perms0));
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = setPermissions(static_cast<uint>(perms0));
        return jboolean(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_setSize_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jlong size0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::setSize(static_cast<qint64>(size0));
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = setSize(static_cast<qint64>(size0));
        return jboolean(__qt_return_value);
    }
}

jlong QFSFileEngine_access::__qt_size(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        qint64 __qt_return_value = QFSFileEngine::size();
        return jlong(__qt_return_value);
    } else {
        qint64 __qt_return_value = size();
        return jlong(__qt_return_value);
    }
}

jboolean QFSFileEngine_access::__qt_syncToDisk(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QFSFileEngine::syncToDisk();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = syncToDisk();
        return jboolean(__qt_return_value);
    }
}

jint QFSFileEngine_access::__qt_write_const_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject data0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    qint64 len1{0};
    JBufferConstData __qt_data0_buffer(__jni_env, data0);
    const char* __qt_data0 = __qt_data0_buffer.data<char>();
    len1 = __qt_data0_buffer.size<char>();
    if (QtJambiAPI::isShell(__this_nativeId)) {
        qint64 __qt_return_value = QFSFileEngine::write(__qt_data0, static_cast<qint64>(len1));
        return jint(__qt_return_value);
    } else {
        qint64 __qt_return_value = write(__qt_data0, static_cast<qint64>(len1));
        return jint(__qt_return_value);
    }
}

// emitting (writeConstructors)
// new QFSFileEngine()
void __qt_construct_QFSFileEngine_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QFSFileEngine()")
    Q_UNUSED(__java_arguments)
    QFSFileEngine *__qt_this = new(__qtjambi_ptr) QFSFileEngine_shell();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QFSFileEngine(QString)
void __qt_construct_QFSFileEngine_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QFSFileEngine(QString)")
    jstring file0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_file0 = qtjambi_cast<QString>(__jni_env, file0);
    QFSFileEngine *__qt_this = new(__qtjambi_ptr) QFSFileEngine_shell(__qt_file0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QFSFileEngine_shell
void __qt_destruct_QFSFileEngine(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QFSFileEngine")
    reinterpret_cast<QFSFileEngine_shell*>(ptr)->~QFSFileEngine_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QFSFileEngine::QFSFileEngine()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_initialize_1native__Lio_qt_core_internal_QFSFileEngine_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QFSFileEngine::QFSFileEngine()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QFSFileEngine_0, sizeof(QFSFileEngine_shell), typeid(QFSFileEngine), true, &deleter_QFSFileEngine, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QFSFileEngine::QFSFileEngine(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_initialize_1native__Lio_qt_core_internal_QFSFileEngine_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring file0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QFSFileEngine::QFSFileEngine(QString)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = file0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QFSFileEngine_1, sizeof(QFSFileEngine_shell), typeid(QFSFileEngine), true, &deleter_QFSFileEngine, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QFSFileEngine::open(QIODevice::OpenMode,int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_open_1native_1QIODevice_1OpenMode_1int__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint flags0,
 jint fd1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::open(QIODevice::OpenMode,int)", __qt_this)
        QIODevice::OpenMode __qt_flags0 = qtjambi_cast<QIODevice::OpenMode>(__jni_env, flags0);
        __java_return_value = __qt_this->open(__qt_flags0, static_cast<int>(fd1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::open(QIODevice::OpenMode,int,QFile::FileHandleFlags)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_open_1native_1QIODevice_1OpenMode_1int_1QFileDevice_1FileHandleFlags__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint flags0,
 jint fd1,
 jint handleFlags2)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::open(QIODevice::OpenMode,int,QFile::FileHandleFlags)", __qt_this)
        QIODevice::OpenMode __qt_flags0 = qtjambi_cast<QIODevice::OpenMode>(__jni_env, flags0);
        QFileDevice::FileHandleFlags __qt_handleFlags2 = qtjambi_cast<QFileDevice::FileHandleFlags>(__jni_env, handleFlags2);
        __java_return_value = __qt_this->open(__qt_flags0, static_cast<int>(fd1), __qt_handleFlags2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::beginEntryList(QDir::Filters,QStringList)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_beginEntryList_1native_1QDir_1Filters_1cref_1QStringList__JILjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint filters0,
 jobject filterNames1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::beginEntryList(QDir::Filters,QStringList)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_beginEntryList_QDir_Filters_cref_QStringList(__jni_env, __this_nativeId, filters0, filterNames1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::caseSensitive()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_caseSensitive_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::caseSensitive()const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_caseSensitive(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::cloneTo(QAbstractFileEngine*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_cloneTo_1native_1QAbstractFileEngine_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID target0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::cloneTo(QAbstractFileEngine*)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_cloneTo_QAbstractFileEngine_ptr(__jni_env, __this_nativeId, target0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::close()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_close_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::close()", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_close(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::copy(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_copy_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring newName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::copy(QString)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_copy_cref_QString(__jni_env, __this_nativeId, newName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::endEntryList()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_endEntryList_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::endEntryList()", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_endEntryList(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::entryList(QDir::Filters,QStringList)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_entryList_1native_1QDir_1Filters_1cref_1QStringList_1constfct__JILjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint filters0,
 jobject filterNames1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::entryList(QDir::Filters,QStringList)const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_entryList_QDir_Filters_cref_QStringList_constfct(__jni_env, __this_nativeId, filters0, filterNames1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::fileFlags(QAbstractFileEngine::FileFlags)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_fileFlags_1native_1QAbstractFileEngine_1FileFlags_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint type0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::fileFlags(QAbstractFileEngine::FileFlags)const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_fileFlags_QAbstractFileEngine_FileFlags_constfct(__jni_env, __this_nativeId, type0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::fileName(QAbstractFileEngine::FileName)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_fileName_1native_1QAbstractFileEngine_1FileName_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint file0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::fileName(QAbstractFileEngine::FileName)const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_fileName_QAbstractFileEngine_FileName_constfct(__jni_env, __this_nativeId, file0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::fileTime(QAbstractFileEngine::FileTime)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_fileTime_1native_1QAbstractFileEngine_1FileTime_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint time0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::fileTime(QAbstractFileEngine::FileTime)const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_fileTime_QAbstractFileEngine_FileTime_constfct(__jni_env, __this_nativeId, time0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::flush()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_flush_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::flush()", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_flush(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::handle()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_handle_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::handle()const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_handle(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::id()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_id_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::id()const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_id(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::isRelativePath()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_isRelativePath_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::isRelativePath()const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_isRelativePath(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::isSequential()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_isSequential_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::isSequential()const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_isSequential(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::isUnnamedFile()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_isUnnamedFile_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::isUnnamedFile()const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_isUnnamedFile(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::link(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_link_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring newName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::link(QString)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_link_cref_QString(__jni_env, __this_nativeId, newName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::mkdir(QString,bool)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_mkdir_1native_1cref_1QString_1bool_1constfct__JLjava_lang_String_2Z)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring dirName0,
 jboolean createParentDirectories1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::mkdir(QString,bool)const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_mkdir_cref_QString_bool_constfct(__jni_env, __this_nativeId, dirName0, createParentDirectories1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::open(QIODevice::OpenMode)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_open_1native_1QIODevice_1OpenMode__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint openMode0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::open(QIODevice::OpenMode)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_open_QIODevice_OpenMode(__jni_env, __this_nativeId, openMode0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::owner(QAbstractFileEngine::FileOwner)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_owner_1native_1QAbstractFileEngine_1FileOwner_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::owner(QAbstractFileEngine::FileOwner)const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_owner_QAbstractFileEngine_FileOwner_constfct(__jni_env, __this_nativeId, arg__1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::ownerId(QAbstractFileEngine::FileOwner)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_ownerId_1native_1QAbstractFileEngine_1FileOwner_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::ownerId(QAbstractFileEngine::FileOwner)const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_ownerId_QAbstractFileEngine_FileOwner_constfct(__jni_env, __this_nativeId, arg__1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::pos()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_pos_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::pos()const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_pos(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::read(char*,qint64)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_read_1native_1char_1ptr_1qint64__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject data0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::read(char*,qint64)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_read_char_ptr_qint64(__jni_env, __this_nativeId, data0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::readLine(char*,qint64)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_readLine_1native_1char_1ptr_1qint64__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject data0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::readLine(char*,qint64)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_readLine_char_ptr_qint64(__jni_env, __this_nativeId, data0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::remove()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_remove_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::remove()", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_remove(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::rename(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_rename_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring newName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::rename(QString)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_rename_cref_QString(__jni_env, __this_nativeId, newName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::renameOverwrite(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_renameOverwrite_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring newName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::renameOverwrite(QString)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_renameOverwrite_cref_QString(__jni_env, __this_nativeId, newName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::rmdir(QString,bool)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_rmdir_1native_1cref_1QString_1bool_1constfct__JLjava_lang_String_2Z)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring dirName0,
 jboolean recurseParentDirectories1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::rmdir(QString,bool)const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_rmdir_cref_QString_bool_constfct(__jni_env, __this_nativeId, dirName0, recurseParentDirectories1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::seek(qint64)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_seek_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong arg__1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::seek(qint64)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_seek_qint64(__jni_env, __this_nativeId, arg__1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::setFileName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_setFileName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring file0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::setFileName(QString)", __qt_this)
        static_cast<QFSFileEngine_access*>(__qt_this)->__qt_setFileName_cref_QString(__jni_env, __this_nativeId, file0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QFSFileEngine::setFileTime(QDateTime,QAbstractFileEngine::FileTime)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_setFileTime_1native_1cref_1QDateTime_1QAbstractFileEngine_1FileTime__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID newDate0,
 jint time1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::setFileTime(QDateTime,QAbstractFileEngine::FileTime)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_setFileTime_cref_QDateTime_QAbstractFileEngine_FileTime(__jni_env, __this_nativeId, newDate0, time1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::setPermissions(uint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_setPermissions_1native_1uint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint perms0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::setPermissions(uint)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_setPermissions_uint(__jni_env, __this_nativeId, perms0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::setSize(qint64)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_setSize_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong size0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::setSize(qint64)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_setSize_qint64(__jni_env, __this_nativeId, size0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::size()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::size()const", __qt_this)
        __java_return_value = static_cast<const QFSFileEngine_access*>(__qt_this)->__qt_size(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::syncToDisk()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_syncToDisk_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::syncToDisk()", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_syncToDisk(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::write(const char*,qint64)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_write_1native_1const_1char_1ptr_1qint64__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring data0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QFSFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QFSFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QFSFileEngine::write(const char*,qint64)", __qt_this)
        __java_return_value = static_cast<QFSFileEngine_access*>(__qt_this)->__qt_write_const_char_ptr_qint64(__jni_env, __this_nativeId, data0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::currentPath(QString)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_currentPath__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring path0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QFSFileEngine::currentPath(QString)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
        QString __qt_return_value = QFSFileEngine::currentPath(__qt_path0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::drives()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_drives__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QFSFileEngine::drives()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QList<QFileInfo> __qt_return_value = QFSFileEngine::drives();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::homePath()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_homePath__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QFSFileEngine::homePath()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QFSFileEngine::homePath();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::rootPath()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_rootPath__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QFSFileEngine::rootPath()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QFSFileEngine::rootPath();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::setCurrentPath(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_setCurrentPath__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring path0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QFSFileEngine::setCurrentPath(QString)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
        __java_return_value = QFSFileEngine::setCurrentPath(__qt_path0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QFSFileEngine::tempPath()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QFSFileEngine_tempPath__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QFSFileEngine::tempPath()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QFSFileEngine::tempPath();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QFSFileEngine(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QFSFileEngine>("QFSFileEngine", "io/qt/core/internal/QFSFileEngine");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/*  0 */ "beginEntryList", "(Lio/qt/core/QDir$Filters;Ljava/util/Collection;)Lio/qt/core/internal/QAbstractFileEngineIterator;"),
        FunctionInfo(/*  1 */ "caseSensitive", "()Z"),
        FunctionInfo(/*  2 */ "cloneTo", "(Lio/qt/core/internal/QAbstractFileEngine;)Z"),
        FunctionInfo(/*  3 */ "close", "()Z"),
        FunctionInfo(/*  4 */ "copy", "(Ljava/lang/String;)Z"),
        FunctionInfo(/*  5 */ "endEntryList", "()Lio/qt/core/internal/QAbstractFileEngineIterator;"),
        FunctionInfo(/*  6 */ "entryList", "(Lio/qt/core/QDir$Filters;Ljava/util/Collection;)Ljava/util/List;"),
        FunctionInfo(/*  7 */ "fileFlags", "(Lio/qt/core/internal/QAbstractFileEngine$FileFlags;)Lio/qt/core/internal/QAbstractFileEngine$FileFlags;"),
        FunctionInfo(/*  8 */ "fileName", "(Lio/qt/core/internal/QAbstractFileEngine$FileName;)Ljava/lang/String;"),
        FunctionInfo(/*  9 */ "fileTime", "(Lio/qt/core/internal/QAbstractFileEngine$FileTime;)Lio/qt/core/QDateTime;"),
        FunctionInfo(/* 10 */ "flush", "()Z"),
        FunctionInfo(/* 11 */ "handle", "()I"),
        FunctionInfo(/* 12 */ "id", "()Lio/qt/core/QByteArray;"),
        FunctionInfo(/* 13 */ "isRelativePath", "()Z"),
        FunctionInfo(/* 14 */ "isSequential", "()Z"),
        FunctionInfo(/* 15 */ "isUnnamedFile", "()Z"),
        FunctionInfo(/* 16 */ "link", "(Ljava/lang/String;)Z"),
        FunctionInfo(/* 17 */ "mkdir", "(Ljava/lang/String;Z)Z"),
        FunctionInfo(/* 18 */ "open", "(Lio/qt/core/QIODevice$OpenMode;)Z"),
        FunctionInfo(/* 19 */ "owner", "(Lio/qt/core/internal/QAbstractFileEngine$FileOwner;)Ljava/lang/String;"),
        FunctionInfo(/* 20 */ "ownerId", "(Lio/qt/core/internal/QAbstractFileEngine$FileOwner;)I"),
        FunctionInfo(/* 21 */ "pos", "()J"),
        FunctionInfo(/* 22 */ "read", "(Ljava/nio/ByteBuffer;)I"),
        FunctionInfo(/* 23 */ "readLine", "(Ljava/nio/ByteBuffer;)I"),
        FunctionInfo(/* 24 */ "remove", "()Z"),
        FunctionInfo(/* 25 */ "rename", "(Ljava/lang/String;)Z"),
        FunctionInfo(/* 26 */ "renameOverwrite", "(Ljava/lang/String;)Z"),
        FunctionInfo(/* 27 */ "rmdir", "(Ljava/lang/String;Z)Z"),
        FunctionInfo(/* 28 */ "seek", "(J)Z"),
        FunctionInfo(/* 29 */ "setFileName", "(Ljava/lang/String;)V"),
        FunctionInfo(/* 30 */ "setFileTime", "(Lio/qt/core/QDateTime;Lio/qt/core/internal/QAbstractFileEngine$FileTime;)Z"),
        FunctionInfo(/* 31 */ "setPermissions", "(I)Z"),
        FunctionInfo(/* 32 */ "setSize", "(J)Z"),
        FunctionInfo(/* 33 */ "size", "()J"),
        FunctionInfo(/* 34 */ "syncToDisk", "()Z"),
        FunctionInfo(/* 35 */ "write", "(Ljava/nio/ByteBuffer;)I")});
    registerConstructorInfos(typeId, &__qt_destruct_QFSFileEngine, {
        ConstructorInfo(&__qt_construct_QFSFileEngine_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QFSFileEngine_1, "Ljava/lang/String;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QFSFileEngine);
    registerSizeOfShell(typeId, sizeof(QFSFileEngine_shell));
// END: type registration

// BEGIN: polymorphic ids
    registerDefaultPolymorphyHandler<QAbstractFileEngine, QFSFileEngine>();
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
