#include <QtCore/QtGlobal>
#include <qtcore-config.h>
#if QT_CONFIG(cborstreamreader)
#include <QtCore/qcborstreamreader.h>
#endif //QT_CONFIG(cborstreamreader)
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qcborcommon.h>
#include <QtCore/qiodevice.h>
#include "utils_p.h"

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

#if QT_CONFIG(cborstreamreader)


void deleter_QCborStreamReader(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QCborStreamReader")
    QCborStreamReader *_ptr = reinterpret_cast<QCborStreamReader *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}


#endif // QT_CONFIG(cborstreamreader)

// emitting (writeConstructors)
// new QCborStreamReader()
void __qt_construct_QCborStreamReader_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCborStreamReader()")
#if QT_CONFIG(cborstreamreader)
    Q_UNUSED(__java_arguments)
    QCborStreamReader *__qt_this = new(__qtjambi_ptr) QCborStreamReader();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
}

// new QCborStreamReader(QByteArray)
void __qt_construct_QCborStreamReader_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCborStreamReader(QByteArray)")
#if QT_CONFIG(cborstreamreader)
    jobject data0 = __java_arguments[0].l;
    const QByteArray& __qt_data0 = qtjambi_cast<const QByteArray& >(__jni_env, data0);
    QCborStreamReader *__qt_this = new(__qtjambi_ptr) QCborStreamReader(__qt_data0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
}

// new QCborStreamReader(QIODevice*)
void __qt_construct_QCborStreamReader_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCborStreamReader(QIODevice*)")
#if QT_CONFIG(cborstreamreader)
    jobject device0 = __java_arguments[0].l;
    QIODevice* __qt_device0 = qtjambi_cast<QIODevice* >(__jni_env, device0);
    QCborStreamReader *__qt_this = new(__qtjambi_ptr) QCborStreamReader(__qt_device0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
}

// new QCborStreamReader(const char*,qsizetype)
void __qt_construct_QCborStreamReader_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCborStreamReader(const char*,qsizetype)")
#if QT_CONFIG(cborstreamreader)
    jstring data0 = static_cast<jstring>(__java_arguments[0].l);
    JBufferConstData __qt_data0_buffer(__jni_env, data0);
    const char* __qt_data0 = __qt_data0_buffer.data<char>();
    jlong len1 = __java_arguments[1].j;
    Q_UNUSED(len1)
    QCborStreamReader *__qt_this = new(__qtjambi_ptr) QCborStreamReader(__qt_data0, static_cast<qsizetype>(len1));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
}

// destruct QCborStreamReader
void __qt_destruct_QCborStreamReader(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QCborStreamReader")

#if QT_CONFIG(cborstreamreader)

    reinterpret_cast<QCborStreamReader*>(ptr)->~QCborStreamReader();

#else
    Q_UNUSED(ptr)

#endif // QT_CONFIG(cborstreamreader)

}

// emitting  (functionsInTargetLang writeFinalFunction)
// QCborStreamReader::QCborStreamReader()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_initialize_1native__Lio_qt_core_QCborStreamReader_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCborStreamReader::QCborStreamReader()")
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCborStreamReader_0, sizeof(QCborStreamReader), typeid(QCborStreamReader), false, &deleter_QCborStreamReader, nullptr);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamReader::QCborStreamReader(QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_initialize_1native__Lio_qt_core_QCborStreamReader_2Lio_qt_core_QByteArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject data0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCborStreamReader::QCborStreamReader(QByteArray)")
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        jvalue arguments;
        arguments.l = data0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCborStreamReader_1, sizeof(QCborStreamReader), typeid(QCborStreamReader), false, &deleter_QCborStreamReader, &arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(data0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamReader::QCborStreamReader(QIODevice*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_initialize_1native__Lio_qt_core_QCborStreamReader_2Lio_qt_core_QIODevice_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject device0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCborStreamReader::QCborStreamReader(QIODevice*)")
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        jvalue arguments;
        arguments.l = device0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCborStreamReader_2, sizeof(QCborStreamReader), typeid(QCborStreamReader), false, &deleter_QCborStreamReader, &arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(device0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamReader::QCborStreamReader(const char*,qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_initialize_1native__Lio_qt_core_QCborStreamReader_2Ljava_nio_ByteBuffer_2J)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring data0,
 jlong len1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCborStreamReader::QCborStreamReader(const char*,qsizetype)")
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        jvalue arguments[2];
        arguments[0].l = data0;
        arguments[1].j = len1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCborStreamReader_3, sizeof(QCborStreamReader), typeid(QCborStreamReader), false, &deleter_QCborStreamReader, arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(data0)
        Q_UNUSED(len1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamReader::addData(QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_addData_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID data0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::addData(QByteArray)", __qt_this)
        const QByteArray& __qt_data0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data0);
        __qt_this->addData(__qt_data0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(data0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamReader::addData(const quint8*,qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_addData_1native_1const_1quint8_1ptr_1qsizetype__JLjava_nio_ByteBuffer_2J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject data0,
 jlong len1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::addData(const quint8*,qsizetype)", __qt_this)
        JBufferConstData __qt_data0_buffer(__jni_env, data0);
        const quint8* __qt_data0 = __qt_data0_buffer.data<quint8>();
        __qt_this->addData(__qt_data0, static_cast<qsizetype>(len1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(data0)
        Q_UNUSED(len1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamReader::clear()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_clear_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::clear()", __qt_this)
        __qt_this->clear();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamReader::containerDepth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_containerDepth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::containerDepth()const", __qt_this)
        __java_return_value = __qt_this->containerDepth();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::currentOffset()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_currentOffset_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::currentOffset()const", __qt_this)
        qint64 __qt_return_value = __qt_this->currentOffset();
        __java_return_value = jlong(__qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::currentStringChunkSize()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_currentStringChunkSize_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::currentStringChunkSize()const", __qt_this)
        qsizetype __qt_return_value = __qt_this->currentStringChunkSize();
        __java_return_value = jlong(__qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::device()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_device_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::device()const", __qt_this)
        QIODevice* __qt_return_value = __qt_this->device();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::enterContainer()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_enterContainer_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::enterContainer()", __qt_this)
        __java_return_value = __qt_this->enterContainer();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::hasNext()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_hasNext_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::hasNext()const", __qt_this)
        __java_return_value = __qt_this->hasNext();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isArray()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isArray_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isArray()const", __qt_this)
        __java_return_value = __qt_this->isArray();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isBool()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isBoolean_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isBool()const", __qt_this)
        __java_return_value = __qt_this->isBool();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isByteArray()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isByteArray_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isByteArray()const", __qt_this)
        __java_return_value = __qt_this->isByteArray();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isContainer()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isContainer_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isContainer()const", __qt_this)
        __java_return_value = __qt_this->isContainer();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isDouble()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isDouble_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isDouble()const", __qt_this)
        __java_return_value = __qt_this->isDouble();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isFalse()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isFalse_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isFalse()const", __qt_this)
        __java_return_value = __qt_this->isFalse();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isFloat()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isFloat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isFloat()const", __qt_this)

        if(__qt_this->isFloat16())
            __java_return_value = true;
        else

        __java_return_value = __qt_this->isFloat();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isInteger()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isInteger_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isInteger()const", __qt_this)
        __java_return_value = __qt_this->isInteger();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isInvalid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isInvalid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isInvalid()const", __qt_this)
        __java_return_value = __qt_this->isInvalid();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isLengthKnown()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isLengthKnown_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isLengthKnown()const", __qt_this)
        __java_return_value = __qt_this->isLengthKnown();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isMap()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isMap_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isMap()const", __qt_this)
        __java_return_value = __qt_this->isMap();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isSimpleType()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isSimpleType_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isSimpleType()const", __qt_this)
        __java_return_value = __qt_this->isSimpleType();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isSimpleType(QCborSimpleType)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isSimpleType_1native_1QCborSimpleType_1constfct__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte st0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isSimpleType(QCborSimpleType)const", __qt_this)
        QCborSimpleType __qt_st0 = qtjambi_cast<QCborSimpleType>(__jni_env, st0);
        __java_return_value = __qt_this->isSimpleType(QCborSimpleType(__qt_st0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(st0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isString()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isString_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isString()const", __qt_this)
        __java_return_value = __qt_this->isString();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isTag()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isTag_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isTag()const", __qt_this)
        __java_return_value = __qt_this->isTag();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isTrue()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isTrue_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isTrue()const", __qt_this)
        __java_return_value = __qt_this->isTrue();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isUndefined()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isUndefined_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isUndefined()const", __qt_this)
        __java_return_value = __qt_this->isUndefined();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isUnsignedInteger()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isBigInteger_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isUnsignedInteger()const", __qt_this)

        if(__qt_this->isNegativeInteger())
            __java_return_value = true;
        else

        __java_return_value = __qt_this->isUnsignedInteger();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::lastError()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_lastError_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::lastError()", __qt_this)
        QCborError __qt_return_value = __qt_this->lastError();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::leaveContainer()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_leaveContainer_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::leaveContainer()", __qt_this)
        __java_return_value = __qt_this->leaveContainer();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::length()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_length_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::length()const", __qt_this)
        quint64 __qt_return_value = __qt_this->length();
        __java_return_value = jlong(__qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::next(int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_next_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint maxRecursion0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::next(int)", __qt_this)
        __java_return_value = __qt_this->next(static_cast<int>(maxRecursion0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(maxRecursion0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::parentContainerType()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_parentContainerType_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::parentContainerType()const", __qt_this)
        QCborStreamReader::Type __qt_return_value = __qt_this->parentContainerType();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::readByteArray()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_readByteArray_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::readByteArray()", __qt_this)
        QCborStreamReader::StringResult<QByteArray> __qt_return_value = __qt_this->readByteArray();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::readString()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_readString_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::readString()", __qt_this)
        QCborStreamReader::StringResult<QString> __qt_return_value = __qt_this->readString();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::readStringChunk(char*,qsizetype)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_readStringChunk_1native_1char_1ptr_1qsizetype__JLjava_nio_ByteBuffer_2J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject ptr0,
 jlong maxlen1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::readStringChunk(char*,qsizetype)", __qt_this)
        JBufferData __qt_ptr0_buffer(__jni_env, ptr0);
        char* __qt_ptr0 = __qt_ptr0_buffer.data<char>();
        QCborStreamReader::StringResult<qsizetype> __qt_return_value = __qt_this->readStringChunk(__qt_ptr0, static_cast<qsizetype>(maxlen1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(ptr0)
        Q_UNUSED(maxlen1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::reparse()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_reparse_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::reparse()", __qt_this)
        __qt_this->reparse();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamReader::reset()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_reset_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::reset()", __qt_this)
        __qt_this->reset();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamReader::setDevice(QIODevice*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_setDevice_1native_1QIODevice_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID device0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::setDevice(QIODevice*)", __qt_this)
        QIODevice* __qt_device0 = QtJambiAPI::objectFromNativeId<QIODevice>(device0);
        __qt_this->setDevice(__qt_device0);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(device0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCborStreamReader::toBool()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_toBoolean_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::toBool()const", __qt_this)
        __java_return_value = __qt_this->toBool();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::toDouble()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_toDouble_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::toDouble()const", __qt_this)
        __java_return_value = __qt_this->toDouble();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::toFloat()const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_toFloat_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::toFloat()const", __qt_this)

        if(__qt_this->isFloat16())
            __java_return_value = jfloat(__qt_this->toFloat16());
        else

        __java_return_value = __qt_this->toFloat();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::toInteger()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_toInteger_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::toInteger()const", __qt_this)
        qint64 __qt_return_value = __qt_this->toInteger();
        __java_return_value = jlong(__qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::toSimpleType()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_toSimpleType_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::toSimpleType()const", __qt_this)
        QCborSimpleType __qt_return_value = __qt_this->toSimpleType();
        __java_return_value = jbyte(__qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::toTag()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_toTag_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::toTag()const", __qt_this)
        QCborTag __qt_return_value = __qt_this->toTag();
        __java_return_value = jlong(__qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::toUnsignedInteger()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_toBigInteger_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::toUnsignedInteger()const", __qt_this)

        if(__qt_this->isNegativeInteger()){
            __java_return_value = toBigInteger(__jni_env, quint64(__qt_this->toNegativeInteger()), true);
        }else{

        quint64 __qt_return_value = __qt_this->toUnsignedInteger();
        __java_return_value = toBigInteger(__jni_env, __qt_return_value, false);
        }
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCborStreamReader::type()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCborStreamReader_type_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(cborstreamreader)
        const QCborStreamReader *__qt_this = QtJambiAPI::objectFromNativeId<QCborStreamReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCborStreamReader::type()const", __qt_this)
        QCborStreamReader::Type __qt_return_value = __qt_this->type();
        __java_return_value = __qt_return_value;
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(cborstreamreader)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QCborStreamReader(){
    using namespace RegistryAPI;

#if QT_CONFIG(cborstreamreader)

    const std::type_info& typeId = registerObjectTypeInfo<QCborStreamReader>("QCborStreamReader", "io/qt/core/QCborStreamReader");
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QCborStreamReader, {
        ConstructorInfo(&__qt_construct_QCborStreamReader_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QCborStreamReader_1, "Lio/qt/core/QByteArray;")
       ,ConstructorInfo(&__qt_construct_QCborStreamReader_2, "Lio/qt/core/QIODevice;")
       ,ConstructorInfo(&__qt_construct_QCborStreamReader_3, "Ljava/nio/ByteBuffer;J")
    });
// END: function table

    registerMetaObject(typeId, QCborStreamReader::staticMetaObject, false);
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QCborStreamReader);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags

#if QT_CONFIG(cborstreamreader)
    registerEnumTypeInfo<QCborStreamReader::StringResultCode>("QCborStreamReader::StringResultCode", "io/qt/core/QCborStreamReader$StringResultCode");
#endif //QT_CONFIG(cborstreamreader)

#if QT_CONFIG(cborstreamreader)
    registerEnumTypeInfo<QCborStreamReader::Type>("QCborStreamReader::Type", "io/qt/core/QCborStreamReader$Type");
#endif //QT_CONFIG(cborstreamreader)
// END: enums and flags

#endif //QT_CONFIG(cborstreamreader)

}
