#include <QtCore/QtGlobal>
#include <QtCore/qcalendar.h>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtCore/qdatetime.h>
#include <QtCore/qlocale.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiCore/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QCalendar(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QCalendar")
    QCalendar *_ptr = reinterpret_cast<QCalendar *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QCalendar()
void __qt_construct_QCalendar_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCalendar()")
    Q_UNUSED(__java_arguments)
    QCalendar *__qt_this = new(__qtjambi_ptr) QCalendar();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QCalendar(QCalendar::System)
void __qt_construct_QCalendar_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCalendar(QCalendar::System)")
    jobject system0 = __java_arguments[0].l;
    QCalendar::System __qt_system0 = qtjambi_cast<QCalendar::System>(__jni_env, system0);
    QCalendar *__qt_this = new(__qtjambi_ptr) QCalendar(QCalendar::System(__qt_system0));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QCalendar(QStringView)
void __qt_construct_QCalendar_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QCalendar(QStringView)")
    QtJambiScope __qtjambi_scope;
    jstring name0 = static_cast<jstring>(__java_arguments[0].l);
    QStringView  __qt_name0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, name0);
    QCalendar *__qt_this = new(__qtjambi_ptr) QCalendar(__qt_name0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QCalendar
void __qt_destruct_QCalendar(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QCalendar")
    reinterpret_cast<QCalendar*>(ptr)->~QCalendar();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QCalendar::QCalendar()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_initialize_1native__Lio_qt_core_QCalendar_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCalendar::QCalendar()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCalendar_0, sizeof(QCalendar), typeid(QCalendar), false, &deleter_QCalendar, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCalendar::QCalendar(QCalendar::System)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_initialize_1native__Lio_qt_core_QCalendar_2Lio_qt_core_QCalendar_00024System_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject system0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCalendar::QCalendar(QCalendar::System)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = system0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCalendar_1, sizeof(QCalendar), typeid(QCalendar), false, &deleter_QCalendar, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCalendar::QCalendar(QStringView)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_initialize_1native__Lio_qt_core_QCalendar_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring name0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCalendar::QCalendar(QStringView)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = name0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QCalendar_2, sizeof(QCalendar), typeid(QCalendar), false, &deleter_QCalendar, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QCalendar::dateFromParts(QCalendar::YearMonthDay)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_dateFromParts_1native_1cref_1QCalendar_1YearMonthDay_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID parts0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::dateFromParts(QCalendar::YearMonthDay)const", __qt_this)
        const QCalendar::YearMonthDay& __qt_parts0 = QtJambiAPI::valueReferenceFromNativeId<QCalendar::YearMonthDay>(parts0);
        QDate __qt_return_value = __qt_this->dateFromParts(__qt_parts0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::dateFromParts(int,int,int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_dateFromParts_1native_1int_1int_1int_1constfct__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint year0,
 jint month1,
 jint day2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::dateFromParts(int,int,int)const", __qt_this)
        QDate __qt_return_value = __qt_this->dateFromParts(static_cast<int>(year0), static_cast<int>(month1), static_cast<int>(day2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::dateTimeToString(QStringView,QDateTime,QDate,QTime,QLocale)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_dateTimeToString_1native_1QStringView_1cref_1QDateTime_1cref_1QDate_1cref_1QTime_1cref_1QLocale_1constfct__JLjava_lang_String_2JJJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring format0,
 QtJambiNativeID datetime1,
 QtJambiNativeID dateOnly2,
 QtJambiNativeID timeOnly3,
 QtJambiNativeID locale4)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::dateTimeToString(QStringView,QDateTime,QDate,QTime,QLocale)const", __qt_this)
        QStringView  __qt_format0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, format0);
        const QDateTime& __qt_datetime1 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(datetime1);
        const QDate& __qt_dateOnly2 = QtJambiAPI::valueReferenceFromNativeId<QDate>(dateOnly2);
        const QTime& __qt_timeOnly3 = QtJambiAPI::valueReferenceFromNativeId<QTime>(timeOnly3);
        const QLocale& __qt_locale4 = QtJambiAPI::valueReferenceFromNativeId<QLocale>(locale4);
        QString __qt_return_value = __qt_this->dateTimeToString(__qt_format0, __qt_datetime1, __qt_dateOnly2, __qt_timeOnly3, __qt_locale4);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::dayOfWeek(QDate)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_dayOfWeek_1native_1QDate_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID date0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::dayOfWeek(QDate)const", __qt_this)
        QDate __qt_date0 = QtJambiAPI::valueReferenceFromNativeId<QDate>(date0);
        __java_return_value = __qt_this->dayOfWeek(__qt_date0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::daysInMonth(int,int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_daysInMonth_1native_1int_1int_1constfct__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint month0,
 jint year1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::daysInMonth(int,int)const", __qt_this)
        __java_return_value = __qt_this->daysInMonth(static_cast<int>(month0), static_cast<int>(year1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::daysInYear(int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_daysInYear_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint year0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::daysInYear(int)const", __qt_this)
        __java_return_value = __qt_this->daysInYear(static_cast<int>(year0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::hasYearZero()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_hasYearZero_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::hasYearZero()const", __qt_this)
        __java_return_value = __qt_this->hasYearZero();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::isDateValid(int,int,int)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_isDateValid_1native_1int_1int_1int_1constfct__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint year0,
 jint month1,
 jint day2)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::isDateValid(int,int,int)const", __qt_this)
        __java_return_value = __qt_this->isDateValid(static_cast<int>(year0), static_cast<int>(month1), static_cast<int>(day2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::isGregorian()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_isGregorian_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::isGregorian()const", __qt_this)
        __java_return_value = __qt_this->isGregorian();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::isLeapYear(int)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_isLeapYear_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint year0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::isLeapYear(int)const", __qt_this)
        __java_return_value = __qt_this->isLeapYear(static_cast<int>(year0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::isLunar()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_isLunar_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::isLunar()const", __qt_this)
        __java_return_value = __qt_this->isLunar();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::isLuniSolar()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_isLuniSolar_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::isLuniSolar()const", __qt_this)
        __java_return_value = __qt_this->isLuniSolar();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::isProleptic()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_isProleptic_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::isProleptic()const", __qt_this)
        __java_return_value = __qt_this->isProleptic();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::isSolar()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_isSolar_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::isSolar()const", __qt_this)
        __java_return_value = __qt_this->isSolar();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::maximumDaysInMonth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_maximumDaysInMonth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::maximumDaysInMonth()const", __qt_this)
        __java_return_value = __qt_this->maximumDaysInMonth();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::maximumMonthsInYear()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_maximumMonthsInYear_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::maximumMonthsInYear()const", __qt_this)
        __java_return_value = __qt_this->maximumMonthsInYear();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::minimumDaysInMonth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_minimumDaysInMonth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::minimumDaysInMonth()const", __qt_this)
        __java_return_value = __qt_this->minimumDaysInMonth();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::monthName(QLocale,int,int,QLocale::FormatType)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_monthName_1native_1cref_1QLocale_1int_1int_1QLocale_1FormatType_1constfct__JJIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID locale0,
 jint month1,
 jint year2,
 jint format3)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::monthName(QLocale,int,int,QLocale::FormatType)const", __qt_this)
        const QLocale& __qt_locale0 = QtJambiAPI::valueReferenceFromNativeId<QLocale>(locale0);
        QLocale::FormatType __qt_format3 = qtjambi_cast<QLocale::FormatType>(__jni_env, format3);
        QString __qt_return_value = __qt_this->monthName(__qt_locale0, static_cast<int>(month1), static_cast<int>(year2), QLocale::FormatType(__qt_format3));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::monthsInYear(int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_monthsInYear_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint year0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::monthsInYear(int)const", __qt_this)
        __java_return_value = __qt_this->monthsInYear(static_cast<int>(year0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::name()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_name_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::name()const", __qt_this)
        QString __qt_return_value = __qt_this->name();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::operator==(QCalendar,QCalendar)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_equals_1native_1cref_1QCalendar__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID value21)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::operator==(QCalendar,QCalendar)", __qt_this)
        const QCalendar& __qt_value21 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(value21);
        __java_return_value = (*__qt_this) == __qt_value21;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::partsFromDate(QDate)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_partsFromDate_1native_1QDate_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID date0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::partsFromDate(QDate)const", __qt_this)
        QDate __qt_date0 = QtJambiAPI::valueReferenceFromNativeId<QDate>(date0);
        QCalendar::YearMonthDay __qt_return_value = __qt_this->partsFromDate(__qt_date0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::standaloneMonthName(QLocale,int,int,QLocale::FormatType)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_standaloneMonthName_1native_1cref_1QLocale_1int_1int_1QLocale_1FormatType_1constfct__JJIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID locale0,
 jint month1,
 jint year2,
 jint format3)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::standaloneMonthName(QLocale,int,int,QLocale::FormatType)const", __qt_this)
        const QLocale& __qt_locale0 = QtJambiAPI::valueReferenceFromNativeId<QLocale>(locale0);
        QLocale::FormatType __qt_format3 = qtjambi_cast<QLocale::FormatType>(__jni_env, format3);
        QString __qt_return_value = __qt_this->standaloneMonthName(__qt_locale0, static_cast<int>(month1), static_cast<int>(year2), QLocale::FormatType(__qt_format3));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::standaloneWeekDayName(QLocale,int,QLocale::FormatType)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_standaloneWeekDayName_1native_1cref_1QLocale_1int_1QLocale_1FormatType_1constfct__JJII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID locale0,
 jint day1,
 jint format2)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::standaloneWeekDayName(QLocale,int,QLocale::FormatType)const", __qt_this)
        const QLocale& __qt_locale0 = QtJambiAPI::valueReferenceFromNativeId<QLocale>(locale0);
        QLocale::FormatType __qt_format2 = qtjambi_cast<QLocale::FormatType>(__jni_env, format2);
        QString __qt_return_value = __qt_this->standaloneWeekDayName(__qt_locale0, static_cast<int>(day1), QLocale::FormatType(__qt_format2));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::weekDayName(QLocale,int,QLocale::FormatType)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_weekDayName_1native_1cref_1QLocale_1int_1QLocale_1FormatType_1constfct__JJII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID locale0,
 jint day1,
 jint format2)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QCalendar::weekDayName(QLocale,int,QLocale::FormatType)const", __qt_this)
        const QLocale& __qt_locale0 = QtJambiAPI::valueReferenceFromNativeId<QLocale>(locale0);
        QLocale::FormatType __qt_format2 = qtjambi_cast<QLocale::FormatType>(__jni_env, format2);
        QString __qt_return_value = __qt_this->weekDayName(__qt_locale0, static_cast<int>(day1), QLocale::FormatType(__qt_format2));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QCalendar::availableCalendars()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_availableCalendars__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QCalendar::availableCalendars()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QStringList __qt_return_value = QCalendar::availableCalendars();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QCalendar_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QCalendar *__qt_this = QtJambiAPI::objectFromNativeId<QCalendar>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QCalendar(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QCalendar>("QCalendar", "io/qt/core/QCalendar");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QCalendar, {
        ConstructorInfo(&__qt_construct_QCalendar_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QCalendar_1, "Lio/qt/core/QCalendar$System;")
       ,ConstructorInfo(&__qt_construct_QCalendar_2, "Ljava/lang/String;")
    });
// END: function table

    registerMetaObject(typeId, QCalendar::staticMetaObject, false);
// END: signal table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QCalendar);
    registerMetaType<QCalendar>("QCalendar");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QCalendar::System>("QCalendar::System", "io/qt/core/QCalendar$System");
// END: enums and flags
}
