#include <QtCore/QtGlobal>
#include <QtCore/qbytearray.h>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtCore/qhashfunctions.h>
#include <QtCore/qnamespace.h>
#include <QtCore/qstring.h>
#include "utils_p.h"

#include <QtJambi/QtJambiAPI>
#include <QtJambi/JavaAPI>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QByteArray(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QByteArray")
    QByteArray *_ptr = reinterpret_cast<QByteArray *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QByteArray()
void __qt_construct_QByteArray_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QByteArray()")
    Q_UNUSED(__java_arguments)
    QByteArray *__qt_this = new(__qtjambi_ptr) QByteArray();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QByteArray(QByteArray)
void __qt_construct_QByteArray_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QByteArray(QByteArray)")
    jobject arg__1 = __java_arguments[0].l;
    const QByteArray& __qt_arg__1 = qtjambi_cast<const QByteArray& >(__jni_env, arg__1);
    QByteArray *__qt_this = new(__qtjambi_ptr) QByteArray(__qt_arg__1);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QByteArray(const char*,int)
void __qt_construct_QByteArray_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QByteArray(const char*,int)")
    size_t size1 = 0;
    jstring arg__1 = static_cast<jstring>(__java_arguments[0].l);
    JBufferConstData __qt_arg__1_buffer(__jni_env, arg__1);
    const char* __qt_arg__1 = __qt_arg__1_buffer.data<char>();
    size1 = __qt_arg__1_buffer.size<char>();
    QByteArray *__qt_this = new(__qtjambi_ptr) QByteArray(__qt_arg__1, static_cast<int>(size1));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QByteArray(int,char)
void __qt_construct_QByteArray_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QByteArray(int,char)")
    jint size0 = __java_arguments[0].i;
    Q_UNUSED(size0)
    jbyte c1 = __java_arguments[1].b;
    Q_UNUSED(c1)
    QByteArray *__qt_this = new(__qtjambi_ptr) QByteArray(static_cast<int>(size0), static_cast<char>(c1));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QByteArray
void __qt_destruct_QByteArray(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QByteArray")
    reinterpret_cast<QByteArray*>(ptr)->~QByteArray();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QByteArray::QByteArray()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_initialize_1native__Lio_qt_core_QByteArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::QByteArray()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QByteArray_0, sizeof(QByteArray), typeid(QByteArray), false, &deleter_QByteArray, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::QByteArray(QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_initialize_1native__Lio_qt_core_QByteArray_2Lio_qt_core_QByteArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::QByteArray(QByteArray)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = arg__1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QByteArray_1, sizeof(QByteArray), typeid(QByteArray), false, &deleter_QByteArray, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::QByteArray(const char*,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_initialize_1native__Lio_qt_core_QByteArray_2Ljava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::QByteArray(const char*,int)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = arg__1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QByteArray_2, sizeof(QByteArray), typeid(QByteArray), false, &deleter_QByteArray, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::QByteArray(int,char)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_initialize_1native__Lio_qt_core_QByteArray_2IB)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint size0,
 jbyte c1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::QByteArray(int,char)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].i = size0;
        arguments[1].b = c1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QByteArray_3, sizeof(QByteArray), typeid(QByteArray), false, &deleter_QByteArray, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::append(QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_append_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::append(QByteArray)", __qt_this)
        const QByteArray& __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a0);
        __qt_this->append(__qt_a0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::append(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_append_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring s0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::append(QString)", __qt_this)
        QString  __qt_s0 = qtjambi_cast<QString>(__jni_env, s0);
        __qt_this->append(__qt_s0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::append(char)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_append_1native_1char__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::append(char)", __qt_this)
        __qt_this->append(static_cast<char>(c0));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::append(const char*,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_append_1native_1const_1char_1ptr_1int__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring s0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::append(const char*,int)", __qt_this)
        int len1{0};
        JBufferConstData __qt_s0_buffer(__jni_env, s0);
        const char* __qt_s0 = __qt_s0_buffer.data<char>();
        len1 = __qt_s0_buffer.size<char>();
        __qt_this->append(__qt_s0, static_cast<int>(len1));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::append(int,char)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_append_1native_1int_1char__JIB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint count0,
 jbyte c1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::append(int,char)", __qt_this)
        __qt_this->append(static_cast<int>(count0), static_cast<char>(c1));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::at(int)const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_at_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::at(int)const", __qt_this)
        __java_return_value = __qt_this->at(static_cast<int>(i0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::back()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_back_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::back()const", __qt_this)
        __java_return_value = __qt_this->back();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::capacity()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_capacity_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::capacity()const", __qt_this)
        __java_return_value = __qt_this->capacity();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::chop(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_chop_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::chop(int)", __qt_this)
        __qt_this->chop(static_cast<int>(n0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::chopped(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_chopped_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint len0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::chopped(int)const", __qt_this)
        QByteArray __qt_return_value = __qt_this->chopped(static_cast<int>(len0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::clear()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_clear_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::clear()", __qt_this)
        __qt_this->clear();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::compare(QByteArray,Qt::CaseSensitivity)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_compare_1native_1cref_1QByteArray_1Qt_1CaseSensitivity_1constfct__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0,
 jint cs1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::compare(QByteArray,Qt::CaseSensitivity)const", __qt_this)
        const QByteArray& __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a0);
        Qt::CaseSensitivity __qt_cs1 = qtjambi_cast<Qt::CaseSensitivity>(__jni_env, cs1);
        __java_return_value = __qt_this->compare(__qt_a0, Qt::CaseSensitivity(__qt_cs1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::constBegin()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_constBegin_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::constBegin()const", __qt_this)
        QByteArray::const_iterator __qt_return_value = __qt_this->constBegin();
        __java_return_value = qtjambi_cast_sequential_iterator(__jni_env, __qtjambi_scope, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::constData()const
extern "C" Q_DECL_EXPORT jbyteArray JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toArray_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jbyteArray __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::constData()const", __qt_this)
        const char* __qt_return_value = __qt_this->constData();
        __java_return_value = qtjambi_array_cast<jbyteArray>(__jni_env, __qtjambi_scope, __qt_return_value, __qt_this->size());
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::constEnd()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_constEnd_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::constEnd()const", __qt_this)
        QByteArray::const_iterator __qt_return_value = __qt_this->constEnd();
        __java_return_value = qtjambi_cast_sequential_iterator(__jni_env, __qtjambi_scope, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::contains(QByteArray)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_contains_1native_1cref_1QByteArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::contains(QByteArray)const", __qt_this)
        const QByteArray& __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a0);
        __java_return_value = __qt_this->contains(__qt_a0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::contains(char)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_contains_1native_1char_1constfct__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::contains(char)const", __qt_this)
        __java_return_value = __qt_this->contains(static_cast<char>(c0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::count(QByteArray)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_count_1native_1cref_1QByteArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::count(QByteArray)const", __qt_this)
        const QByteArray& __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a0);
        __java_return_value = __qt_this->count(__qt_a0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::count(char)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_count_1native_1char_1constfct__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::count(char)const", __qt_this)
        __java_return_value = __qt_this->count(static_cast<char>(c0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::data()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_data_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::data()const", __qt_this)
        const char* __qt_return_value = __qt_this->data();
        DataJBuffer __java_return_value_buffer(__jni_env, __qt_return_value, __qt_this->capacity());
        __java_return_value = __java_return_value_buffer.take();
        QtJambiAPI::registerDependency(__jni_env, __java_return_value, __this_nativeId);


        if(__qt_this->size()<__qt_this->capacity())
            DataJBuffer::setLimit(__jni_env, __java_return_value, jsize(__qt_this->size()));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::detach()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_detach_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::detach()", __qt_this)
        __qt_this->detach();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::endsWith(QByteArray)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_endsWith_1native_1cref_1QByteArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::endsWith(QByteArray)const", __qt_this)
        const QByteArray& __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a0);
        __java_return_value = __qt_this->endsWith(__qt_a0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::endsWith(char)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_endsWith_1native_1char_1constfct__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::endsWith(char)const", __qt_this)
        __java_return_value = __qt_this->endsWith(static_cast<char>(c0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::fill(char,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_fill_1native_1char_1int__JBI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0,
 jint size1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::fill(char,int)", __qt_this)
        __qt_this->fill(static_cast<char>(c0), static_cast<int>(size1));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::front()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_front_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::front()const", __qt_this)
        __java_return_value = __qt_this->front();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::indexOf(QByteArray,int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_indexOf_1native_1cref_1QByteArray_1int_1constfct__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0,
 jint from1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::indexOf(QByteArray,int)const", __qt_this)
        const QByteArray& __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a0);
        __java_return_value = __qt_this->indexOf(__qt_a0, static_cast<int>(from1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::indexOf(QString,int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_indexOf_1native_1cref_1QString_1int_1constfct__JLjava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring s0,
 jint from1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::indexOf(QString,int)const", __qt_this)
        QString  __qt_s0 = qtjambi_cast<QString>(__jni_env, s0);
        __java_return_value = __qt_this->indexOf(__qt_s0, static_cast<int>(from1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::indexOf(char,int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_indexOf_1native_1char_1int_1constfct__JBI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0,
 jint from1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::indexOf(char,int)const", __qt_this)
        __java_return_value = __qt_this->indexOf(static_cast<char>(c0), static_cast<int>(from1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::insert(int,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_insert_1native_1int_1cref_1QByteArray__JIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0,
 QtJambiNativeID a1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::insert(int,QByteArray)", __qt_this)
        const QByteArray& __qt_a1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a1);
        __qt_this->insert(static_cast<int>(i0), __qt_a1);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::insert(int,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_insert_1native_1int_1cref_1QString__JILjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0,
 jstring s1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::insert(int,QString)", __qt_this)
        QString  __qt_s1 = qtjambi_cast<QString>(__jni_env, s1);
        __qt_this->insert(static_cast<int>(i0), __qt_s1);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::insert(int,char)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_insert_1native_1int_1char__JIB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0,
 jbyte c1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::insert(int,char)", __qt_this)
        __qt_this->insert(static_cast<int>(i0), static_cast<char>(c1));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::insert(int,const char*,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_insert_1native_1int_1const_1char_1ptr_1int__JILjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0,
 jstring s1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::insert(int,const char*,int)", __qt_this)
        int len2{0};
        JBufferConstData __qt_s1_buffer(__jni_env, s1);
        const char* __qt_s1 = __qt_s1_buffer.data<char>();
        len2 = __qt_s1_buffer.size<char>();
        __qt_this->insert(static_cast<int>(i0), __qt_s1, static_cast<int>(len2));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::insert(int,int,char)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_insert_1native_1int_1int_1char__JIIB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0,
 jint count1,
 jbyte c2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::insert(int,int,char)", __qt_this)
        __qt_this->insert(static_cast<int>(i0), static_cast<int>(count1), static_cast<char>(c2));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::isDetached()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_isDetached_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::isDetached()const", __qt_this)
        __java_return_value = __qt_this->isDetached();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::isEmpty()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_isEmpty_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::isEmpty()const", __qt_this)
        __java_return_value = __qt_this->isEmpty();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::isLower()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_isLower_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::isLower()const", __qt_this)
        __java_return_value = __qt_this->isLower();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::isSharedWith(QByteArray)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_isSharedWith_1native_1cref_1QByteArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::isSharedWith(QByteArray)const", __qt_this)
        const QByteArray& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(other0);
        __java_return_value = __qt_this->isSharedWith(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::isUpper()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_isUpper_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::isUpper()const", __qt_this)
        __java_return_value = __qt_this->isUpper();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::lastIndexOf(QByteArray,int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_lastIndexOf_1native_1cref_1QByteArray_1int_1constfct__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0,
 jint from1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::lastIndexOf(QByteArray,int)const", __qt_this)
        const QByteArray& __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a0);
        __java_return_value = __qt_this->lastIndexOf(__qt_a0, static_cast<int>(from1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::lastIndexOf(QString,int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_lastIndexOf_1native_1cref_1QString_1int_1constfct__JLjava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring s0,
 jint from1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::lastIndexOf(QString,int)const", __qt_this)
        QString  __qt_s0 = qtjambi_cast<QString>(__jni_env, s0);
        __java_return_value = __qt_this->lastIndexOf(__qt_s0, static_cast<int>(from1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::lastIndexOf(char,int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_lastIndexOf_1native_1char_1int_1constfct__JBI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0,
 jint from1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::lastIndexOf(char,int)const", __qt_this)
        __java_return_value = __qt_this->lastIndexOf(static_cast<char>(c0), static_cast<int>(from1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::left(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_left_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint len0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::left(int)const", __qt_this)
        QByteArray __qt_return_value = __qt_this->left(static_cast<int>(len0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::leftJustified(int,char,bool)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_leftJustified_1native_1int_1char_1bool_1constfct__JIBZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint width0,
 jbyte fill1,
 jboolean truncate2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::leftJustified(int,char,bool)const", __qt_this)
        QByteArray __qt_return_value = __qt_this->leftJustified(static_cast<int>(width0), static_cast<char>(fill1), static_cast<bool>(truncate2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::length()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_length_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::length()const", __qt_this)
        __java_return_value = __qt_this->length();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::mid(int,int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_mid_1native_1int_1int_1constfct__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint len1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::mid(int,int)const", __qt_this)
        QByteArray __qt_return_value = __qt_this->mid(static_cast<int>(index0), static_cast<int>(len1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::operator+(QByteArray,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_plus_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator+(QByteArray,QByteArray)", __qt_this)
        const QByteArray& __qt_a21 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a21);
        const QByteArray __qt_return_value = (*__qt_this) + __qt_a21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::operator+(QByteArray,char)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_plus_1native_1char__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte a21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator+(QByteArray,char)", __qt_this)
        const QByteArray __qt_return_value = (*__qt_this) + static_cast<char>(a21);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::operator+(QByteArray,const char*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_plus_1native_1const_1char_1ptr__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring a21)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator+(QByteArray,const char*)", __qt_this)
        const char*  __qt_a21 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, a21);
        const QByteArray __qt_return_value = (*__qt_this) + __qt_a21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::operator<(QByteArray,QByteArray)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_operator_1less_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a21)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator<(QByteArray,QByteArray)", __qt_this)
        const QByteArray& __qt_a21 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a21);
        __java_return_value = (*__qt_this) < __qt_a21;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::operator<(QString)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_operator_1less_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring s20)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator<(QString)const", __qt_this)
        QString  __qt_s20 = qtjambi_cast<QString>(__jni_env, s20);
        __java_return_value = (*__qt_this) < __qt_s20;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::operator<<(QDataStream&,QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator<<(QDataStream&,QByteArray)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::operator=(QByteArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_assign_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator=(QByteArray)", __qt_this)
        const QByteArray& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(arg__1);
        (*__qt_this) = __qt_arg__1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::operator==(QByteArray,QByteArray)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_equals_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a21)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator==(QByteArray,QByteArray)", __qt_this)
        const QByteArray& __qt_a21 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a21);
        __java_return_value = (*__qt_this) == __qt_a21;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::operator==(QString)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_equals_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring s20)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator==(QString)const", __qt_this)
        QString  __qt_s20 = qtjambi_cast<QString>(__jni_env, s20);
        __java_return_value = (*__qt_this) == __qt_s20;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::operator>(QByteArray,const char*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_operator_1greater_1native_1const_1char_1ptr__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring a21)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator>(QByteArray,const char*)", __qt_this)
        const char*  __qt_a21 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, a21);
        __java_return_value = (*__qt_this) > __qt_a21;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::operator>=(QByteArray,QStringRef)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_operator_1greater_1or_1equal_1native_1cref_1QStringRef__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring rhs1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator>=(QByteArray,QStringRef)", __qt_this)
        const QStringRef&  __qt_rhs1 = qtjambi_cast<QStringRef>(__jni_env, __qtjambi_scope, rhs1);
        __java_return_value = (*__qt_this) >= __qt_rhs1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::operator>>(QDataStream&,QByteArray&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator>>(QDataStream&,QByteArray&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::operator[](int)const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_get_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator[](int)const", __qt_this)
        __java_return_value = (*__qt_this)[static_cast<int>(i0)];
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::operator[](int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_set_1native_1int_1char__JIB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint i0,
 jbyte value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::operator[](int)", __qt_this)
        (*__qt_this)[static_cast<int>(i0)] = static_cast<char>(value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::prepend(QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_prepend_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::prepend(QByteArray)", __qt_this)
        const QByteArray& __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a0);
        __qt_this->prepend(__qt_a0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::prepend(char)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_prepend_1native_1char__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::prepend(char)", __qt_this)
        __qt_this->prepend(static_cast<char>(c0));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::prepend(const char*,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_prepend_1native_1const_1char_1ptr_1int__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring s0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::prepend(const char*,int)", __qt_this)
        int len1{0};
        JBufferConstData __qt_s0_buffer(__jni_env, s0);
        const char* __qt_s0 = __qt_s0_buffer.data<char>();
        len1 = __qt_s0_buffer.size<char>();
        __qt_this->prepend(__qt_s0, static_cast<int>(len1));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::prepend(int,char)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_prepend_1native_1int_1char__JIB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint count0,
 jbyte c1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::prepend(int,char)", __qt_this)
        __qt_this->prepend(static_cast<int>(count0), static_cast<char>(c1));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::remove(int,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_remove_1native_1int_1int__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint len1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::remove(int,int)", __qt_this)
        __qt_this->remove(static_cast<int>(index0), static_cast<int>(len1));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::repeated(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_repeated_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint times0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::repeated(int)const", __qt_this)
        QByteArray __qt_return_value = __qt_this->repeated(static_cast<int>(times0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::replace(QByteArray,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_replace_1native_1cref_1QByteArray_1cref_1QByteArray__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID before0,
 QtJambiNativeID after1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::replace(QByteArray,QByteArray)", __qt_this)
        const QByteArray& __qt_before0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(before0);
        const QByteArray& __qt_after1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(after1);
        __qt_this->replace(__qt_before0, __qt_after1);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::replace(QString,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_replace_1native_1cref_1QString_1cref_1QByteArray__JLjava_lang_String_2J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring before0,
 QtJambiNativeID after1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::replace(QString,QByteArray)", __qt_this)
        QString  __qt_before0 = qtjambi_cast<QString>(__jni_env, before0);
        const QByteArray& __qt_after1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(after1);
        __qt_this->replace(__qt_before0, __qt_after1);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::replace(char,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_replace_1native_1char_1cref_1QByteArray__JBJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte before0,
 QtJambiNativeID after1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::replace(char,QByteArray)", __qt_this)
        const QByteArray& __qt_after1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(after1);
        __qt_this->replace(static_cast<char>(before0), __qt_after1);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::replace(char,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_replace_1native_1char_1cref_1QString__JBLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0,
 jstring after1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::replace(char,QString)", __qt_this)
        QString  __qt_after1 = qtjambi_cast<QString>(__jni_env, after1);
        __qt_this->replace(static_cast<char>(c0), __qt_after1);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::replace(char,char)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_replace_1native_1char_1char__JBB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte before0,
 jbyte after1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::replace(char,char)", __qt_this)
        __qt_this->replace(static_cast<char>(before0), static_cast<char>(after1));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::replace(const char*,int,const char*,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_replace_1native_1const_1char_1ptr_1int_1const_1char_1ptr_1int__JLjava_nio_ByteBuffer_2Ljava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring before0,
 jstring after2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::replace(const char*,int,const char*,int)", __qt_this)
        int bsize1{0};
        int asize3{0};
        JBufferConstData __qt_before0_buffer(__jni_env, before0);
        const char* __qt_before0 = __qt_before0_buffer.data<char>();
        bsize1 = __qt_before0_buffer.size<char>();
        JBufferConstData __qt_after2_buffer(__jni_env, after2);
        const char* __qt_after2 = __qt_after2_buffer.data<char>();
        asize3 = __qt_after2_buffer.size<char>();
        __qt_this->replace(__qt_before0, static_cast<int>(bsize1), __qt_after2, static_cast<int>(asize3));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::replace(int,int,QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_replace_1native_1int_1int_1cref_1QByteArray__JIIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint len1,
 QtJambiNativeID s2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::replace(int,int,QByteArray)", __qt_this)
        const QByteArray& __qt_s2 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(s2);
        __qt_this->replace(static_cast<int>(index0), static_cast<int>(len1), __qt_s2);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::replace(int,int,const char*,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_replace_1native_1int_1int_1const_1char_1ptr_1int__JIILjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint len1,
 jstring s2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::replace(int,int,const char*,int)", __qt_this)
        int alen3{0};
        JBufferConstData __qt_s2_buffer(__jni_env, s2);
        const char* __qt_s2 = __qt_s2_buffer.data<char>();
        alen3 = __qt_s2_buffer.size<char>();
        __qt_this->replace(static_cast<int>(index0), static_cast<int>(len1), __qt_s2, static_cast<int>(alen3));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::reserve(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_reserve_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint size0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::reserve(int)", __qt_this)
        __qt_this->reserve(static_cast<int>(size0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::resize(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_resize_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint size0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::resize(int)", __qt_this)
        __qt_this->resize(static_cast<int>(size0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::right(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_right_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint len0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::right(int)const", __qt_this)
        QByteArray __qt_return_value = __qt_this->right(static_cast<int>(len0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::rightJustified(int,char,bool)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_rightJustified_1native_1int_1char_1bool_1constfct__JIBZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint width0,
 jbyte fill1,
 jboolean truncate2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::rightJustified(int,char,bool)const", __qt_this)
        QByteArray __qt_return_value = __qt_this->rightJustified(static_cast<int>(width0), static_cast<char>(fill1), static_cast<bool>(truncate2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::setNum(double,char,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_setNum_1native_1double_1char_1int__JDCI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble arg__1,
 jchar f1,
 jint prec2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::setNum(double,char,int)", __qt_this)
        __qt_this->setNum(static_cast<double>(arg__1), static_cast<char>(f1), static_cast<int>(prec2));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::setNum(float,char,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_setNum_1native_1float_1char_1int__JFCI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat arg__1,
 jchar f1,
 jint prec2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::setNum(float,char,int)", __qt_this)
        __qt_this->setNum(static_cast<float>(arg__1), static_cast<char>(f1), static_cast<int>(prec2));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::setNum(int,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_setNum_1native_1int_1int__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1,
 jint base1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::setNum(int,int)", __qt_this)
        __qt_this->setNum(static_cast<int>(arg__1), static_cast<int>(base1));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::setNum(qlonglong,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_setNum_1native_1qlonglong_1int__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong arg__1,
 jint base1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::setNum(qlonglong,int)", __qt_this)
        __qt_this->setNum(static_cast<qlonglong>(arg__1), static_cast<int>(base1));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::setNum(short,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_setNum_1native_1short_1int__JSI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort arg__1,
 jint base1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::setNum(short,int)", __qt_this)
        __qt_this->setNum(static_cast<short>(arg__1), static_cast<int>(base1));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::setRawData(const char*,uint)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_setRawData_1native_1const_1char_1ptr_1uint__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring a0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::setRawData(const char*,uint)", __qt_this)
        uint n1{0};
        JBufferConstData __qt_a0_buffer(__jni_env, a0);
        const char* __qt_a0 = __qt_a0_buffer.data<char>();
        n1 = __qt_a0_buffer.size<char>();
        __qt_this->setRawData(__qt_a0, static_cast<uint>(n1));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::shrink_to_fit()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_shrink_1to_1fit_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::shrink_to_fit()", __qt_this)
        __qt_this->shrink_to_fit();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::simplified()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_simplified_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::simplified()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->simplified();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::size()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::size()const", __qt_this)
        __java_return_value = __qt_this->size();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::split(char)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_split_1native_1char_1constfct__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte sep0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::split(char)const", __qt_this)
        QList<QByteArray> __qt_return_value = __qt_this->split(static_cast<char>(sep0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::squeeze()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_squeeze_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::squeeze()", __qt_this)
        __qt_this->squeeze();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::startsWith(QByteArray)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_startsWith_1native_1cref_1QByteArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::startsWith(QByteArray)const", __qt_this)
        const QByteArray& __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(a0);
        __java_return_value = __qt_this->startsWith(__qt_a0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::startsWith(char)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_startsWith_1native_1char_1constfct__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::startsWith(char)const", __qt_this)
        __java_return_value = __qt_this->startsWith(static_cast<char>(c0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::swap(QByteArray&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_swap_1native_1ref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::swap(QByteArray&)", __qt_this)
        QByteArray& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QByteArray>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::toBase64()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toBase64_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::toBase64()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->toBase64();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::toBase64(QByteArray::Base64Options)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toBase64_1native_1QByteArray_1Base64Options_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint options0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::toBase64(QByteArray::Base64Options)const", __qt_this)
        QByteArray::Base64Options __qt_options0 = qtjambi_cast<QByteArray::Base64Options>(__jni_env, options0);
        QByteArray __qt_return_value = __qt_this->toBase64(QByteArray::Base64Options(__qt_options0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::toDouble(bool*)const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toDouble_1native_1bool_1ptr_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::toDouble(bool*)const", __qt_this)
        bool ok(false);
        bool* __qt_ok0 = &ok;
        __java_return_value = __qt_this->toDouble(__qt_ok0);


        if(!ok)
            Java::Runtime::NumberFormatException::throwNew(__jni_env, "Unable to parse number." QTJAMBI_STACKTRACEINFO );
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::toFloat(bool*)const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toFloat_1native_1bool_1ptr_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::toFloat(bool*)const", __qt_this)
        bool ok(false);
        bool* __qt_ok0 = &ok;
        __java_return_value = __qt_this->toFloat(__qt_ok0);


        if(!ok)
            Java::Runtime::NumberFormatException::throwNew(__jni_env, "Unable to parse number." QTJAMBI_STACKTRACEINFO );
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::toHex()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toHex_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::toHex()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->toHex();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::toHex(char)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toHex_1native_1char_1constfct__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte separator0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::toHex(char)const", __qt_this)
        QByteArray __qt_return_value = __qt_this->toHex(static_cast<char>(separator0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::toInt(bool*,int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toInt_1native_1bool_1ptr_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint base1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::toInt(bool*,int)const", __qt_this)
        bool ok(false);
        bool* __qt_ok0 = &ok;
        __java_return_value = __qt_this->toInt(__qt_ok0, static_cast<int>(base1));


        if(!ok)
            Java::Runtime::NumberFormatException::throwNew(__jni_env, "Unable to parse number." QTJAMBI_STACKTRACEINFO );
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::toLower()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toLower_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::toLower()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->toLower();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::toPercentEncoding(QByteArray,QByteArray,char)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toPercentEncoding_1native_1cref_1QByteArray_1cref_1QByteArray_1char_1constfct__JJJB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID exclude0,
 QtJambiNativeID include1,
 jbyte percent2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::toPercentEncoding(QByteArray,QByteArray,char)const", __qt_this)
        const QByteArray& __qt_exclude0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(exclude0);
        const QByteArray& __qt_include1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(include1);
        QByteArray __qt_return_value = __qt_this->toPercentEncoding(__qt_exclude0, __qt_include1, static_cast<char>(percent2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::toShort(bool*,int)const
extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toShort_1native_1bool_1ptr_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint base1)
{
    Q_UNUSED(__this)
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::toShort(bool*,int)const", __qt_this)
        bool ok(false);
        bool* __qt_ok0 = &ok;
        __java_return_value = __qt_this->toShort(__qt_ok0, static_cast<int>(base1));


        if(!ok)
            Java::Runtime::NumberFormatException::throwNew(__jni_env, "Unable to parse number." QTJAMBI_STACKTRACEINFO );
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::toUpper()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toUpper_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::toUpper()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->toUpper();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::trimmed()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_trimmed_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::trimmed()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->trimmed();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::truncate(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_truncate_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArray::truncate(int)", __qt_this)
        __qt_this->truncate(static_cast<int>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArray::fromBase64(QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_fromBase64_1native_1cref_1QByteArray__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID base640)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::fromBase64(QByteArray)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray& __qt_base640 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(base640);
        QByteArray __qt_return_value = QByteArray::fromBase64(__qt_base640);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::fromBase64(QByteArray,QByteArray::Base64Options)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_fromBase64_1native_1cref_1QByteArray_1QByteArray_1Base64Options__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID base640,
 jint options1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::fromBase64(QByteArray,QByteArray::Base64Options)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray& __qt_base640 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(base640);
        QByteArray::Base64Options __qt_options1 = qtjambi_cast<QByteArray::Base64Options>(__jni_env, options1);
        QByteArray __qt_return_value = QByteArray::fromBase64(__qt_base640, QByteArray::Base64Options(__qt_options1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::fromBase64Encoding(QByteArray,QByteArray::Base64Options)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_fromBase64Encoding_1native_1cref_1QByteArray_1QByteArray_1Base64Options__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID base640,
 jint options1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::fromBase64Encoding(QByteArray,QByteArray::Base64Options)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray& __qt_base640 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(base640);
        QByteArray::Base64Options __qt_options1 = qtjambi_cast<QByteArray::Base64Options>(__jni_env, options1);
        QByteArray::FromBase64Result __qt_return_value = QByteArray::fromBase64Encoding(__qt_base640, QByteArray::Base64Options(__qt_options1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::fromHex(QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_fromHex_1native_1cref_1QByteArray__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID hexEncoded0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::fromHex(QByteArray)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray& __qt_hexEncoded0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(hexEncoded0);
        QByteArray __qt_return_value = QByteArray::fromHex(__qt_hexEncoded0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::fromPercentEncoding(QByteArray,char)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_fromPercentEncoding_1native_1cref_1QByteArray_1char__JB)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID pctEncoded0,
 jbyte percent1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::fromPercentEncoding(QByteArray,char)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray& __qt_pctEncoded0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(pctEncoded0);
        QByteArray __qt_return_value = QByteArray::fromPercentEncoding(__qt_pctEncoded0, static_cast<char>(percent1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::fromRawData(const char*,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_fromRawData__Ljava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jclass,
 jstring arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::fromRawData(const char*,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        int size1{0};
        JBufferConstData __qt_arg__1_buffer(__jni_env, arg__1);
        const char* __qt_arg__1 = __qt_arg__1_buffer.data<char>();
        size1 = __qt_arg__1_buffer.size<char>();
        QByteArray __qt_return_value = QByteArray::fromRawData(__qt_arg__1, static_cast<int>(size1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::number(double,char,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_number__DBI)
(JNIEnv *__jni_env,
 jclass,
 jdouble arg__1,
 jbyte f1,
 jint prec2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::number(double,char,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray __qt_return_value = QByteArray::number(static_cast<double>(arg__1), static_cast<char>(f1), static_cast<int>(prec2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::number(int,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_number__II)
(JNIEnv *__jni_env,
 jclass,
 jint arg__1,
 jint base1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::number(int,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray __qt_return_value = QByteArray::number(static_cast<int>(arg__1), static_cast<int>(base1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::number(qlonglong,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_number__JI)
(JNIEnv *__jni_env,
 jclass,
 jlong arg__1,
 jint base1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::number(qlonglong,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QByteArray __qt_return_value = QByteArray::number(static_cast<qlonglong>(arg__1), static_cast<int>(base1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::qChecksum(const char*,uint)
extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_qChecksum__Ljava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jclass,
 jstring s0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::qChecksum(const char*,uint)")
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        uint len1{0};
        JBufferConstData __qt_s0_buffer(__jni_env, s0);
        const char* __qt_s0 = __qt_s0_buffer.data<char>();
        len1 = __qt_s0_buffer.size<char>();
        quint16 __qt_return_value = qChecksum(__qt_s0, static_cast<uint>(len1));
        __java_return_value = jshort(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::qChecksum(const char*,uint,Qt::ChecksumType)
extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_qChecksum_1native_1const_1char_1ptr_1uint_1Qt_1ChecksumType__Ljava_nio_ByteBuffer_2I)
(JNIEnv *__jni_env,
 jclass,
 jstring s0,
 jint standard2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::qChecksum(const char*,uint,Qt::ChecksumType)")
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        uint len1{0};
        JBufferConstData __qt_s0_buffer(__jni_env, s0);
        const char* __qt_s0 = __qt_s0_buffer.data<char>();
        len1 = __qt_s0_buffer.size<char>();
        Qt::ChecksumType __qt_standard2 = qtjambi_cast<Qt::ChecksumType>(__jni_env, standard2);
        quint16 __qt_return_value = qChecksum(__qt_s0, static_cast<uint>(len1), Qt::ChecksumType(__qt_standard2));
        __java_return_value = jshort(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::qCompress(QByteArray,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_qCompress_1native_1cref_1QByteArray_1int__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID data0,
 jint compressionLevel1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::qCompress(QByteArray,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray& __qt_data0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data0);
        QByteArray __qt_return_value = qCompress(__qt_data0, static_cast<int>(compressionLevel1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::qCompress(const uchar*,int,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_qCompress__Ljava_nio_ByteBuffer_2I)
(JNIEnv *__jni_env,
 jclass,
 jobject data0,
 jint compressionLevel2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::qCompress(const uchar*,int,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        int nbytes1{0};
        JBufferConstData __qt_data0_buffer(__jni_env, data0);
        const uchar* __qt_data0 = __qt_data0_buffer.data<uchar>();
        nbytes1 = __qt_data0_buffer.size<uchar>();
        QByteArray __qt_return_value = qCompress(__qt_data0, static_cast<int>(nbytes1), static_cast<int>(compressionLevel2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::qUncompress(QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_qUncompress_1native_1cref_1QByteArray__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID data0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::qUncompress(QByteArray)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray& __qt_data0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data0);
        QByteArray __qt_return_value = qUncompress(__qt_data0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArray::qUncompress(const uchar*,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_qUncompress__Ljava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jclass,
 jobject data0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArray::qUncompress(const uchar*,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        int nbytes1{0};
        JBufferConstData __qt_data0_buffer(__jni_env, data0);
        const uchar* __qt_data0 = __qt_data0_buffer.data<uchar>();
        nbytes1 = __qt_data0_buffer.size<uchar>();
        QByteArray __qt_return_value = qUncompress(__qt_data0, static_cast<int>(nbytes1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_toString_1native)(JNIEnv *__jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, QVariant(*__qt_this).toString());
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArray_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QByteArray *__qt_this = QtJambiAPI::objectFromNativeId<QByteArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QByteArray(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QByteArray>("QByteArray", "io/qt/core/QByteArray");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QByteArray, {
        ConstructorInfo(&__qt_construct_QByteArray_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QByteArray_1, "Lio/qt/core/QByteArray;")
       ,ConstructorInfo(&__qt_construct_QByteArray_2, "Ljava/nio/ByteBuffer;")
       ,ConstructorInfo(&__qt_construct_QByteArray_3, "IB")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QByteArray);
    registerMetaType<QByteArray>("QByteArray");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QByteArray::Base64DecodingStatus>("QByteArray::Base64DecodingStatus", "io/qt/core/QByteArray$Base64DecodingStatus");
    registerEnumTypeInfo<QByteArray::Base64Option>("QByteArray::Base64Option", "io/qt/core/QByteArray$Base64Option", "QByteArray::Base64Options", "QFlags<QByteArray::Base64Option>", "io/qt/core/QByteArray$Base64Options");
// END: enums and flags
}
