#include <QtCore/QtGlobal>
#include <QtCore/qbasictimer.h>
#include <QtCore/QVariant>
#include <QtCore/qnamespace.h>
#include <QtCore/qobject.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QBasicTimer(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QBasicTimer")
    QBasicTimer *_ptr = reinterpret_cast<QBasicTimer *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QBasicTimer()
void __qt_construct_QBasicTimer_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBasicTimer()")
    Q_UNUSED(__java_arguments)
    QBasicTimer *__qt_this = new(__qtjambi_ptr) QBasicTimer();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QBasicTimer
void __qt_destruct_QBasicTimer(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QBasicTimer")
    reinterpret_cast<QBasicTimer*>(ptr)->~QBasicTimer();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QBasicTimer::QBasicTimer()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBasicTimer_initialize_1native__Lio_qt_core_QBasicTimer_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBasicTimer::QBasicTimer()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBasicTimer_0, sizeof(QBasicTimer), typeid(QBasicTimer), false, &deleter_QBasicTimer, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBasicTimer::isActive()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBasicTimer_isActive_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBasicTimer *__qt_this = QtJambiAPI::objectFromNativeId<QBasicTimer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBasicTimer::isActive()const", __qt_this)
        __java_return_value = __qt_this->isActive();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBasicTimer::start(int,QObject*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBasicTimer_start_1native_1int_1QObject_1ptr__JIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint msec0,
 QtJambiNativeID obj1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBasicTimer *__qt_this = QtJambiAPI::objectFromNativeId<QBasicTimer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBasicTimer::start(int,QObject*)", __qt_this)
        QObject* __qt_obj1 = QtJambiAPI::objectFromNativeId<QObject>(obj1);
        __qt_this->start(static_cast<int>(msec0), __qt_obj1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBasicTimer::start(int,Qt::TimerType,QObject*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBasicTimer_start_1native_1int_1Qt_1TimerType_1QObject_1ptr__JIIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint msec0,
 jint timerType1,
 QtJambiNativeID obj2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBasicTimer *__qt_this = QtJambiAPI::objectFromNativeId<QBasicTimer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBasicTimer::start(int,Qt::TimerType,QObject*)", __qt_this)
        Qt::TimerType __qt_timerType1 = qtjambi_cast<Qt::TimerType>(__jni_env, timerType1);
        QObject* __qt_obj2 = QtJambiAPI::objectFromNativeId<QObject>(obj2);
        __qt_this->start(static_cast<int>(msec0), Qt::TimerType(__qt_timerType1), __qt_obj2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBasicTimer::stop()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBasicTimer_stop_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBasicTimer *__qt_this = QtJambiAPI::objectFromNativeId<QBasicTimer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBasicTimer::stop()", __qt_this)
        __qt_this->stop();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBasicTimer::swap(QBasicTimer&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBasicTimer_swap_1native_1ref_1QBasicTimer__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBasicTimer *__qt_this = QtJambiAPI::objectFromNativeId<QBasicTimer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBasicTimer::swap(QBasicTimer&)", __qt_this)
        QBasicTimer& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QBasicTimer>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBasicTimer::timerId()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBasicTimer_timerId_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QBasicTimer *__qt_this = QtJambiAPI::objectFromNativeId<QBasicTimer>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBasicTimer::timerId()const", __qt_this)
        __java_return_value = __qt_this->timerId();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QBasicTimer(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QBasicTimer>("QBasicTimer", "io/qt/core/QBasicTimer");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QBasicTimer, {
        ConstructorInfo(&__qt_construct_QBasicTimer_0, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QBasicTimer);
    registerMetaType<QBasicTimer>("QBasicTimer");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
