#include "QAccessibleWidget_shell.h"
#include <QtJambi/Cast>

QtJambiShell* QAccessibleWidget_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QAccessibleWidget_shell) ); }

jmethodID QAccessibleWidget_shell::__shell_javaMethod(int pos) const { return QAccessibleWidget_shell::__shell()->javaMethod(typeid(QAccessibleWidget), pos); }

// emitting (writeShellConstructor)
QAccessibleWidget_shell::QAccessibleWidget_shell(QWidget* o0, QAccessible::Role r1, const QString& name2)
    : QAccessibleWidget(o0, r1, name2)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QAccessibleWidget::QAccessibleWidget_shell(QWidget* o0, QAccessible::Role r1, const QString& name2)", QAccessibleWidget_shell::__shell())
    QAccessibleWidget_shell::__shell()->constructed(typeid(QAccessibleWidget));
}

// emitting (writeShellDestructor)
QAccessibleWidget_shell::~QAccessibleWidget_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QAccessibleWidget::~QAccessibleWidget()", QAccessibleWidget_shell::__shell())
    QAccessibleWidget_shell::__shell()->destructed(typeid(QAccessibleWidget));
}

void QAccessibleWidget_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QAccessibleWidget_shell*>(ptr)->QAccessibleWidget_shell::__shell()->tryDeleteShell(typeid(QAccessibleWidget));
}

// emitting Virtual overrides (virtualFunctions)
QStringList QAccessibleWidget_shell::actionNames() const
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::actionNames()const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QStringList  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    QtJambiScope __qtjambi_scope(QAccessibleWidget_shell::__shell());
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QStringList >(__jni_env, __qtjambi_scope, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::actionNames()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::actionNames()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::actionNames();
        }
    }else{
        return QAccessibleWidget::actionNames();
    }
}

QColor QAccessibleWidget_shell::backgroundColor() const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::backgroundColor()const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QColor  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QColor >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::backgroundColor()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::backgroundColor()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::backgroundColor();
        }
    }else{
        return QAccessibleWidget::backgroundColor();
    }
}

QAccessibleInterface* QAccessibleWidget_shell::child(int index0) const
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::child(int)const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessibleInterface*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, index0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessibleInterface* >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::child(int)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::child(int)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::child(static_cast<int>(index0));
        }
    }else{
        return QAccessibleWidget::child(static_cast<int>(index0));
    }
}

QAccessibleInterface* QAccessibleWidget_shell::childAt(int x0, int y1) const
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessibleInterface*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, x0, y1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessibleInterface* >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleObject::childAt(static_cast<int>(x0), static_cast<int>(y1));
        }
    }else{
        return QAccessibleObject::childAt(static_cast<int>(x0), static_cast<int>(y1));
    }
}

int QAccessibleWidget_shell::childCount() const
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::childCount()const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::childCount()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::childCount()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::childCount();
        }
    }else{
        return QAccessibleWidget::childCount();
    }
}

void QAccessibleWidget_shell::doAction(const QString& actionName0)
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::doAction(QString)", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_actionName0 = qtjambi_cast<jstring>(__jni_env, actionName0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_actionName0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::doAction(QString)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::doAction(QString)");
            } QTJAMBI_TRY_END
        }else{
            QAccessibleWidget::doAction(actionName0);
        }
    }else{
        QAccessibleWidget::doAction(actionName0);
    }
}

QAccessibleInterface* QAccessibleWidget_shell::focusChild() const
{
    if(jmethodID method_id = __shell_javaMethod(6)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::focusChild()const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessibleInterface*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessibleInterface* >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::focusChild()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::focusChild()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::focusChild();
        }
    }else{
        return QAccessibleWidget::focusChild();
    }
}

QColor QAccessibleWidget_shell::foregroundColor() const
{
    if(jmethodID method_id = __shell_javaMethod(7)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::foregroundColor()const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QColor  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QColor >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::foregroundColor()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::foregroundColor()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::foregroundColor();
        }
    }else{
        return QAccessibleWidget::foregroundColor();
    }
}

int QAccessibleWidget_shell::indexOfChild(const QAccessibleInterface* child0) const
{
    if(jmethodID method_id = __shell_javaMethod(8)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::indexOfChild(const QAccessibleInterface*)const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_child0 = qtjambi_cast<jobject>(__jni_env, child0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_child0);
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_child0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::indexOfChild(const QAccessibleInterface*)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::indexOfChild(const QAccessibleInterface*)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::indexOfChild(child0);
        }
    }else{
        return QAccessibleWidget::indexOfChild(child0);
    }
}

bool QAccessibleWidget_shell::isValid() const
{
    if(jmethodID method_id = __shell_javaMethod(9)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::isValid()const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::isValid()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::isValid()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::isValid();
        }
    }else{
        return QAccessibleWidget::isValid();
    }
}

QStringList QAccessibleWidget_shell::keyBindingsForAction(const QString& actionName0) const
{
    if(jmethodID method_id = __shell_javaMethod(10)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::keyBindingsForAction(QString)const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QStringList  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    QtJambiScope __qtjambi_scope(QAccessibleWidget_shell::__shell());
                    jstring __java_actionName0 = qtjambi_cast<jstring>(__jni_env, actionName0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_actionName0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QStringList >(__jni_env, __qtjambi_scope, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::keyBindingsForAction(QString)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::keyBindingsForAction(QString)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::keyBindingsForAction(actionName0);
        }
    }else{
        return QAccessibleWidget::keyBindingsForAction(actionName0);
    }
}

QString QAccessibleWidget_shell::localizedActionDescription(const QString& name0) const
{
    if(jmethodID method_id = __shell_javaMethod(11)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_name0 = qtjambi_cast<jstring>(__jni_env, name0);
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, __java_name0));
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QString >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleActionInterface::localizedActionDescription(name0);
        }
    }else{
        return QAccessibleActionInterface::localizedActionDescription(name0);
    }
}

QString QAccessibleWidget_shell::localizedActionName(const QString& name0) const
{
    if(jmethodID method_id = __shell_javaMethod(12)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_name0 = qtjambi_cast<jstring>(__jni_env, name0);
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, __java_name0));
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QString >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleActionInterface::localizedActionName(name0);
        }
    }else{
        return QAccessibleActionInterface::localizedActionName(name0);
    }
}

QObject* QAccessibleWidget_shell::object() const
{
    if(jmethodID method_id = __shell_javaMethod(13)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QObject*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QObject* >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleObject::object();
        }
    }else{
        return QAccessibleObject::object();
    }
}

QAccessibleInterface* QAccessibleWidget_shell::parent() const
{
    if(jmethodID method_id = __shell_javaMethod(14)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::parent()const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessibleInterface*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessibleInterface* >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::parent()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::parent()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::parent();
        }
    }else{
        return QAccessibleWidget::parent();
    }
}

QRect QAccessibleWidget_shell::rect() const
{
    if(jmethodID method_id = __shell_javaMethod(15)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::rect()const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QRect  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QRect >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::rect()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::rect()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::rect();
        }
    }else{
        return QAccessibleWidget::rect();
    }
}

QVector<QPair<QAccessibleInterface*, QAccessible::Relation> > QAccessibleWidget_shell::relations(QAccessible::Relation match0) const
{
    if(jmethodID method_id = __shell_javaMethod(16)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::relations(QAccessible::Relation)const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QVector<QPair<QAccessibleInterface*, QAccessible::Relation> >  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    QtJambiScope __qtjambi_scope(QAccessibleWidget_shell::__shell());
                    jobject __java_match0 = qtjambi_cast<jobject>(__jni_env, match0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_match0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QVector<QPair<QAccessibleInterface*, QAccessible::Relation> > >(__jni_env, __qtjambi_scope, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::relations(QAccessible::Relation)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::relations(QAccessible::Relation)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::relations(QAccessible::Relation(match0));
        }
    }else{
        return QAccessibleWidget::relations(QAccessible::Relation(match0));
    }
}

QAccessible::Role QAccessibleWidget_shell::role() const
{
    if(jmethodID method_id = __shell_javaMethod(17)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::role()const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessible::Role  __qt_return_value = QAccessible::Role(0);
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessible::Role>(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::role()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::role()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::role();
        }
    }else{
        return QAccessibleWidget::role();
    }
}

void QAccessibleWidget_shell::setText(QAccessible::Text t0, const QString& text1)
{
    if(jmethodID method_id = __shell_javaMethod(18)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_t0 = qtjambi_cast<jobject>(__jni_env, t0);
                    jstring __java_text1 = qtjambi_cast<jstring>(__jni_env, text1);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_t0, __java_text1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::");
            } QTJAMBI_TRY_END
        }else{
            QAccessibleObject::setText(QAccessible::Text(t0), text1);
        }
    }else{
        QAccessibleObject::setText(QAccessible::Text(t0), text1);
    }
}

QAccessible::State QAccessibleWidget_shell::state() const
{
    if(jmethodID method_id = __shell_javaMethod(19)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::state()const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessible::State  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessible::State >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::state()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::state()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::state();
        }
    }else{
        return QAccessibleWidget::state();
    }
}

QString QAccessibleWidget_shell::text(QAccessible::Text t0) const
{
    if(jmethodID method_id = __shell_javaMethod(20)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::text(QAccessible::Text)const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_t0 = qtjambi_cast<jobject>(__jni_env, t0);
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, __java_t0));
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QString >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::text(QAccessible::Text)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::text(QAccessible::Text)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::text(QAccessible::Text(t0));
        }
    }else{
        return QAccessibleWidget::text(QAccessible::Text(t0));
    }
}

QWindow* QAccessibleWidget_shell::window() const
{
    if(jmethodID method_id = __shell_javaMethod(21)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleWidget::window()const", QAccessibleWidget_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QWindow*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleWidget_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QWindow* >(__jni_env, __java_return_value);
                } else {
                    QAccessibleWidget_shell::__shell()->warnForMethod("QAccessibleWidget::window()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleWidget::window()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleWidget::window();
        }
    }else{
        return QAccessibleWidget::window();
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
void QAccessibleWidget_access::__qt_addControllingSignal_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring signal0)
{
    Q_UNUSED(__jni_env)
    Q_UNUSED(__this_nativeId)
    QString  __qt_signal0 = qtjambi_cast<QString >(__jni_env, signal0);
    QAccessibleWidget::addControllingSignal(__qt_signal0);
}

jobject QAccessibleWidget_access::__qt_parentObject(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_UNUSED(__this_nativeId)
    QObject* __qt_return_value = QAccessibleWidget::parentObject();
    return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
}

jobject QAccessibleWidget_access::__qt_widget(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_UNUSED(__this_nativeId)
    QWidget* __qt_return_value = QAccessibleWidget::widget();
    return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
}

// emitting Virtual Override Functions (virtualOverrideFunctions)
jobject QAccessibleWidget_access::__qt_actionNames(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QStringList __qt_return_value = QAccessibleWidget::actionNames();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QStringList __qt_return_value = actionNames();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QAccessibleWidget_access::__qt_backgroundColor(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QColor __qt_return_value = QAccessibleWidget::backgroundColor();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QColor __qt_return_value = backgroundColor();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QAccessibleWidget_access::__qt_child_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint index0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAccessibleInterface* __qt_return_value = QAccessibleWidget::child(static_cast<int>(index0));
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QAccessibleInterface* __qt_return_value = child(static_cast<int>(index0));
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QAccessibleWidget_access::__qt_childCount(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QAccessibleWidget::childCount();
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = childCount();
        return jint(__qt_return_value);
    }
}

void QAccessibleWidget_access::__qt_doAction_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring actionName0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_actionName0 = qtjambi_cast<QString >(__jni_env, actionName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAccessibleWidget::doAction(__qt_actionName0);
    } else {
        doAction(__qt_actionName0);
    }
}

jobject QAccessibleWidget_access::__qt_focusChild(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAccessibleInterface* __qt_return_value = QAccessibleWidget::focusChild();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QAccessibleInterface* __qt_return_value = focusChild();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QAccessibleWidget_access::__qt_foregroundColor(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QColor __qt_return_value = QAccessibleWidget::foregroundColor();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QColor __qt_return_value = foregroundColor();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QAccessibleWidget_access::__qt_indexOfChild_const_QAccessibleInterface_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID child0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QAccessibleInterface* __qt_child0 = QtJambiAPI::interfaceFromNativeId<QAccessibleInterface>(child0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QAccessibleWidget::indexOfChild(__qt_child0);
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = indexOfChild(__qt_child0);
        return jint(__qt_return_value);
    }
}

jboolean QAccessibleWidget_access::__qt_isValid(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAccessibleWidget::isValid();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = isValid();
        return jboolean(__qt_return_value);
    }
}

jobject QAccessibleWidget_access::__qt_keyBindingsForAction_cref_QString_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring actionName0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_actionName0 = qtjambi_cast<QString >(__jni_env, actionName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QStringList __qt_return_value = QAccessibleWidget::keyBindingsForAction(__qt_actionName0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QStringList __qt_return_value = keyBindingsForAction(__qt_actionName0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jstring QAccessibleWidget_access::__qt_localizedActionDescription_cref_QString_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring name0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_name0 = qtjambi_cast<QString >(__jni_env, name0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QAccessibleActionInterface::localizedActionDescription(__qt_name0);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = localizedActionDescription(__qt_name0);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jstring QAccessibleWidget_access::__qt_localizedActionName_cref_QString_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring name0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_name0 = qtjambi_cast<QString >(__jni_env, name0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QAccessibleActionInterface::localizedActionName(__qt_name0);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = localizedActionName(__qt_name0);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jobject QAccessibleWidget_access::__qt_parent(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAccessibleInterface* __qt_return_value = QAccessibleWidget::parent();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QAccessibleInterface* __qt_return_value = parent();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QAccessibleWidget_access::__qt_rect(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QRect __qt_return_value = QAccessibleWidget::rect();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QRect __qt_return_value = rect();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QAccessibleWidget_access::__qt_relations_QAccessible_Relation_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint match0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAccessible::Relation __qt_match0 = qtjambi_cast<QAccessible::Relation>(__jni_env, match0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QVector<QPair<QAccessibleInterface*, QAccessible::Relation> > __qt_return_value = QAccessibleWidget::relations(__qt_match0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QVector<QPair<QAccessibleInterface*, QAccessible::Relation> > __qt_return_value = relations(__qt_match0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QAccessibleWidget_access::__qt_role(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAccessible::Role __qt_return_value = QAccessibleWidget::role();
        return __qt_return_value;
    } else {
        QAccessible::Role __qt_return_value = role();
        return __qt_return_value;
    }
}

jobject QAccessibleWidget_access::__qt_state(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAccessible::State __qt_return_value = QAccessibleWidget::state();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QAccessible::State __qt_return_value = state();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jstring QAccessibleWidget_access::__qt_text_QAccessible_Text_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint t0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAccessible::Text __qt_t0 = qtjambi_cast<QAccessible::Text>(__jni_env, t0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QAccessibleWidget::text(__qt_t0);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = text(__qt_t0);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jobject QAccessibleWidget_access::__qt_window(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QWindow* __qt_return_value = QAccessibleWidget::window();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QWindow* __qt_return_value = window();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

// emitting (writeConstructors)
// new QAccessibleWidget(QWidget*,QAccessible::Role,QString)
void __qt_construct_QAccessibleWidget_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAccessibleWidget(QWidget*,QAccessible::Role,QString)")
    jobject o0 = __java_arguments[0].l;
    QWidget* __qt_o0 = qtjambi_cast<QWidget* >(__jni_env, o0);
    QAccessibleWidget *__qt_this = new(__qtjambi_ptr) QAccessibleWidget_shell(__qt_o0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QAccessibleWidget(QWidget*,QAccessible::Role,QString)
void __qt_construct_QAccessibleWidget_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAccessibleWidget(QWidget*,QAccessible::Role,QString)")
    jobject o0 = __java_arguments[0].l;
    QWidget* __qt_o0 = qtjambi_cast<QWidget* >(__jni_env, o0);
    jobject r1 = __java_arguments[1].l;
    QAccessible::Role __qt_r1 = qtjambi_cast<QAccessible::Role>(__jni_env, r1);
    QAccessibleWidget *__qt_this = new(__qtjambi_ptr) QAccessibleWidget_shell(__qt_o0, QAccessible::Role(__qt_r1));
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QAccessibleWidget(QWidget*,QAccessible::Role,QString)
void __qt_construct_QAccessibleWidget_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAccessibleWidget(QWidget*,QAccessible::Role,QString)")
    jobject o0 = __java_arguments[0].l;
    QWidget* __qt_o0 = qtjambi_cast<QWidget* >(__jni_env, o0);
    jobject r1 = __java_arguments[1].l;
    QAccessible::Role __qt_r1 = qtjambi_cast<QAccessible::Role>(__jni_env, r1);
    jstring name2 = static_cast<jstring>(__java_arguments[2].l);
    QString  __qt_name2 = qtjambi_cast<QString >(__jni_env, name2);
    QAccessibleWidget *__qt_this = new(__qtjambi_ptr) QAccessibleWidget_shell(__qt_o0, QAccessible::Role(__qt_r1), __qt_name2);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QAccessibleWidget_shell
void __qt_destruct_QAccessibleWidget(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QAccessibleWidget")
    reinterpret_cast<QAccessibleWidget_shell*>(ptr)->~QAccessibleWidget_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QAccessibleWidget::QAccessibleWidget(QWidget*,QAccessible::Role,QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_initialize_1native__Lio_qt_widgets_QAccessibleWidget_2Lio_qt_widgets_QWidget_2Lio_qt_gui_QAccessible_00024Role_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject o0,
 jobject r1,
 jstring name2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::QAccessibleWidget(QWidget*,QAccessible::Role,QString)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].l = o0;
        arguments[1].l = r1;
        arguments[2].l = name2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAccessibleWidget_2, sizeof(QAccessibleWidget_shell), typeid(QAccessibleWidget), true, [](void* ptr,bool){ delete reinterpret_cast<QAccessibleWidget_shell*>(ptr); }, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAccessibleWidget::addControllingSignal(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_addControllingSignal_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring signal0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::addControllingSignal(QString)", __qt_this)
        static_cast<QAccessibleWidget_access*>(__qt_this)->__qt_addControllingSignal_cref_QString(__jni_env, __this_nativeId, signal0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAccessibleWidget::parentObject()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_parentObject_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::parentObject()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_parentObject(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::widget()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_widget_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::widget()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_widget(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::actionNames()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_actionNames_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::actionNames()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_actionNames(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::backgroundColor()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_backgroundColor_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::backgroundColor()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_backgroundColor(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::child(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_child_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::child(int)const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_child_int_constfct(__jni_env, __this_nativeId, index0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::childCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_childCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::childCount()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_childCount(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::doAction(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_doAction_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring actionName0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::doAction(QString)", __qt_this)
        static_cast<QAccessibleWidget_access*>(__qt_this)->__qt_doAction_cref_QString(__jni_env, __this_nativeId, actionName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAccessibleWidget::focusChild()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_focusChild_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::focusChild()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_focusChild(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::foregroundColor()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_foregroundColor_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::foregroundColor()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_foregroundColor(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::indexOfChild(const QAccessibleInterface*)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_indexOfChild_1native_1const_1QAccessibleInterface_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID child0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::indexOfChild(const QAccessibleInterface*)const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_indexOfChild_const_QAccessibleInterface_ptr_constfct(__jni_env, __this_nativeId, child0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::isValid()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_isValid(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::keyBindingsForAction(QString)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_keyBindingsForAction_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring actionName0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::keyBindingsForAction(QString)const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_keyBindingsForAction_cref_QString_constfct(__jni_env, __this_nativeId, actionName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::localizedActionDescription(QString)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_localizedActionDescription_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::localizedActionDescription(QString)const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_localizedActionDescription_cref_QString_constfct(__jni_env, __this_nativeId, name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::localizedActionName(QString)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_localizedActionName_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::localizedActionName(QString)const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_localizedActionName_cref_QString_constfct(__jni_env, __this_nativeId, name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::parent()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_parent_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::parent()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_parent(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::rect()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_rect_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::rect()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_rect(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::relations(QAccessible::Relation)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_relations_1native_1QAccessible_1Relation_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint match0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::relations(QAccessible::Relation)const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_relations_QAccessible_Relation_constfct(__jni_env, __this_nativeId, match0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::role()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_role_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::role()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_role(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::state()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_state_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::state()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_state(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::text(QAccessible::Text)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_text_1native_1QAccessible_1Text_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint t0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::text(QAccessible::Text)const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_text_QAccessible_Text_constfct(__jni_env, __this_nativeId, t0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::window()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_window_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleWidget *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleWidget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleWidget::window()const", __qt_this)
        __java_return_value = static_cast<const QAccessibleWidget_access*>(__qt_this)->__qt_window(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::decreaseAction()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_decreaseAction__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::decreaseAction()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QString& __qt_return_value = QAccessibleWidget::decreaseAction();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::increaseAction()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_increaseAction__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::increaseAction()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QString& __qt_return_value = QAccessibleWidget::increaseAction();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::nextPageAction()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_nextPageAction__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::nextPageAction()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QAccessibleWidget::nextPageAction();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::pressAction()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_pressAction__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::pressAction()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QString& __qt_return_value = QAccessibleWidget::pressAction();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::previousPageAction()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_previousPageAction__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::previousPageAction()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QAccessibleWidget::previousPageAction();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::scrollDownAction()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_scrollDownAction__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::scrollDownAction()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QAccessibleWidget::scrollDownAction();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::scrollLeftAction()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_scrollLeftAction__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::scrollLeftAction()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QAccessibleWidget::scrollLeftAction();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::scrollRightAction()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_scrollRightAction__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::scrollRightAction()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QAccessibleWidget::scrollRightAction();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::scrollUpAction()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_scrollUpAction__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::scrollUpAction()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QAccessibleWidget::scrollUpAction();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::setFocusAction()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_setFocusAction__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::setFocusAction()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QString& __qt_return_value = QAccessibleWidget::setFocusAction();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::showMenuAction()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_showMenuAction__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::showMenuAction()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QString& __qt_return_value = QAccessibleWidget::showMenuAction();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleWidget::toggleAction()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_widgets_QAccessibleWidget_toggleAction__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleWidget::toggleAction()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QString& __qt_return_value = QAccessibleWidget::toggleAction();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QAccessibleWidget(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QAccessibleWidget>("QAccessibleWidget", "io/qt/widgets/QAccessibleWidget");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/*  0 */ "actionNames", "()Ljava/util/List;"),
        FunctionInfo(/*  1 */ "backgroundColor", "()Lio/qt/gui/QColor;"),
        FunctionInfo(/*  2 */ "child", "(I)Lio/qt/gui/QAccessibleInterface;"),
        FunctionInfo(/*  3 */ "childAt", "(II)Lio/qt/gui/QAccessibleInterface;"),
        FunctionInfo(/*  4 */ "childCount", "()I"),
        FunctionInfo(/*  5 */ "doAction", "(Ljava/lang/String;)V"),
        FunctionInfo(/*  6 */ "focusChild", "()Lio/qt/gui/QAccessibleInterface;"),
        FunctionInfo(/*  7 */ "foregroundColor", "()Lio/qt/gui/QColor;"),
        FunctionInfo(/*  8 */ "indexOfChild", "(Lio/qt/gui/QAccessibleInterface;)I"),
        FunctionInfo(/*  9 */ "isValid", "()Z"),
        FunctionInfo(/* 10 */ "keyBindingsForAction", "(Ljava/lang/String;)Ljava/util/List;"),
        FunctionInfo(/* 11 */ "localizedActionDescription", "(Ljava/lang/String;)Ljava/lang/String;"),
        FunctionInfo(/* 12 */ "localizedActionName", "(Ljava/lang/String;)Ljava/lang/String;"),
        FunctionInfo(/* 13 */ "object", "()Lio/qt/core/QObject;"),
        FunctionInfo(/* 14 */ "parent", "()Lio/qt/gui/QAccessibleInterface;"),
        FunctionInfo(/* 15 */ "rect", "()Lio/qt/core/QRect;"),
        FunctionInfo(/* 16 */ "relations", "(Lio/qt/gui/QAccessible$Relation;)Ljava/util/List;"),
        FunctionInfo(/* 17 */ "role", "()Lio/qt/gui/QAccessible$Role;"),
        FunctionInfo(/* 18 */ "setText", "(Lio/qt/gui/QAccessible$Text;Ljava/lang/String;)V"),
        FunctionInfo(/* 19 */ "state", "()Lio/qt/gui/QAccessible$State;"),
        FunctionInfo(/* 20 */ "text", "(Lio/qt/gui/QAccessible$Text;)Ljava/lang/String;"),
        FunctionInfo(/* 21 */ "window", "()Lio/qt/gui/QWindow;")});
    registerConstructorInfos(typeId, &__qt_destruct_QAccessibleWidget, {
        ConstructorInfo(&__qt_construct_QAccessibleWidget_0, "Lio/qt/widgets/QWidget;")
       ,ConstructorInfo(&__qt_construct_QAccessibleWidget_1, "Lio/qt/widgets/QWidget;Lio/qt/gui/QAccessible$Role;")
       ,ConstructorInfo(&__qt_construct_QAccessibleWidget_2, "Lio/qt/widgets/QWidget;Lio/qt/gui/QAccessible$Role;Ljava/lang/String;")
    });
// END: function table

// BEGIN: type registration
    registerSizeOfShell(typeId, sizeof(QAccessibleWidget_shell));
// END: type registration

// BEGIN: polymorphic ids
    registerDefaultPolymorphyHandler<QAccessibleObject, QAccessibleWidget>();
    registerPolymorphyHandler(typeid(QAccessibleActionInterface), typeId, [](void *ptr, qintptr& offset) -> bool {
            QAccessibleActionInterface *object = reinterpret_cast<QAccessibleActionInterface *>(ptr);
            Q_ASSERT(object);
            bool _result = false;
            QTJAMBI_TRY_ANY {
                if(QAccessibleWidget* _object = dynamic_cast<QAccessibleWidget*>(object)){
                    offset = qintptr(object)-qintptr(_object);
                    _result = true;
                }
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
// END: polymorphic ids

    registerInterfaceOffset(typeId, typeid(QAccessibleActionInterface), int(reinterpret_cast<quintptr>(static_cast<QAccessibleActionInterface *>(reinterpret_cast<QAccessibleWidget *>(0x10000000)))) - 0x10000000);
    registerInterfaceOffset(typeId, typeid(QAccessibleInterface), int(reinterpret_cast<quintptr>(static_cast<QAccessibleInterface *>(reinterpret_cast<QAccessibleWidget *>(0x10000000)))) - 0x10000000);

// BEGIN: enums and flags
// END: enums and flags
}
